/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.modeldetail.tree;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.data.AttributeDataType;
import javax.datamining.modeldetail.tree.TreeModelDetail;
import javax.datamining.modeldetail.tree.TreeNode;
import javax.datamining.rule.BooleanOperator;
import javax.datamining.rule.Predicate;
import javax.datamining.rule.Rule;
import oracle.dmt.jdm.OraPLSQLMappings;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.base.OraModelDetail;
import oracle.dmt.jdm.data.OraCategorySet;
import oracle.dmt.jdm.modeldetail.tree.OraTreeNode;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.rule.OraBooleanPredicate;
import oracle.dmt.jdm.rule.OraCompoundPredicate;
import oracle.dmt.jdm.rule.OraPredicate;
import oracle.dmt.jdm.rule.OraRule;
import oracle.dmt.jdm.rule.OraSimplePredicate;
import oracle.dmt.jdm.supervised.classification.OraClassificationModel;
import oracle.xdb.XMLType;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OraTreeModelDetail
extends OraModelDetail
implements TreeModelDetail {
    private OraTreeNode m_root = null;
    private HashMap m_dictionaryMap = new HashMap();
    private String m_targetAttributeName = null;
    private OraTreeNode[] m_nodeIndexMap = null;
    private int m_numberOfTreeNodes = 0;
    private int m_numberOfLeafNodes = 0;
    private Vector m_rulesForLeafNodes = null;
    private int m_treeDepth = 0;
    private String m_copyright = null;
    private String m_splitCharacteristic = null;
    private HashMap m_buildSettingsMap = null;
    private HashMap m_priorsMap = null;
    private Vector m_costMatrixActual = null;
    private Vector m_costMatrixPredicted = null;
    private Vector m_costMatrixCost = null;
    private HashSet m_targets = null;
    private static final String NODE_PMML = "PMML";
    private static final String PMML_VERSION = "2.1";
    private static final String NODE_HEADER = "Header";
    private static final String ATTR_COPYRIGHT = "copyright";
    private static final String NODE_EXTENSION = "Extension";
    private static final String BUILD_SETTINGS = "buildSettings";
    private static final String ATTR_EXTENSION_TYPE = "type";
    private static final String NODE_SETTING = "Setting";
    private static final String NODE_PRIOR_PROBABILITIES = "priorProbabilities";
    private static final String NODE_ENTRY = "entry";
    private static final String NODE_ATTRIBUTE_VALUE = "attributeValue";
    private static final String NODE_PRIOR_PROBABILITY = "priorProbability";
    private static final String NODE_COST_MATRIX = "costMatrix";
    private static final String NODE_COST_ELEMENT = "costElement";
    private static final String NODE_ACTUAL_VALUE = "actualValue";
    private static final String NODE_PREDICTED_VALUE = "predictedValue";
    private static final String NODE_COST = "cost";
    private static final String NODE_DATA_DICTIONARY = "DataDictionary";
    private static final String ATTR_NUM_FIELDS = "numberOfFields";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_OP_TYPE = "optype";
    private static final String OP_TYPE_CONTINUOUS = "continuous";
    private static final String OP_TYPE_CATEGORICAL = "categorical";
    private static final String OP_TYPE_ORDINAL = "ordinal";
    private static final String NODE_DECISION_TREE_MODEL = "TreeModel";
    private static final String ATTR_MODEL_NAME = "modelName";
    private static final String ATTR_FUNCTION_NAME = "functionName";
    private static final String ATTR_ALGORITHM_NAME = "algorithmName";
    private static final String ATTR_SPLIT_CHARACTERISTIC = "splitCharacteristic";
    private static final String FUNCTION_CLASSIFICATION = "classification";
    private static final String BINARY_SPLIT = "binarySplit";
    private static final String NODE_MINING_SCHEMA = "MiningSchema";
    private static final String ATTR_USAGE_TYPE = "usageType";
    private static final String USAGE_TYPE_ACTIVE = "active";
    private static final String USAGE_TYPE_PREDICTED = "predicted";
    private static final String USAGE_TYPE_SUPPLEMENTARY = "supplementary";
    private static final String USAGE_TYPE_GROUP = "group";
    private static final String NODE_NODE = "Node";
    private static final String ATTR_NODE_ID = "id";
    private static final String ATTR_SCORE = "score";
    private static final String ATTR_RECORD_COUNT = "recordCount";
    private static final String NODE_SCORE_DISTRIBUTION = "ScoreDistribution";
    private static final String ATTR_VALUE = "value";
    private static final String NODE_PREDICATE_TRUE = "True";
    private static final String NODE_PREDICATE_FALSE = "False";
    private static final String NODE_PREDICATE_SIMPLE = "SimplePredicate";
    private static final String ATTR_FIELD = "field";
    private static final String ATTR_RELATIONAL_OPERATOR = "operator";
    private static final String OPERATOR_EQUAL = "equal";
    private static final String OPERATOR_NOT_EQUAL = "notEqual";
    private static final String OPERATOR_LESS_THAN = "lessThan";
    private static final String OPERATOR_LESS_OR_EQUALL = "lessOrEqual";
    private static final String OPERATOR_GREATER_THAN = "greaterThan";
    private static final String OPERATOR_GREATER_OR_EQUAL = "greaterOrEqual";
    private static final String OPERATOR_IS_MISSING = "isMissing";
    private static final String OPERATOR_IS_NOT_MISSING = "isNotMissing";
    private static final String NODE_PREDICATE_COMPOUND = "CompoundPredicate";
    private static final String ATTR_BOOLEAN_OPERATOR = "booleanOperator";
    private static final String OPERATOR_AND = "and";
    private static final String OPERATOR_OR = "or";
    private static final String OPERATOR_XOR = "xor";
    private static final String OPERATOR_SURROGATE = "surrogate";
    private static final String OPERATOR_IS_IN = "isIn";
    private static final String OPERATOR_IS_NOT_IN = "isNotIn";
    private static final String NODE_PREDICATE_SIMPLE_SET = "SimpleSetPredicate";
    private static final String NODE_ARRAY = "Array";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_TEXT = "#text";
    private static final String TYPE_STRING = "string";
    private static final String TYPE_DOUBLE = "real";
    private static final String TYPE_INTEGER = "int";
    private static final String SQL_GET_TREE_MODEL_DETAIL = "select dbms_data_mining.get_model_details_xml(?) from dual";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OraTreeModelDetail(OraConnection dmeConn, OraModel model) throws JDMException {
        super(dmeConn, model);
        Connection dbConn = dmeConn.getDatabaseConnection();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = dbConn.prepareStatement(SQL_GET_TREE_MODEL_DETAIL);
            pStmt.setString(1, this.m_model.getName());
            rs = pStmt.executeQuery();
            Object iStream = null;
            Object stringVal = null;
            Object r = null;
            Document doc = null;
            XMLType xml = null;
            if (rs.next()) {
                xml = (XMLType)rs.getObject(1);
                doc = xml.getDocument();
            }
            rs.close();
            pStmt.close();
            rs = null;
            pStmt = null;
            this.getTreeModelDetail(doc);
        }
        catch (SQLException sqlExp) {
            sqlExp.printStackTrace();
            System.out.println(sqlExp.getMessage());
        }
        catch (Exception exp) {
            exp.printStackTrace();
            System.out.println(exp.getMessage());
        }
        finally {
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException sqlExp) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqlExp2) {}
            }
        }
    }

    private void getDataDictionary(Node node) {
        NamedNodeMap nodeAttrs = node.getAttributes();
        int numberOfFields = 0;
        for (int i = 0; i < nodeAttrs.getLength(); ++i) {
            Node attr = nodeAttrs.item(i);
            String attrName = attr.getNodeName();
            String attrVal = attr.getNodeValue();
            if (attrName.compareTo(ATTR_NUM_FIELDS) == 0) {
                numberOfFields = Integer.parseInt(attrVal);
                continue;
            }
            System.out.println("OraTreeModelDetail: Unrecognized node attribute " + attrName);
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node field = children.item(i);
            DataDictionaryEntry dicEntry = new DataDictionaryEntry();
            NamedNodeMap fieldAttrs = field.getAttributes();
            for (int j = 0; j < fieldAttrs.getLength(); ++j) {
                Node fieldAttr = fieldAttrs.item(j);
                String attrName = fieldAttr.getNodeName();
                String attrVal = fieldAttr.getNodeValue();
                if (attrName.compareTo(ATTR_NAME) == 0) {
                    dicEntry.setAttributeName(attrVal);
                    continue;
                }
                if (attrName.compareTo(ATTR_OP_TYPE) == 0) {
                    dicEntry.setAttributeType(attrVal);
                    continue;
                }
                System.out.println("OraTreeModelDetail: Unrecognized node attribute " + attrName);
            }
            this.m_dictionaryMap.put(dicEntry.getAttributeName(), dicEntry);
        }
        if (children.getLength() != numberOfFields) {
            System.out.println("OraTreeModelDetail: Unmatching number of fields");
        }
    }

    private void getExtension(Node node) {
        NamedNodeMap nnm = node.getAttributes();
        for (int i = 0; nnm != null && i < nnm.getLength(); ++i) {
            Node attr = nnm.item(i);
            String nodeName = attr.getNodeName();
            String nodeVal = attr.getNodeValue();
            if (nodeName.compareTo(ATTR_NAME) == 0) {
                if (nodeVal.compareTo(BUILD_SETTINGS) == 0) {
                    this.m_buildSettingsMap = new HashMap();
                    continue;
                }
                System.out.println("OraTreeModelDetail: Unsupported extension type " + nodeVal);
                continue;
            }
            System.out.println("OraTreeModelDetail: Unprocessed extension attribute " + nodeVal);
        }
        if (this.m_buildSettingsMap == null) {
            return;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node settingParam = children.item(i);
            String nodeName = settingParam.getNodeName();
            if (nodeName.compareTo(NODE_SETTING) == 0) {
                String settingName = null;
                String settingVal = null;
                NamedNodeMap settingAttrs = settingParam.getAttributes();
                for (int j = 0; j < settingAttrs.getLength(); ++j) {
                    Node settingAttr = settingAttrs.item(j);
                    String attrName = settingAttr.getNodeName();
                    String attrVal = settingAttr.getNodeValue();
                    if (attrName.compareTo(ATTR_NAME) == 0) {
                        settingName = attrVal;
                        continue;
                    }
                    if (attrName.compareTo(ATTR_VALUE) == 0) {
                        settingVal = attrVal;
                        continue;
                    }
                    System.out.println("OraTreeModelDetail: Unrecognized setting attribute " + attrName);
                }
                this.m_buildSettingsMap.put(settingName, settingVal);
                continue;
            }
            if (nodeName.compareTo(NODE_PRIOR_PROBABILITIES) == 0) {
                if (this.m_priorsMap != null) {
                    System.out.println("OraTreeModelDetail: Duplicate prior probabilities representation");
                    continue;
                }
                this.m_priorsMap = new HashMap();
                this.getPriorProbabilities(settingParam);
                continue;
            }
            if (nodeName.compareTo(NODE_COST_MATRIX) == 0) {
                if (this.m_costMatrixActual != null) {
                    System.out.println("OraTreeModelDetail: Duplicate cost matrix representation");
                    continue;
                }
                this.m_costMatrixActual = new Vector();
                this.m_costMatrixPredicted = new Vector();
                this.m_costMatrixCost = new Vector();
                this.getCostMatrix(settingParam);
                continue;
            }
            System.out.println("OraTreeModelDetail: Unprocessed extension node " + nodeName);
        }
    }

    private void getPriorProbabilities(Node node) {
        Node child1 = node.getFirstChild();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().compareTo(NODE_ENTRY) != 0) {
                System.out.println("OraTreeModelDetail: Unsupported priors entry node " + child.getNodeName());
                continue;
            }
            if (child.hasChildNodes()) {
                NodeList grandChildren = child.getChildNodes();
                String catValue = null;
                String priors = null;
                for (int j = 0; j < grandChildren.getLength(); ++j) {
                    Node grandChild = grandChildren.item(j);
                    String entryName = grandChild.getNodeName();
                    Node valueNode = grandChild.getFirstChild();
                    if (entryName.compareTo(NODE_ATTRIBUTE_VALUE) == 0) {
                        catValue = valueNode.getNodeValue();
                        continue;
                    }
                    if (entryName.compareTo(NODE_PRIOR_PROBABILITY) == 0) {
                        priors = valueNode.getNodeValue();
                        continue;
                    }
                    System.out.println("OraTreeModelDetail: Invalid priors entry " + entryName);
                }
                if (catValue != null && priors != null) {
                    this.m_priorsMap.put(catValue, priors);
                    this.m_targets.add(catValue);
                    continue;
                }
                System.out.println("OraTreeModelDetail: Invalid priors specification");
                continue;
            }
            System.out.println("OraTreeModelDetail: Missing priors specification entry");
        }
    }

    private void getCostMatrix(Node node) {
        Node child1 = node.getFirstChild();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().compareTo(NODE_COST_ELEMENT) != 0) {
                System.out.println("OraTreeModelDetail: Unsupported cost matrix entry node " + child.getNodeName());
                continue;
            }
            if (child.hasChildNodes()) {
                NodeList grandChildren = child.getChildNodes();
                String actualValue = null;
                String predictedValue = null;
                String cost = null;
                for (int j = 0; j < grandChildren.getLength(); ++j) {
                    Node grandChild = grandChildren.item(j);
                    String entryName = grandChild.getNodeName();
                    Node valueNode = grandChild.getFirstChild();
                    if (entryName.compareTo(NODE_ACTUAL_VALUE) == 0) {
                        actualValue = valueNode.getNodeValue();
                        continue;
                    }
                    if (entryName.compareTo(NODE_PREDICTED_VALUE) == 0) {
                        predictedValue = valueNode.getNodeValue();
                        continue;
                    }
                    if (entryName.compareTo(NODE_COST) == 0) {
                        cost = valueNode.getNodeValue();
                        continue;
                    }
                    System.out.println("OraTreeModelDetail: Invalid cost matrix entry " + entryName);
                }
                if (actualValue != null && predictedValue != null && cost != null) {
                    this.m_costMatrixActual.add(actualValue);
                    this.m_costMatrixPredicted.add(predictedValue);
                    this.m_costMatrixCost.add(cost);
                    this.m_targets.add(actualValue);
                    this.m_targets.add(predictedValue);
                    continue;
                }
                System.out.println("OraTreeModelDetail: Invalid cost matrix specification");
                continue;
            }
            System.out.println("OraTreeModelDetail: Missing cost matrix specification costElement");
        }
    }

    private void getMiningSchema(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node field = children.item(i);
            String fieldName = null;
            String fieldUsage = null;
            NamedNodeMap fieldAttrs = field.getAttributes();
            for (int j = 0; j < fieldAttrs.getLength(); ++j) {
                Node fieldAttr = fieldAttrs.item(j);
                String attrName = fieldAttr.getNodeName();
                String attrVal = fieldAttr.getNodeValue();
                if (attrName.compareTo(ATTR_NAME) == 0) {
                    fieldName = attrVal;
                    continue;
                }
                if (attrName.compareTo(ATTR_USAGE_TYPE) == 0) {
                    fieldUsage = attrVal;
                    continue;
                }
                System.out.println("OraTreeModelDetail: Unprocessed node attribute " + attrName);
            }
            if (fieldUsage.compareTo(USAGE_TYPE_PREDICTED) == 0) {
                this.m_targetAttributeName = fieldName;
            }
            DataDictionaryEntry dicEntry = (DataDictionaryEntry)this.m_dictionaryMap.get(fieldName);
            dicEntry.setAttributeUsage(fieldUsage);
        }
    }

    private void getTreeModelDetail(Document doc) {
        NodeList pmmlList = doc.getElementsByTagName(NODE_PMML);
        if (pmmlList == null) {
            System.out.println("OraTreeModelDetail: No PMML header, invalid model");
        }
        Node pmmlNode = pmmlList.item(0);
        NamedNodeMap nnm = pmmlNode.getAttributes();
        for (int i = 0; nnm != null && i < nnm.getLength(); ++i) {
            Node attr = nnm.item(i);
            String nodeName = attr.getNodeName();
            String nodeVal = attr.getNodeValue();
            if (nodeName.compareTo(NODE_PMML) != 0 || nodeVal.compareTo(PMML_VERSION) == 0) continue;
            System.out.println("OraTreeModelDetail: Unsupported PMML version in XML " + nodeVal);
        }
        NodeList topChildren = pmmlNode.getChildNodes();
        for (int i = 0; i < topChildren.getLength(); ++i) {
            Node topChild = topChildren.item(i);
            String topNodeName = topChild.getNodeName();
            if (topNodeName.compareTo(NODE_DATA_DICTIONARY) == 0) {
                this.getDataDictionary(topChild);
                continue;
            }
            if (topNodeName.compareTo(NODE_DECISION_TREE_MODEL) == 0) {
                this.getTreeModel(topChild);
                continue;
            }
            if (topNodeName.compareTo(NODE_HEADER) == 0) {
                this.getHeader(topChild);
                continue;
            }
            System.out.println("OraTreeModelDetail: Unrecognized top node name " + topNodeName);
        }
    }

    private void getHeader(Node node) {
        NamedNodeMap nnm = node.getAttributes();
        for (int i = 0; nnm != null && i < nnm.getLength(); ++i) {
            Node attr = nnm.item(i);
            String nodeName = attr.getNodeName();
            String nodeVal = attr.getNodeValue();
            if (nodeName.compareTo(ATTR_COPYRIGHT) != 0) continue;
            this.m_copyright = nodeVal;
        }
    }

    private void getTreeModel(Node node) {
        NamedNodeMap nnm = node.getAttributes();
        for (int j = 0; j < nnm.getLength(); ++j) {
            Node attr = nnm.item(j);
            String nodeName = attr.getNodeName();
            String nodeVal = attr.getNodeValue();
            if (nodeName.compareTo(ATTR_MODEL_NAME) == 0 && nodeVal.compareToIgnoreCase(this.m_model.getName()) != 0) {
                System.out.println("OraTreeModelDetail: Model name in XML " + nodeVal + " is different from " + this.m_model.getName());
                continue;
            }
            if (nodeName.compareTo(ATTR_FUNCTION_NAME) == 0 && nodeVal.compareTo(FUNCTION_CLASSIFICATION) != 0) {
                System.out.println("OraTreeModelDetail: Unprocessed function name " + nodeVal);
                continue;
            }
            if (nodeName.compareTo(ATTR_SPLIT_CHARACTERISTIC) != 0) continue;
            this.m_splitCharacteristic = nodeVal;
        }
        this.m_targets = new HashSet();
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            String childName = child.getNodeName();
            if (childName.compareTo(NODE_NODE) == 0) {
                this.m_root = this.createTreeNode(child, 1, null);
                continue;
            }
            if (childName.compareTo(NODE_MINING_SCHEMA) == 0) {
                this.getMiningSchema(child);
                continue;
            }
            if (childName.compareTo(NODE_EXTENSION) == 0) {
                this.getExtension(child);
                continue;
            }
            System.out.println("OraTreeModelDetail: Unprocessed node name " + childName);
        }
        this.createTreeMap();
    }

    private void createTreeMap() {
        this.m_nodeIndexMap = new OraTreeNode[this.m_numberOfTreeNodes];
        Stack<OraTreeNode> nodeStack = new Stack<OraTreeNode>();
        nodeStack.push(this.m_root);
        while (!nodeStack.isEmpty()) {
            OraTreeNode node;
            this.m_nodeIndexMap[node.getIdentifier()] = node = (OraTreeNode)nodeStack.pop();
            for (OraTreeNode child = node.getFirstChild(); child != null; child = child.getNext()) {
                nodeStack.push(child);
            }
        }
    }

    private OraTreeNode createTreeNode(Node node, int level, OraTreeNode parent) {
        OraTreeNode treeNode = null;
        OraTreeNode next = null;
        try {
            treeNode = new OraTreeNode(this.getConnection(), this, (OraCategorySet)((OraClassificationModel)this.m_model).getTargetCategorySet());
            ++this.m_numberOfTreeNodes;
            treeNode.setLevel(level);
            if (level > this.m_treeDepth) {
                this.m_treeDepth = level;
            }
            treeNode.setParent(parent);
            NamedNodeMap nodeAttrs = node.getAttributes();
            for (int i = 0; i < nodeAttrs.getLength(); ++i) {
                Node attr = nodeAttrs.item(i);
                String attrName = attr.getNodeName();
                String attrVal = attr.getNodeValue();
                if (attrName.compareTo(ATTR_NODE_ID) == 0) {
                    int id = Integer.parseInt(attrVal);
                    treeNode.setNodeId(id);
                    continue;
                }
                if (attrName.compareTo(ATTR_SCORE) == 0) {
                    treeNode.setPrediction(attrVal);
                    this.m_targets.add(attrVal);
                    continue;
                }
                if (attrName.compareTo(ATTR_RECORD_COUNT) == 0) {
                    long recordCount = Long.parseLong(attrVal);
                    treeNode.setCaseCount(recordCount);
                    continue;
                }
                System.out.println("OraTreeModelDetail: Unprocessed node attribute " + attrName);
            }
            NodeList children = node.getChildNodes();
            long biggestCount = 0L;
            String prediction = null;
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                String childName = child.getNodeName();
                if (childName.compareTo(NODE_SCORE_DISTRIBUTION) == 0) {
                    NamedNodeMap scoreAttrs = child.getAttributes();
                    String scoreValue = null;
                    long scoreCount = 0L;
                    for (int j = 0; j < scoreAttrs.getLength(); ++j) {
                        Node scoreAttr = scoreAttrs.item(j);
                        String scoreAttrName = scoreAttr.getNodeName();
                        String scoreAttrVal = scoreAttr.getNodeValue();
                        if (scoreAttrName.compareTo(ATTR_VALUE) == 0) {
                            scoreValue = scoreAttrVal;
                            continue;
                        }
                        if (scoreAttrName.compareTo(ATTR_RECORD_COUNT) != 0) continue;
                        scoreCount = Long.parseLong(scoreAttrVal);
                    }
                    if (scoreCount > biggestCount) {
                        biggestCount = scoreCount;
                        prediction = scoreValue;
                    }
                    treeNode.setPredictionCount(scoreValue, scoreCount);
                    this.m_targets.add(scoreValue);
                    continue;
                }
                if (childName.compareTo(NODE_NODE) == 0) {
                    OraTreeNode childNode = this.createTreeNode(child, level + 1, treeNode);
                    if (next == null) {
                        treeNode.setFirstChild(childNode);
                    } else {
                        next.setNext(childNode);
                    }
                    next = childNode;
                    continue;
                }
                if (childName.compareTo(NODE_PREDICATE_TRUE) == 0 || childName.compareTo(NODE_PREDICATE_FALSE) == 0) {
                    OraBooleanPredicate boolPredicate = new OraBooleanPredicate(this.getConnection(), Boolean.valueOf(childName));
                    treeNode.setPredicate(boolPredicate);
                    continue;
                }
                if (childName.compareTo(NODE_PREDICATE_SIMPLE) == 0 || childName.compareTo(NODE_PREDICATE_SIMPLE_SET) == 0) {
                    OraSimplePredicate simplePredicate = this.createSimplePredicate(child);
                    treeNode.setPredicate(simplePredicate);
                    continue;
                }
                if (childName.compareTo(NODE_PREDICATE_COMPOUND) == 0) {
                    OraCompoundPredicate compoundPredicate = this.createCompoundPredicate(child);
                    Predicate[] predicates = compoundPredicate.getPredicates();
                    treeNode.setPredicate(predicates[0]);
                    Predicate[] surrogates = null;
                    int start = 1;
                    if (predicates.length == 2 && predicates[1] instanceof OraCompoundPredicate) {
                        OraCompoundPredicate compound = (OraCompoundPredicate)predicates[1];
                        predicates = compound.getPredicates();
                        start = 0;
                    }
                    surrogates = new OraPredicate[predicates.length - start];
                    System.arraycopy(predicates, start, surrogates, 0, surrogates.length);
                    treeNode.setSurrogates(surrogates);
                    continue;
                }
                System.out.println("OraTreeModelDetail: Unprocessed node attribute " + childName);
            }
            treeNode.setPrediction(prediction);
        }
        catch (JDMException jdmExp) {
            jdmExp.printStackTrace();
            System.out.println(jdmExp.getMessage());
        }
        if (next == null) {
            ++this.m_numberOfLeafNodes;
        }
        return treeNode;
    }

    private OraSimplePredicate createSimplePredicate(Node simpleNode) throws JDMException {
        NamedNodeMap simpleAttrs;
        String attributeName = null;
        String compOperator = null;
        Double numericalValue = null;
        Object[] catValues = null;
        boolean isSimplePredicate = true;
        String nodeName = simpleNode.getNodeName();
        if (nodeName.compareTo(NODE_PREDICATE_SIMPLE) == 0) {
            simpleAttrs = simpleNode.getAttributes();
            for (int i = 0; i < simpleAttrs.getLength(); ++i) {
                Node simpleAttr = simpleAttrs.item(i);
                String simpleAttrName = simpleAttr.getNodeName();
                String simpleAttrVal = simpleAttr.getNodeValue();
                if (simpleAttrName.compareTo(ATTR_FIELD) == 0) {
                    attributeName = simpleAttrVal;
                    continue;
                }
                if (simpleAttrName.compareTo(ATTR_RELATIONAL_OPERATOR) == 0) {
                    compOperator = simpleAttrVal;
                    continue;
                }
                if (simpleAttrName.compareTo(ATTR_VALUE) == 0) {
                    numericalValue = new Double(simpleAttrVal);
                    continue;
                }
                System.out.println("OraTreeModelDetail: Unprocessed attribute name " + simpleAttrName + " for SimplePredicate");
            }
        } else {
            isSimplePredicate = false;
            simpleAttrs = simpleNode.getAttributes();
            for (int i = 0; i < simpleAttrs.getLength(); ++i) {
                Node simpleAttr = simpleAttrs.item(i);
                String simpleAttrName = simpleAttr.getNodeName();
                String simpleAttrVal = simpleAttr.getNodeValue();
                if (simpleAttrName.compareTo(ATTR_FIELD) == 0) {
                    attributeName = simpleAttrVal;
                    continue;
                }
                if (simpleAttrName.compareTo(ATTR_BOOLEAN_OPERATOR) == 0) {
                    compOperator = simpleAttrVal;
                    continue;
                }
                System.out.println("OraTreeModelDetail: Unprocessed attribute name " + simpleAttrName + " for SimplePredicate");
            }
            String arrayType = null;
            NodeList children = simpleNode.getChildNodes();
            Node arrayNode = children.item(0);
            NamedNodeMap arrayAttrs = arrayNode.getAttributes();
            for (int i = 0; i < arrayAttrs.getLength(); ++i) {
                Node arrayAttr = arrayAttrs.item(i);
                if (arrayAttr.getNodeName().compareTo("type") == 0) {
                    arrayType = arrayAttr.getNodeValue();
                    continue;
                }
                System.out.println("OraTreeModelDetail: Unrecognized array attribute " + arrayAttr.getNodeName());
            }
            Node firstChild = arrayNode.getFirstChild();
            String textName = firstChild.getNodeName();
            String textVal = firstChild.getNodeValue();
            if (textName.compareTo(ATTR_TEXT) == 0) {
                catValues = this.createCategoryValues(textVal, arrayType);
            } else {
                System.out.println("OraTreeModelDetail: Unprocessed attribute name " + textName);
            }
        }
        OraSimplePredicate simplePredicate = new OraSimplePredicate(this.getConnection(), attributeName, OraPLSQLMappings.getComparisonOperator_tree(compOperator), numericalValue, catValues);
        return simplePredicate;
    }

    private Object[] createCategoryValues(String valueText, String type) {
        Object[] values = null;
        String regExp = null;
        String trimmedSpaces = valueText.trim();
        String trimmedQuotesValueText = trimmedSpaces.substring(1, trimmedSpaces.length() - 1);
        boolean isString = type.compareTo(TYPE_STRING) == 0;
        regExp = isString ? "\"\\s+\"" : "\\s+";
        values = trimmedQuotesValueText.split(regExp);
        return values;
    }

    private OraCompoundPredicate createCompoundPredicate(Node compoundNode) throws JDMException {
        String booleanOperator = null;
        NamedNodeMap compoundAttrs = compoundNode.getAttributes();
        for (int i = 0; i < compoundAttrs.getLength(); ++i) {
            Node compoundAttr = compoundAttrs.item(i);
            String compoundAttrName = compoundAttr.getNodeName();
            String compoundAttrVal = compoundAttr.getNodeValue();
            if (compoundAttrName.compareTo(ATTR_BOOLEAN_OPERATOR) == 0) {
                booleanOperator = compoundAttrVal;
                continue;
            }
            System.out.println("OraTreeModelDetail: Unprocessed attribute name " + compoundAttrName + " for CompoundPredicate");
        }
        NodeList children = compoundNode.getChildNodes();
        OraPredicate predicate = null;
        Vector<OraSimplePredicate> predicates = new Vector<OraSimplePredicate>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (childName.compareTo(NODE_PREDICATE_SIMPLE) == 0 || childName.compareTo(NODE_PREDICATE_SIMPLE_SET) == 0) {
                predicate = this.createSimplePredicate(child);
            } else if (childName.compareTo(NODE_PREDICATE_COMPOUND) == 0) {
                predicate = this.createCompoundPredicate(child);
            } else if (childName.compareTo(NODE_PREDICATE_TRUE) == 0 || childName.compareTo(NODE_PREDICATE_FALSE) == 0) {
                predicate = new OraBooleanPredicate(this.getConnection(), Boolean.valueOf(childName));
            } else {
                System.out.println("OraTreeModelDetail: Unprocessed node " + childName + " for CompoundPredicate");
                predicate = null;
            }
            if (predicate == null) continue;
            predicates.add((OraSimplePredicate)predicate);
        }
        BooleanOperator booleanOp = BooleanOperator.valueOf((String)booleanOperator);
        Predicate[] simplePredicates = new OraPredicate[predicates.size()];
        predicates.toArray(simplePredicates);
        OraCompoundPredicate compoundPredicate = new OraCompoundPredicate(this.getConnection(), simplePredicates, booleanOp);
        return compoundPredicate;
    }

    public TreeNode getRootNode() throws JDMException {
        return this.m_root;
    }

    public TreeNode[] getNodes() throws JDMException {
        return this.m_nodeIndexMap;
    }

    public int[] getNodeIdentifiers() {
        if (this.m_root == null || this.m_nodeIndexMap == null) {
            return null;
        }
        int[] nodeIds = new int[this.m_nodeIndexMap.length];
        for (int i = 0; i < this.m_nodeIndexMap.length; ++i) {
            nodeIds[i] = this.m_nodeIndexMap[i].getIdentifier();
        }
        return nodeIds;
    }

    public Collection getRules() throws JDMException {
        if (this.m_rulesForLeafNodes != null) {
            return this.m_rulesForLeafNodes;
        }
        this.m_rulesForLeafNodes = new Vector();
        if (this.m_root == null || this.m_nodeIndexMap == null) {
            return this.m_rulesForLeafNodes;
        }
        Stack predStack = new Stack();
        OraTreeNode node = this.m_root;
        do {
            this.createRulePredicate(node, predStack);
            if (node.isLeaf()) {
                OraRule rule = this.createRule(node, predStack);
                this.m_rulesForLeafNodes.add(rule);
                predStack.pop();
                while (node.getNext() == null) {
                    if ((node = (OraTreeNode)node.getParent()) != null) {
                        predStack.pop();
                        continue;
                    }
                    node = this.m_root;
                    break;
                }
                node = node.getNext();
                continue;
            }
            node = node.getFirstChild();
        } while (node != null);
        return this.m_rulesForLeafNodes;
    }

    void createRulePredicate(OraTreeNode node, Stack predStack) throws JDMException {
        Predicate pred1 = node.getPredicate();
        Predicate[] pred2 = node.getSurrogates();
        int size = 1;
        if (pred2 != null) {
            size += pred2.length;
        }
        Predicate[] anteComps = new Predicate[size];
        anteComps[0] = pred1;
        for (int i = 1; i < size; ++i) {
            anteComps[i] = pred2[i - 1];
        }
        if (size == 1) {
            predStack.push(pred1);
        } else {
            OraCompoundPredicate compound = new OraCompoundPredicate(this.getConnection(), anteComps, BooleanOperator.surrogate);
            predStack.push(compound);
        }
    }

    OraRule createRule(OraTreeNode node, Stack predicates) throws JDMException {
        OraPredicate antecedent = this.createAntecedent(node, predicates);
        String compOp = OPERATOR_EQUAL;
        Object prediction = node.getPrediction();
        Double numValue = null;
        Object[] catValues = null;
        DataDictionaryEntry targetDic = (DataDictionaryEntry)this.m_dictionaryMap.get(this.m_targetAttributeName);
        String attrType = targetDic.getAttributeType();
        if (attrType.compareTo(OP_TYPE_CONTINUOUS) == 0 || attrType.compareTo(OP_TYPE_ORDINAL) == 0) {
            if (prediction instanceof Double) {
                numValue = (Double)prediction;
            } else if (prediction instanceof Integer) {
                numValue = new Double(((Integer)prediction).intValue());
            } else if (prediction instanceof String) {
                numValue = new Double((String)prediction);
            } else {
                System.out.println("OraTreeModelDetail: Unrecognized prediction type " + node.getPredictionType().name());
            }
        } else {
            catValues = new String[]{prediction.toString()};
        }
        OraSimplePredicate consequent = new OraSimplePredicate(this.getConnection(), this.m_targetAttributeName, OraPLSQLMappings.getComparisonOperator_tree(compOp), numValue, catValues);
        long absoluteSupport = node.getCaseCount();
        double support = (double)absoluteSupport / (double)this.m_root.getCaseCount();
        double confidence = (double)node.getPredictionCaseCount() / (double)absoluteSupport;
        OraRule rule = new OraRule(this.getConnection(), node.getIdentifier(), antecedent, consequent, support, confidence, absoluteSupport);
        return rule;
    }

    public Rule getRule(int nodeId) throws JDMException {
        OraTreeNode node;
        OraTreeNode next;
        Stack<OraTreeNode> nodeStack = new Stack<OraTreeNode>();
        for (next = node = (OraTreeNode)this.getNode(nodeId); next != null; next = (OraTreeNode)next.getParent()) {
            nodeStack.push(next);
        }
        Stack predStack = new Stack();
        while (!nodeStack.isEmpty()) {
            next = (OraTreeNode)nodeStack.pop();
            this.createRulePredicate(next, predStack);
        }
        OraRule rule = this.createRule(node, predStack);
        return rule;
    }

    private OraPredicate createAntecedent(OraTreeNode node, Stack predStack) throws JDMException {
        OraPredicate antecedent = null;
        Stack predicates = predStack;
        int size = predStack.size();
        if (size == 1) {
            antecedent = (OraPredicate)predicates.elementAt(0);
        } else {
            int skip = 0;
            if (predicates.elementAt(0) instanceof OraBooleanPredicate) {
                skip = 1;
            }
            Predicate[] predArray = new OraPredicate[size - skip];
            for (int i = skip; i < size; ++i) {
                predArray[i - skip] = (OraPredicate)predicates.elementAt(i);
            }
            antecedent = new OraCompoundPredicate(this.getConnection(), predArray, BooleanOperator.and);
        }
        return antecedent;
    }

    public TreeNode getNode(int nodeId) throws JDMException {
        this.getValidationHandler().validateNumber(nodeId, 0, this.m_nodeIndexMap.length - 1, "nodeId");
        if (this.m_root == null || this.m_nodeIndexMap == null) {
            return null;
        }
        return this.m_nodeIndexMap[nodeId];
    }

    protected boolean isPriorsAvailable() {
        return this.m_priorsMap != null;
    }

    protected boolean isCostAvailable() {
        return this.m_costMatrixActual != null;
    }

    protected double getPriorProbability(Object targetValue) throws JDMException {
        this.getValidationHandler().validateCategory(targetValue, "targetValue");
        if (this.m_priorsMap == null) {
            return -1.0;
        }
        double priorValue = 0.0;
        Object prior = this.m_priorsMap.get(targetValue);
        if (prior == null) {
            System.out.println("Target value " + targetValue.toString() + " does not exists.");
        } else {
            priorValue = Double.parseDouble((String)prior);
        }
        return priorValue;
    }

    protected double getCost(Object actualTarget, Object predictedTarget) throws JDMException {
        this.getValidationHandler().validateCategory(actualTarget, "actualTarget");
        this.getValidationHandler().validateCategory(predictedTarget, "predictedTarget");
        if (this.m_costMatrixActual == null) {
            return -1.0;
        }
        double costValue = 0.0;
        for (int iActual = 0; iActual < this.m_costMatrixActual.size(); ++iActual) {
            Object predicted;
            Object actual = this.m_costMatrixActual.elementAt(iActual);
            if (!actualTarget.equals(actual) || !predictedTarget.equals(predicted = this.m_costMatrixPredicted.elementAt(iActual))) continue;
            String cost = (String)this.m_costMatrixCost.elementAt(iActual);
            return Double.parseDouble(cost);
        }
        System.out.println("Cost not found for (" + actualTarget.toString() + "," + predictedTarget.toString() + ")");
        return costValue;
    }

    protected OraCategorySet getTargetCategorySet() {
        AttributeDataType targetDataType = this.getTargetDataType();
        OraCategorySet catSet = new OraCategorySet(this.getConnection(), targetDataType);
        Iterator iterator = this.m_targets.iterator();
        while (iterator.hasNext()) {
            try {
                String target = (String)iterator.next();
                Object value = null;
                value = targetDataType.equals((Object)AttributeDataType.integerType) ? new Integer(target) : (targetDataType.equals((Object)AttributeDataType.doubleType) ? new Double(target) : target);
                catSet.addCategory(value, null);
            }
            catch (JDMException jdmExp) {}
        }
        return catSet;
    }

    protected AttributeDataType getTargetDataType() {
        AttributeDataType targetType = null;
        Iterator iterator = this.m_targets.iterator();
        if (iterator.hasNext()) {
            String target = (String)iterator.next();
            targetType = AttributeDataType.stringType;
            if (Character.isDigit(target.charAt(0))) {
                int indexPoint = target.indexOf(".");
                targetType = indexPoint == -1 ? AttributeDataType.integerType : AttributeDataType.doubleType;
            } else if (target.charAt(0) == '.' && target.length() > 1 && Character.isDigit(target.charAt(1))) {
                targetType = AttributeDataType.doubleType;
            }
        }
        return targetType;
    }

    protected String getCopyright() {
        return this.m_copyright;
    }

    protected boolean isBinarySplit() {
        return this.m_splitCharacteristic != null && this.m_splitCharacteristic.compareTo(BINARY_SPLIT) == 0;
    }

    public int getTreeDepth() {
        return this.m_treeDepth;
    }

    public int getNumberOfNodes() {
        return this.m_numberOfTreeNodes;
    }

    public int getNumberOfLeafNodes() {
        return this.m_numberOfLeafNodes;
    }

    class DataDictionaryEntry {
        private String m_attributeName = null;
        private String m_attributeType = null;
        private String m_attributeUsage = null;

        DataDictionaryEntry() {
        }

        public String getAttributeName() {
            return this.m_attributeName;
        }

        public void setAttributeName(String attrName) {
            this.m_attributeName = attrName;
        }

        public String getAttributeType() {
            return this.m_attributeType;
        }

        public void setAttributeType(String attrType) {
            this.m_attributeType = attrType;
        }

        public String getAttributeUsage() {
            return this.m_attributeUsage;
        }

        public void setAttributeUsage(String attrUsage) {
            this.m_attributeUsage = attrUsage;
        }
    }
}

