/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.modeldetail.naivebayes;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Vector;
import javax.datamining.JDMException;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.data.OraPairProbability;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.transform.binning.OraBinningTransform;
import oracle.dmt.jdm.utils.OraResultSetCollection;

public class OraTargetProbability
extends OraDMObject {
    private String m_name = null;
    private Object m_val = null;
    private double m_priorProbability = 0.0;
    private Vector m_conditionals = null;
    private String m_modelName = null;
    private PreparedStatement m_qryStmt = null;
    private ResultSet m_rs = null;
    private OraBinningTransform m_binningTransform = null;
    private String[] m_rsAttrNames = null;
    private static String QRY_GET_CONDITIONALS = "SELECT c.* FROM TABLE(dbms_data_mining.get_model_details_nb(?)) t, TABLE(t.conditionals) c where t.target_attribute_name=? ";
    private static String QRY_GET_CONDITIONALS_NUM_SUFFIX = " and t.target_attribute_num_value=?";
    private static String QRY_GET_CONDITIONALS_STR_SUFFIX = " and t.target_attribute_str_value=?";
    private static String ORDER_BY = "  order by c.CONDITIONAL_PROBABILITY, c.ATTRIBUTE_NAME, c.ATTRIBUTE_SUBNAME";
    private static String QRY_LABEL_VIEW_CLAUSE = "WITH label_view AS ";
    private static String QRY_DECODE_NUM_BIN_TABLE = " SELECT col, bin,Decode(bin,'1','[','(') || lv || ',' || val || ']' label FROM (SELECT col, bin, last_value(val) over ( PARTITION BY col ORDER BY val rows BETWEEN unbounded preceding AND 1 preceding) lv, val FROM ";
    private static String QRY_DECODE_CAT_BIN_TABLE = " SELECT col, bin, val label  FROM {0} ";
    private static String QRY_LABLED_GET_CONDITIONALS = " SELECT NVL2( c.attribute_subname, c.attribute_name, c.attribute_name || '.' || c.attribute_subname ), Nvl(l.label, Nvl(c.attribute_str_value,c.attribute_num_value)) attribute_value, c.conditional_probability FROM TABLE(dbms_data_mining.get_model_details_nb(?)) t, TABLE(t.conditionals) c, label_view l WHERE c.attribute_name = l.col (+) AND (Nvl(c.attribute_str_value,c.attribute_num_value) = l.bin(+) ) and  t.target_attribute_name=? ";

    OraTargetProbability(OraConnection dmeConn, String targetAttrName, Object targetVal, double priorProbability, String modelName, OraBinningTransform binningTransform) throws JDMException {
        super(dmeConn, null);
        this.setup102();
        this.m_name = targetAttrName;
        this.m_val = targetVal;
        this.m_priorProbability = priorProbability;
        this.m_modelName = modelName;
        this.m_binningTransform = binningTransform;
        String qry = null;
        boolean isStringVal = true;
        if (this.m_binningTransform == null) {
            qry = QRY_GET_CONDITIONALS;
            String orderBy = ORDER_BY;
            if (targetVal instanceof String) {
                qry = qry + QRY_GET_CONDITIONALS_STR_SUFFIX;
                orderBy = orderBy + ", c.ATTRIBUTE_STR_VALUE";
            } else {
                isStringVal = false;
                qry = qry + QRY_GET_CONDITIONALS_NUM_SUFFIX;
                orderBy = orderBy + ", c.ATTRIBUTE_NUM_VALUE";
            }
            qry = qry + orderBy;
        } else {
            String catBinTable = this.m_binningTransform.getCategoricalBinTable();
            String numBinTable = this.m_binningTransform.getNumericalBinTable();
            qry = QRY_LABEL_VIEW_CLAUSE;
            qry = qry + " ( ";
            if (numBinTable != null) {
                qry = qry + QRY_DECODE_NUM_BIN_TABLE;
                qry = qry + numBinTable + " )";
                if (catBinTable != null) {
                    qry = qry + " UNION ALL ";
                }
            }
            if (catBinTable != null) {
                qry = qry + MessageFormat.format(QRY_DECODE_CAT_BIN_TABLE, catBinTable);
            }
            qry = qry + " ) ";
            qry = qry + QRY_LABLED_GET_CONDITIONALS;
            String orderBy = ORDER_BY;
            if (targetVal instanceof String) {
                qry = qry + QRY_GET_CONDITIONALS_STR_SUFFIX;
                orderBy = orderBy + ", ATTRIBUTE_VALUE";
            } else {
                isStringVal = false;
                qry = qry + QRY_GET_CONDITIONALS_NUM_SUFFIX;
                orderBy = orderBy + ", ATTRIBUTE_VALUE";
            }
            qry = qry + orderBy;
        }
        this.logTrace(qry, new Object[0]);
        try {
            this.m_qryStmt = dmeConn.getDatabaseConnection().prepareCall(qry);
            this.m_qryStmt.setString(1, this.m_modelName);
            this.m_qryStmt.setString(2, this.m_name);
            if (isStringVal) {
                this.m_qryStmt.setString(3, (String)this.m_val);
            } else {
                this.m_qryStmt.setBigDecimal(3, (BigDecimal)this.m_val);
            }
            this.m_rs = this.m_qryStmt.executeQuery();
        }
        catch (SQLException sqlExp) {
            this.close();
        }
    }

    public String getTargetAttributeName() {
        return this.m_name;
    }

    public Object getTargetValue() {
        return this.m_val;
    }

    public double getPriorProbability() {
        return this.m_priorProbability;
    }

    public Collection getPairProbabilities() {
        if (this.m_binningTransform == null) {
            return new OraResultSetCollection(this.m_rs, new String[]{"ATTRIBUTE_NAME", "ATTRIBUTE_NUM_VALUE", "ATTRIBUTE_STR_VALUE", "CONDITIONAL_PROBABILITY"}, new int[]{12, 2, 12, 2}, OraPairProbability.class);
        }
        return new OraResultSetCollection(this.m_rs, new String[]{"ATTRIBUTE_NAME", "ATTRIBUTE_VALUE", "CONDITIONAL_PROBABILITY"}, new int[]{12, 12, 2}, OraPairProbability.class);
    }

    public void close() {
        try {
            if (this.m_rs != null) {
                this.m_rs.close();
            }
        }
        catch (SQLException sqlExp1) {
            // empty catch block
        }
        try {
            if (this.m_qryStmt != null) {
                this.m_qryStmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void finalize() {
        this.close();
    }

    private void setup102() {
        if (this.is102()) {
            ORDER_BY = "  order by c.CONDITIONAL_PROBABILITY, c.ATTRIBUTE_NAME";
            QRY_LABLED_GET_CONDITIONALS = " SELECT c.attribute_name, Nvl(l.label, Nvl(c.attribute_str_value,c.attribute_num_value)) attribute_value, c.conditional_probability FROM TABLE(dbms_data_mining.get_model_details_nb(?)) t, TABLE(t.conditionals) c, label_view l WHERE c.attribute_name = l.col (+) AND (Nvl(c.attribute_str_value,c.attribute_num_value) = l.bin(+) ) and  t.target_attribute_name=? ";
        }
    }
}

