/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.modeldetail.naivebayes;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.datamining.JDMException;
import javax.datamining.modeldetail.naivebayes.NaiveBayesModelDetail;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.base.OraModelDetail;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.transform.binning.OraBinningTransform;

public class OraNaiveBayesModelDetail
extends OraModelDetail
implements NaiveBayesModelDetail {
    private OraBinningTransform m_binningTransform = null;
    private static String QRY_ATTRIBUTE_CONDITIONAL_PROBABILITY = "SELECT c.CONDITIONAL_PROBABILITY from TABLE(dbms_data_mining.get_model_details_nb(?)) t, TABLE(t.conditionals) c ";
    private static String QRY_TARGET_PROBABILITIES = "SELECT NVL(c.ATTRIBUTE_STR_VALUE, c.ATTRIBUTE_NUM_VALUE) as attribute_value, c.CONDITIONAL_PROBABILITY FROM TABLE(dbms_data_mining.get_model_details_nb(?)) t, TABLE(t.conditionals) c where nvl(t.target_attribute_str_value, t.target_attribute_num_value)=? and DECODE(c.attribute_subname, null, c.attribute_name, c.attribute_name || '.' || c.attribute_subname)  =? order by c.CONDITIONAL_PROBABILITY desc, attribute_value";
    private static String QRY_LABEL_VIEW_CLAUSE = "WITH label_view AS ";
    private static String QRY_DECODE_NUM_BIN_TABLE = " SELECT col, att, bin,Decode(bin,'1','[','(') || lv || ',' || val || ']' label FROM (SELECT col, att, bin, last_value(val) over ( PARTITION BY col, att ORDER BY val rows BETWEEN unbounded preceding AND 1 preceding) lv, val FROM ";
    private static String QRY_DECODE_CAT_BIN_TABLE = " SELECT col, att, bin, val label  FROM {0} ";
    private static String QRY_LABLED_TARGET_PROBABILITIES = " SELECT Nvl(l.label, Nvl(c.attribute_str_value,c.attribute_num_value)) attribute_value, c.conditional_probability FROM TABLE(dbms_data_mining.get_model_details_nb(?)) t, TABLE(t.conditionals) c, label_view l WHERE c.attribute_name = l.col (+) and (Nvl(c.attribute_str_value,c.attribute_num_value) = l.bin(+) ) and nvl(t.target_attribute_str_value, t.target_attribute_num_value)=? and DECODE(c.attribute_subname, null, c.attribute_name, c.attribute_name || '.' || c.attribute_subname) = ? order by c.CONDITIONAL_PROBABILITY desc, attribute_value";
    private static final String QRY_WHERE_TARGET_NUM_VALUE = " t.target_attribute_num_value = ? ";
    private static final String QRY_WHERE_TARGET_STR_VALUE = " t.target_attribute_str_value = ? ";
    private static final String QRY_WHERE_PREDICTOR_NAME = " c.ATTRIBUTE_NAME = ? ";
    private static final String QRY_WHERE_PREDICTOR_NUM_VAL = " c.ATTRIBUTE_NUM_VALUE = ? ";
    private static final String QRY_WHERE_PREDICTOR_STR_VAL = " c.ATTRIBUTE_STR_VALUE = ? ";

    public OraNaiveBayesModelDetail(OraConnection dmeConn, OraModel model, OraBinningTransform binningTransform) throws JDMException {
        super(dmeConn, model);
        this.setup102();
        this.m_binningTransform = binningTransform;
    }

    public int getCount(String attributeName, Object attributeValue) throws JDMException {
        this.unsupported("NaiveBayesCapability.singletonCount");
        return 0;
    }

    public int getPairCount(String attributeName, Object predictorValue, Object targetValue) throws JDMException {
        this.unsupported("NaiveBayesCapability.pairCount");
        return 0;
    }

    public double getPairProbability(String attributeName, Object predictorValue, Object targetValue) throws JDMException {
        this.getValidationHandler().validateCategory(predictorValue, "predictorValue");
        this.getValidationHandler().validateNotNull(targetValue, "targetValue");
        StringBuffer qry = new StringBuffer(QRY_ATTRIBUTE_CONDITIONAL_PROBABILITY);
        qry.append(" where ");
        if (targetValue instanceof String) {
            qry.append(QRY_WHERE_TARGET_STR_VALUE);
        } else {
            qry.append(QRY_WHERE_TARGET_NUM_VALUE);
        }
        qry.append(" and ");
        qry.append(QRY_WHERE_PREDICTOR_NAME);
        qry.append(" and ");
        if (predictorValue instanceof String) {
            qry.append(QRY_WHERE_PREDICTOR_STR_VAL);
        } else {
            qry.append(QRY_WHERE_PREDICTOR_NUM_VAL);
        }
        CallableStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = this.getDatabaseConnection().prepareCall(qry.toString());
            pStmt.setString(1, this.m_model.getName());
            pStmt.setString(2, targetValue.toString());
            pStmt.setString(3, attributeName);
            pStmt.setString(4, targetValue.toString());
            rs = pStmt.executeQuery();
            if (rs.next()) {
                double d = rs.getDouble("CONDITIONAL_PROBABILITY");
                return d;
            }
            try {
                throw new JDMException(1, "");
            }
            catch (SQLException sqlExp) {
                throw new JDMException(1, "");
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
    }

    public long getTargetCount(Object targetValue) throws JDMException {
        this.unsupported("NaiveBayesCapability.targetCount");
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getPairProbabilities(String attrName, Object targetValue) {
        this.getValidationHandler().validateCategory(targetValue, "targetValue");
        LinkedHashMap<Object, BigDecimal> pairProbabilityMap = null;
        String qry = null;
        if (this.m_binningTransform == null) {
            qry = QRY_TARGET_PROBABILITIES;
        } else {
            String catBinTable = this.m_binningTransform.getCategoricalBinTable();
            String numBinTable = this.m_binningTransform.getNumericalBinTable();
            qry = QRY_LABEL_VIEW_CLAUSE;
            qry = qry + " ( ";
            if (numBinTable != null) {
                qry = qry + QRY_DECODE_NUM_BIN_TABLE;
                qry = qry + numBinTable + " )";
                if (catBinTable != null) {
                    qry = qry + " UNION ALL ";
                }
            }
            if (catBinTable != null) {
                qry = qry + MessageFormat.format(QRY_DECODE_CAT_BIN_TABLE, catBinTable);
            }
            qry = qry + " ) ";
            qry = qry + QRY_LABLED_TARGET_PROBABILITIES;
        }
        this.logTrace(qry, new Object[0]);
        CallableStatement qryStmt = null;
        ResultSet rs = null;
        Connection dbConn = this.getDatabaseConnection();
        pairProbabilityMap = new LinkedHashMap<Object, BigDecimal>();
        try {
            qryStmt = dbConn.prepareCall(qry);
            qryStmt.setString(1, this.m_model.getName());
            qryStmt.setString(2, targetValue.toString());
            qryStmt.setString(3, attrName);
            rs = qryStmt.executeQuery();
            while (rs.next()) {
                pairProbabilityMap.put(rs.getObject(1), rs.getBigDecimal(2));
            }
        }
        catch (SQLException sqlExp) {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, sqlExp);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception anyExp) {}
            try {
                if (qryStmt != null) {
                    qryStmt.close();
                }
            }
            catch (Exception anyExp2) {}
        }
        return pairProbabilityMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTargetProbability(Object targetValue) throws JDMException {
        double targetProbability = 0.0;
        this.getValidationHandler().validateCategory(targetValue, "targetValue");
        String qry = "SELECT t.prior_probability from TABLE(dbms_data_mining.get_model_details_nb(?)) t where NVL(t.target_attribute_str_value, t.target_attribute_num_value)=?";
        CallableStatement qryStmt = null;
        ResultSet rs = null;
        Connection dbConn = this.getDatabaseConnection();
        try {
            qryStmt = dbConn.prepareCall(qry);
            qryStmt.setString(1, this.m_model.getName());
            qryStmt.setString(2, targetValue.toString());
            rs = qryStmt.executeQuery();
            if (rs.next()) {
                targetProbability = rs.getDouble(1);
            } else {
                this.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new String[]{"targetValue=" + targetValue}, null);
            }
        }
        catch (SQLException sqlExp) {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, sqlExp);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception anyExp) {}
            try {
                if (qryStmt != null) {
                    qryStmt.close();
                }
            }
            catch (Exception anyExp2) {}
        }
        return targetProbability;
    }

    private void setup102() {
        if (this.is102()) {
            QRY_ATTRIBUTE_CONDITIONAL_PROBABILITY = "SELECT c.CONDITIONAL_PROBABILITY from TABLE(dbms_data_mining.get_model_details_nb(?)) t, TABLE(t.conditionals) c ";
            QRY_TARGET_PROBABILITIES = "SELECT NVL(c.ATTRIBUTE_STR_VALUE, c.ATTRIBUTE_NUM_VALUE) as attribute_value, c.CONDITIONAL_PROBABILITY FROM TABLE(dbms_data_mining.get_model_details_nb(?)) t, TABLE(t.conditionals) c where nvl(t.target_attribute_str_value, t.target_attribute_num_value)=? and c.attribute_name=? order by c.CONDITIONAL_PROBABILITY desc, attribute_value";
            QRY_LABEL_VIEW_CLAUSE = "WITH label_view AS ";
            QRY_DECODE_NUM_BIN_TABLE = " SELECT col, bin,Decode(bin,'1','[','(') || lv || ',' || val || ']' label FROM (SELECT col, bin, last_value(val) over ( PARTITION BY col ORDER BY val rows BETWEEN unbounded preceding AND 1 preceding) lv, val FROM ";
            QRY_DECODE_CAT_BIN_TABLE = " SELECT col, bin, val label  FROM {0} ";
            QRY_LABLED_TARGET_PROBABILITIES = " SELECT Nvl(l.label, Nvl(c.attribute_str_value,c.attribute_num_value)) attribute_value, c.conditional_probability FROM TABLE(dbms_data_mining.get_model_details_nb(?)) t, TABLE(t.conditionals) c, label_view l WHERE c.attribute_name = l.col (+) AND (Nvl(c.attribute_str_value,c.attribute_num_value) = l.bin(+) ) and nvl(t.target_attribute_str_value, t.target_attribute_num_value)=? and c.attribute_name=? order by c.CONDITIONAL_PROBABILITY desc, attribute_value";
        }
    }
}

