/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.modeldetail.abn;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.rule.Rule;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.base.OraModelDetail;
import oracle.dmt.jdm.modeldetail.abn.OraABNModelDetail;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.rule.OraABNRule;
import oracle.dmt.jdm.transform.binning.OraBinningTransform;

public class OraABNModelDetailImpl
extends OraModelDetail
implements OraABNModelDetail {
    private static String QRY_ALL_ABN_RULES = " SELECT  root.rule_id                    rule_id,          root.rule_support               rule_support,          root_confidence.rule_confidence rule_confidence  FROM TABLE(dbms_data_mining.get_model_details_abn(?)) root,       (SELECT a.rule_id,               max(rl_cons.attribute_confidence) rule_confidence        FROM  (SELECT * FROM TABLE(dbms_data_mining.get_model_details_abn(?))) a,               TABLE(a.consequent) rl_cons        GROUP BY a.rule_id       ) root_confidence  WHERE root.rule_id = root_confidence.rule_id  {0}  {1} ";
    private static String AND = "AND root.rule_id = ";
    private static String ORDER_BY = "ORDER BY rule_support DESC, rule_confidence DESC";
    private OraBinningTransform m_binningTransform = null;

    public OraABNModelDetailImpl(OraConnection dmeConn, OraModel model, OraBinningTransform binningTransform) throws JDMException {
        super(dmeConn, model);
        this.m_binningTransform = binningTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getRules() {
        String modelName = this.m_model.getName();
        Connection dbConn = this.getDatabaseConnection();
        Vector<OraABNRule> rules = new Vector<OraABNRule>();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int ind = 1;
        try {
            pStmt = dbConn.prepareStatement(this.getQuery(QRY_ALL_ABN_RULES, null, ORDER_BY));
            pStmt.setString(ind++, modelName);
            pStmt.setString(ind++, modelName);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                int iRuleId = rs.getInt("rule_id");
                double dRuleSupport = rs.getDouble("rule_support");
                double dRuleConfidence = rs.getDouble("rule_confidence");
                OraABNRule rule = new OraABNRule(this.getConnection(), modelName, iRuleId, dRuleSupport, dRuleConfidence, this.m_binningTransform);
                rules.add(rule);
            }
        }
        catch (Exception exp) {
            this.logTrace("Failed Operation: OraABNModelDetailImpl.getRules", exp);
            rules = null;
            this.getConnection().createRuntimeException("2007", new Object[]{modelName}, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rule getRule(int ruleId) {
        String modelName = this.m_model.getName();
        Connection dbConn = this.getDatabaseConnection();
        OraABNRule rule = null;
        Statement pStmt = null;
        ResultSet rs = null;
        int ind = 1;
        try {
            pStmt = dbConn.prepareStatement(this.getQuery(QRY_ALL_ABN_RULES, AND + ruleId, ORDER_BY));
            pStmt.setString(ind++, modelName);
            pStmt.setString(ind++, modelName);
            rs = pStmt.executeQuery();
            if (rs.next()) {
                int iRuleId = rs.getInt("rule_id");
                double dRuleSupport = rs.getDouble("rule_support");
                double dRuleConfidence = rs.getDouble("rule_confidence");
                rule = new OraABNRule(this.getConnection(), modelName, iRuleId, dRuleSupport, dRuleConfidence, this.m_binningTransform);
            }
        }
        catch (Exception exp) {
            this.logTrace("Failed Operation: OraABNModelDetailImpl.getRules(int ruleId)", exp);
            rule = null;
            this.getConnection().createRuntimeException("2007", new Object[]{modelName, ruleId + ""}, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
        return rule;
    }

    private String getQuery(String query, String and, String orderBy) {
        String resultquery = query;
        String finalQuery = null;
        String param1 = "";
        String param2 = "";
        if (and != null) {
            param1 = and;
        }
        if (orderBy != null) {
            param2 = orderBy;
        }
        finalQuery = MessageFormat.format(resultquery, param1, param2);
        return finalQuery;
    }
}

