/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.featureextraction;

import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.base.AlgorithmSettings;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.OraMiningFunction;
import oracle.dmt.jdm.algorithm.nmf.OraNMFAlgorithmSettingsFactory;
import oracle.dmt.jdm.algorithm.nmf.OraNMFAlgorithmSettingsImpl;
import oracle.dmt.jdm.base.OraBuildSettings;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;

public class OraFeatureExtractionSettings
extends OraBuildSettings {
    public void setNumberOfFeatures(int numberOfFeatures) {
        this.getValidationHandler().validateNumber(numberOfFeatures, 1, "numberOfFeatures");
        this.setValue("FEAT_NUM_FEATURES", Integer.toString(numberOfFeatures));
    }

    public int getNumberOfFeatures() {
        String numberOfFeatures = this.getValue("FEAT_NUM_FEATURES");
        if (numberOfFeatures == null) {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_DATA_TYPE, new String[]{"null", "numberOfFeatures"}, null);
        }
        return Integer.parseInt(numberOfFeatures);
    }

    protected OraFeatureExtractionSettings(OraConnection dmeConn, OraFactory factory) throws JDMException {
        super(dmeConn, factory, OraMiningFunction.featureExtraction);
    }

    protected boolean isSupported(AlgorithmSettings algoSettings) {
        MiningAlgorithm miningAlgo = algoSettings.getMiningAlgorithm();
        return miningAlgo.equals((Object)OraMiningAlgorithm.nonNegativeMatrixFactorization);
    }

    protected AlgorithmSettings getDefaultAlgorithmSettings() {
        OraNMFAlgorithmSettingsImpl nmfSettings = null;
        try {
            OraNMFAlgorithmSettingsFactory nmfFactory = (OraNMFAlgorithmSettingsFactory)this.getConnection().getFactory("oracle.dmt.jdm.algorithm.nmf.OraNMFAlgorithmSettings");
            nmfSettings = (OraNMFAlgorithmSettingsImpl)nmfFactory.create();
        }
        catch (Exception e) {
            nmfSettings = null;
            this.logSevere("Failed to instantiate {0} in the {1}", new String[]{"OraNMFAlgorithmSettings", "OraFeatureExtractionSettings"});
        }
        return nmfSettings;
    }
}

