/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.featureextraction;

import java.util.Vector;
import javax.datamining.Enum;
import javax.datamining.JDMException;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningFunction;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionApplyContent;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.task.apply.OraApplySettings;

public class OraFeatureExtractionApplySettings
extends OraApplySettings {
    private static final String OP_FEATURE_ID = "FEATURE_ID";
    private static final String OP_FEATURE_VALUE = "FEATURE_VALUE";
    private static final String OP_FEATURE_SET = "FEATURE_SET";
    private static final String COLUMN_FEATURE_ID = "FEATURE_ID";
    private static final String COLUMN_MATCH_QUALITY = "VALUE";
    private static final String[][] m_contentColumnMap = new String[][]{{OraFeatureExtractionApplyContent.featureIdentifier.name(), OraFeatureExtractionApplyContent.matchQuality.name()}, {"FEATURE_ID", "VALUE"}};

    protected String getPredictionColName(String destAttrName) {
        String columnName = null;
        try {
            OraFeatureExtractionApplyContent content = this.getContent(destAttrName);
            String contentType = content.name();
            for (int i = 0; i < m_contentColumnMap[0].length; ++i) {
                if (contentType.compareTo(m_contentColumnMap[0][i]) != 0) continue;
                columnName = m_contentColumnMap[1][i];
            }
        }
        catch (JDMException jDMException) {
            // empty catch block
        }
        return columnName;
    }

    public OraFeatureExtractionApplyContent[] getContentsByFeature(int featureIdentifier) throws JDMException {
        Object[] objs = this.getContentsByCategoryEnums(new Integer(featureIdentifier));
        OraFeatureExtractionApplyContent[] enums = null;
        if (objs != null && objs.length > 0) {
            enums = new OraFeatureExtractionApplyContent[objs.length];
            System.arraycopy(objs, 0, enums, 0, objs.length);
        }
        return enums;
    }

    public OraFeatureExtractionApplyContent[] getMappedContents() {
        Object[] objs = super.getMappedContentsEnums();
        OraFeatureExtractionApplyContent[] enums = null;
        if (objs != null && objs.length > 0) {
            enums = new OraFeatureExtractionApplyContent[objs.length];
            System.arraycopy(objs, 0, enums, 0, objs.length);
        }
        return enums;
    }

    protected String[] toSQL(String modelName) throws JDMException {
        this.m_attrNames = new Vector();
        String[] sqlStats = new String[]{null, null};
        StringBuffer sqlStat = new StringBuffer("select ");
        OraFeatureExtractionApplyContent[] contents = this.getMappedContents();
        switch (this.m_applyOutputMode) {
            case 2: {
                this.m_attrMapping = 1;
                int[] featureIds = this.getMappedFeatureIdentifiers();
                for (int i = 0; i < featureIds.length; ++i) {
                    OraFeatureExtractionApplyContent[] contents2 = this.getContentsByFeature(featureIds[i]);
                    for (int j = 0; j < contents2.length; ++j) {
                        if (i + j > 0) {
                            sqlStat.append(", ");
                        }
                        if (contents2[j].equals((Object)OraFeatureExtractionApplyContent.featureIdentifier)) {
                            sqlStat.append(featureIds[i]);
                        } else if (contents2[j].equals((Object)OraFeatureExtractionApplyContent.matchQuality)) {
                            sqlStat.append(OP_FEATURE_VALUE).append("(").append(modelName);
                            sqlStat.append(", ").append(featureIds[i]).append(" USING *)");
                        } else {
                            this.unsupported("OraFeatureExtractionApplyContent." + contents2[j].name());
                        }
                        sqlStat.append(" as ").append(this.getMappedDestinationAttrName(new Integer(featureIds[i]), contents2[j]));
                        this.m_attrNames.add(this.getMappedDestinationAttrName(new Integer(featureIds[i]), contents2[j]));
                    }
                }
                break;
            }
            case 3: {
                if (this.m_rankContentMap != null) {
                    this.m_attrMapping = 4;
                    sqlStat.append("s.").append("FEATURE_ID").append(" ");
                    sqlStat.append("FEATURE_ID").append(", ");
                    sqlStat.append("s.").append(COLUMN_MATCH_QUALITY).append(" ");
                    sqlStat.append(COLUMN_MATCH_QUALITY);
                    sqlStat.append(" from (select ").append(OP_FEATURE_SET).append("(");
                    sqlStat.append(modelName).append(", ").append(this.getRanks().toString());
                    sqlStat.append(" USING *) pset");
                    sqlStats[1] = ") t, TABLE(t.pset) s order by VALUE desc";
                    Integer ranks = this.getRanks();
                    OraFeatureExtractionApplyContent[] mappedContents = this.getMappedContents();
                    for (int iRank = 1; iRank < ranks + 1; ++iRank) {
                        Vector<String> attrNames = new Vector<String>();
                        for (int jj = 0; jj < mappedContents.length; ++jj) {
                            String attrName = this.getMappedDestinationAttrName(iRank, mappedContents[jj]);
                            if (attrName == null) continue;
                            attrNames.add(attrName);
                        }
                        this.m_attrNames.add(Integer.toString(attrNames.size()));
                        for (int kk = 0; kk < attrNames.size(); ++kk) {
                            this.m_attrNames.add(attrNames.elementAt(kk));
                        }
                    }
                } else {
                    this.m_attrMapping = 1;
                    for (int i = 0; i < contents.length; ++i) {
                        if (i > 0) {
                            sqlStat.append(", ");
                        }
                        String op = null;
                        if (contents[i].equals((Object)OraFeatureExtractionApplyContent.featureIdentifier)) {
                            op = "FEATURE_ID";
                        } else if (contents[i].equals((Object)OraFeatureExtractionApplyContent.matchQuality)) {
                            op = OP_FEATURE_VALUE;
                        } else {
                            this.unsupported("OraFeatureExtractionApplyContent." + contents[i].name());
                        }
                        this.m_attrNames.add(this.getMappedDestinationAttrName(contents[i]));
                        sqlStat.append(op).append("(").append(modelName).append(" USING *) as ");
                        sqlStat.append(this.getMappedDestinationAttrName(contents[i]));
                    }
                }
                break;
            }
            default: {
                String idCol = "FEATURE_ID";
                if (this.m_applyOutputMode == 4) {
                    this.m_attrMapping = 3;
                    idCol = this.getMappedBaseDestinationAttributeName(OraFeatureExtractionApplyContent.featureIdentifier);
                } else {
                    this.m_attrMapping = 2;
                }
                this.m_attrNames.add(idCol);
                sqlStat.append("s.").append("FEATURE_ID").append(" ");
                sqlStat.append("FEATURE_ID").append(", ");
                sqlStat.append("s.").append(COLUMN_MATCH_QUALITY).append(" ");
                sqlStat.append(COLUMN_MATCH_QUALITY);
                String probCol = this.getMappedBaseDestinationAttributeName(OraFeatureExtractionApplyContent.matchQuality);
                if (this.m_applyOutputMode != 4) {
                    probCol = COLUMN_MATCH_QUALITY;
                }
                if (probCol != null) {
                    this.m_attrNames.add(probCol);
                }
                sqlStat.append(" from (select ").append(OP_FEATURE_SET).append("(");
                sqlStat.append(modelName).append(" USING *) pset");
                sqlStats[1] = ") t, TABLE(t.pset) s order by VALUE desc";
            }
        }
        sqlStats[0] = sqlStat.toString();
        return sqlStats;
    }

    public void mapByRank(OraFeatureExtractionApplyContent content, String[] destPhysAttrNameArray, boolean fromTop) throws JDMException {
        super.mapByRank(content, destPhysAttrNameArray, fromTop);
    }

    public void mapByFeature(OraFeatureExtractionApplyContent content, int featureId, String destinationAttrName) throws JDMException {
        super.mapByCategory(content, new Integer(featureId), destinationAttrName);
    }

    public void mapTopFeature(OraFeatureExtractionApplyContent content, String destPhysAttrName) throws JDMException {
        super.mapTopPrediction(content, destPhysAttrName);
    }

    public void mapFeatures(OraFeatureExtractionApplyContent content, String baseDestPhysAttrName) throws JDMException {
        super.mapPredictions(content, baseDestPhysAttrName);
    }

    public Integer getRank(String destinationAttrName) throws JDMException {
        return super.getRank(destinationAttrName);
    }

    public Integer getRanks() {
        return super.getRanks();
    }

    public boolean isFromTop() {
        return super.isFromTop();
    }

    public int[] getMappedFeatureIdentifiers() {
        Object[] featureIdArray = super.getMappedCategories();
        if (featureIdArray == null) {
            return null;
        }
        int[] intArray = new int[featureIdArray.length];
        for (int i = 0; i < featureIdArray.length; ++i) {
            intArray[i] = ((Number)featureIdArray[i]).intValue();
        }
        return intArray;
    }

    public String getMappedDestinationAttrName(Integer featureIdentifier, OraFeatureExtractionApplyContent contentType) throws JDMException {
        return super.getMappedDestinationAttrName(featureIdentifier, (Enum)contentType);
    }

    public String getMappedDestinationAttrName(int featureRank, OraFeatureExtractionApplyContent contentType) throws JDMException {
        return super.getMappedDestinationAttrName(featureRank, (Enum)contentType);
    }

    public OraFeatureExtractionApplyContent getContent(String destinationAttrName) throws JDMException {
        return (OraFeatureExtractionApplyContent)super.getContentEnum(destinationAttrName);
    }

    public OraFeatureExtractionApplyContent[] getContents(int rank) throws JDMException {
        Object[] contents = super.getContentsByRankEnums(rank);
        return contents != null ? (OraFeatureExtractionApplyContent[])contents : null;
    }

    protected OraFeatureExtractionApplySettings(OraConnection dmeConn, OraFactory factory) throws JDMException {
        super(dmeConn, factory, OraMiningFunction.featureExtraction);
    }
}

