/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.featureextraction;

import java.util.Map;
import java.util.Vector;
import javax.datamining.JDMException;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionModel;
import oracle.dmt.jdm.resource.OraConnection;

public class OraFeature
extends OraDMObject {
    private int m_featureId;
    private OraFeatureExtractionModel m_model = null;
    private Vector m_attributeNames = null;
    private Vector m_attributeCoefficients = null;

    public int getFeatureIdentifier() {
        return this.m_featureId;
    }

    public String[] getAttributeNames() throws JDMException {
        if (this.m_attributeNames == null) {
            this.m_attributeNames = this.m_model.getAttributeNames(this.m_featureId);
        }
        return this.m_attributeNames.toArray(new String[this.m_attributeNames.size()]);
    }

    void addAttributeName(String attributeName) {
        if (this.m_attributeNames == null) {
            this.m_attributeNames = new Vector();
        }
        this.m_attributeNames.add(attributeName);
    }

    void addCoefficient(Object coefficient) {
        if (this.m_attributeCoefficients == null) {
            this.m_attributeCoefficients = new Vector();
        }
        this.m_attributeCoefficients.add(coefficient);
    }

    public Map getAttributeCoefficients(String attributeName) throws JDMException {
        return this.m_model.getAttributeCoefficients(this.m_featureId, attributeName);
    }

    OraFeature(OraConnection dmeConn, OraFeatureExtractionModel model, int featureId) throws JDMException {
        super(dmeConn, null);
        this.m_model = model;
        this.m_featureId = featureId;
    }
}

