/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.data;

import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.datamining.JDMException;
import javax.datamining.NamedObject;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.PhysicalAttribute;
import javax.datamining.data.PhysicalAttributeRole;
import javax.datamining.data.PhysicalDataSet;
import javax.datamining.resource.Connection;
import javax.datamining.statistics.AttributeStatisticsSet;
import oracle.dmt.jdm.OraDataURI;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningObject;
import oracle.dmt.jdm.OraPLSQLMappings;
import oracle.dmt.jdm.data.OraPhysicalAttributeFactory;
import oracle.dmt.jdm.data.OraPhysicalAttributeRole;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraPhysicalDataSet
extends OraMiningObject
implements PhysicalDataSet {
    private static String[] IMPORT_METADATA = new String[]{"SELECT column_name, data_type FROM all_tab_columns WHERE owner = '", "' AND table_name='", "' AND data_type IN ('NUMBER','FLOAT','VARCHAR2','CHAR', 'DM_NESTED_NUMERICALS', 'DM_NESTED_CATEGORICALS') "};
    private static String[] IMPORT_USER_METADATA = new String[]{"SELECT column_name, data_type FROM user_tab_columns WHERE ", "table_name='", "' AND data_type IN ('NUMBER','FLOAT','VARCHAR2','CHAR', 'DM_NESTED_NUMERICALS', 'DM_NESTED_CATEGORICALS') "};
    private static String EXCLUDED_LIST = " and column_name NOT IN ({0})";
    private static String ORDER_BY = " ORDER BY column_name";
    protected static String COLUMN_LIST = "COLUMN_LIST_JDM";
    private ArrayList m_attrs = new ArrayList();
    private PhysicalAttribute m_caseId = null;
    private OraDataURI m_uriObj = null;
    private String m_tableName = null;
    private String m_schemaName = null;
    private Hashtable m_columnIndexMap = new Hashtable();
    private String[] m_excludedAttributes = null;

    OraPhysicalDataSet(OraConnection dmeConn, OraFactory factory, String uri, String[] excludedAttributes) throws JDMException {
        super(dmeConn, factory, NamedObject.physicalDataSet);
        this.m_uriObj = new OraDataURI(uri);
        this.m_excludedAttributes = excludedAttributes;
    }

    public Collection getAttributes() {
        return this.m_attrs;
    }

    public int getAttributeCount() {
        if (this.m_attrs == null) {
            return 0;
        }
        return this.m_attrs.size();
    }

    public PhysicalAttribute getAttribute(String name) throws JDMException {
        Integer index = (Integer)this.m_columnIndexMap.get(name);
        return index != null ? this.getAttribute(index) : null;
    }

    public Integer getAttributeIndex(String attributeName) throws JDMException {
        Integer index = (Integer)this.m_columnIndexMap.get(attributeName);
        return index != null ? index : null;
    }

    public PhysicalAttribute getAttribute(int index) {
        return (PhysicalAttribute)this.m_attrs.get(index);
    }

    public void addAttribute(PhysicalAttribute attribute) throws JDMException {
        this.getValidationHandler().validateNotNull(attribute, "attribute");
        PhysicalAttributeRole role = attribute.getRole();
        if (role != null && PhysicalAttributeRole.caseId.equals((Object)role)) {
            this.m_caseId = attribute;
        }
        this.m_attrs.add(attribute);
        this.m_columnIndexMap.put(attribute.getName(), new Integer(this.m_attrs.size() - 1));
    }

    public void addAttributes(PhysicalAttribute[] attributeArray) throws JDMException {
        if (attributeArray == null || attributeArray.length == 0) {
            return;
        }
        for (int i = 0; i < attributeArray.length; ++i) {
            this.addAttribute(attributeArray[i]);
        }
    }

    public void removeAttribute(String name) throws JDMException {
        this.getValidationHandler().validateTableColumnName(name, "name");
        Integer index = (Integer)this.m_columnIndexMap.get(name);
        if (index != null) {
            this.m_attrs.remove(index);
            this.m_columnIndexMap.remove(name);
        } else {
            this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new Object[]{name, "PhysicalDataSet"}, null);
        }
    }

    public void removeAllAttributes() {
        this.m_attrs.clear();
        this.m_columnIndexMap.clear();
        this.m_caseId = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importMetaData() throws JDMException {
        StringBuffer sbQuery = new StringBuffer(IMPORT_METADATA[0]);
        if (this.m_uriObj.getSchemaName() == null) {
            sbQuery = new StringBuffer(IMPORT_USER_METADATA[0]);
            sbQuery.append(IMPORT_USER_METADATA[1]);
        } else {
            String schemaName = this.m_uriObj.getSchemaName();
            String cleanSchemaName = OraStringUtils.processQuotedName(schemaName);
            if (cleanSchemaName.equals(schemaName)) {
                cleanSchemaName = cleanSchemaName.toUpperCase();
            }
            sbQuery.append(cleanSchemaName);
            sbQuery.append(IMPORT_METADATA[1]);
        }
        String tableName = this.m_uriObj.getTableName();
        String cleanTableName = OraStringUtils.processQuotedName(tableName);
        if (cleanTableName.equals(tableName)) {
            cleanTableName = tableName.toUpperCase();
        }
        sbQuery.append(cleanTableName);
        sbQuery.append(IMPORT_METADATA[2]);
        if (this.m_excludedAttributes != null && this.m_excludedAttributes.length != 0) {
            String excludedList = "";
            StringBuffer attrList = new StringBuffer();
            for (int ind = 0; ind < this.m_excludedAttributes.length; ++ind) {
                attrList.append("'" + this.m_excludedAttributes[ind] + "'");
                if (ind == this.m_excludedAttributes.length - 1) continue;
                attrList.append(",");
            }
            excludedList = MessageFormat.format(EXCLUDED_LIST, attrList.toString());
            sbQuery.append(excludedList);
        }
        sbQuery.append(ORDER_BY);
        OraPhysicalAttributeFactory physAtrrFactory = (OraPhysicalAttributeFactory)this.getConnection().getFactory("javax.datamining.data.PhysicalAttribute");
        physAtrrFactory.setParentPDS(this);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getConnection().getDatabaseConnection().createStatement();
            rs = stmt.executeQuery(sbQuery.toString());
            while (rs.next()) {
                String columnName = rs.getString("column_name");
                String oracleType = rs.getString("data_type");
                PhysicalAttribute phAttr = this.getPhysicalAttribute(this.getConnection(), physAtrrFactory, columnName, oracleType);
                phAttr.setRole(PhysicalAttributeRole.data);
                this.addAttribute(phAttr);
            }
        }
        catch (Exception ex) {
            this.logTrace("Error: OraSQLUtils.getMetaData failed:", ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public AttributeStatisticsSet getAttributeStatistics() {
        return null;
    }

    public String getURI() {
        return this.m_uriObj.getURI();
    }

    public String getTableName() {
        return this.m_uriObj.getTableName();
    }

    public String getSchemaName() {
        return this.m_uriObj.getSchemaName();
    }

    public PhysicalAttribute getCaseIDAttribute() {
        return this.m_caseId;
    }

    public boolean isInputObject() {
        return true;
    }

    protected void saveObjectInDatabase(Connection dmeConn, String name) throws JDMException {
    }

    private PhysicalAttribute getPhysicalAttribute(OraConnection dmeConn, OraPhysicalAttributeFactory physAtrrFactory, String columnName, String oracleDataType) throws JDMException {
        boolean bNested = OraPLSQLMappings.isNested(oracleDataType);
        PhysicalAttribute phAttribute = physAtrrFactory.create(columnName, OraPLSQLMappings.getAttributeDataType(oracleDataType), bNested ? OraPhysicalAttributeRole.nestedTable : PhysicalAttributeRole.data);
        return phAttribute;
    }

    public Collection getAttributeNames(AttributeDataType attrDataType) {
        this.getValidationHandler().validateNotNull(attrDataType, "attrDataType");
        ArrayList<String> attrNames = new ArrayList<String>();
        if (this.m_attrs != null) {
            for (int i = 0; i < this.m_attrs.size(); ++i) {
                PhysicalAttribute attr = (PhysicalAttribute)this.m_attrs.get(i);
                if (!attr.getDataType().equals((Object)attrDataType)) continue;
                attrNames.add(attr.getName());
            }
        }
        return attrNames;
    }

    public Collection getAttributeNames(PhysicalAttributeRole attrRole) {
        this.getValidationHandler().validateNotNull(attrRole, "attrRole");
        ArrayList<Object> attrNames = null;
        if (attrRole.equals((Object)PhysicalAttributeRole.caseId) && this.m_caseId != null) {
            attrNames = new ArrayList(1);
            attrNames.add(this.m_caseId);
        } else {
            attrNames = new ArrayList<Object>();
            if (this.m_attrs != null) {
                for (int i = 0; i < this.m_attrs.size(); ++i) {
                    PhysicalAttribute attr = (PhysicalAttribute)this.m_attrs.get(i);
                    if (attr.getRole() == null || !attrRole.equals((Object)attr.getRole())) continue;
                    attrNames.add(attr.getName());
                }
            }
        }
        return attrNames;
    }
}

