/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.data;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.datamining.JDMException;
import javax.datamining.data.PhysicalDataRecord;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.data.OraPhysicalDataRecordFactory;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraPhysicalDataRecord
extends OraDMObject
implements PhysicalDataRecord {
    private TreeMap m_attrValPairs = new TreeMap();

    OraPhysicalDataRecord(OraConnection dmeConn, OraPhysicalDataRecordFactory factory) throws JDMException {
        super(dmeConn, factory);
    }

    public Object getValue(String attributeName) throws JDMException {
        String name = this.getValidationHandler().validateTableColumnName(attributeName, "attributeName");
        if (!this.m_attrValPairs.containsKey(name)) {
            this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new Object[]{attributeName, "PhysicalDataRecord", ""}, null);
        }
        return this.m_attrValPairs.get(name);
    }

    public void setValue(String attributeName, Object value) throws JDMException {
        String name = this.getValidationHandler().validateTableColumnName(attributeName, "attributeName");
        if (value != null) {
            this.getValidationHandler().validateCategory(value, "value");
        }
        this.m_attrValPairs.put(name, value);
    }

    public Collection getAttributeNames() {
        return this.m_attrValPairs.keySet();
    }

    public Map getAttributeNameValueMap() {
        return this.m_attrValPairs;
    }

    public int getAttributeCount() {
        return this.m_attrValPairs.size();
    }

    public void removeAttribute(String attributeName) throws JDMException {
        String name = this.getValidationHandler().validateTableColumnName(attributeName, "attributeName");
        if (!this.m_attrValPairs.containsKey(name)) {
            this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new Object[]{attributeName, "PhysicalDataRecord", ""}, null);
        }
        this.m_attrValPairs.remove(name);
    }

    public void removeAllAttributes() {
        this.m_attrValPairs.clear();
    }

    public void resetValues() {
        Set keySet = this.m_attrValPairs.keySet();
        for (String attrName : keySet) {
            this.m_attrValPairs.put(attrName, null);
        }
    }

    public String toSQL() {
        if (this.m_attrValPairs.size() == 0) {
            return "select 0 dummy from dual";
        }
        StringBuffer sqlStmt = new StringBuffer("select ");
        int nonNullEntries = 0;
        Set keySet = this.m_attrValPairs.keySet();
        for (String attrName : keySet) {
            Object value = this.m_attrValPairs.get(attrName);
            if (value == null || !(value instanceof Number) && !(value instanceof String) && !(value instanceof Character)) continue;
            if (nonNullEntries > 0) {
                sqlStmt.append(", ");
            }
            sqlStmt.append("? ").append("\"" + OraStringUtils.trimDoubleQuotes(attrName) + "\"");
            ++nonNullEntries;
        }
        if (nonNullEntries == 0) {
            return null;
        }
        sqlStmt.append(" from dual");
        return sqlStmt.toString();
    }
}

