/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.data;

import java.math.BigDecimal;
import javax.datamining.JDMException;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.utils.OraResultSetRecord;

public class OraAttributeCoefficient
extends OraDMObject
implements OraResultSetRecord {
    private String m_attrName;
    private Object m_attrVal;
    private double m_coefficient;
    private Object m_targetVal;

    public OraAttributeCoefficient() {
    }

    public OraAttributeCoefficient(OraConnection dmeConn, String attrName, Object attrVal, double coefficient) throws JDMException {
        super(dmeConn, null);
        this.getValidationHandler().validateTableColumnName(attrName, "attrName");
        this.m_attrName = attrName;
        this.m_attrVal = attrVal;
        this.m_coefficient = coefficient;
        this.m_targetVal = null;
    }

    public OraAttributeCoefficient(OraConnection dmeConn, String attrName, Object attrVal, double coefficient, Object targetVal) throws JDMException {
        super(dmeConn, null);
        this.getValidationHandler().validateTableColumnName(attrName, "attrName");
        this.m_attrName = attrName;
        this.m_attrVal = attrVal;
        this.m_coefficient = coefficient;
        this.m_targetVal = targetVal;
    }

    public String getAttributeName() {
        return this.m_attrName;
    }

    public void setAttributeName(String attrName) {
        this.getValidationHandler().validateTableColumnName(attrName, "attrName");
        this.m_attrName = attrName;
    }

    public void setAttributeValue(Object value) {
        this.getValidationHandler().validateCategory(value, "value");
        this.m_attrVal = value;
    }

    public Object getAttributeValue() {
        return this.m_attrVal;
    }

    public void setCoefficient(double coefficient) {
        this.m_coefficient = coefficient;
    }

    public double getCoefficient() {
        return this.m_coefficient;
    }

    public void setTargetValue(Object targetVal) {
        this.m_targetVal = targetVal;
    }

    public Object getTargetValue() {
        return this.m_targetVal;
    }

    public void setParams(Object[] paramValues) {
        if (paramValues != null) {
            int noOfParams = paramValues.length;
            if (noOfParams == 4) {
                this.m_targetVal = (String)paramValues[0];
                this.m_attrName = (String)paramValues[1];
                this.m_attrVal = (String)paramValues[2];
                this.m_coefficient = ((BigDecimal)paramValues[3]).doubleValue();
            } else if (noOfParams == 3) {
                this.m_attrName = (String)paramValues[0];
                this.m_attrVal = (String)paramValues[1];
                this.m_coefficient = ((BigDecimal)paramValues[2]).doubleValue();
            }
        }
    }
}

