/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.clustering;

import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.clustering.AggregationFunction;
import javax.datamining.clustering.AttributeComparisonFunction;
import javax.datamining.clustering.ClusteringCapability;
import javax.datamining.clustering.ClusteringSettings;
import javax.datamining.clustering.ClusteringSettingsFactory;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.OraSupportedEnums;
import oracle.dmt.jdm.clustering.OraClusteringSettings;

public class OraClusteringSettingsFactory
extends OraFactory
implements ClusteringSettingsFactory {
    private static final String[] supportedAlgorithms = new String[]{MiningAlgorithm.kMeans.name(), OraMiningAlgorithm.oCluster.name()};
    private static final String[] supportedComparisonFunctions = new String[]{AttributeComparisonFunction.systemDefault.name(), AttributeComparisonFunction.systemDetermined.name()};
    private static final String[] supportedAggregationFunctions = new String[]{AggregationFunction.systemDefault.name(), AggregationFunction.systemDetermined.name()};
    private static final OraSupportedEnums supportedFeatures = new OraSupportedEnums(new Enum[]{ClusteringCapability.maxNumberOfClusters});
    private static final OraSupportedEnums[] supportedFeaturesAlgo = new OraSupportedEnums[]{new OraSupportedEnums(new Enum[]{ClusteringCapability.maxNumberOfClusters}), new OraSupportedEnums(new Enum[]{ClusteringCapability.maxNumberOfClusters})};

    public ClusteringSettings create() throws JDMException {
        OraClusteringSettings clusteringSettings = new OraClusteringSettings(this.getConnection(), this);
        return clusteringSettings;
    }

    public boolean supportsCapability(ClusteringCapability capability) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(capability, "capability");
        return supportedFeatures.isSupported((Enum)capability);
    }

    public boolean supportsCapability(AggregationFunction aggregationFunction) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(aggregationFunction, "aggregationFunction");
        return OraClusteringSettingsFactory.isSupported(supportedAggregationFunctions, aggregationFunction.name());
    }

    public boolean supportsCapability(AttributeComparisonFunction comparisonFunction) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(comparisonFunction, "comparisonFunction");
        return OraClusteringSettingsFactory.isSupported(supportedComparisonFunctions, comparisonFunction.name());
    }

    public boolean supportsCapability(AggregationFunction aggregationFunction, AttributeComparisonFunction comparisonFunction) {
        this.m_dmeConn.getValidationHandler().validateNotNull(aggregationFunction, "aggregationFunction");
        this.m_dmeConn.getValidationHandler().validateNotNull(comparisonFunction, "comparisonFunction");
        boolean aggSupported = OraClusteringSettingsFactory.isSupported(supportedAggregationFunctions, aggregationFunction.name());
        if (!aggSupported) {
            return false;
        }
        return OraClusteringSettingsFactory.isSupported(supportedComparisonFunctions, comparisonFunction.name());
    }

    public boolean supportsCapability(MiningAlgorithm algorithm, ClusteringCapability capability) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(algorithm, "algorithm");
        this.m_dmeConn.getValidationHandler().validateNotNull(capability, "capability");
        int index = OraClusteringSettingsFactory.isSupported(algorithm);
        if (index == -1) {
            return false;
        }
        return supportedFeaturesAlgo[index].isSupported((Enum)capability);
    }

    private static int isSupported(MiningAlgorithm algorithm) {
        for (int i = 0; i < supportedAlgorithms.length; ++i) {
            if (supportedAlgorithms[i].compareTo(algorithm.name()) != 0) continue;
            return i;
        }
        return -1;
    }

    private static boolean isSupported(String[] names, String functionName) {
        for (int i = 0; i < names.length; ++i) {
            if (names[i].compareTo(functionName) != 0) continue;
            return true;
        }
        return false;
    }
}

