/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.clustering;

import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.clustering.ClusteringApplyCapability;
import javax.datamining.clustering.ClusteringApplyContent;
import javax.datamining.clustering.ClusteringApplySettings;
import javax.datamining.clustering.ClusteringApplySettingsFactory;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.OraSupportedEnums;
import oracle.dmt.jdm.clustering.OraClusteringApplySettings;

public class OraClusteringApplySettingsFactory
extends OraFactory
implements ClusteringApplySettingsFactory {
    private ClusteringApplySettings s_defaultApplySettings = null;
    private static final OraSupportedEnums supportedApplyContents = new OraSupportedEnums(new Enum[]{ClusteringApplyContent.clusterIdentifier, ClusteringApplyContent.probability});
    private static final OraSupportedEnums supportedCapabilities = new OraSupportedEnums(new Enum[]{ClusteringApplyCapability.allClusters, ClusteringApplyCapability.topCluster, ClusteringApplyCapability.topSequentialRanks, ClusteringApplyCapability.individualClusters});

    public ClusteringApplySettings create() throws JDMException {
        OraClusteringApplySettings clusteringApplySettings = new OraClusteringApplySettings(this.getConnection(), this);
        return clusteringApplySettings;
    }

    public ClusteringApplySettings getDefaultApplySettings() {
        try {
            if (this.s_defaultApplySettings == null) {
                this.s_defaultApplySettings = new OraClusteringApplySettings(this.getConnection(), this);
            }
        }
        catch (JDMException jDMException) {
            // empty catch block
        }
        return this.s_defaultApplySettings;
    }

    public boolean supportsCapability(MiningAlgorithm algorithm, ClusteringApplyContent content) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(content, "content");
        if (algorithm != null && !algorithm.equals((Object)MiningAlgorithm.kMeans) && !algorithm.equals((Object)OraMiningAlgorithm.oCluster)) {
            return false;
        }
        return supportedApplyContents.isSupported((Enum)content);
    }

    public boolean supportsCapability(MiningAlgorithm algorithm, ClusteringApplyCapability mappingType) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(mappingType, "mappingType");
        if (algorithm != null && !algorithm.equals((Object)MiningAlgorithm.kMeans) && !algorithm.equals((Object)OraMiningAlgorithm.oCluster)) {
            return false;
        }
        return supportedCapabilities.isSupported((Enum)mappingType);
    }

    public ClusteringApplyContent[] getSupportedApplyContents(MiningAlgorithm algorithm) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(algorithm, "algorithm");
        if (!algorithm.equals((Object)MiningAlgorithm.kMeans) && !algorithm.equals((Object)OraMiningAlgorithm.oCluster)) {
            return null;
        }
        Enum[] enums = supportedApplyContents.getSupportedEnums();
        ClusteringApplyContent[] newEnums = new ClusteringApplyContent[enums.length];
        System.arraycopy(enums, 0, newEnums, 0, enums.length);
        return newEnums;
    }
}

