/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.clustering;

import java.util.Collection;
import java.util.TreeMap;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.clustering.Cluster;
import javax.datamining.rule.Predicate;
import javax.datamining.rule.Rule;
import javax.datamining.statistics.AttributeStatisticsSet;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.clustering.OraClusteringModel;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;

public class OraCluster
extends OraDMObject
implements Cluster {
    private int m_clusterId;
    private Cluster m_parent;
    private int m_treeLevel;
    private Integer m_parentID;
    private double m_dispersion;
    private long m_caseCount;
    private OraClusteringModel m_model;
    private Boolean m_bRoot = null;
    private Boolean m_bLeaf = null;
    private Cluster[] m_ancestors;
    private Predicate m_splitPredicate;
    private Cluster[] m_children;
    private AttributeStatisticsSet m_StatisticsSet;
    private Rule m_Rule;
    private TreeMap m_centroids;

    public int getClusterId() {
        return this.m_clusterId;
    }

    public String getName() {
        return Integer.toString(this.m_clusterId);
    }

    public Cluster getParent() {
        if (this.m_parent != null) {
            return this.m_parent;
        }
        if (this.m_parent == null && this.m_bRoot != null && this.m_bRoot.booleanValue()) {
            return null;
        }
        if (this.m_parentID == null) {
            this.m_parent = null;
            return this.m_parent;
        }
        try {
            this.m_parent = this.m_model.getCluster(this.m_parentID);
        }
        catch (Exception ex) {
            this.logTrace("Failed Operation: OraCluster.getParent: Cluster ID:" + this.m_parent.getClusterId() + ": ", ex);
            this.m_parent = null;
        }
        return this.m_parent;
    }

    public Cluster[] getAncestors() throws JDMException {
        if (this.m_ancestors != null) {
            return this.m_ancestors;
        }
        Cluster parentCluster = this.getParent();
        if (parentCluster == null) {
            return null;
        }
        Vector<Cluster> ancestors = new Vector<Cluster>();
        ancestors.insertElementAt(parentCluster, 0);
        while ((parentCluster = parentCluster.getParent()) != null) {
            ancestors.addElement(parentCluster);
        }
        this.m_ancestors = ancestors.toArray(new Cluster[ancestors.size()]);
        return this.m_ancestors;
    }

    public int getLevel() {
        return this.m_treeLevel - 1;
    }

    public long getCaseCount() {
        return this.m_caseCount;
    }

    public double getSupport() {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"getSupport", ""}, null);
        return 0.0;
    }

    public double getDispersion() {
        return this.m_dispersion;
    }

    public Double getCentroidCoordinate(String numericalAttributeName) throws JDMException {
        Object centroidValue;
        if (this.m_centroids == null) {
            this.m_centroids = this.m_model.getCentroids(this.m_clusterId);
        }
        if ((centroidValue = this.m_centroids.get(numericalAttributeName)) == null || !(centroidValue instanceof Double)) {
            this.createException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"getCentroidCoordinate", ""}, null);
        }
        return (Double)centroidValue;
    }

    public TreeMap getCentroids() throws JDMException {
        if (this.m_centroids == null) {
            this.m_centroids = this.m_model.getCentroids(this.m_clusterId);
        }
        return this.m_centroids;
    }

    public Double getCentroidCoordinate(String categoricalAttributeName, Object category) throws JDMException {
        return null;
    }

    public Predicate getSplitPredicate() {
        if (this.m_splitPredicate != null) {
            return this.m_splitPredicate;
        }
        MiningAlgorithm ma = this.m_model.getMiningAlgorithm();
        if (ma.equals((Object)MiningAlgorithm.kMeans)) {
            return null;
        }
        Predicate predicate = null;
        try {
            predicate = this.m_model.getSplitPredicate(this.m_clusterId);
        }
        catch (Exception ex) {
            this.logTrace("Failed Operation: OraCluster.getSplitPredicate: Cluster ID:" + this.m_clusterId + ": ", ex);
            predicate = null;
        }
        this.m_splitPredicate = predicate;
        return this.m_splitPredicate;
    }

    public Cluster[] getChildren() {
        if (this.m_children != null) {
            return this.m_children;
        }
        Collection childClusters = null;
        try {
            childClusters = this.m_model.getChildClusters(this.m_clusterId);
        }
        catch (Exception ex) {
            this.logTrace("Failed Operation: OraCluster.getChildren: Cluster ID:" + this.m_clusterId + ": ", ex);
            childClusters = null;
        }
        if (childClusters != null && !childClusters.isEmpty()) {
            this.m_children = childClusters.toArray(new Cluster[childClusters.size()]);
        }
        return this.m_children;
    }

    public AttributeStatisticsSet getStatistics() throws JDMException {
        if (this.m_StatisticsSet != null) {
            return this.m_StatisticsSet;
        }
        this.m_StatisticsSet = this.m_model.getAttributeStatisticsSet(this.m_clusterId);
        return this.m_StatisticsSet;
    }

    public boolean isLeaf() {
        if (this.m_bLeaf != null) {
            return this.m_bLeaf;
        }
        boolean bLeaf = false;
        try {
            bLeaf = this.m_model.isLeaf(this.m_clusterId);
            this.m_bLeaf = new Boolean(bLeaf);
        }
        catch (Exception ex) {
            this.logTrace("Failed Operation: OraCluster.isLeaf: Cluster ID:" + this.m_clusterId + ": ", ex);
        }
        return bLeaf;
    }

    public boolean isRoot() {
        if (this.m_bRoot != null) {
            return this.m_bRoot;
        }
        boolean bRoot = false;
        try {
            bRoot = this.m_model.isRoot(this.m_clusterId);
            this.m_bRoot = new Boolean(bRoot);
        }
        catch (Exception ex) {
            this.logTrace("Failed Operation: OraCluster.isRoot: Cluster ID:" + this.m_clusterId + ": ", ex);
        }
        return bRoot;
    }

    public Rule getRule() {
        if (this.m_Rule != null) {
            return this.m_Rule;
        }
        Rule rule = null;
        try {
            this.m_Rule = rule = this.m_model.getRule(this.m_clusterId);
        }
        catch (Exception ex) {
            this.logTrace("Failed Operation: OraCluster.getRule: Cluster ID:" + this.m_clusterId + ": ", ex);
        }
        return rule;
    }

    OraCluster(OraConnection dmeConn, OraClusteringModel model, int clusterId, int treeLevel, Integer parentId, long caseCount, double dispersion) throws JDMException {
        super(dmeConn, null);
        this.m_clusterId = clusterId;
        this.m_parentID = parentId;
        this.m_treeLevel = treeLevel;
        this.m_caseCount = caseCount;
        this.m_dispersion = dispersion;
        this.m_model = model;
    }

    void setParentCluster(OraCluster parent) {
        this.m_parent = parent;
    }

    Integer getParentId() {
        return this.m_parentID;
    }

    void setChildren(Cluster[] childrenClusters) {
        this.m_children = childrenClusters;
    }
}

