/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.base;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.datamining.Enum;
import javax.datamining.ExecutionHandle;
import javax.datamining.ExecutionState;
import javax.datamining.ExecutionStatus;
import javax.datamining.JDMException;
import javax.datamining.MiningObject;
import javax.datamining.MiningTask;
import javax.datamining.NamedObject;
import javax.datamining.VerificationReport;
import javax.datamining.base.Task;
import javax.datamining.resource.Connection;
import oracle.dmt.jdm.OraExecutionHandle;
import oracle.dmt.jdm.OraExecutionStatus;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningObject;
import oracle.dmt.jdm.OraMiningTask;
import oracle.dmt.jdm.base.OraBuildSettings;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.scheduler.OraJob;
import oracle.dmt.jdm.scheduler.OraJobInfo;
import oracle.dmt.jdm.scheduler.OraProgramJob;
import oracle.dmt.jdm.supervised.classification.OraClassificationTestMetricsTask;
import oracle.dmt.jdm.supervised.classification.OraClassificationTestMetricsTaskFactory;
import oracle.dmt.jdm.supervised.classification.OraClassificationTestTask;
import oracle.dmt.jdm.supervised.classification.OraClassificationTestTaskFactory;
import oracle.dmt.jdm.supervised.regression.OraRegressionTestMetricsTask;
import oracle.dmt.jdm.supervised.regression.OraRegressionTestMetricsTaskFactory;
import oracle.dmt.jdm.supervised.regression.OraRegressionTestTask;
import oracle.dmt.jdm.supervised.regression.OraRegressionTestTaskFactory;
import oracle.dmt.jdm.task.OraBuildTask;
import oracle.dmt.jdm.task.OraBuildTaskFactory;
import oracle.dmt.jdm.task.OraDetectTaskImpl;
import oracle.dmt.jdm.task.OraExplainTaskFactoryImpl;
import oracle.dmt.jdm.task.OraExplainTaskImpl;
import oracle.dmt.jdm.task.OraExportTask;
import oracle.dmt.jdm.task.OraExportTaskFactory;
import oracle.dmt.jdm.task.OraImportTask;
import oracle.dmt.jdm.task.OraImportTaskFactory;
import oracle.dmt.jdm.task.OraPredictTaskFactoryImpl;
import oracle.dmt.jdm.task.OraPredictTaskImpl;
import oracle.dmt.jdm.task.OraPredictiveAnalyticsTaskFactoryImpl;
import oracle.dmt.jdm.task.OraProfileTaskImpl;
import oracle.dmt.jdm.task.OraSegmentTaskImpl;
import oracle.dmt.jdm.task.OraTransformationTaskFactoryImpl;
import oracle.dmt.jdm.task.OraTransformationTaskImpl;
import oracle.dmt.jdm.task.apply.OraDataSetApplyTask;
import oracle.dmt.jdm.task.apply.OraDataSetApplyTaskFactory;
import oracle.dmt.jdm.task.apply.OraRecordApplyTask;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public abstract class OraTask
extends OraMiningObject
implements Task {
    protected String m_programName = null;
    private OraProgramJob m_programJob = null;
    private ExecutionHandle m_execHandle = null;
    protected MiningTask m_taskType = null;
    private boolean m_autoDrop = false;
    private List m_parentTasks = null;
    protected String m_overwriteOutputs = "N";
    protected Vector m_jobArgs = null;
    private static int m_syncTaskNumber = 0;
    protected static String BUILD_PROGRAM = "SYS.JDM_BUILD_PROGRAM";
    protected static String APPLY_PROGRAM = "SYS.JDM_SQL_APPLY_PROGRAM";
    protected static String TEST_PROGRAM = "SYS.JDM_TEST_PROGRAM";
    protected static String EXPORT_PROGRAM = "SYS.JDM_EXPORT_PROGRAM";
    protected static String IMPORT_PROGRAM = "SYS.JDM_IMPORT_PROGRAM";
    protected static String XFORM_PROGRAM = "SYS.JDM_XFORM_PROGRAM";
    protected static String XFORM_SEQ_PROGRAM = "SYS.JDM_XFORM_SEQ_PROGRAM";
    protected static String PREDICT_PROGRAM = "SYS.JDM_PREDICT_PROGRAM";
    protected static String EXPLAIN_PROGRAM = "SYS.JDM_EXPLAIN_PROGRAM";
    protected static String PROFILE_PROGRAM = "SYS.JDM_PROFILE_PROGRAM";
    protected static String DETECT_PROGRAM = "SYS.JDM_DETECT_PROGRAM";
    protected static String SEGMENT_PROGRAM = "SYS.JDM_SEGMENT_PROGRAM";
    protected static String JDM_ATTR_NAMES = "SYS.JDM_ATTR_NAMES";
    protected static String JDM_STR_VALS = "SYS.JDM_STR_VALS";
    protected static String JDM_NUM_VALS = "SYS.JDM_NUM_VALS";
    private static String GET_JDM_ATTR_NAMES = "{ ? = call SYS.DBMS_JDM_INTERNAL.GET_JDM_ATTR_NAMES(?, ?) }";
    private static String GET_JDM_STR_VALS = "{ ? = call SYS.DBMS_JDM_INTERNAL.GET_JDM_STR_VALS(?, ?, ?) }";
    private static String GET_JDM_NUM_VALS = "{ ? = call SYS.DBMS_JDM_INTERNAL.GET_JDM_NUM_VALS(?, ?) }";
    protected static String ARG_OVERWRITE_OUTPUT = "OVERWRITE_OUTPUT";
    protected static String ARG_PARENT_TASKS = "PARENT_TASKS";
    protected static String ARG_CHILD_TASKS = "CHILD_TASKS";
    protected int ARG_IX_OVERWRITE_OUTPUT = -1;
    protected int ARG_IX_PARENT_TASKS = -1;
    protected int ARG_IX_CHILD_TASKS = -1;

    public ExecutionHandle getExecutionHandle() {
        if (this.m_execHandle == null && this.m_programJob != null) {
            this.m_execHandle = new OraExecutionHandle(this.getConnection(), this.m_programJob);
        }
        return this.m_execHandle;
    }

    protected OraTask(OraConnection dmeConn, OraFactory parentFactory, String programName) throws JDMException {
        super(dmeConn, parentFactory, NamedObject.task);
        if (dmeConn.is102()) {
            this.setup102();
            this.m_programName = programName.replaceFirst("SYS.JDM_", "DMSYS.");
        } else {
            this.m_programName = programName;
        }
    }

    protected abstract void prepareJobArguments(String var1) throws JDMException;

    protected void prepareNewJobArguments(String taskName) throws JDMException {
    }

    protected abstract void setupTaskInputs(String var1) throws JDMException;

    protected void prepareTaskDependncyJobArguments(String taskName) throws JDMException {
        try {
            ARRAY arr_parentTaskNames = null;
            if (this.m_parentTasks != null && this.m_parentTasks.size() > 0) {
                OraConnection dmeConn = this.getConnection();
                java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
                Object parentTaskNames = null;
                ArrayDescriptor strValsDesc = ArrayDescriptor.createDescriptor((String)(this.installedSchema + ".JDM_STR_VALS"), (java.sql.Connection)dbConn);
                Object[] parentTaskArray = this.m_parentTasks.toArray();
                String[] parentTasks = new String[parentTaskArray.length];
                System.arraycopy(parentTaskArray, 0, parentTasks, 0, parentTaskArray.length);
                arr_parentTaskNames = new ARRAY(strValsDesc, dbConn, (Object)parentTasks);
            }
            this.m_jobArgs.add(new Object[]{ARG_OVERWRITE_OUTPUT, this.m_overwriteOutputs, new Integer(12)});
            this.m_jobArgs.add(new Object[]{ARG_PARENT_TASKS, arr_parentTaskNames, new Integer(2003)});
            this.m_jobArgs.add(new Object[]{ARG_CHILD_TASKS, null, new Integer(2003)});
        }
        catch (SQLException sqlExp) {
            this.createException("2000", new Object[]{"save"}, sqlExp);
        }
    }

    protected void saveObjectInDatabase(Connection dmeConn, String name) throws JDMException {
        this.setupTaskInputs(name);
        this.prepareJobArguments(name);
        if (!this.is102()) {
            this.prepareTaskDependncyJobArguments(name);
            this.prepareNewJobArguments(name);
        }
        try {
            this.m_programJob = new OraProgramJob(name, this.m_programName, this.m_description, this.m_jobArgs);
            if (this.m_autoDrop) {
                this.m_programJob.setAutoDrop(this.m_autoDrop);
            }
            this.m_programJob.saveJob(((OraConnection)dmeConn).getDatabaseConnection(), name);
            if (!this.is102() && this.m_parentTasks != null && this.m_parentTasks.size() > 0) {
                OraJob.setJobDependency(((OraConnection)dmeConn).getDatabaseConnection(), name, (String)this.m_parentTasks.get(0), null, ((OraConnection)dmeConn).getLogger());
                String[] childTaskNamesOfTheParentTask = OraTask.getJDM_STR_VALS(((OraConnection)dmeConn).getDatabaseConnection(), (String)this.m_parentTasks.get(0), null, ARG_CHILD_TASKS, false);
                if (childTaskNamesOfTheParentTask == null || childTaskNamesOfTheParentTask.length < 1) {
                    childTaskNamesOfTheParentTask = new String[]{name};
                } else {
                    String[] temp = new String[childTaskNamesOfTheParentTask.length + 1];
                    System.arraycopy(childTaskNamesOfTheParentTask, 0, temp, 0, childTaskNamesOfTheParentTask.length);
                    temp[childTaskNamesOfTheParentTask.length] = name;
                    childTaskNamesOfTheParentTask = temp;
                }
                OraTask.addChildTasks(((OraConnection)dmeConn).getDatabaseConnection(), (String)this.m_parentTasks.get(0), childTaskNamesOfTheParentTask);
            }
        }
        catch (SQLException sqlExp) {
            try {
                OraProgramJob.dropJob(((OraConnection)dmeConn).getDatabaseConnection(), name, null);
            }
            catch (Exception exp) {
                // empty catch block
            }
            this.logTrace("Failed Operation: OraTask.saveObjectInDatabase: ", sqlExp);
            this.createException("2000", new Object[]{"save"}, sqlExp);
        }
    }

    public static void removeObjectFromDatabase(OraConnection dmeConn, String name) throws JDMException {
        OraTask.removeTaskContents(dmeConn, name);
        try {
            OraJob.dropJob(dmeConn.getDatabaseConnection(), name, dmeConn.getLogger());
        }
        catch (SQLException sqlExp) {
            dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, sqlExp);
        }
    }

    static void removeTaskContents(OraConnection dmeConn, String name) throws JDMException {
        try {
            OraTask task = OraTask.retrieveObjectFromDatabase(dmeConn, name);
            if (task != null) {
                task.removeTaskNonJobContents(dmeConn);
            }
        }
        catch (SQLException sqlExp) {
            dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, sqlExp);
        }
    }

    protected void removeTaskNonJobContents(OraConnection dmeConn) throws JDMException {
    }

    public NamedObject getObjectType() {
        return NamedObject.task;
    }

    public boolean isInputObject() {
        return false;
    }

    public void addDependency(String parentTaskName) throws JDMException {
        String parentTask = this.getConnection().getValidationHandler().validateObjectName(parentTaskName, "parentTaskName", NamedObject.task);
        if (this.m_parentTasks == null) {
            this.m_parentTasks = new ArrayList();
        }
        this.m_parentTasks.add(parentTask);
    }

    public void dropDependency(String parentTaskName) throws JDMException {
        this.getConnection().getValidationHandler().validateObjectName(parentTaskName, "parentTaskName", NamedObject.task);
        if (this.m_parentTasks != null) {
            this.m_parentTasks.remove(parentTaskName);
        }
    }

    public List getParentTaskNames() {
        return this.m_parentTasks;
    }

    public List getChildTaskNames() {
        return this.m_parentTasks;
    }

    public void overwriteOutput(boolean overwrite) {
        this.m_overwriteOutputs = overwrite ? "Y" : "N";
    }

    public boolean overwriteOutput() {
        return this.m_overwriteOutputs.equals("Y");
    }

    public static ExecutionHandle execute(Connection dmeConn, String taskName) throws JDMException {
        OraConnection dmeConnImpl = (OraConnection)dmeConn;
        try {
            java.sql.Connection dbConn = dmeConnImpl.getDatabaseConnection();
            if (dmeConnImpl.is102()) {
                OraJob.enableJob(dbConn, taskName, dmeConnImpl.getLogger());
            } else {
                OraTask.executeChildTasks(dbConn, taskName, dmeConnImpl.getLogger(), dmeConnImpl.is102());
            }
            OraProgramJob job = OraProgramJob.retrieve(dbConn, taskName, dmeConnImpl.getLogger());
            return new OraExecutionHandle(dmeConnImpl, job);
        }
        catch (SQLException sqlExp) {
            dmeConnImpl.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, sqlExp);
            return null;
        }
    }

    private static void executeChildTasks(java.sql.Connection dbConn, String taskName, Logger logger, boolean is102) throws SQLException {
        String[] childTaskNames = OraTask.getJDM_STR_VALS(dbConn, taskName, null, ARG_CHILD_TASKS, is102);
        if (childTaskNames != null) {
            for (int i = 0; i < childTaskNames.length; ++i) {
                OraTask.executeChildTasks(dbConn, childTaskNames[i], logger, is102);
            }
        }
        OraJob.enableJob(dbConn, taskName, logger);
    }

    public static ExecutionStatus execute(OraConnection dmeConn, Task task, Long timeout) throws JDMException {
        dmeConn.getValidationHandler().validateNotNull(task, "task");
        if (timeout != null) {
            dmeConn.getValidationHandler().validateNumber(timeout, 0L, "timeout");
        }
        OraExecutionStatus execStatus = null;
        if (task instanceof OraRecordApplyTask) {
            OraRecordApplyTask rat = (OraRecordApplyTask)task;
            rat.execute(dmeConn, timeout);
            execStatus = new OraExecutionStatus(ExecutionState.success, rat.getTaskDescription());
        } else {
            try {
                String taskName = OraJob.generateJobName(dmeConn.getDatabaseConnection());
                OraTask oraTask = (OraTask)task;
                dmeConn.saveObject(taskName, (MiningObject)task, true);
                OraProgramJob cfr_ignored_0 = oraTask.m_programJob;
                OraProgramJob.runJob(dmeConn.getDatabaseConnection(), taskName, dmeConn.getLogger());
                dmeConn.getDatabaseConnection().commit();
                String[] jobStateDetails = OraJobInfo.getJobStateDetails(dmeConn.getDatabaseConnection(), taskName);
                execStatus = new OraExecutionStatus(jobStateDetails[0], jobStateDetails[1]);
                try {
                    dmeConn.removeObject(taskName, NamedObject.task);
                }
                catch (Exception anyExp) {}
            }
            catch (Exception anyExp) {
                dmeConn.createException("2000", new Object[]{"execute"}, anyExp);
            }
        }
        return execStatus;
    }

    public OraProgramJob getJob() {
        return this.m_programJob;
    }

    public String getDescription() {
        if (this.m_description == null) {
            this.m_description = this.m_programJob.getComments();
        }
        return super.getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection retrieveObjectsFromDatabase(OraConnection dmeConn, Date createdAfter, Date createdBefore, Enum minorType) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        String sqlSpec = "SELECT job_name FROM user_scheduler_jobs";
        PreparedStatement ps = null;
        ResultSet rs = null;
        Object description = null;
        String objectName = null;
        Vector<OraTask> returnedObjects = new Vector<OraTask>();
        try {
            ps = dbConn.prepareStatement(sqlSpec);
            rs = ps.executeQuery();
            while (rs.next()) {
                objectName = rs.getString("JOB_NAME");
                OraTask object = null;
                try {
                    object = OraTask.retrieveObjectFromDatabase(dmeConn, objectName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                boolean addToList = false;
                if (object != null) {
                    if (createdAfter == null & createdBefore == null) {
                        addToList = true;
                    } else if (createdAfter != null && object.getCreationDate().after(createdAfter) & createdBefore == null) {
                        addToList = true;
                    } else if (createdAfter == null & createdBefore != null && object.getCreationDate().before(createdBefore)) {
                        addToList = true;
                    } else if (createdAfter != null && object.getCreationDate().after(createdAfter) & createdBefore != null && object.getCreationDate().before(createdBefore)) {
                        addToList = true;
                    }
                    if (minorType != null && object.m_taskType == minorType) {
                        addToList &= true;
                    } else if (minorType != null && object.m_taskType != minorType) {
                        addToList &= false;
                    }
                }
                if (!addToList) continue;
                returnedObjects.add(object);
            }
        }
        catch (SQLException sqlExp) {
            dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{objectName}, sqlExp, OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e1) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception e2) {}
        }
        return returnedObjects;
    }

    public static OraTask retrieveObjectFromDatabase(Connection dmeConn, String name) throws JDMException, SQLException {
        OraConnection dmeConnImpl = (OraConnection)dmeConn;
        OraTask task = null;
        try {
            OraProgramJob job = OraProgramJob.retrieve(dmeConnImpl.getDatabaseConnection(), name, dmeConnImpl.getLogger());
            if (job != null) {
                Vector jobArgsVector = job.getJobArguments();
                boolean isArgsRetrieved = false;
                if (BUILD_PROGRAM.endsWith(job.getProgramName())) {
                    task = new OraBuildTask(dmeConnImpl, (OraBuildTaskFactory)dmeConn.getFactory("javax.datamining.task.BuildTask"));
                } else if (APPLY_PROGRAM.endsWith(job.getProgramName())) {
                    task = new OraDataSetApplyTask(dmeConnImpl, (OraDataSetApplyTaskFactory)dmeConn.getFactory("javax.datamining.task.apply.DataSetApplyTask"));
                } else if (TEST_PROGRAM.endsWith(job.getProgramName())) {
                    if (jobArgsVector != null) {
                        isArgsRetrieved = true;
                        boolean isTestMetrics = false;
                        boolean isClassification = false;
                        if (((Object[])jobArgsVector.get(0))[1] == null) {
                            isTestMetrics = true;
                        }
                        if ("CLASSIFICATION".equals(((Object[])jobArgsVector.get(16))[1])) {
                            isClassification = true;
                        }
                        task = isClassification ? (isTestMetrics ? new OraClassificationTestMetricsTask(dmeConnImpl, (OraClassificationTestMetricsTaskFactory)dmeConn.getFactory("javax.datamining.supervised.classification.ClassificationTestMetricsTask")) : new OraClassificationTestTask(dmeConnImpl, (OraClassificationTestTaskFactory)dmeConn.getFactory("javax.datamining.supervised.classification.ClassificationTestTask"))) : (isTestMetrics ? new OraRegressionTestMetricsTask(dmeConnImpl, (OraRegressionTestMetricsTaskFactory)dmeConn.getFactory("javax.datamining.supervised.regression.RegressionTestMetricsTask")) : new OraRegressionTestTask(dmeConnImpl, (OraRegressionTestTaskFactory)dmeConn.getFactory("javax.datamining.supervised.regression.RegressionTestTask")));
                        task.m_jobArgs = jobArgsVector;
                        task.mapJobArgs();
                    }
                } else if (EXPORT_PROGRAM.endsWith(job.getProgramName())) {
                    task = new OraExportTask(dmeConnImpl, (OraExportTaskFactory)dmeConn.getFactory("javax.datamining.task.ExportTask"));
                } else if (IMPORT_PROGRAM.endsWith(job.getProgramName())) {
                    task = new OraImportTask(dmeConnImpl, (OraImportTaskFactory)dmeConn.getFactory("javax.datamining.task.ImportTask"));
                } else if (XFORM_PROGRAM.endsWith(job.getProgramName())) {
                    task = new OraTransformationTaskImpl(dmeConnImpl, (OraTransformationTaskFactoryImpl)dmeConn.getFactory("oracle.dmt.jdm.task.OraTransformationTask"));
                } else if (XFORM_SEQ_PROGRAM.endsWith(job.getProgramName())) {
                    task = new OraTransformationTaskImpl(dmeConnImpl, (OraTransformationTaskFactoryImpl)dmeConn.getFactory("oracle.dmt.jdm.task.OraTransformationTask"), XFORM_SEQ_PROGRAM);
                } else if (PREDICT_PROGRAM.endsWith(job.getProgramName())) {
                    task = new OraPredictTaskImpl(dmeConnImpl, (OraPredictTaskFactoryImpl)dmeConn.getFactory("oracle.dmt.jdm.task.OraPredictTask"));
                } else if (EXPLAIN_PROGRAM.endsWith(job.getProgramName())) {
                    task = new OraExplainTaskImpl(dmeConnImpl, (OraExplainTaskFactoryImpl)dmeConn.getFactory("oracle.dmt.jdm.task.OraExplainTask"));
                } else if (PROFILE_PROGRAM.endsWith(job.getProgramName())) {
                    task = new OraProfileTaskImpl(dmeConnImpl, (OraPredictiveAnalyticsTaskFactoryImpl)dmeConn.getFactory("oracle.dmt.jdm.task.OraPredictiveAnalyticsTask"));
                } else if (SEGMENT_PROGRAM.endsWith(job.getProgramName())) {
                    task = new OraSegmentTaskImpl(dmeConnImpl, (OraPredictiveAnalyticsTaskFactoryImpl)dmeConn.getFactory("oracle.dmt.jdm.task.OraPredictiveAnalyticsTask"));
                } else if (DETECT_PROGRAM.endsWith(job.getProgramName())) {
                    task = new OraDetectTaskImpl(dmeConnImpl, (OraPredictiveAnalyticsTaskFactoryImpl)dmeConn.getFactory("oracle.dmt.jdm.task.OraPredictiveAnalyticsTask"));
                }
                task.m_programJob = job;
                if (jobArgsVector != null && !isArgsRetrieved) {
                    task.m_jobArgs = jobArgsVector;
                    task.mapJobArgs();
                }
                task.setName(job.getName());
                task.setDescription(job.getComments());
                task.setCreationDate(job.getJobInfo(dmeConnImpl.getDatabaseConnection()).getCreatedTimestamp());
                return task;
            }
            dmeConnImpl.createException("2000", new Object[]{"retrieveObject"}, null, "3516", new Object[]{name});
        }
        catch (SQLException sqlExp) {
            JDMException jdmExp = new JDMException();
            jdmExp.initCause((Throwable)sqlExp);
            throw jdmExp;
        }
        return null;
    }

    public static OraBuildSettings retrieveObjectFromDatabaseByID(OraConnection dmeConn, String identifier) throws JDMException, SQLException {
        return null;
    }

    public static void renameObjectInDatabase(OraConnection dmeConn, String oldName, String newName) throws JDMException, SQLException {
        dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"task:rename", null}, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesObjectExistInDatabase(OraConnection dmeConn, String name) throws JDMException, SQLException {
        String sql = "SELECT OBJECT_NAME FROM USER_OBJECTS WHERE OBJECT_TYPE='JOB' AND OBJECT_NAME = '" + name + "'";
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqlExp) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqlExp2) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getJDM_ATTR_NAMES(String jobName, int argPosition) throws SQLException {
        java.sql.Connection dbConn = this.getDatabaseConnection();
        OracleCallableStatement cStmt = null;
        Object textCols = null;
        ARRAY objArray = null;
        try {
            Object arr_txtCols = null;
            ArrayDescriptor attrNamesDesc = ArrayDescriptor.createDescriptor((String)((this.is102() ? "DMSYS." : "SYS.") + "JDM_ATTR_NAMES"), (java.sql.Connection)dbConn);
            cStmt = (OracleCallableStatement)dbConn.prepareCall(GET_JDM_ATTR_NAMES);
            cStmt.setString(2, jobName);
            cStmt.setInt(3, argPosition);
            cStmt.registerOutParameter(1, 2003, (this.is102() ? "DMSYS." : "SYS.") + "JDM_ATTR_NAMES");
            cStmt.execute();
            objArray = cStmt.getARRAY(1);
        }
        finally {
            if (cStmt != null) {
                cStmt.close();
            }
        }
        if (objArray == null) {
            return null;
        }
        return (String[])objArray.getArray();
    }

    protected String[] getJDM_STR_VALS(String jobName, int argPosition) throws SQLException {
        java.sql.Connection dbConn = this.getDatabaseConnection();
        return OraTask.getJDM_STR_VALS(dbConn, jobName, new Integer(argPosition), null, this.is102());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getJDM_STR_VALS(java.sql.Connection dbConn, String jobName, Integer argPosition, String argName, boolean is102) throws SQLException {
        OracleCallableStatement cStmt = null;
        Object textCols = null;
        ARRAY objArray = null;
        try {
            Object arr_txtCols = null;
            ArrayDescriptor attrNamesDesc = ArrayDescriptor.createDescriptor((String)((is102 ? "DMSYS." : "SYS.") + "JDM_STR_VALS"), (java.sql.Connection)dbConn);
            cStmt = (OracleCallableStatement)dbConn.prepareCall(GET_JDM_STR_VALS);
            cStmt.setString(2, jobName);
            if (!is102 && argPosition == null) {
                cStmt.setString(4, argName);
                cStmt.setNull(3, 4);
            } else {
                if (!is102) {
                    cStmt.setNull(4, 12);
                }
                cStmt.setInt(3, argPosition.intValue());
            }
            cStmt.registerOutParameter(1, 2003, (is102 ? "DMSYS." : "SYS.") + "JDM_STR_VALS");
            cStmt.execute();
            objArray = cStmt.getARRAY(1);
        }
        catch (SQLException sqlExp) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (cStmt != null) {
                cStmt.close();
            }
        }
        if (objArray == null) {
            return null;
        }
        return (String[])objArray.getArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double[] getJDM_NUM_VALS(String jobName, int argPosition) throws SQLException {
        java.sql.Connection dbConn = this.getDatabaseConnection();
        OracleCallableStatement cStmt = null;
        Object textCols = null;
        ARRAY objArray = null;
        try {
            Object arr_txtCols = null;
            ArrayDescriptor attrNamesDesc = ArrayDescriptor.createDescriptor((String)((this.is102() ? "DMSYS." : "SYS.") + "JDM_NUM_VALS"), (java.sql.Connection)dbConn);
            cStmt = (OracleCallableStatement)dbConn.prepareCall(GET_JDM_NUM_VALS);
            cStmt.setString(2, jobName);
            cStmt.setInt(3, argPosition);
            cStmt.registerOutParameter(1, 2003, (this.is102() ? "DMSYS." : "SYS.") + "JDM_NUM_VALS");
            cStmt.execute();
            objArray = cStmt.getARRAY(1);
        }
        finally {
            if (cStmt != null) {
                cStmt.close();
            }
        }
        if (objArray == null) {
            return null;
        }
        return objArray.getDoubleArray();
    }

    public VerificationReport verify() {
        return null;
    }

    public static String getProgramName(MiningTask taskEnum) {
        if (MiningTask.buildTask.equals((Object)taskEnum)) {
            return "SYS.JDM_BUILD_PROGRAM".substring(4);
        }
        if (MiningTask.testTask.equals((Object)taskEnum)) {
            return "SYS.JDM_TEST_PROGRAM".substring(4);
        }
        if (MiningTask.applyTask.equals((Object)taskEnum)) {
            return "SYS.JDM_SQL_APPLY_PROGRAM".substring(4);
        }
        if (MiningTask.importTask.equals((Object)taskEnum)) {
            return "SYS.JDM_IMPORT_PROGRAM".substring(4);
        }
        if (MiningTask.exportTask.equals((Object)taskEnum)) {
            return "SYS.JDM_EXPORT_PROGRAM".substring(4);
        }
        if (OraMiningTask.predictTask.equals((Object)taskEnum)) {
            return "SYS.JDM_PREDICT_PROGRAM".substring(4);
        }
        if (OraMiningTask.explainTask.equals((Object)taskEnum)) {
            return "SYS.JDM_EXPLAIN_PROGRAM".substring(4);
        }
        if (OraMiningTask.transformTask.equals((Object)taskEnum)) {
            return "SYS.JDM_XFORM_PROGRAM".substring(4);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addChildTasks(java.sql.Connection dbConn, String jobName, String[] childTasks) throws SQLException {
        StringBuffer sqlQuery = new StringBuffer("{ call DBMS_SCHEDULER.SET_JOB_ANYDATA_VALUE(?,?, ANYDATA.");
        Statement cStmt = null;
        try {
            sqlQuery.append("convertcollection(?)) }");
            cStmt = dbConn.prepareCall(sqlQuery.toString());
            OracleCallableStatement ocstmt = (OracleCallableStatement)cStmt;
            ocstmt.setString(1, jobName);
            ocstmt.setString(2, ARG_CHILD_TASKS);
            if (childTasks == null || childTasks.length < 1) {
                ocstmt.setNull(3, 2003);
            } else {
                Object childTaskNames = null;
                ArrayDescriptor strValsDesc = ArrayDescriptor.createDescriptor((String)"SYS.JDM_STR_VALS", (java.sql.Connection)dbConn);
                ARRAY arr_childTaskNames = new ARRAY(strValsDesc, dbConn, (Object)childTasks);
                ocstmt.setARRAY(3, arr_childTaskNames);
            }
            ocstmt.execute();
        }
        finally {
            if (cStmt != null) {
                cStmt.close();
            }
        }
    }

    protected abstract void mapJobArgs();

    public void setup102() {
        BUILD_PROGRAM = "DMSYS.BUILD_PROGRAM";
        APPLY_PROGRAM = "DMSYS.SQL_APPLY_PROGRAM";
        TEST_PROGRAM = "DMSYS.TEST_PROGRAM";
        EXPORT_PROGRAM = "DMSYS.EXPORT_PROGRAM";
        IMPORT_PROGRAM = "DMSYS.IMPORT_PROGRAM";
        XFORM_PROGRAM = "DMSYS.XFORM_PROGRAM";
        PREDICT_PROGRAM = "DMSYS.PREDICT_PROGRAM";
        EXPLAIN_PROGRAM = "DMSYS.EXPLAIN_PROGRAM";
        JDM_ATTR_NAMES = "DMSYS.JDM_ATTR_NAMES";
        JDM_STR_VALS = "DMSYS.JDM_STR_VALS";
        JDM_NUM_VALS = "DMSYS.JDM_NUM_VALS";
        GET_JDM_ATTR_NAMES = "{ ? = call DMSYS.DBMS_JDM_INTERNAL.GET_JDM_ATTR_NAMES(?, ?) }";
        GET_JDM_STR_VALS = "{ ? = call DMSYS.DBMS_JDM_INTERNAL.GET_JDM_STR_VALS(?, ?) }";
        GET_JDM_NUM_VALS = "{ ? = call DMSYS.DBMS_JDM_INTERNAL.GET_JDM_NUM_VALS(?, ?) }";
    }

    public static interface SYS_CONSTANTS {
        public static final String BUILD_PROGRAM = "SYS.JDM_BUILD_PROGRAM";
        public static final String APPLY_PROGRAM = "SYS.JDM_SQL_APPLY_PROGRAM";
        public static final String TEST_PROGRAM = "SYS.JDM_TEST_PROGRAM";
        public static final String EXPORT_PROGRAM = "SYS.JDM_EXPORT_PROGRAM";
        public static final String IMPORT_PROGRAM = "SYS.JDM_IMPORT_PROGRAM";
        public static final String XFORM_PROGRAM = "SYS.JDM_XFORM_PROGRAM";
        public static final String XFORM_SEQ_PROGRAM = "SYS.JDM_XFORM_SEQ_PROGRAM";
        public static final String PREDICT_PROGRAM = "SYS.JDM_PREDICT_PROGRAM";
        public static final String EXPLAIN_PROGRAM = "SYS.JDM_EXPLAIN_PROGRAM";
        public static final String PROFILE_PROGRAM = "SYS.JDM_PROFILE_PROGRAM";
        public static final String DETECT_PROGRAM = "SYS.JDM_DETECT_PROGRAM";
        public static final String SEGMENT_PROGRAM = "SYS.JDM_SEGMENT_PROGRAM";
        public static final String JDM_ATTR_NAMES = "SYS.JDM_ATTR_NAMES";
        public static final String JDM_STR_VALS = "SYS.JDM_STR_VALS";
        public static final String JDM_NUM_VALS = "SYS.JDM_NUM_VALS";
        public static final String GET_JDM_ATTR_NAMES = "{ ? = call SYS.DBMS_JDM_INTERNAL.GET_JDM_ATTR_NAMES(?, ?) }";
        public static final String GET_JDM_STR_VALS = "{ ? = call SYS.DBMS_JDM_INTERNAL.GET_JDM_STR_VALS(?, ?, ?) }";
        public static final String GET_JDM_NUM_VALS = "{ ? = call SYS.DBMS_JDM_INTERNAL.GET_JDM_NUM_VALS(?, ?) }";
    }

    static interface DMSYS_CONSTANTS {
        public static final String BUILD_PROGRAM = "DMSYS.BUILD_PROGRAM";
        public static final String APPLY_PROGRAM = "DMSYS.SQL_APPLY_PROGRAM";
        public static final String TEST_PROGRAM = "DMSYS.TEST_PROGRAM";
        public static final String EXPORT_PROGRAM = "DMSYS.EXPORT_PROGRAM";
        public static final String IMPORT_PROGRAM = "DMSYS.IMPORT_PROGRAM";
        public static final String XFORM_PROGRAM = "DMSYS.XFORM_PROGRAM";
        public static final String PREDICT_PROGRAM = "DMSYS.PREDICT_PROGRAM";
        public static final String EXPLAIN_PROGRAM = "DMSYS.EXPLAIN_PROGRAM";
        public static final String JDM_ATTR_NAMES = "DMSYS.JDM_ATTR_NAMES";
        public static final String JDM_STR_VALS = "DMSYS.JDM_STR_VALS";
        public static final String JDM_NUM_VALS = "DMSYS.JDM_NUM_VALS";
        public static final String GET_JDM_ATTR_NAMES = "{ ? = call DMSYS.DBMS_JDM_INTERNAL.GET_JDM_ATTR_NAMES(?, ?) }";
        public static final String GET_JDM_STR_VALS = "{ ? = call DMSYS.DBMS_JDM_INTERNAL.GET_JDM_STR_VALS(?, ?) }";
        public static final String GET_JDM_NUM_VALS = "{ ? = call DMSYS.DBMS_JDM_INTERNAL.GET_JDM_NUM_VALS(?, ?) }";
    }
}

