/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.base;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.datamining.AttributeRetrievalType;
import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.LogicalAttributeUsage;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningFunction;
import javax.datamining.NamedObject;
import javax.datamining.OutlierTreatment;
import javax.datamining.VerificationReport;
import javax.datamining.algorithm.kmeans.KMeansSettingsFactory;
import javax.datamining.algorithm.naivebayes.NaiveBayesSettingsFactory;
import javax.datamining.algorithm.tree.TreeSettingsFactory;
import javax.datamining.association.AssociationSettingsFactory;
import javax.datamining.attributeimportance.AttributeImportanceSettingsFactory;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.base.BuildSettings;
import javax.datamining.clustering.ClusteringSettingsFactory;
import javax.datamining.data.Interval;
import javax.datamining.data.LogicalData;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.classification.ClassificationSettingsFactory;
import javax.datamining.supervised.regression.RegressionSettingsFactory;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.OraMiningFunction;
import oracle.dmt.jdm.OraMiningObject;
import oracle.dmt.jdm.OraPLSQLMappings;
import oracle.dmt.jdm.algorithm.abn.OraABNSettingsFactory;
import oracle.dmt.jdm.algorithm.glm.OraGLMSettingsFactory;
import oracle.dmt.jdm.algorithm.nmf.OraNMFAlgorithmSettingsFactory;
import oracle.dmt.jdm.algorithm.ocluster.OraOClusterSettingsFactory;
import oracle.dmt.jdm.algorithm.svm.classification.OraSVMClassificationSettingsFactory;
import oracle.dmt.jdm.algorithm.svm.regression.OraSVMRegressionSettingsFactory;
import oracle.dmt.jdm.base.OraAlgorithmSettings;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionSettingsFactory;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.resource.OraValidationHandler;
import oracle.dmt.jdm.supervised.classification.OraClassificationSettings;
import oracle.dmt.jdm.utils.OraSQLUtils;
import oracle.dmt.jdm.utils.OraStringUtils;
import oracle.jdbc.OraclePreparedStatement;

public abstract class OraBuildSettings
extends OraMiningObject
implements BuildSettings {
    private MiningFunction m_miningFunction = null;
    private Map m_settingsPair = null;
    private Map m_priorsMap = null;
    protected Map m_targetWeightsMap = null;
    private String m_weightAttributeName = null;
    protected OraAlgorithmSettings m_algoSettings = null;
    private int m_desiredExecutionTime = Integer.MAX_VALUE;
    protected static final String FUNCTION_NAME = "JDMS_FUNCTION_TYPE";
    protected static final String BS_COMMENTS_PREFIX = "BS_";
    protected static final String PR_COMMENTS_PREFIX = "PR_";
    protected static final String WT_COMMENTS_PREFIX = "WT_";
    private static String SINGLE_QUOTE = "'";
    protected String m_priorTableName = null;
    protected String m_targetWeightsTableName = null;

    public void useAutomatedDataPreparations(boolean useAutomatedDataPreparations) {
        if (this.m_algoSettings == null && !useAutomatedDataPreparations && MiningAlgorithm.decisionTree.equals((Object)this.m_algoSettings.getMiningAlgorithm())) {
            this.unsupported("useAutomatedDataPreparations");
        } else {
            this.setValue("PREP_AUTO", useAutomatedDataPreparations ? "ON" : "OFF");
        }
    }

    public boolean useAutomatedDataPreparations() {
        String prepAuto = this.getValue("PREP_AUTO");
        if (prepAuto == null) {
            return MiningAlgorithm.decisionTree.equals((Object)this.m_algoSettings.getMiningAlgorithm());
        }
        return prepAuto.equalsIgnoreCase("ON");
    }

    protected OraBuildSettings(OraConnection dmeConn, OraFactory factory, MiningFunction miningFunction) throws JDMException {
        super(dmeConn, factory, NamedObject.buildSettings);
        this.m_miningFunction = miningFunction;
        this.m_settingsPair = new HashMap();
        this.setValue(FUNCTION_NAME, OraPLSQLMappings.getPLSQLConstant(miningFunction));
        this.m_algoSettings = (OraAlgorithmSettings)this.getDefaultAlgorithmSettings();
    }

    protected abstract AlgorithmSettings getDefaultAlgorithmSettings();

    protected abstract boolean isSupported(AlgorithmSettings var1);

    protected synchronized void setValue(String key, Object value) {
        this.m_settingsPair.put(key, value);
    }

    protected Object getObjectValue(String key) {
        if (!this.m_settingsPair.containsKey(key)) {
            // empty if block
        }
        return this.m_settingsPair.get(key);
    }

    protected String getValue(String key) {
        return (String)this.getObjectValue(key);
    }

    public int getDesiredExecutionTimeInMinutes() {
        return this.m_desiredExecutionTime;
    }

    public void setDesiredExecutionTimeInMinutes(int minutes) {
        this.getValidationHandler().validateNonNegative(minutes, "minutes");
        this.m_desiredExecutionTime = minutes;
    }

    public AlgorithmSettings getAlgorithmSettings() {
        return this.m_algoSettings;
    }

    public void setAlgorithmSettings(AlgorithmSettings algorithmSettings) {
        if (algorithmSettings == null) {
            this.m_algoSettings = (OraAlgorithmSettings)this.getDefaultAlgorithmSettings();
        } else {
            if (!this.isSupported(algorithmSettings)) {
                this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new Object[]{"AlgorithmSettings", algorithmSettings.getClass().getName()}, null);
            }
            this.m_algoSettings = (OraAlgorithmSettings)algorithmSettings;
        }
    }

    public LogicalData getLogicalData() {
        this.unsupported("BuildSettings.LogicalData");
        return null;
    }

    public String getLogicalDataName() {
        this.unsupported("BuildSettings.getLogicalDataName");
        return null;
    }

    public void setLogicalDataName(String name) throws JDMException {
        this.unsupported("BuildSettings.setLogicalDataName");
    }

    public Collection getLogicalAttributes(LogicalAttributeUsage usage) throws JDMException {
        this.unsupported("BuildSettings.getLogicalAttributes");
        return null;
    }

    public double getWeight(String logicalAttrName) throws JDMException {
        this.unsupported("BuildSettings.getWeight");
        return 0.0;
    }

    public void setWeight(String logicalAttrName, double weight) throws JDMException {
        this.unsupported("BuildSettings.setWeight");
    }

    public void setWeightAttribute(String logicalAttrName) throws JDMException {
        if (this.m_algoSettings != null && OraMiningAlgorithm.generalizedLinearModel.equals((Object)this.m_algoSettings.getMiningAlgorithm())) {
            if (logicalAttrName == null) {
                this.m_weightAttributeName = null;
                this.setValue("ODMS_ROW_WEIGHT_COLUMN_NAME", this.m_weightAttributeName);
            } else {
                this.getValidationHandler().validateTableColumnName(logicalAttrName, "logicalAttrName");
                this.m_weightAttributeName = logicalAttrName;
                this.setValue("ODMS_ROW_WEIGHT_COLUMN_NAME", this.m_weightAttributeName);
            }
        } else {
            this.unsupported("BuildSettings.setWeightAttribute");
        }
    }

    public String getWeightAttribute() {
        if (this.m_algoSettings != null && OraMiningAlgorithm.generalizedLinearModel.equals((Object)this.m_algoSettings.getMiningAlgorithm())) {
            if (this.m_weightAttributeName == null) {
                this.m_weightAttributeName = this.getValue("ODMS_ROW_WEIGHT_COLUMN_NAME");
            }
        } else {
            this.unsupported("BuildSettings.setWeightAttribute");
        }
        return this.m_weightAttributeName;
    }

    public LogicalAttributeUsage getUsage(String logicalAttrName) throws JDMException {
        this.unsupported("BuildSettings.getUsage");
        return null;
    }

    public void setUsage(String logicalAttrName, LogicalAttributeUsage usage) throws JDMException {
        this.unsupported("BuildSettings.setUsage");
    }

    public void setOutlierTreatment(String logicalAttrName, OutlierTreatment treatment) throws JDMException {
        this.unsupported("BuildSettings.setOutlierTreatment");
    }

    public OutlierTreatment getOutlierTreatment(String logicalAttrName) throws JDMException {
        this.unsupported("BuildSettings.getOutlierTreatment");
        return null;
    }

    public void setOutlierIdentification(String logicalAttrName, Interval bounds) throws JDMException {
        this.unsupported("BuildSettings.setOutlierIdentification");
    }

    public Interval getOutlierIdentification(String logicalAttrName) throws JDMException {
        this.unsupported("BuildSettings.getOutlierIdentification");
        return null;
    }

    public String[] getAttributeNames(AttributeRetrievalType retrievalType) {
        return null;
    }

    public MiningFunction getMiningFunction() {
        return this.m_miningFunction;
    }

    public VerificationReport verify() {
        return null;
    }

    protected Map getPriorsMap(String logicalAttrName) throws JDMException {
        this.getValidationHandler().validateTableColumnName(logicalAttrName, "logicalAttrName");
        return this.m_priorsMap;
    }

    protected void setPriorsMap(String logicalAttrName, Map priorsMap) {
        this.getValidationHandler().validateTableColumnName(logicalAttrName, "logicalAttrName");
        this.getValidationHandler().validateNotNull(priorsMap, "priorsMap");
        this.m_priorsMap = priorsMap;
    }

    public void saveObjectInDatabase(String name) throws JDMException {
        this.getValidationHandler().validateObjectName(name, "name", NamedObject.buildSettings);
        this.saveObjectInDatabase(this.getConnection(), name);
    }

    protected void saveObjectInDatabase(Connection dmeConn, String name) throws JDMException {
        this.getValidationHandler().validateObjectName(name, "name", NamedObject.buildSettings);
        try {
            this.doBeforeStore(name);
            this.createSettingsTable(dmeConn, name);
            this.storeSettings(dmeConn, name);
        }
        catch (JDMException jdmExp) {
            this.logTrace("Failed Operation: OraBuildSettings.saveObjectInDatabase: ", jdmExp);
            throw jdmExp;
        }
    }

    protected void createSettingsTable(Connection dmeConn, String tableName) throws JDMException {
        java.sql.Connection dbConn = this.getDatabaseConnection();
        try {
            if (OraSQLUtils.doesTableOrViewExists(dbConn, OraStringUtils.processQuotedName(tableName))) {
                // empty if block
            }
            String tableSpec = "CREATE TABLE " + tableName + " (SETTING_NAME VARCHAR2(30), SETTING_VALUE VARCHAR2(4000))";
            String comments = BS_COMMENTS_PREFIX + this.m_miningFunction.name();
            String description = this.getDescription();
            if (description != null) {
                comments = comments + ";Description:" + description;
            }
            OraSQLUtils.createTable(dbConn, tableName, tableSpec, comments);
        }
        catch (SQLException sqlExp) {
            this.logTrace("Failed Operation: OraBuildSettings.createSettingsTable: ", sqlExp);
            this.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, sqlExp, "2011", new Object[]{tableName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeSettings(Connection dmeConn, String tableName) throws JDMException {
        java.sql.Connection dbConn = ((OraConnection)dmeConn).getDatabaseConnection();
        boolean autoCommitFlag = false;
        try {
            autoCommitFlag = dbConn.getAutoCommit();
            dbConn.setAutoCommit(false);
            String[] sqlSpec = new String[]{"INSERT INTO " + tableName, " (SETTING_NAME, SETTING_VALUE) VALUES ({2}{0}{2},{2}{1}{2})"};
            Statement stmtInsertSettings = null;
            OraclePreparedStatement pStmtInsertPriors = null;
            String priorTableName = null;
            OraclePreparedStatement pStmtInsertWeights = null;
            String weightsTableName = null;
            try {
                String tableSpec;
                boolean isTargetString;
                Object targetVal;
                boolean isFirstTarget;
                Iterator targetIterator;
                Set targetSet;
                if (this.m_priorsMap != null && this.m_priorsMap.size() > 0) {
                    targetSet = this.m_priorsMap.keySet();
                    targetIterator = targetSet.iterator();
                    isFirstTarget = true;
                    targetVal = null;
                    isTargetString = false;
                    priorTableName = this.m_priorTableName == null ? (tableName.startsWith("\"") && tableName.endsWith("\"") ? "\"" + OraStringUtils.trimDoubleQuotes(tableName) + "_PR" + "\"" : tableName + "_PR") : (this.m_priorTableName.startsWith("\"") && this.m_priorTableName.endsWith("\"") ? "\"" + OraStringUtils.trimDoubleQuotes(this.m_priorTableName) + "\"" : this.m_priorTableName);
                    String insertPriors = null;
                    while (targetIterator.hasNext()) {
                        targetVal = targetIterator.next();
                        if (isFirstTarget) {
                            insertPriors = "INSERT INTO " + priorTableName + " VALUES (?,?)";
                            pStmtInsertPriors = (OraclePreparedStatement)dbConn.prepareStatement(insertPriors);
                            isTargetString = targetVal instanceof String;
                            tableSpec = "CREATE TABLE " + priorTableName + " (TARGET_VALUE ";
                            tableSpec = isTargetString ? tableSpec + "VARCHAR2(4000)" : tableSpec + "NUMBER";
                            tableSpec = tableSpec + ", PRIOR_PROBABILITY NUMBER)";
                            OraSQLUtils.createTable(dbConn, priorTableName, tableSpec, PR_COMMENTS_PREFIX + this.m_miningFunction.name());
                            isFirstTarget = false;
                        }
                        Number priorVal = (Number)this.m_priorsMap.get(targetVal);
                        if (isTargetString) {
                            pStmtInsertPriors.setString(1, (String)targetVal);
                            pStmtInsertPriors.setDouble(2, priorVal.doubleValue());
                        } else {
                            pStmtInsertPriors.setBigDecimal(1, new BigDecimal(((Number)targetVal).doubleValue()));
                            pStmtInsertPriors.setDouble(2, priorVal.doubleValue());
                        }
                        pStmtInsertPriors.addBatch();
                    }
                    pStmtInsertPriors.executeBatch();
                    dbConn.commit();
                }
                if (this.m_targetWeightsMap != null && this.m_targetWeightsMap.size() > 0) {
                    targetSet = this.m_targetWeightsMap.keySet();
                    targetIterator = targetSet.iterator();
                    isFirstTarget = true;
                    targetVal = null;
                    isTargetString = false;
                    weightsTableName = this.m_targetWeightsTableName == null ? (tableName.startsWith("\"") && tableName.endsWith("\"") ? "\"" + OraStringUtils.trimDoubleQuotes(tableName) + "_WT" + "\"" : tableName + "_WT") : (this.m_targetWeightsTableName.startsWith("\"") && this.m_targetWeightsTableName.endsWith("\"") ? "\"" + OraStringUtils.trimDoubleQuotes(this.m_targetWeightsTableName) + "\"" : this.m_targetWeightsTableName);
                    String insertWeights = null;
                    isFirstTarget = true;
                    while (targetIterator.hasNext()) {
                        targetVal = targetIterator.next();
                        if (isFirstTarget) {
                            insertWeights = "INSERT INTO " + weightsTableName + " VALUES (?,?)";
                            pStmtInsertWeights = (OraclePreparedStatement)dbConn.prepareStatement(insertWeights);
                            isTargetString = targetVal instanceof String;
                            tableSpec = "CREATE TABLE " + weightsTableName + " (TARGET_VALUE ";
                            tableSpec = isTargetString ? tableSpec + "VARCHAR2(4000)" : tableSpec + "NUMBER";
                            tableSpec = tableSpec + ", WEIGHT NUMBER)";
                            OraSQLUtils.createTable(dbConn, weightsTableName, tableSpec, WT_COMMENTS_PREFIX + this.m_miningFunction.name());
                            isFirstTarget = false;
                        }
                        Number weightVal = (Number)this.m_targetWeightsMap.get(targetVal);
                        Object sqlInsert = null;
                        if (isTargetString) {
                            pStmtInsertWeights.setString(1, (String)targetVal);
                            pStmtInsertWeights.setDouble(2, weightVal.doubleValue());
                        } else {
                            pStmtInsertWeights.setBigDecimal(1, new BigDecimal(((Number)targetVal).doubleValue()));
                            pStmtInsertWeights.setDouble(2, weightVal.doubleValue());
                        }
                        pStmtInsertWeights.addBatch();
                    }
                    pStmtInsertWeights.executeBatch();
                    dbConn.commit();
                }
                if (this.m_algoSettings != null) {
                    this.m_settingsPair.putAll(this.m_algoSettings.getAlgorithmSettingsMap());
                }
                Set keySet = this.m_settingsPair.keySet();
                Iterator keyIterator = keySet.iterator();
                stmtInsertSettings = dbConn.createStatement();
                while (keyIterator.hasNext()) {
                    String key = (String)keyIterator.next();
                    Object value = this.m_settingsPair.get(key);
                    String stringValue = null;
                    if (value == null) continue;
                    stringValue = (String)value;
                    String sqlInsert = sqlSpec[0] + MessageFormat.format(sqlSpec[1], key, stringValue, SINGLE_QUOTE);
                    stmtInsertSettings.execute(sqlInsert);
                }
                if (priorTableName != null) {
                    String sqlInsert = sqlSpec[0] + MessageFormat.format(sqlSpec[1], "CLAS_PRIORS_TABLE_NAME", OraStringUtils.getReplacedString(priorTableName, "'", "''"), SINGLE_QUOTE);
                    stmtInsertSettings.execute(sqlInsert);
                }
                if (weightsTableName != null) {
                    String sqlInsert = sqlSpec[0] + MessageFormat.format(sqlSpec[1], "CLAS_WEIGHTS_TABLE_NAME", OraStringUtils.getReplacedString(weightsTableName, "'", "''"), SINGLE_QUOTE);
                    stmtInsertSettings.execute(sqlInsert);
                }
                dbConn.commit();
            }
            catch (SQLException sqlExp) {
                try {
                    dbConn.rollback();
                }
                catch (Exception anyExp) {
                    // empty catch block
                }
                try {
                    OraBuildSettings.removeObjectFromDatabase((OraConnection)dmeConn, tableName);
                    if (priorTableName != null) {
                        OraSQLUtils.dropTableOrView(dbConn, OraStringUtils.getReplacedString(priorTableName, "'", "''"), true);
                    }
                    if (weightsTableName != null) {
                        OraSQLUtils.dropTableOrView(dbConn, OraStringUtils.getReplacedString(weightsTableName, "'", "''"), true);
                    }
                }
                catch (Exception anyExp) {
                    // empty catch block
                }
                this.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, sqlExp, "2000", new Object[]{"save"});
            }
            finally {
                if (pStmtInsertPriors != null) {
                    try {
                        pStmtInsertPriors.close();
                    }
                    catch (SQLException sqlExp) {}
                }
                if (stmtInsertSettings != null) {
                    try {
                        stmtInsertSettings.close();
                    }
                    catch (SQLException sqlExp) {}
                }
            }
        }
        catch (Exception sqlExp) {
            this.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, sqlExp, "2000", new Object[]{"save"});
        }
        finally {
            try {
                dbConn.setAutoCommit(autoCommitFlag);
            }
            catch (SQLException ignore) {}
        }
    }

    public NamedObject getObjectType() {
        return NamedObject.buildSettings;
    }

    public boolean isInputObject() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection retrieveObjectsFromDatabase(OraConnection dmeConn, java.util.Date createdAfter, java.util.Date createdBefore, Enum minorType) throws JDMException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        String sqlSpec = "SELECT C.COMMENTS, T.TABLE_NAME from ALL_TABLES T, ALL_TAB_COMMENTS C WHERE C.TABLE_NAME = T.TABLE_NAME AND C.COMMENTS like 'BS_%'";
        PreparedStatement ps = null;
        ResultSet rs = null;
        String description = null;
        String objectName = null;
        Vector<OraBuildSettings> returnedObjects = new Vector<OraBuildSettings>();
        try {
            ps = dbConn.prepareStatement(sqlSpec);
            rs = ps.executeQuery();
            while (rs.next()) {
                description = rs.getString("COMMENTS");
                objectName = rs.getString("TABLE_NAME");
                OraBuildSettings object = null;
                try {
                    object = OraBuildSettings.retrieveObjectFromDatabase(dmeConn, objectName, null);
                }
                catch (Exception e) {
                    // empty catch block
                }
                boolean addToList = false;
                if (object != null) {
                    if (createdAfter == null && createdBefore == null) {
                        addToList = true;
                    } else if (createdAfter != null && object.getCreationDate().after(createdAfter) && createdBefore == null) {
                        addToList = true;
                    } else if (createdAfter == null && createdBefore != null && object.getCreationDate().before(createdBefore)) {
                        addToList = true;
                    } else if (createdAfter != null && object.getCreationDate().after(createdAfter) && createdBefore != null && object.getCreationDate().before(createdBefore)) {
                        addToList = true;
                    }
                    if (minorType != null) {
                        addToList = object.getMiningFunction().equals((Object)minorType) ? addToList : false;
                    }
                }
                if (!addToList) continue;
                returnedObjects.add(object);
            }
        }
        catch (SQLException sqlExp) {
            dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{objectName}, sqlExp, "3503", null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e1) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception e2) {}
        }
        return returnedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OraBuildSettings createSettings(OraConnection dmeConn, Map settingsPair, MiningFunction function, String name) throws JDMException, SQLException {
        Object factory;
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        if (function == null) {
            String functionName = (String)settingsPair.get(FUNCTION_NAME);
            if (functionName == null) {
                dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{name}, null, "3505", new Object[]{FUNCTION_NAME});
            } else {
                function = OraPLSQLMappings.getMiningFunction(functionName);
                if (function == null) {
                    dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{name}, null, "3504", new Object[]{FUNCTION_NAME, functionName});
                }
            }
        }
        OraBuildSettings bSettings = null;
        if (MiningFunction.classification.equals((Object)function)) {
            Object weightsTableName;
            factory = (ClassificationSettingsFactory)dmeConn.getFactory("javax.datamining.supervised.classification.ClassificationSettings");
            OraClassificationSettings clsSettings = (OraClassificationSettings)factory.create();
            bSettings = clsSettings;
            bSettings.m_settingsPair.putAll(settingsPair);
            Object priorsTableName = settingsPair.get("CLAS_PRIORS_TABLE_NAME");
            if (priorsTableName != null) {
                bSettings.m_priorsMap = new TreeMap();
                Statement pStmt = null;
                ResultSet rsPriors = null;
                try {
                    pStmt = dbConn.prepareCall("SELECT * FROM " + (String)priorsTableName + " ORDER BY TARGET_VALUE ASC");
                    rsPriors = pStmt.executeQuery();
                    while (rsPriors.next()) {
                        bSettings.m_priorsMap.put(rsPriors.getObject(1), rsPriors.getObject(2));
                    }
                }
                finally {
                    if (pStmt != null) {
                        try {
                            pStmt.close();
                        }
                        catch (Exception anyExp1) {}
                    }
                    if (rsPriors != null) {
                        try {
                            rsPriors.close();
                        }
                        catch (Exception anyExp2) {}
                    }
                }
            }
            if ((weightsTableName = settingsPair.get("CLAS_WEIGHTS_TABLE_NAME")) != null) {
                bSettings.m_targetWeightsMap = new TreeMap();
                Statement pStmtWeights = null;
                ResultSet rsWeights = null;
                try {
                    pStmtWeights = dbConn.prepareCall("SELECT * FROM " + (String)weightsTableName + " ORDER BY TARGET_VALUE ASC");
                    rsWeights = pStmtWeights.executeQuery();
                    while (rsWeights.next()) {
                        bSettings.m_targetWeightsMap.put(rsWeights.getObject(1), rsWeights.getObject(2));
                    }
                }
                finally {
                    if (pStmtWeights != null) {
                        try {
                            pStmtWeights.close();
                        }
                        catch (Exception anyExp1) {}
                    }
                    if (rsWeights != null) {
                        try {
                            rsWeights.close();
                        }
                        catch (Exception anyExp2) {}
                    }
                }
            }
        } else if (MiningFunction.regression.equals((Object)function)) {
            factory = (RegressionSettingsFactory)dmeConn.getFactory("javax.datamining.supervised.regression.RegressionSettings");
            bSettings = (OraBuildSettings)factory.create();
        } else if (MiningFunction.clustering.equals((Object)function)) {
            factory = (ClusteringSettingsFactory)dmeConn.getFactory("javax.datamining.clustering.ClusteringSettings");
            bSettings = (OraBuildSettings)factory.create();
        } else if (MiningFunction.association.equals((Object)function)) {
            factory = (AssociationSettingsFactory)dmeConn.getFactory("javax.datamining.association.AssociationSettings");
            bSettings = (OraBuildSettings)factory.create();
        } else if (MiningFunction.attributeImportance.equals((Object)function)) {
            factory = (AttributeImportanceSettingsFactory)dmeConn.getFactory("javax.datamining.attributeimportance.AttributeImportanceSettings");
            bSettings = (OraBuildSettings)factory.create();
        } else if (OraMiningFunction.featureExtraction.equals((Object)function)) {
            factory = (OraFeatureExtractionSettingsFactory)dmeConn.getFactory("oracle.dmt.jdm.featureextraction.OraFeatureExtractionSettings");
            bSettings = factory.create();
        }
        String algoName = null;
        if (settingsPair != null) {
            algoName = (String)settingsPair.get("ALGO_NAME");
            if (algoName != null) {
                Object factory2;
                OraAlgorithmSettings algoSettings = null;
                if (algoName.equals("ALGO_ADAPTIVE_BAYES_NETWORK")) {
                    factory2 = (OraABNSettingsFactory)dmeConn.getFactory("oracle.dmt.jdm.algorithm.abn.OraABNSettings");
                    algoSettings = (OraAlgorithmSettings)((Object)factory2.create());
                    algoSettings.setAlgorithmSettingsMap(settingsPair);
                } else if (!algoName.equals("ALGO_AI_MDL")) {
                    if (!algoName.equals("ALGO_APRIORI_ASSOCIATION_RULES")) {
                        if (algoName.equals("ALGO_DECISION_TREE")) {
                            factory2 = (TreeSettingsFactory)dmeConn.getFactory("javax.datamining.algorithm.tree.TreeSettings");
                            algoSettings = (OraAlgorithmSettings)factory2.create();
                            algoSettings.setAlgorithmSettingsMap(settingsPair);
                        } else if (algoName.equals("ALGO_GENERALIZED_LINEAR_MODEL")) {
                            factory2 = (OraGLMSettingsFactory)dmeConn.getFactory("oracle.dmt.jdm.algorithm.glm.OraGLMSettings");
                            algoSettings = bSettings.getMiningFunction().equals((Object)MiningFunction.classification) ? (OraAlgorithmSettings)((Object)factory2.createGLMClassificationSettings()) : (OraAlgorithmSettings)((Object)factory2.createGLMRegressionSettings());
                            algoSettings.setAlgorithmSettingsMap(settingsPair);
                        } else if (algoName.equals("ALGO_KMEANS")) {
                            factory2 = (KMeansSettingsFactory)dmeConn.getFactory("javax.datamining.algorithm.kmeans.KMeansSettings");
                            algoSettings = (OraAlgorithmSettings)factory2.create();
                            algoSettings.setAlgorithmSettingsMap(settingsPair);
                        } else if (algoName.equals("ALGO_O_CLUSTER")) {
                            factory2 = (OraOClusterSettingsFactory)dmeConn.getFactory("oracle.dmt.jdm.algorithm.ocluster.OraOClusterSettings");
                            algoSettings = (OraAlgorithmSettings)((Object)factory2.create());
                            algoSettings.setAlgorithmSettingsMap(settingsPair);
                        } else if (algoName.equals("ALGO_NAIVE_BAYES")) {
                            factory2 = (NaiveBayesSettingsFactory)dmeConn.getFactory("javax.datamining.algorithm.naivebayes.NaiveBayesSettings");
                            algoSettings = (OraAlgorithmSettings)factory2.create();
                            algoSettings.setAlgorithmSettingsMap(settingsPair);
                        } else if (algoName.equals("ALGO_NONNEGATIVE_MATRIX_FACTOR")) {
                            factory2 = (OraNMFAlgorithmSettingsFactory)dmeConn.getFactory("oracle.dmt.jdm.algorithm.nmf.OraNMFAlgorithmSettings");
                            algoSettings = (OraAlgorithmSettings)((Object)factory2.create());
                            algoSettings.setAlgorithmSettingsMap(settingsPair);
                        } else if (algoName.equals("ALGO_SUPPORT_VECTOR_MACHINES")) {
                            if (bSettings.getMiningFunction().equals((Object)MiningFunction.classification)) {
                                factory2 = (OraSVMClassificationSettingsFactory)dmeConn.getFactory("javax.datamining.algorithm.svm.classification.SVMClassificationSettings");
                                algoSettings = (OraAlgorithmSettings)((OraSVMClassificationSettingsFactory)factory2).create();
                                algoSettings.setAlgorithmSettingsMap(settingsPair);
                            } else {
                                factory2 = (OraSVMRegressionSettingsFactory)dmeConn.getFactory("javax.datamining.algorithm.svm.regression.SVMRegressionSettings");
                                algoSettings = (OraAlgorithmSettings)((OraSVMRegressionSettingsFactory)factory2).create();
                                algoSettings.setAlgorithmSettingsMap(settingsPair);
                            }
                        }
                    }
                }
                bSettings.setAlgorithmSettings(algoSettings);
            }
        }
        if (settingsPair != null) {
            bSettings.m_settingsPair.putAll(settingsPair);
        }
        return bSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OraBuildSettings retrieveObjectFromDatabase(OraConnection dmeConn, String name, MiningFunction function) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        boolean bsExist = dmeConn.doesObjectExist(name, NamedObject.buildSettings);
        if (bsExist) {
            String[] descSplits;
            String sqlSpec = "SELECT * FROM " + name;
            PreparedStatement ps = null;
            ResultSet rs = null;
            HashMap<String, String> settingsPair = new HashMap<String, String>();
            try {
                ps = dbConn.prepareStatement(sqlSpec);
                rs = ps.executeQuery();
                while (rs.next()) {
                    String value;
                    String key = rs.getString("SETTING_NAME");
                    if (!(key != null & (value = rs.getString("SETTING_VALUE")) != null)) continue;
                    settingsPair.put(key, value);
                }
            }
            catch (SQLException sqlExp) {
                dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{name}, sqlExp, "3503", null);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e1) {}
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (Exception e2) {}
            }
            if (function == null) {
                String functionName = (String)settingsPair.get(FUNCTION_NAME);
                if (functionName == null) {
                    dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{name}, null, "3505", new Object[]{FUNCTION_NAME});
                } else {
                    function = OraPLSQLMappings.getMiningFunction(functionName);
                    if (function == null) {
                        dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{name}, null, "3504", new Object[]{FUNCTION_NAME, functionName});
                    }
                }
            }
            OraBuildSettings bSettings = OraBuildSettings.createSettings(dmeConn, settingsPair, function, name);
            String sPreparedName = name.startsWith("\"") && name.endsWith("\"") ? OraStringUtils.processQuotedName(name) : name.toUpperCase();
            sqlSpec = "SELECT O.CREATED, O.OWNER,  C.COMMENTS, O.OBJECT_NAME from ALL_OBJECTS O, ALL_TAB_COMMENTS C WHERE (O.OBJECT_TYPE='TABLE' OR O.OBJECT_TYPE='VIEW') AND C.TABLE_NAME = O.OBJECT_NAME AND O.OBJECT_NAME = '" + sPreparedName + "'";
            ps = null;
            rs = null;
            Date creationDate = null;
            String creatorInfo = null;
            String description = null;
            String objectName = null;
            try {
                ps = dbConn.prepareStatement(sqlSpec);
                rs = ps.executeQuery();
                if (rs.next()) {
                    creationDate = rs.getDate("CREATED");
                    creatorInfo = rs.getString("OWNER");
                    description = rs.getString("COMMENTS");
                    objectName = rs.getString("OBJECT_NAME");
                }
            }
            catch (SQLException sqlExp) {
                dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{name}, sqlExp, "3503", null);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e1) {}
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (Exception e2) {}
            }
            if (description != null && (descSplits = description.split(";Description:")).length > 1) {
                bSettings.setDescription(descSplits[1]);
            }
            bSettings.setCreationDate(creationDate);
            bSettings.setCreatorInfo(creatorInfo);
            bSettings.setName(objectName);
            return bSettings;
        }
        dmeConn.createException(OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, new Object[]{name}, null);
        return null;
    }

    public static OraBuildSettings retrieveObjectFromDatabaseByID(OraConnection dmeConn, String identifier, MiningFunction function) throws JDMException, SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeObjectFromDatabase(OraConnection dmeConn, String name) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        Statement pStmt = null;
        Statement pStmt2 = null;
        Statement pStmt3 = null;
        ResultSet rs = null;
        try {
            String tableName = null;
            String sqlSpec = "select SETTING_VALUE from " + name + " where " + "SETTING_NAME IN ('" + "CLAS_PRIORS_TABLE_NAME" + "', '" + "CLAS_WEIGHTS_TABLE_NAME" + "' )";
            pStmt2 = dbConn.prepareStatement(sqlSpec);
            rs = pStmt2.executeQuery();
            while (rs.next()) {
                tableName = rs.getString("SETTING_VALUE");
                OraSQLUtils.dropTableOrView(dbConn, tableName, true);
            }
            pStmt = dbConn.prepareStatement("DROP TABLE " + name + " PURGE");
            pStmt.execute();
        }
        catch (SQLException sqlExp) {
        }
        finally {
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (Exception anyExp) {}
            }
            if (pStmt2 != null) {
                try {
                    pStmt2.close();
                }
                catch (Exception anyExp) {}
            }
            if (pStmt3 != null) {
                try {
                    pStmt3.close();
                }
                catch (Exception anyExp) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    public static void renameObjectInDatabase(OraConnection dmeConn, String oldName, String newName) throws JDMException, SQLException {
        if (dmeConn != null) {
            OraValidationHandler v = dmeConn.getValidationHandler();
            v.validateObjectName(oldName, "oldName", NamedObject.buildSettings);
            v.validateObjectName(newName, "newName", NamedObject.buildSettings);
            OraSQLUtils.renameTable(dmeConn.getDatabaseConnection(), oldName, newName);
        }
    }

    public static boolean doesObjectExistInDatabase(OraConnection dmeConn, String name) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        return OraSQLUtils.doesTableOrViewExists(dbConn, name);
    }
}

