/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.association;

import javax.datamining.ComparisonOperator;
import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.association.RuleProperty;
import javax.datamining.association.RulesFilter;
import javax.datamining.association.RulesFilterFactory;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraSupportedEnums;
import oracle.dmt.jdm.association.OraRulesFilter;

public class OraRulesFilterFactory
extends OraFactory
implements RulesFilterFactory {
    private static final OraSupportedEnums supportedCapabilities = new OraSupportedEnums(new Enum[]{RuleProperty.support, RuleProperty.confidence, RuleProperty.length});
    private static final OraSupportedEnums supportedCompOperators = new OraSupportedEnums(new Enum[]{ComparisonOperator.equal, ComparisonOperator.notEqual, ComparisonOperator.lessThan, ComparisonOperator.greaterThan, ComparisonOperator.lessOrEqual, ComparisonOperator.greaterOrEqual});

    public RulesFilter create() throws JDMException {
        return new OraRulesFilter(this.getConnection(), this);
    }

    public boolean supportsCapability(RuleProperty property) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(property, "property");
        return supportedCapabilities.isSupported((Enum)property);
    }

    public boolean supportsCapability(RuleProperty property, ComparisonOperator compOp) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(property, "property");
        this.m_dmeConn.getValidationHandler().validateNotNull(compOp, "compOp");
        boolean propertySupported = this.supportsCapability(property);
        boolean supported = false;
        if (propertySupported) {
            supported = supportedCompOperators.isSupported((Enum)compOp);
        }
        return supported;
    }
}

