/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.association;

import javax.datamining.association.AssociationRule;
import javax.datamining.association.Itemset;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.association.OraItemset;
import oracle.dmt.jdm.resource.OraConnection;

public class OraAssociationRule
extends OraDMObject
implements AssociationRule {
    private int m_ruleId = 0;
    private double m_support = 0.0;
    private double m_confidence = 0.0;
    private double m_lift = 0.0;
    private OraItemset m_antecedent = null;
    private OraItemset m_consequent = null;

    OraAssociationRule(OraConnection dmeConn, int rule_id, double support, double confidence, double lift) {
        super(dmeConn, null);
        this.m_ruleId = rule_id;
        this.m_support = support;
        this.m_confidence = confidence;
        this.m_lift = lift;
    }

    public int getRuleIdentifier() {
        return this.m_ruleId;
    }

    void setAntecedent(OraItemset antecedent) {
        this.m_antecedent = antecedent;
    }

    void setConsequent(OraItemset consequent) {
        this.m_consequent = consequent;
    }

    public Itemset getAntecedent() {
        return this.m_antecedent;
    }

    public Itemset getConsequent() {
        return this.m_consequent;
    }

    public double getSupport() {
        return this.m_support * 100.0;
    }

    public int getAbsoluteSupport() {
        this.unsupported("AssociationRule.getAbsoluteSupport");
        return 0;
    }

    public double getConfidence() {
        return this.m_confidence * 100.0;
    }

    public double getLift() {
        if (this.is102()) {
            this.unsupported("AssociationRule.getLift");
        }
        return this.m_lift;
    }

    public int getLength() {
        return this.m_antecedent.getSize() + this.m_consequent.getSize();
    }
}

