/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.association;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import javax.datamining.ComparisonOperator;
import javax.datamining.JDMException;
import javax.datamining.MiningFunction;
import javax.datamining.SortOrder;
import javax.datamining.association.AssociationModel;
import javax.datamining.association.RuleComponentOption;
import javax.datamining.association.RuleProperty;
import javax.datamining.association.RulesFilter;
import javax.datamining.base.ModelDetail;
import oracle.dmt.jdm.association.OraAssociationRule;
import oracle.dmt.jdm.association.OraItemset;
import oracle.dmt.jdm.association.OraRulesFilter;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.transform.binning.OraBinningTransform;
import oracle.dmt.jdm.transform.binning.OraBinningTransformImpl;

public class OraAssociationModel
extends OraModel
implements AssociationModel {
    private double m_minConfidence;
    private double m_maxConfidence;
    private double m_minSupport;
    private double m_maxSupport;
    private int m_maxRuleLength;
    private int m_numberOfItemsets;
    private HashSet m_items = null;
    private Vector m_itemsets = new Vector();
    private Collection m_rules = null;
    private boolean m_isUnbinning = false;
    private static String QRY_AR_NUM_ITEMSETS = "SELECT count(*) number_of_itemsets FROM TABLE( dbms_data_mining.get_frequent_itemsets(?) )";
    private static String QRY_AR_MODEL_CONSTANTS = "SELECT max(rule_confidence) max_confidence, min(rule_confidence) min_confidence, max(rule_support) max_support, min(rule_support) min_support FROM TABLE( dbms_data_mining.get_association_rules(?) )";
    private static String QRY_AR_GET_ITEMSETS = "SELECT t.itemset_id itemset_id, t.support support, t.number_of_items itemset_size, NVL2( i.attribute_subname,  i.attribute_name || '.' || i.attribute_subname , i.attribute_name) itemAttrName, i.attribute_str_value itemStrValue, i.attribute_num_value itemNumValue FROM TABLE( dbms_data_mining.get_frequent_itemsets(?) ) t, TABLE(t.items) i ORDER BY support desc, itemset_id asc, NVL2( i.attribute_subname,  i.attribute_name || '.' || i.attribute_subname , i.attribute_name) asc, number_of_items asc ";
    private static String QRY_AR_GET_ITEMSETS_WHERE = "WHERE number_of_items = ";
    private static String QRY_AR_GET_ITEMS = "SELECT distinct NVL2( i.attribute_subname,  i.attribute_name || '.' || i.attribute_subname , i.attribute_name) itemAttrName, i.attribute_str_value itemStrValue, i.attribute_num_value itemNumValue FROM TABLE( dbms_data_mining.get_frequent_itemsets(?) ) t, TABLE(t.items) i";
    private static String QRY_AR_GET_ALL_RULES = "SELECT t.rule_id rule_id, t.rule_support rule_support, t.rule_confidence rule_confidence, t.rule_lift rule_lift, NVL2( ante.attribute_subname,  ante.attribute_name || '.' || ante.attribute_subname , ante.attribute_name) as ante_attr, ante.conditional_operator ante_op, NVL(ante.attribute_str_value , ante.attribute_num_value ) ante_val, NVL2( cons.attribute_subname,  cons.attribute_name || '.' || cons.attribute_subname , cons.attribute_name) as cons_attr, cons.conditional_operator cons_op, NVL(cons.attribute_str_value, cons.attribute_num_value) cons_val, ante.attribute_support ante_support, cons.attribute_support cons_support, ante.attribute_confidence ante_conf, cons.attribute_confidence cons_conf, t.number_of_items rule_length FROM TABLE( dbms_data_mining.get_association_rules({0}) ) t, TABLE(t.antecedent) ante, TABLE(t.consequent) cons ";
    private static String QRY_AR_GET_ALL_RULES_WITH_UNBINNING = "WITH  label_view as ( {0} ), rules as ( SELECT * FROM TABLE( dbms_data_mining.get_association_rules({1}) ) ),  ante_pred as (    SELECT rules.rule_id rule_id,  rules.rule_support rule_support,  rules.rule_confidence rule_confidence, rules.rule_lift rule_lift,  NVL2( ante.attribute_subname,  ante.attribute_name || '.' || ante.attribute_subname , ante.attribute_name) as ante_attr,  ante.conditional_operator ante_op,   NVL( l.label, NVL(ante.attribute_str_value , ante.attribute_num_value )) ante_val,   ante.attribute_support ante_support,  ante.attribute_confidence ante_conf,  rules.number_of_items rule_length    FROM rules,    TABLE(rules.antecedent) ante,    label_view l    WHERE    ante.attribute_name = l.col (+) AND    (NVL(ANTE.attribute_str_value, ANTE.attribute_num_value) = l.bin (+))    ) SELECT ante.*, NVL2( cons.attribute_subname,  cons.attribute_name || '.' || cons.attribute_subname , cons.attribute_name) as cons_attr,    cons.conditional_operator cons_op,    NVL( l.label, NVL(cons.attribute_str_value ,cons.attribute_num_value )) cons_val,    cons.attribute_support cons_support,    cons.attribute_confidence cons_conf FROM rules,    TABLE(rules.consequent) cons,    ANTE_PRED ante,    label_view l  WHERE      rules.rule_id=ante.rule_id (+) AND    cons.attribute_name = l.col (+) AND    (NVL(CONS.attribute_str_value, CONS.attribute_num_value) = l.bin (+) ) ";
    private static String ORDER_BY_RULE_ID = "ORDER BY rule_id desc ";
    private static String ORDER_BY_RULE_ID_WITH_BINNING = "ORDER BY ante.rule_id desc ";
    private static String QRY_AR_GET_MAX_RULE_LENGTH = "SELECT max(cardinality(antecedent))+1 max_rule_length FROM TABLE( dbms_data_mining.get_association_rules(?) )";

    public OraAssociationModel(OraConnection dmeConn, String name) throws JDMException {
        super(dmeConn, name, MiningFunction.association);
        this.setup102();
    }

    public ModelDetail getModelDetail() {
        return null;
    }

    void loadSupportConfidence() {
        if (this.m_maxSupport > 0.0) {
            return;
        }
        Connection dbConn = this.getDatabaseConnection();
        CallableStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = dbConn.prepareCall(QRY_AR_MODEL_CONSTANTS);
            pStmt.setString(1, this.getName());
            rs = pStmt.executeQuery();
            if (rs.next()) {
                this.m_maxConfidence = rs.getDouble("MAX_CONFIDENCE");
                this.m_minConfidence = rs.getDouble("MIN_CONFIDENCE");
                this.m_maxSupport = rs.getDouble("MAX_SUPPORT");
                this.m_minSupport = rs.getDouble("MIN_SUPPORT");
            }
        }
        catch (SQLException sqlExp) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {
                // empty catch block
            }
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {
                // empty catch block
            }
        }
    }

    private String getRulesQuery(String queryParams) {
        String qry = null;
        if (this.m_buildTransform != null) {
            try {
                OraBinningTransform binTransform = (OraBinningTransform)this.m_buildTransform;
                String numBinTable = binTransform.getNumericalBinTable();
                String catBinTable = binTransform.getCategoricalBinTable();
                String unbinningClause = OraBinningTransformImpl.getUnbinningClause(catBinTable, numBinTable);
                qry = this.is102() ? MessageFormat.format(QRY_AR_GET_ALL_RULES_WITH_UNBINNING, unbinningClause, queryParams) : MessageFormat.format(QRY_AR_GET_ALL_RULES_WITH_UNBINNING.replaceAll("'", "''"), unbinningClause, queryParams);
                this.m_isUnbinning = true;
            }
            catch (Exception anyExp) {
                anyExp.printStackTrace();
            }
        } else {
            qry = this.is102() ? MessageFormat.format(QRY_AR_GET_ALL_RULES, queryParams) : MessageFormat.format(QRY_AR_GET_ALL_RULES.replaceAll("'", "''"), queryParams);
        }
        return qry;
    }

    public Collection getRules() throws JDMException {
        if (this.m_rules == null) {
            this.m_rules = this.getRules(this.getRulesQuery("?") + ORDER_BY_RULE_ID, null, 1);
        }
        return this.m_rules;
    }

    public Collection getRules(RulesFilter filter) throws JDMException {
        this.getValidationHandler().validateNotNull(filter, "filter");
        OraRulesFilter filter2 = (OraRulesFilter)filter;
        int topN = filter.getMaxNumberOfRules();
        Double minConfidence = filter.getMinValue(RuleProperty.confidence);
        Double minSupport = filter.getMinValue(RuleProperty.support);
        Double minRuleLength = filter.getMinValue(RuleProperty.length);
        Double maxRuleLength = filter.getMaxValue(RuleProperty.length);
        RuleProperty[] orderingElems = filter.getOrderingConditions();
        String orderParams = "null";
        if (orderingElems != null) {
            orderParams = "";
            for (int i = 0; i < orderingElems.length; ++i) {
                SortOrder sortOrder = filter.getOrderingCondition(orderingElems[i]);
                if (i > 0) {
                    orderParams = orderParams + ", ";
                }
                if (orderingElems[i].equals((Object)RuleProperty.support)) {
                    orderParams = orderParams + "'RULE_SUPPORT ";
                } else if (orderingElems[i].equals((Object)RuleProperty.confidence)) {
                    orderParams = orderParams + "'RULE_CONFIDENCE ";
                } else if (orderingElems[i].equals((Object)RuleProperty.length)) {
                    orderParams = orderParams + "'NUMBER_OF_ITEMS ";
                }
                orderParams = sortOrder.equals((Object)SortOrder.ascending) ? orderParams + "ASC'" : orderParams + "DESC'";
            }
            orderParams = this.installedSchema + ".ORA_MINING_VARCHAR2_NT(" + orderParams + ")";
        }
        Object[] anteItems = filter.getItems(RuleComponentOption.antecedent, true);
        Object[] consItems = filter.getItems(RuleComponentOption.consequent, true);
        String anteParams = "null";
        String consParams = "null";
        if (this.is102()) {
            int i;
            if (anteItems != null && anteItems.length > 0) {
                anteParams = "'" + anteItems[0].toString() + "'";
                for (i = 1; i < anteItems.length; ++i) {
                    anteParams = anteParams + ", '" + anteItems[i].toString() + "'";
                }
                anteParams = this.installedSchema + ".ORA_MINING_VARCHAR2_NT(" + anteParams + ")";
            }
            if (consItems != null && consItems.length > 0) {
                consParams = "'" + consItems[0].toString() + "'";
                for (i = 1; i < consItems.length; ++i) {
                    consParams = consParams + ", '" + consItems[i].toString() + "'";
                }
                consParams = this.installedSchema + ".ORA_MINING_VARCHAR2_NT(" + consParams + ")";
            }
        } else {
            int i;
            String[] attrNameSplits;
            if (anteItems != null && anteItems.length > 0) {
                String anteAttrName = null;
                String anteAttrSubName = null;
                String anteStrVal = null;
                Double anteNumVal = null;
                Object anteVal = null;
                attrNameSplits = null;
                StringBuffer anteItemFilterClause = new StringBuffer();
                anteItemFilterClause.append("DM_ITEMS( ");
                for (i = 0; i < anteItems.length; ++i) {
                    OraItemset.OraItem anteItem = (OraItemset.OraItem)anteItems[i];
                    attrNameSplits = this.splitAttribute(anteItem.getAttributeName(), true);
                    anteAttrName = attrNameSplits[0];
                    anteAttrSubName = attrNameSplits[1];
                    anteVal = anteItem.getAttributeValue();
                    if (anteVal instanceof String) {
                        anteStrVal = (String)anteVal;
                    } else {
                        anteNumVal = (Double)anteVal;
                    }
                    anteItemFilterClause.append(i == 0 ? "" : ", ").append("DM_ITEM( ").append(anteAttrName == null ? "null" : "'" + anteAttrName + "'").append(", ").append(anteAttrSubName == null ? "null" : "'" + anteAttrSubName + "'").append(", ").append(anteNumVal == null ? "null" : anteNumVal.toString()).append(", ").append(anteStrVal == null ? "null" : "'" + anteStrVal + "'").append(")");
                }
                anteItemFilterClause.append(" )");
                anteParams = anteItemFilterClause.toString();
            }
            if (consItems != null && consItems.length > 0) {
                String consAttrName = null;
                String consAttrSubName = null;
                String consStrVal = null;
                Double consNumVal = null;
                Object consVal = null;
                attrNameSplits = null;
                StringBuffer consItemFilterClause = new StringBuffer();
                consItemFilterClause.append("DM_ITEMS( ");
                for (i = 0; i < consItems.length; ++i) {
                    OraItemset.OraItem consItem = (OraItemset.OraItem)consItems[i];
                    attrNameSplits = this.splitAttribute(consItem.getAttributeName(), true);
                    consAttrName = attrNameSplits[0];
                    consAttrSubName = attrNameSplits[1];
                    consVal = consItem.getAttributeValue();
                    if (consVal instanceof String) {
                        consStrVal = (String)consVal;
                    } else {
                        consNumVal = (Double)consVal;
                    }
                    consItemFilterClause.append(i == 0 ? "" : ", ").append("DM_ITEM( ").append(consAttrName == null ? "null" : "'" + consAttrName + "'").append(", ").append(consAttrSubName == null ? "null" : "'" + consAttrSubName + "'").append(", ").append(consNumVal == null ? "null" : consNumVal.toString()).append(", ").append(consStrVal == null ? "null" : "'" + consStrVal + "'").append(")");
                }
                consItemFilterClause.append(" )");
                consParams = consItemFilterClause.toString();
            }
        }
        String params = "";
        int numParams = 1;
        if (consItems != null) {
            numParams = 6;
            params = "?,?,null,?,?,?,?," + orderParams + "," + anteParams + "," + consParams;
        } else if (anteItems != null) {
            numParams = 6;
            params = "?,?,null,?,?,?,?," + orderParams + "," + anteParams;
        } else if (orderingElems != null) {
            numParams = 6;
            params = "?,?,null,?,?,?,?," + orderParams;
        } else if (maxRuleLength != null) {
            numParams = 6;
            params = "?,?,null,?,?,?,?";
        } else if (minRuleLength != null) {
            numParams = 5;
            params = "?,?,null,?,?,?";
        } else if (minSupport != null) {
            numParams = 4;
            params = "?,?,null,?,?";
        } else if (minConfidence != null) {
            numParams = 3;
            params = "?,?,null,?";
        } else if (topN > 0) {
            numParams = 2;
            params = "?,?";
        }
        String query = this.getRulesQuery(params);
        return this.getRules(query, filter, numParams);
    }

    public String getItemAttribute(String item) {
        this.getValidationHandler().validateNotNull(item, "item");
        String divider = "-";
        int index = item.lastIndexOf(divider);
        if (index == -1 && (index = item.lastIndexOf(divider = "= ")) == -1) {
            return item;
        }
        if (item.length() <= index + divider.length()) {
            return item;
        }
        try {
            int x = Integer.parseInt(item.substring(index + divider.length()));
        }
        catch (NumberFormatException exp) {
            return item;
        }
        return item.substring(0, index);
    }

    private boolean compareRuleLength(int thisRuleLength, ComparisonOperator compOp, int ruleLength) {
        if (ruleLength == 0 || compOp == null) {
            return true;
        }
        if (compOp.equals((Object)ComparisonOperator.equal)) {
            return thisRuleLength == ruleLength;
        }
        if (compOp.equals((Object)ComparisonOperator.greaterOrEqual)) {
            return thisRuleLength >= ruleLength;
        }
        if (compOp.equals((Object)ComparisonOperator.greaterThan)) {
            return thisRuleLength > ruleLength;
        }
        if (compOp.equals((Object)ComparisonOperator.lessOrEqual)) {
            return thisRuleLength <= ruleLength;
        }
        if (compOp.equals((Object)ComparisonOperator.lessThan)) {
            return thisRuleLength < ruleLength;
        }
        if (compOp.equals((Object)ComparisonOperator.notEqual)) {
            return thisRuleLength != ruleLength;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getRules(String query, RulesFilter filter, int numParams) throws JDMException {
        int topN = 0;
        Double maxConfidence = null;
        Double minConfidence = null;
        Double maxSupport = null;
        Double minSupport = null;
        Double maxRuleLength = null;
        Double minRuleLength = null;
        if (filter != null) {
            topN = filter.getMaxNumberOfRules();
            maxConfidence = filter.getMaxValue(RuleProperty.confidence);
            minConfidence = filter.getMinValue(RuleProperty.confidence);
            maxSupport = filter.getMaxValue(RuleProperty.support);
            minSupport = filter.getMinValue(RuleProperty.support);
            maxRuleLength = filter.getMaxValue(RuleProperty.length);
            minRuleLength = filter.getMinValue(RuleProperty.length);
        }
        boolean postFiltering = maxConfidence != null && maxConfidence < 100.0 || maxSupport != null && maxSupport < 100.0;
        Vector<OraAssociationRule> ruleSet = new Vector<OraAssociationRule>();
        Connection dbConn = this.getDatabaseConnection();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = dbConn.prepareStatement(query);
            int locParam = 1;
            pStmt.setString(locParam++, this.getName());
            if (numParams >= locParam) {
                if (topN == 0) {
                    pStmt.setNull(locParam++, 0);
                } else {
                    pStmt.setInt(locParam++, topN);
                }
            }
            if (numParams >= locParam) {
                if (minConfidence == null) {
                    pStmt.setNull(locParam++, 0);
                } else {
                    pStmt.setDouble(locParam++, minConfidence / 100.0);
                }
            }
            if (numParams >= locParam) {
                if (minSupport == null) {
                    pStmt.setNull(locParam++, 0);
                } else {
                    pStmt.setDouble(locParam++, minSupport / 100.0);
                }
            }
            if (numParams >= locParam) {
                if (minRuleLength == null) {
                    pStmt.setNull(locParam++, 0);
                } else {
                    pStmt.setInt(locParam++, minRuleLength.intValue());
                }
            }
            if (numParams >= locParam) {
                if (maxRuleLength == null) {
                    pStmt.setNull(locParam++, 0);
                } else {
                    pStmt.setInt(locParam++, maxRuleLength.intValue());
                }
            }
            rs = pStmt.executeQuery();
            int rule_id2 = -1;
            boolean rule_count = false;
            int rule_length = 0;
            boolean num_rules = false;
            OraAssociationRule rule = null;
            OraItemset antecedent = null;
            while (rs.next()) {
                int rule_id = rs.getInt("rule_id");
                double support = rs.getDouble("rule_support");
                double confidence = rs.getDouble("rule_confidence");
                double lift = 0.0;
                if (!this.is102()) {
                    lift = rs.getDouble("rule_lift");
                }
                if (rule_id != rule_id2) {
                    rule = new OraAssociationRule(this.getConnection(), rule_id, support, confidence, lift);
                    rule_id2 = rule_id;
                    String cons_attr_name = rs.getString("cons_attr");
                    String cons_op = rs.getString("cons_op");
                    String cons_str = rs.getString("cons_val");
                    String cons = cons_attr_name + cons_op + cons_str;
                    OraItemset consequent = new OraItemset(this.getConnection());
                    consequent.addItem(cons);
                    rule.setConsequent(consequent);
                    antecedent = new OraItemset(this.getConnection());
                    rule.setAntecedent(antecedent);
                    rule_length = 0;
                }
                String ante_attr_name = rs.getString("ante_attr");
                String ante_op = rs.getString("ante_op");
                String ante_str = rs.getString("ante_val");
                String ante = ante_attr_name + ante_op + ante_str;
                antecedent.addItem(ante);
                if (++rule_length != rs.getInt("rule_length")) continue;
                boolean addRule = true;
                if (postFiltering) {
                    if (maxConfidence != null) {
                        boolean bl = addRule = confidence <= maxConfidence / 100.0;
                    }
                    if (addRule && maxSupport != null) {
                        boolean bl = addRule = support <= maxSupport / 100.0;
                    }
                }
                if (addRule) {
                    ruleSet.addElement(rule);
                }
                rule_id2 = rule_id;
            }
        }
        catch (SQLException sqlExp) {
            this.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, sqlExp, "2007", new Object[]{this.getName()});
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqlExp) {}
            }
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException sqlExp) {}
            }
        }
        return ruleSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getRules(String query, int maxRules, int ruleLength, ComparisonOperator compOp) throws JDMException {
        Vector<OraAssociationRule> ruleSet = new Vector<OraAssociationRule>();
        Connection dbConn = this.getDatabaseConnection();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = dbConn.prepareStatement(query);
            pStmt.setString(1, this.getName());
            rs = pStmt.executeQuery();
            int rule_id2 = -1;
            boolean rule_count = false;
            int rule_length = 0;
            int num_rules = 0;
            OraAssociationRule rule = null;
            OraItemset antecedent = null;
            while (rs.next()) {
                int rule_id = rs.getInt("rule_id");
                double support = rs.getDouble("rule_support");
                double confidence = rs.getDouble("rule_confidence");
                double lift = rs.getDouble("rule_lift");
                if (rule_id != rule_id2) {
                    if (antecedent != null) {
                        if (this.compareRuleLength(rule_length, compOp, ruleLength)) {
                            ruleSet.addElement(rule);
                            ++num_rules;
                        }
                        if (num_rules == maxRules) break;
                    }
                    rule = new OraAssociationRule(this.getConnection(), rule_id, support, confidence, lift);
                    rule_id2 = rule_id;
                    String cons_attr_name = rs.getString("cons_attr");
                    String cons_op = rs.getString("cons_op");
                    String cons_str = rs.getString("cons_val");
                    String cons = cons_attr_name + cons_op + cons_str;
                    OraItemset consequent = new OraItemset(this.getConnection());
                    consequent.addItem(cons);
                    rule.setConsequent(consequent);
                    antecedent = new OraItemset(this.getConnection());
                    rule.setAntecedent(antecedent);
                    rule_length = 1;
                } else {
                    rule_id2 = rule_id;
                }
                String ante_attr_name = rs.getString("ante_attr");
                String ante_op = rs.getString("ante_op");
                String ante_str = rs.getString("ante_val");
                String ante = ante_attr_name + ante_op + ante_str;
                antecedent.addItem(ante);
                ++rule_length;
            }
            if (num_rules < maxRules && antecedent != null && (ruleLength == 0 && rule_length > 0 || ruleLength > 0 && rule_length == ruleLength)) {
                ruleSet.addElement(rule);
                ++num_rules;
            }
        }
        catch (SQLException sqlExp) {
            this.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, sqlExp, "2007", new Object[]{this.getName()});
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqlExp) {}
            }
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException sqlExp) {}
            }
        }
        return ruleSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getItems() throws JDMException {
        if (this.m_items != null) {
            return this.m_items;
        }
        Connection dbConn = this.getDatabaseConnection();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = dbConn.prepareStatement(QRY_AR_GET_ITEMS);
            pStmt.setString(1, this.getName());
            rs = pStmt.executeQuery();
            this.m_items = new HashSet();
            while (rs.next()) {
                Object item;
                if (this.is102()) {
                    item = rs.getString(1);
                    this.m_items.add(item);
                    continue;
                }
                item = new OraItemset.OraItem(rs.getString(1), rs.getObject(3) == null ? null : Double.valueOf(rs.getDouble(3)), rs.getString(2));
                this.m_items.add(item);
            }
        }
        catch (SQLException sqlExp) {
            this.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, sqlExp, "2008", new Object[]{this.getName()});
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqlExp) {}
            }
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException sqlExp) {}
            }
        }
        return this.m_items;
    }

    public Collection getItemsets() throws JDMException {
        if (this.m_itemsets.isEmpty()) {
            this.getItemsets(QRY_AR_GET_ITEMSETS);
        }
        return this.m_itemsets;
    }

    public Collection getItemsets(int itemsetSize) throws JDMException {
        this.getValidationHandler().validateNumber(itemsetSize, 1, "itemsetSize");
        if (this.m_itemsets.isEmpty()) {
            this.getItemsets(QRY_AR_GET_ITEMSETS);
        }
        Vector<OraItemset> itemsets = new Vector<OraItemset>();
        for (int i = 0; i < this.m_itemsets.size(); ++i) {
            OraItemset itemset = (OraItemset)this.m_itemsets.elementAt(i);
            if (itemset.getSize() != itemsetSize) continue;
            itemsets.add(itemset);
        }
        return itemsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getItemsets(String query) throws JDMException {
        Connection dbConn = this.getDatabaseConnection();
        OraConnection conn = this.getConnection();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = dbConn.prepareStatement(query);
            pStmt.setString(1, this.getName());
            rs = pStmt.executeQuery();
            int itemset_id2 = -1;
            int item_count = 0;
            OraItemset itemset = null;
            while (rs.next()) {
                int itemset_id = rs.getInt(1);
                double support = rs.getDouble(2);
                int itemset_size = rs.getInt(3);
                if (this.is102()) {
                    String item = rs.getString(4);
                    if (item_count == 0) {
                        itemset = new OraItemset(conn);
                        itemset.setItemsetId(itemset_id);
                        itemset.setSupport(support);
                        this.m_itemsets.add(itemset);
                        item_count = itemset_size;
                    }
                    itemset.addItem(item);
                    --item_count;
                    continue;
                }
                String itemAttrName = rs.getString(4);
                String itemStrValue = rs.getString(5);
                Double itemNumValue = null;
                if (rs.getObject(6) != null) {
                    itemNumValue = rs.getDouble(6);
                }
                if (item_count == 0) {
                    itemset = new OraItemset(conn);
                    itemset.setItemsetId(itemset_id);
                    itemset.setSupport(support);
                    this.m_itemsets.add(itemset);
                    item_count = itemset_size;
                }
                itemset.addItem(itemAttrName, itemNumValue, itemStrValue);
                --item_count;
            }
        }
        catch (SQLException sqlExp) {
            this.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, sqlExp, "2008", new Object[]{this.getName()});
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqlExp) {}
            }
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException sqlExp) {}
            }
        }
    }

    public int getMaxTransactionSize() {
        this.unsupported("AssociationModel.getMaxTransactionSize");
        return 0;
    }

    public Double getAverageTransactionSize() {
        this.unsupported("AssociationModel.getAverageTransactionSize");
        return new Double(0.0);
    }

    public long getNumberOfTransactions() {
        this.unsupported("AssociationModel.getNumberOfTransactions");
        return 0L;
    }

    public int getNumberOfItems() {
        int numItems = 0;
        try {
            Collection items = this.getItems();
            numItems = items.size();
        }
        catch (JDMException jdmExp) {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, jdmExp, "2008", new Object[]{this.getName()});
        }
        return numItems;
    }

    public int getNumberOfItemsets() {
        Connection dbConn = this.getDatabaseConnection();
        CallableStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = dbConn.prepareCall(QRY_AR_NUM_ITEMSETS);
            pStmt.setString(1, this.getName());
            rs = pStmt.executeQuery();
            if (rs.next()) {
                this.m_numberOfItemsets = rs.getInt("NUMBER_OF_ITEMSETS");
            }
        }
        catch (SQLException sqlExp) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {
                // empty catch block
            }
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {
                // empty catch block
            }
            this.m_numberOfItemsets = 0;
        }
        return this.m_numberOfItemsets;
    }

    public int getMinAbsoluteSupport() {
        this.unsupported("AssociationModel.getMinAbsoluteSupport");
        return 0;
    }

    public int getMaxAbsoluteSupport() {
        this.unsupported("AssociationModel.getMaxAbsoluteSupport");
        return 0;
    }

    public Double getMinConfidence() {
        this.loadSupportConfidence();
        return new Double(this.m_minConfidence * 100.0);
    }

    public Double getMaxConfidence() {
        this.loadSupportConfidence();
        return new Double(this.m_maxConfidence * 100.0);
    }

    public Double getMinSupport() {
        this.loadSupportConfidence();
        return new Double(this.m_minSupport * 100.0);
    }

    public Double getMaxSupport() {
        this.loadSupportConfidence();
        return new Double(this.m_maxSupport * 100.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxRuleLength() {
        if (this.m_maxRuleLength == 0) {
            Connection dbConn = this.getDatabaseConnection();
            PreparedStatement pStmt = null;
            ResultSet rs = null;
            try {
                pStmt = dbConn.prepareStatement(QRY_AR_GET_MAX_RULE_LENGTH);
                pStmt.setString(1, this.getName());
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    this.m_maxRuleLength = rs.getInt(1);
                }
            }
            catch (SQLException sqlExp) {
                this.m_maxRuleLength = 0;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sqlExp) {}
                }
                if (pStmt != null) {
                    try {
                        pStmt.close();
                    }
                    catch (SQLException sqlExp) {}
                }
            }
        }
        return this.m_maxRuleLength;
    }

    private void setup102() {
        if (this.is102()) {
            QRY_AR_GET_ALL_RULES = "SELECT t.rule_id rule_id, t.rule_support rule_support, t.rule_confidence rule_confidence, ante.attribute_name ante_attr, ante.conditional_operator ante_op, NVL(ante.attribute_str_value , ante.attribute_num_value ) ante_val, cons.attribute_name cons_attr, cons.conditional_operator cons_op, NVL(cons.attribute_str_value, cons.attribute_num_value) cons_val, ante.attribute_support ante_support, cons.attribute_support cons_support, ante.attribute_confidence ante_conf, cons.attribute_confidence cons_conf, t.number_of_items rule_length FROM TABLE( dbms_data_mining.get_association_rules({0}) ) t, TABLE(t.antecedent) ante, TABLE(t.consequent) cons ";
            QRY_AR_GET_ALL_RULES_WITH_UNBINNING = "WITH  label_view as ( {0} ), rules as ( SELECT * FROM TABLE( dbms_data_mining.get_association_rules({1}) ) ),  ante_pred as (    SELECT rules.rule_id rule_id,  rules.rule_support rule_support,  rules.rule_confidence rule_confidence,  ante.attribute_name ante_attr,   ante.conditional_operator ante_op,   NVL( l.label, NVL(ante.attribute_str_value , ante.attribute_num_value )) ante_val,   ante.attribute_support ante_support,  ante.attribute_confidence ante_conf,  rules.number_of_items rule_length    FROM rules,    TABLE(rules.antecedent) ante,    label_view l    WHERE    ante.attribute_name = l.col (+) AND    (NVL(ANTE.attribute_str_value, ANTE.attribute_num_value) = l.bin (+))    ) SELECT ante.*, cons.attribute_name cons_attr,    cons.conditional_operator cons_op,    NVL( l.label, NVL(cons.attribute_str_value ,cons.attribute_num_value )) cons_val,    cons.attribute_support cons_support,    cons.attribute_confidence cons_conf FROM rules,    TABLE(rules.consequent) cons,    ANTE_PRED ante,    label_view l  WHERE      rules.rule_id=ante.rule_id (+) AND    cons.attribute_name = l.col (+) AND    (NVL(CONS.attribute_str_value, CONS.attribute_num_value) = l.bin (+) ) ";
            QRY_AR_NUM_ITEMSETS = "SELECT count(*) number_of_itemsets FROM TABLE( dbms_data_mining.get_frequent_itemsets(?) )";
            QRY_AR_MODEL_CONSTANTS = "SELECT max(rule_confidence) max_confidence, min(rule_confidence) min_confidence, max(rule_support) max_support, min(rule_support) min_support FROM TABLE( dbms_data_mining.get_association_rules(?) )";
            QRY_AR_GET_ITEMSETS = "SELECT t.itemset_id itemset_id, t.support support, t.number_of_items itemset_size, i.column_value item FROM TABLE( dbms_data_mining.get_frequent_itemsets(?) ) t, TABLE(t.items) i ORDER BY support desc, itemset_id asc, column_value asc, number_of_items asc ";
            QRY_AR_GET_ITEMSETS_WHERE = "WHERE number_of_items = ";
            QRY_AR_GET_ITEMS = "SELECT distinct i.column_value item FROM TABLE( dbms_data_mining.get_frequent_itemsets(?) ) t, TABLE(t.items) i";
        }
    }
}

