/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.algorithm.tree;

import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.SizeUnit;
import javax.datamining.algorithm.tree.TreeCapability;
import javax.datamining.algorithm.tree.TreeSettings;
import javax.datamining.algorithm.tree.TreeSettingsFactory;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraSupportedEnums;
import oracle.dmt.jdm.algorithm.tree.OraTreeSettings;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;

public class OraTreeSettingsFactory
extends OraFactory
implements TreeSettingsFactory {
    private static final OraSupportedEnums supportedCapabilities = new OraSupportedEnums(new Enum[]{TreeCapability.maxDepth, TreeCapability.minAbsoluteSize, TreeCapability.minPercentageSize, TreeCapability.buildHomogeneityMetric, TreeCapability.missingValueHandling});

    public TreeSettings create() throws JDMException {
        return new OraTreeSettings(this.getConnection(), this);
    }

    public boolean supportsCapability(TreeCapability capability) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(capability, "capability");
        return supportedCapabilities.isSupported((Enum)capability);
    }

    public boolean supportsMinNodeSizeUnit(SizeUnit unit) {
        this.m_dmeConn.getValidationHandler().validateNotNull(unit, "unit");
        return true;
    }

    public int getMaxSurrogatesAllowed() {
        this.getConnection().createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"TreeSettingsFactory.getMaxSurrogatesAllowed", "Maxinum number of surrogates is not supported"}, null);
        return 3;
    }

    public int getMaxDepthAllowed() {
        return 20;
    }
}

