/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.algorithm.nmf;

import javax.datamining.JDMException;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.algorithm.nmf.OraNMFAlgorithmSettings;
import oracle.dmt.jdm.base.OraAlgorithmSettings;
import oracle.dmt.jdm.resource.OraConnection;

public class OraNMFAlgorithmSettingsImpl
extends OraAlgorithmSettings
implements OraNMFAlgorithmSettings {
    private static long DEFAULT_SEED = -1L;
    private static long DEFAULT_NUMBER_ITERATIONS = 1L;
    private static double DEFAULT_CONVERGENCE_TOLERANCE = 0.05;

    public long getMaxNumberOfIterations() {
        String value = this.getValue("NMFS_NUM_ITERATIONS");
        return value == null ? DEFAULT_NUMBER_ITERATIONS : Long.parseLong(value);
    }

    public void setMaxNumberOfIterations(long maxIterations) {
        this.getValidationHandler().validateNumber(maxIterations, 1L, 500L, "maxIterations");
        String value = Long.toString(maxIterations);
        this.setValue("NMFS_NUM_ITERATIONS", value);
    }

    public double getMinConvergenceTolerance() {
        String value = this.getValue("NMFS_CONV_TOLERANCE");
        return value == null ? DEFAULT_CONVERGENCE_TOLERANCE : Double.parseDouble(value);
    }

    public void setMinConvergenceTolerance(double minConvergenceTolerance) {
        this.getValidationHandler().validateNumber(minConvergenceTolerance, 0.0, 0.5, false, true, "minConvergenceTolerance");
        String value = Double.toString(minConvergenceTolerance);
        this.setValue("NMFS_CONV_TOLERANCE", value);
    }

    public long getSeedValue() {
        String value = this.getValue("NMFS_RANDOM_SEED");
        return value == null ? DEFAULT_SEED : Long.parseLong(value);
    }

    public void setSeedValue(long seedValue) {
        String value = Long.toString(seedValue);
        this.setValue("NMFS_RANDOM_SEED", value);
    }

    protected OraNMFAlgorithmSettingsImpl(OraConnection dmeConn, OraFactory parentFactory) throws JDMException {
        super(dmeConn, parentFactory, OraMiningAlgorithm.nonNegativeMatrixFactorization, "ALGO_NONNEGATIVE_MATRIX_FACTOR");
    }
}

