/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.algorithm.kmeans;

import java.util.Hashtable;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.algorithm.kmeans.ClusteringDistanceFunction;
import javax.datamining.algorithm.kmeans.KMeansSettings;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraPLSQLMappings;
import oracle.dmt.jdm.algorithm.kmeans.OraClusteringDistanceFunction;
import oracle.dmt.jdm.algorithm.kmeans.OraSplitCriterion;
import oracle.dmt.jdm.clustering.OraClusteringAlgorithmSettings;
import oracle.dmt.jdm.resource.OraConnection;

public class OraKMeansSettings
extends OraClusteringAlgorithmSettings
implements KMeansSettings {
    private static int DEFAULT_BLOCK_GROWTH = 2;
    private static int DEFAULT_BIN_NUMBER = 10;
    private static int DEFAULT_NUM_ITERATIONS = 3;
    private static int ITERATION_LIMIT_MAX = 20;
    private static int ITERATION_LIMIT_MIN = 1;
    private static double ERROR_TOLERANCE_LIMIT_MAX = 0.5;
    private static double ERROR_TOLERANCE_LIMIT_MIN = 0.0;
    private static int BLOCK_GROWTH_LIMIT_MAX = 5;
    private static int BLOCK_GROWTH_LIMIT_MIN = 2;
    private static int MAX_BIN_NUMBER = 126;
    private static Hashtable m_PLSQLJavaMap = new Hashtable();

    public int getMaxNumberOfIterations() {
        String value = this.getValue("KMNS_ITERATIONS");
        return value == null ? DEFAULT_NUM_ITERATIONS : Integer.parseInt(value);
    }

    public void setMaxNumberOfIterations(int maxIterations) {
        this.getValidationHandler().validateNumber(maxIterations, ITERATION_LIMIT_MIN, ITERATION_LIMIT_MAX, "maxIterations");
        String value = Integer.toString(maxIterations);
        this.setValue("KMNS_ITERATIONS", value);
    }

    public double getMinErrorTolerance() {
        String value = this.getValue("KMNS_CONV_TOLERANCE");
        return value == null ? 0.0 : Double.parseDouble(value);
    }

    public void setMinErrorTolerance(double minErrorTolerance) {
        this.getValidationHandler().validateNumber(minErrorTolerance, ERROR_TOLERANCE_LIMIT_MIN, ERROR_TOLERANCE_LIMIT_MAX, false, "minErrorTolerance");
        String value = Double.toString(minErrorTolerance);
        this.setValue("KMNS_CONV_TOLERANCE", value);
    }

    public ClusteringDistanceFunction getDistanceFunction() {
        String value = this.getValue("KMNS_DISTANCE");
        ClusteringDistanceFunction result = null;
        try {
            result = value == null ? ClusteringDistanceFunction.systemDefault : (ClusteringDistanceFunction)m_PLSQLJavaMap.get(value);
        }
        catch (Exception e) {
            result = ClusteringDistanceFunction.systemDefault;
        }
        return result;
    }

    public void setDistanceFunction(ClusteringDistanceFunction distanceFunction) {
        ClusteringDistanceFunction cf = distanceFunction != null ? distanceFunction : ClusteringDistanceFunction.systemDefault;
        String kMeansDistance = OraPLSQLMappings.getKmeansDistance(cf);
        this.setValue("KMNS_DISTANCE", kMeansDistance);
    }

    protected OraKMeansSettings(OraConnection dmeConn, OraFactory factory) throws JDMException {
        super(dmeConn, factory, MiningAlgorithm.kMeans, "ALGO_KMEANS");
    }

    public void setSplitCriterion(OraSplitCriterion splitCriterion) {
        this.setValue("KMNS_SPLIT_CRITERION", splitCriterion != null ? splitCriterion.name() : OraSplitCriterion.clusterVariance.name());
    }

    public OraSplitCriterion getSplitCriterion() throws JDMException {
        String value = this.getValue("KMNS_SPLIT_CRITERION");
        return value == null ? OraSplitCriterion.clusterVariance : OraSplitCriterion.valueOf(value);
    }

    public void setNumberOfBins(int numberOfBins) {
        this.getValidationHandler().validateNumber(numberOfBins, 1, MAX_BIN_NUMBER, "numberOfBins");
        String value = Integer.toString(numberOfBins);
        this.setValue("KMNS_NUM_BINS", value);
    }

    public int getNumberOfBins() {
        String value = this.getValue("KMNS_NUM_BINS");
        return value == null ? DEFAULT_BIN_NUMBER : Integer.parseInt(value);
    }

    public void setBlockGrowth(int blockGrowth) {
        this.getValidationHandler().validateNumber(blockGrowth, BLOCK_GROWTH_LIMIT_MIN, BLOCK_GROWTH_LIMIT_MAX, "blockGrowth");
        String value = Integer.toString(blockGrowth);
        this.setValue("KMNS_BLOCK_GROWTH", value);
    }

    public int getBlockGrowth() {
        String value = this.getValue("KMNS_BLOCK_GROWTH");
        return value == null ? DEFAULT_BLOCK_GROWTH : Integer.parseInt(value);
    }

    public void setMinPercentageAtrrSupport(double minPercentageAtrrSupport) {
        this.getValidationHandler().validateNumber(minPercentageAtrrSupport, 0.0, 1.0, true, "minPercentageAtrrSupport");
        String value = Double.toString(minPercentageAtrrSupport);
        this.setValue("KMNS_MIN_PCT_ATTR_SUPPORT", value);
    }

    public double getMinPercentageAtrrSupport() {
        String value = this.getValue("KMNS_MIN_PCT_ATTR_SUPPORT");
        return value == null ? 0.1 : Double.parseDouble(value);
    }

    static {
        m_PLSQLJavaMap.put("KMNS_EUCLIDEAN", ClusteringDistanceFunction.euclidean);
        m_PLSQLJavaMap.put("KMNS_COSINE", OraClusteringDistanceFunction.cosine);
        m_PLSQLJavaMap.put("KMNS_FAST_COSINE", OraClusteringDistanceFunction.fastCosine);
    }
}

