/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.algorithm.glm;

import javax.datamining.JDMException;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.algorithm.glm.OraGLMClassificationSettings;
import oracle.dmt.jdm.algorithm.glm.OraGLMRegressionSettings;
import oracle.dmt.jdm.base.OraAlgorithmSettings;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraGLMSettingsImpl
extends OraAlgorithmSettings
implements OraGLMClassificationSettings,
OraGLMRegressionSettings {
    private static Boolean DEFAULT_USE_RIDGE = null;
    private static Boolean DEFAULT_VIF_FOR_RIDGE = false;

    protected OraGLMSettingsImpl(OraConnection dmeConn, OraFactory parentFactory) throws JDMException {
        super(dmeConn, parentFactory, OraMiningAlgorithm.generalizedLinearModel, "ALGO_GENERALIZED_LINEAR_MODEL");
    }

    public Boolean useRidgeRegression() {
        String valueStr = this.getValue("GLMS_RIDGE_REGRESSION");
        if (valueStr == null) {
            return DEFAULT_USE_RIDGE;
        }
        if (valueStr.equalsIgnoreCase("GLMS_RIDGE_REG_ENABLE")) {
            return true;
        }
        return false;
    }

    public void useRidgeRegression(Boolean enableRidgeRegression) {
        if (enableRidgeRegression != null && enableRidgeRegression.booleanValue()) {
            this.setValue("GLMS_RIDGE_REGRESSION", "GLMS_RIDGE_REG_ENABLE");
        } else {
            this.setValue("GLMS_RIDGE_REGRESSION", "GLMS_RIDGE_REG_DISABLE");
        }
    }

    public Double getRidgeValue() {
        String valueStr = this.getValue("GLMS_RIDGE_VALUE");
        if (valueStr == null) {
            return null;
        }
        return new Double(valueStr);
    }

    public void setRidgeValue(Double ridgeVal) {
        if (ridgeVal == null) {
            this.setValue("GLMS_RIDGE_VALUE", null);
        } else {
            this.getValidationHandler().validateNumber((double)ridgeVal, 0.0, Double.MAX_VALUE, false, true, "ridgeVal");
            if (this.useRidgeRegression() == null || !this.useRidgeRegression().booleanValue()) {
                this.useRidgeRegression(true);
            }
            this.setValue("GLMS_RIDGE_VALUE", Double.toString(ridgeVal));
        }
    }

    public void setConfidenceLevel(double confidenceLevel) {
        this.getValidationHandler().validateNumber(confidenceLevel, 0.0, 1.0, false, false, "confidenceLevel");
        this.setValue("GLMS_CONF_LEVEL", Double.toString(confidenceLevel));
    }

    public double getConfidenceLevel() {
        String valueStr = this.getValue("GLMS_CONF_LEVEL");
        if (valueStr == null) {
            return 0.95;
        }
        return new Double(valueStr);
    }

    public void setDiagnosticsTableName(String diagnosticsTableName) {
        if (diagnosticsTableName == null) {
            this.setValue("GLMS_DIAGNOSTICS_TABLE_NAME", diagnosticsTableName);
        } else {
            this.getValidationHandler().validateDataSourceURI(diagnosticsTableName, "diagnosticsTableName");
            this.setValue("GLMS_DIAGNOSTICS_TABLE_NAME", diagnosticsTableName);
        }
    }

    public String getDiagnosticsTableName() {
        return this.getValue("GLMS_DIAGNOSTICS_TABLE_NAME");
    }

    public void setReferenceCategory(Object referenceCategory) {
        if (referenceCategory == null) {
            this.setValue("GLMS_REFERENCE_CLASS_NAME", null);
        } else {
            this.getValidationHandler().validateCategory(referenceCategory, "referenceCategory");
            String quotedReferenceCategory = OraStringUtils.getReplacedString(referenceCategory.toString(), "'", "''");
            this.setValue("GLMS_REFERENCE_CLASS_NAME", quotedReferenceCategory);
        }
    }

    public Object getReferenceCategory() {
        return this.getValue("GLMS_REFERENCE_CLASS_NAME");
    }

    public void setMissingValueTreatmentType(String treatmentType) {
        if (treatmentType == null || !treatmentType.equals("ODMS_MISSING_VALUE_MEAN_MODE") && !treatmentType.equals("ODMS_MISSING_VALUE_DELETE_ROW")) {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new String[]{"treatmentType"}, null);
        } else {
            this.setValue("ODMS_MISSING_VALUE_TREATMENT", treatmentType);
        }
    }

    public String getMissingValueTreatmentType() {
        String valStr = this.getValue("ODMS_MISSING_VALUE_TREATMENT");
        if (valStr == null) {
            return "ODMS_MISSING_VALUE_MEAN_MODE";
        }
        return valStr;
    }

    public boolean produceVIFforRidgeRegression() {
        String valueStr = this.getValue("GLMS_VIF_FOR_RIDGE");
        if (valueStr == null) {
            return DEFAULT_VIF_FOR_RIDGE;
        }
        if (valueStr.equalsIgnoreCase("GLMS_VIF_RIDGE_ENABLE")) {
            return true;
        }
        return false;
    }

    public void produceVIFforRidgeRegression(boolean enableVIFforRidge) {
        if (enableVIFforRidge) {
            this.setValue("GLMS_VIF_FOR_RIDGE", "GLMS_VIF_RIDGE_ENABLE");
        } else {
            this.setValue("GLMS_VIF_FOR_RIDGE", "GLMS_VIF_RIDGE_DISABLE");
        }
    }
}

