/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.algorithm.abn;

import javax.datamining.JDMException;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.algorithm.abn.OraABNModelType;
import oracle.dmt.jdm.algorithm.abn.OraABNSettings;
import oracle.dmt.jdm.algorithm.abn.OraABNSettingsFactoryImpl;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.OraSupervisedAlgorithmSettings;

public class OraABNSettingsImpl
extends OraSupervisedAlgorithmSettings
implements OraABNSettings {
    OraABNSettingsImpl(OraConnection dmeConn, OraABNSettingsFactoryImpl factory, OraABNModelType modelType, int maxNumberOfPredictors, int maxBuildMinutes, int maxNBPredictors) throws JDMException {
        super(dmeConn, factory, OraMiningAlgorithm.adaptiveBayesNetwork, "ALGO_ADAPTIVE_BAYES_NETWORK");
        this.setModelType(modelType);
        this.setMaximumNumberOfPredictors(maxNumberOfPredictors);
        this.setMaxBuildMinutes(maxBuildMinutes);
        this.setNaiveBayesNumberOfPredictors(maxNBPredictors);
    }

    public int getMaxBuildMinutes() {
        return Integer.parseInt(this.getValue("ABNS_MAX_BUILD_MINUTES"));
    }

    public void setMaxBuildMinutes(int maxBuildMinutes) {
        this.getValidationHandler().validateNonNegative(maxBuildMinutes, "maxBuildMinutes");
        this.setValue("ABNS_MAX_BUILD_MINUTES", Integer.toString(maxBuildMinutes));
    }

    public OraABNModelType getModelType() {
        OraABNModelType modelType = null;
        try {
            modelType = OraABNModelType.valueOf(this.getValue("ABNS_MODEL_TYPE"));
        }
        catch (JDMException anyExp) {
            RuntimeException runTimeExp = new RuntimeException();
            runTimeExp.initCause(anyExp);
            throw runTimeExp;
        }
        return modelType;
    }

    public void setModelType(OraABNModelType modelType) {
        this.getValidationHandler().validateNotNull((Object)modelType, "modelType");
        this.setValue("ABNS_MODEL_TYPE", modelType.name());
    }

    public int getNaiveBayesNumberOfPredictors() {
        return Integer.parseInt(this.getValue("ABNS_MAX_NB_PREDICTORS"));
    }

    public void setNaiveBayesNumberOfPredictors(int nbPredictors) {
        this.getValidationHandler().validateNumber(nbPredictors, 0, Integer.MAX_VALUE, false, true, "nbPredictors");
        this.setValue("ABNS_MAX_NB_PREDICTORS", Integer.toString(nbPredictors));
    }

    public int getMaximumNumberOfPredictors() {
        return Integer.parseInt(this.getValue("ABNS_MAX_PREDICTORS"));
    }

    public void setMaximumNumberOfPredictors(int maxPredictors) {
        this.getValidationHandler().validateNumber(maxPredictors, 0, Integer.MAX_VALUE, false, true, "maxPredictors");
        this.setValue("ABNS_MAX_PREDICTORS", Integer.toString(maxPredictors));
    }
}

