/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm;

import java.util.Hashtable;
import javax.datamining.ComparisonOperator;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningFunction;
import javax.datamining.algorithm.kmeans.ClusteringDistanceFunction;
import javax.datamining.algorithm.svm.KernelFunction;
import javax.datamining.algorithm.tree.TreeHomogeneityMetric;
import javax.datamining.clustering.ClusteringApplyContent;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.AttributeType;
import javax.datamining.supervised.classification.ClassificationApplyContent;
import javax.datamining.supervised.regression.RegressionApplyContent;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.OraMiningFunction;
import oracle.dmt.jdm.OraPLSQLConstants;
import oracle.dmt.jdm.algorithm.kmeans.OraClusteringDistanceFunction;
import oracle.dmt.jdm.data.OraAttributeDataType;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionApplyContent;
import oracle.dmt.jdm.supervised.classification.OraClassificationApplyContent;
import oracle.dmt.jdm.supervised.regression.OraRegressionApplyContent;

public class OraPLSQLMappings
implements OraPLSQLConstants {
    private static Hashtable m_oracleToJDMAttributeTypeMap = new Hashtable();
    private static Hashtable m_oracleToJDMDataTypeMap;
    private static Hashtable m_nestedMap;
    private static Hashtable m_plsqlConstants;

    public static boolean isNested(String oracleType) {
        Boolean bNested = (Boolean)m_nestedMap.get(oracleType);
        return bNested;
    }

    public static String getPLSQLConstant(MiningFunction func) {
        if (func.equals((Object)MiningFunction.classification)) {
            return "CLASSIFICATION";
        }
        if (func.equals((Object)MiningFunction.regression)) {
            return "REGRESSION";
        }
        if (func.equals((Object)MiningFunction.clustering)) {
            return "CLUSTERING";
        }
        if (func.equals((Object)MiningFunction.association)) {
            return "ASSOCIATION";
        }
        if (func.equals((Object)MiningFunction.attributeImportance)) {
            return "ATTRIBUTE_IMPORTANCE";
        }
        if (func.equals((Object)OraMiningFunction.featureExtraction)) {
            return "FEATURE_EXTRACTION";
        }
        return null;
    }

    public static MiningFunction getMiningFunction(String plsqlConstant) {
        if (plsqlConstant.equals("CLASSIFICATION")) {
            return MiningFunction.classification;
        }
        if (plsqlConstant.equals("REGRESSION")) {
            return MiningFunction.regression;
        }
        if (plsqlConstant.equals("CLUSTERING")) {
            return MiningFunction.clustering;
        }
        if (plsqlConstant.equals("ASSOCIATION_RULES") || plsqlConstant.equals("ASSOCIATION")) {
            return MiningFunction.association;
        }
        if (plsqlConstant.equals("ATTRIBUTE_IMPORTANCE")) {
            return MiningFunction.attributeImportance;
        }
        if (plsqlConstant.equals("FEATURE_EXTRACTION")) {
            return OraMiningFunction.featureExtraction;
        }
        return null;
    }

    public static String getPLSQLConstant(MiningAlgorithm algo) {
        if (algo.equals((Object)MiningAlgorithm.naiveBayes)) {
            return "ALGO_NAIVE_BAYES";
        }
        if (algo.equals((Object)MiningAlgorithm.svmClassification)) {
            return "ALGO_SUPPORT_VECTOR_MACHINES";
        }
        if (algo.equals((Object)MiningAlgorithm.svmRegression)) {
            return "ALGO_SUPPORT_VECTOR_MACHINES";
        }
        if (algo.equals((Object)MiningAlgorithm.kMeans)) {
            return "ALGO_KMEANS";
        }
        if (algo.equals((Object)MiningAlgorithm.decisionTree)) {
            return "ALGO_DECISION_TREE";
        }
        if (algo.equals((Object)OraMiningAlgorithm.adaptiveBayesNetwork)) {
            return "ALGO_ADAPTIVE_BAYES_NETWORK";
        }
        if (algo.equals((Object)OraMiningAlgorithm.aprioriAssociationRules)) {
            return "ALGO_APRIORI_ASSOCIATION_RULES";
        }
        if (algo.equals((Object)OraMiningAlgorithm.nonNegativeMatrixFactorization)) {
            return "ALGO_NONNEGATIVE_MATRIX_FACTOR";
        }
        if (algo.equals((Object)OraMiningAlgorithm.minimumDescriptionLength)) {
            return "ALGO_AI_MDL";
        }
        if (algo.equals((Object)OraMiningAlgorithm.oCluster)) {
            return "ALGO_O_CLUSTER";
        }
        if (algo.equals((Object)OraMiningAlgorithm.generalizedLinearModel)) {
            return "ALGO_GENERALIZED_LINEAR_MODEL";
        }
        return null;
    }

    public static MiningAlgorithm getMiningAlgorithm(String plsqlConstant) {
        if (plsqlConstant.equals("ALGO_NAIVE_BAYES")) {
            return MiningAlgorithm.naiveBayes;
        }
        if (plsqlConstant.equals("ALGO_SUPPORT_VECTOR_MACHINES")) {
            return MiningAlgorithm.svmClassification;
        }
        if (plsqlConstant.equals("ALGO_KMEANS")) {
            return MiningAlgorithm.kMeans;
        }
        if (plsqlConstant.equals("ALGO_DECISION_TREE")) {
            return MiningAlgorithm.decisionTree;
        }
        if (plsqlConstant.equals("ALGO_ADAPTIVE_BAYES_NETWORK")) {
            return OraMiningAlgorithm.adaptiveBayesNetwork;
        }
        if (plsqlConstant.equals("ALGO_NONNEGATIVE_MATRIX_FACTOR")) {
            return OraMiningAlgorithm.nonNegativeMatrixFactorization;
        }
        if (plsqlConstant.equals("ALGO_MINIMUM_DESCRIPTION_LENGTH")) {
            return OraMiningAlgorithm.minimumDescriptionLength;
        }
        if (plsqlConstant.equals("ALGO_APRIORI_ASSOCIATION_RULES")) {
            return OraMiningAlgorithm.aprioriAssociationRules;
        }
        if (plsqlConstant.equals("ALGO_O_CLUSTER")) {
            return OraMiningAlgorithm.oCluster;
        }
        if (plsqlConstant.equals("ALGO_GENERALIZED_LINEAR_MODEL")) {
            return OraMiningAlgorithm.generalizedLinearModel;
        }
        return null;
    }

    public static KernelFunction getKernelFunction(String plsqlConstant) {
        if (plsqlConstant.equals("SVMS_LINEAR")) {
            return KernelFunction.kLinear;
        }
        if (plsqlConstant.equals("SVMS_GAUSSIAN")) {
            return KernelFunction.kGaussian;
        }
        return null;
    }

    public static String getPLSQLConstant(KernelFunction kf) {
        if (kf.equals((Object)KernelFunction.kLinear)) {
            return "SVMS_LINEAR";
        }
        if (kf.equals((Object)KernelFunction.kGaussian)) {
            return "SVMS_GAUSSIAN";
        }
        return null;
    }

    public static boolean getActiveLearning(String plsqlConstant) {
        if (plsqlConstant.equals("SVMS_AL_ENABLE")) {
            return true;
        }
        return !plsqlConstant.equals("SVMS_AL_DISABLE");
    }

    public static ComparisonOperator getComparisonOperator(String plsqlConstant) {
        if (plsqlConstant == null) {
            return ComparisonOperator.equal;
        }
        return (ComparisonOperator)m_plsqlConstants.get(plsqlConstant);
    }

    public static String getComparisonOperatorValue(ComparisonOperator op) {
        if (op == null) {
            return "= ";
        }
        if (op.equals((Object)ComparisonOperator.equal)) {
            return "= ";
        }
        if (op.equals((Object)ComparisonOperator.notEqual)) {
            return "!=";
        }
        if (op.equals((Object)ComparisonOperator.lessThan)) {
            return "<";
        }
        if (op.equals((Object)ComparisonOperator.greaterThan)) {
            return ">";
        }
        if (op.equals((Object)ComparisonOperator.lessOrEqual)) {
            return "<=";
        }
        if (op.equals((Object)ComparisonOperator.greaterOrEqual)) {
            return ">=";
        }
        if (op.equals((Object)ComparisonOperator.notIn)) {
            return "NOT IN";
        }
        if (op.equals((Object)ComparisonOperator.in)) {
            return "IN";
        }
        return null;
    }

    public static ComparisonOperator getComparisonOperator_tree(String plsqlConstant) {
        if (plsqlConstant.compareToIgnoreCase("equal") == 0) {
            return ComparisonOperator.equal;
        }
        if (plsqlConstant.compareToIgnoreCase("notEqual") == 0) {
            return ComparisonOperator.notEqual;
        }
        if (plsqlConstant.compareToIgnoreCase("lessThan") == 0) {
            return ComparisonOperator.lessThan;
        }
        if (plsqlConstant.compareToIgnoreCase("greaterThan") == 0) {
            return ComparisonOperator.greaterThan;
        }
        if (plsqlConstant.compareToIgnoreCase("lessOrEqual") == 0) {
            return ComparisonOperator.lessOrEqual;
        }
        if (plsqlConstant.compareToIgnoreCase("greaterOrEqual") == 0) {
            return ComparisonOperator.greaterOrEqual;
        }
        if (plsqlConstant.compareToIgnoreCase("isIn") == 0) {
            return ComparisonOperator.in;
        }
        if (plsqlConstant.compareToIgnoreCase("notIsIn") == 0) {
            return ComparisonOperator.notIn;
        }
        return null;
    }

    public static String getComparisonOperatorValue_tree(ComparisonOperator op) {
        if (op == null) {
            return null;
        }
        if (op.equals((Object)ComparisonOperator.equal)) {
            return "equal";
        }
        if (op.equals((Object)ComparisonOperator.notEqual)) {
            return "notEqual";
        }
        if (op.equals((Object)ComparisonOperator.lessThan)) {
            return "lessThan";
        }
        if (op.equals((Object)ComparisonOperator.greaterThan)) {
            return "greaterThan";
        }
        if (op.equals((Object)ComparisonOperator.lessOrEqual)) {
            return "lessOrEqual";
        }
        if (op.equals((Object)ComparisonOperator.greaterOrEqual)) {
            return "greaterOrEqual";
        }
        if (op.equals((Object)ComparisonOperator.notIn)) {
            return "notIsIn";
        }
        if (op.equals((Object)ComparisonOperator.in)) {
            return "isIn";
        }
        return null;
    }

    public static AttributeType getAttributeType(String oracleType) {
        Object obj = m_oracleToJDMAttributeTypeMap.get(oracleType);
        return obj != null ? (AttributeType)obj : AttributeType.notSpecified;
    }

    public static AttributeDataType getAttributeDataType(String oracleType) {
        Object obj = m_oracleToJDMDataTypeMap.get(oracleType);
        return obj != null ? (AttributeDataType)obj : AttributeDataType.unknownType;
    }

    public static String getDBDictionaryName(MiningAlgorithm algo) {
        String plsqlConstantName = OraPLSQLMappings.getPLSQLConstant(algo);
        if (plsqlConstantName != null) {
            return plsqlConstantName.substring(5, plsqlConstantName.length());
        }
        return null;
    }

    public static String getKmeansDistance(ClusteringDistanceFunction dFunction) {
        if (dFunction.equals((Object)OraClusteringDistanceFunction.cosine)) {
            return "KMNS_COSINE";
        }
        if (dFunction.equals((Object)OraClusteringDistanceFunction.fastCosine)) {
            return "KMNS_FAST_COSINE";
        }
        return "KMNS_EUCLIDEAN";
    }

    public static TreeHomogeneityMetric getTreeHomogeneityMetric(String plsqlConstant) {
        if (plsqlConstant.compareToIgnoreCase("TREE_IMPURITY_GINI") == 0) {
            return TreeHomogeneityMetric.gini;
        }
        if (plsqlConstant.compareToIgnoreCase("TREE_IMPURITY_ENTROPY") == 0) {
            return TreeHomogeneityMetric.entropy;
        }
        return null;
    }

    public static String getPLSQLConstant(TreeHomogeneityMetric metric) {
        if (metric.equals((Object)TreeHomogeneityMetric.gini)) {
            return "TREE_IMPURITY_GINI";
        }
        if (metric.equals((Object)TreeHomogeneityMetric.entropy)) {
            return "TREE_IMPURITY_ENTROPY";
        }
        return null;
    }

    public static int getPLSQLConstant(ClassificationApplyContent applyContent) {
        if (ClassificationApplyContent.cost.equals((Object)applyContent)) {
            return 2;
        }
        if (ClassificationApplyContent.probability.equals((Object)applyContent)) {
            return 1;
        }
        if (ClassificationApplyContent.predictedCategory.equals((Object)applyContent)) {
            return 3;
        }
        if (ClassificationApplyContent.nodeId.equals((Object)applyContent)) {
            return 4;
        }
        if (OraClassificationApplyContent.probabilityLowerBound.equals((Object)applyContent)) {
            return 5;
        }
        if (OraClassificationApplyContent.probabilityUpperBound.equals((Object)applyContent)) {
            return 6;
        }
        return -1;
    }

    public static int getPLSQLConstant(RegressionApplyContent applyContent) {
        if (RegressionApplyContent.predictedValue.equals((Object)applyContent)) {
            return 3;
        }
        if (RegressionApplyContent.confidence.equals((Object)applyContent)) {
            return 1;
        }
        if (OraRegressionApplyContent.predictionLowerBound.equals((Object)applyContent)) {
            return 5;
        }
        if (OraRegressionApplyContent.predictionUpperBound.equals((Object)applyContent)) {
            return 6;
        }
        return -1;
    }

    public static int getPLSQLConstant(ClusteringApplyContent applyContent) {
        if (ClusteringApplyContent.clusterIdentifier.equals((Object)applyContent)) {
            return 3;
        }
        if (ClusteringApplyContent.probability.equals((Object)applyContent)) {
            return 1;
        }
        return -1;
    }

    public static int getPLSQLConstant(OraFeatureExtractionApplyContent applyContent) {
        if (OraFeatureExtractionApplyContent.featureIdentifier.equals((Object)applyContent)) {
            return 3;
        }
        if (OraFeatureExtractionApplyContent.matchQuality.equals((Object)applyContent)) {
            return 1;
        }
        return -1;
    }

    public static ClassificationApplyContent getClassificationApplyContent(int plsqlConstant) {
        if (plsqlConstant == 2) {
            return ClassificationApplyContent.cost;
        }
        if (plsqlConstant == 1) {
            return ClassificationApplyContent.probability;
        }
        if (plsqlConstant == 4) {
            return ClassificationApplyContent.nodeId;
        }
        if (plsqlConstant == 3) {
            return ClassificationApplyContent.predictedCategory;
        }
        if (plsqlConstant == 5) {
            return OraClassificationApplyContent.probabilityLowerBound;
        }
        if (plsqlConstant == 6) {
            return OraClassificationApplyContent.probabilityUpperBound;
        }
        return null;
    }

    public static RegressionApplyContent getRegressionApplyContent(int plsqlConstant) {
        if (plsqlConstant == 3) {
            return RegressionApplyContent.predictedValue;
        }
        if (plsqlConstant == 1) {
            return RegressionApplyContent.confidence;
        }
        if (plsqlConstant == 5) {
            return OraRegressionApplyContent.predictionLowerBound;
        }
        if (plsqlConstant == 6) {
            return OraRegressionApplyContent.predictionUpperBound;
        }
        return null;
    }

    public static ClusteringApplyContent getClusteringApplyContent(int plsqlConstant) {
        if (plsqlConstant == 3) {
            return ClusteringApplyContent.clusterIdentifier;
        }
        if (plsqlConstant == 1) {
            return ClusteringApplyContent.probability;
        }
        return null;
    }

    public static OraFeatureExtractionApplyContent getFeatureExtractionApplyContent(int plsqlConstant) {
        if (plsqlConstant == 3) {
            return OraFeatureExtractionApplyContent.featureIdentifier;
        }
        if (plsqlConstant == 1) {
            return OraFeatureExtractionApplyContent.matchQuality;
        }
        return null;
    }

    static {
        m_oracleToJDMAttributeTypeMap.put("NUMBER", AttributeType.numerical);
        m_oracleToJDMAttributeTypeMap.put("FLOAT", AttributeType.numerical);
        m_oracleToJDMAttributeTypeMap.put("NUMERICAL", AttributeType.numerical);
        m_oracleToJDMAttributeTypeMap.put("CHAR", AttributeType.categorical);
        m_oracleToJDMAttributeTypeMap.put("VARCHAR2", AttributeType.categorical);
        m_oracleToJDMAttributeTypeMap.put("CATEGORICAL", AttributeType.categorical);
        m_oracleToJDMDataTypeMap = new Hashtable();
        m_oracleToJDMDataTypeMap.put("NUMBER", AttributeDataType.doubleType);
        m_oracleToJDMDataTypeMap.put("FLOAT", AttributeDataType.doubleType);
        m_oracleToJDMDataTypeMap.put("INTEGER", AttributeDataType.doubleType);
        m_oracleToJDMDataTypeMap.put("NESTED TABLE", OraAttributeDataType.nestedTable);
        m_oracleToJDMDataTypeMap.put("NUMERICAL", AttributeDataType.doubleType);
        m_oracleToJDMDataTypeMap.put("CHAR", AttributeDataType.stringType);
        m_oracleToJDMDataTypeMap.put("VARCHAR2", AttributeDataType.stringType);
        m_oracleToJDMDataTypeMap.put("VARCHAR", AttributeDataType.stringType);
        m_oracleToJDMDataTypeMap.put("CATEGORICAL", AttributeDataType.stringType);
        m_oracleToJDMDataTypeMap.put("BINARY_FLOAT", AttributeDataType.doubleType);
        m_oracleToJDMDataTypeMap.put("BINARY_DOUBLE", AttributeDataType.doubleType);
        m_nestedMap = new Hashtable();
        m_nestedMap.put("NUMBER", Boolean.FALSE);
        m_nestedMap.put("FLOAT", Boolean.FALSE);
        m_nestedMap.put("DM_NESTED_NUMERICALS", Boolean.TRUE);
        m_nestedMap.put("CHAR", Boolean.FALSE);
        m_nestedMap.put("VARCHAR2", Boolean.FALSE);
        m_nestedMap.put("DM_NESTED_CATEGORICALS", Boolean.TRUE);
        m_plsqlConstants = new Hashtable();
        m_plsqlConstants.put("= ", ComparisonOperator.equal);
        m_plsqlConstants.put("!=", ComparisonOperator.notEqual);
        m_plsqlConstants.put("<", ComparisonOperator.lessThan);
        m_plsqlConstants.put(">", ComparisonOperator.greaterThan);
        m_plsqlConstants.put("<=", ComparisonOperator.lessOrEqual);
        m_plsqlConstants.put(">=", ComparisonOperator.greaterOrEqual);
        m_plsqlConstants.put("IN", ComparisonOperator.in);
        m_plsqlConstants.put("NOT IN", ComparisonOperator.notIn);
    }
}

