/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm;

import java.util.Date;
import javax.datamining.JDMException;
import javax.datamining.MiningObject;
import javax.datamining.NamedObject;
import javax.datamining.resource.Connection;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;

public abstract class OraMiningObject
extends OraDMObject
implements MiningObject {
    private NamedObject m_objectType = null;
    private String m_name = null;
    protected String m_description = null;
    private String m_creatorInfo = null;
    private Date m_creationDate = null;
    private String m_identifier = null;
    public static final String DESCRIPTION_DELIMITER = ";Description:";
    private static final String TABLE_EXIST = "SELECT COUNT(*) FROM USER_TABLES WHERE TABLE_NAME =?";
    private static final String VIEW_EXIST = "SELECT COUNT(*) FROM USER_VIEWS WHERE VIEW_NAME =?";

    protected OraMiningObject(OraConnection dmeConn, OraFactory parentFactory, NamedObject objectType) throws JDMException {
        super(dmeConn, parentFactory);
        this.m_objectType = objectType;
        this.m_creationDate = new Date();
    }

    protected void setName(String name) throws JDMException {
        this.getValidationHandler().validateNotNull(name, "name");
        this.getValidationHandler().validateObjectName(name, "name", this.getObjectType());
        this.m_name = name;
        this.m_identifier = this.getObjectType().name() + "_" + name;
    }

    protected void setCreatorInfo(String creatorInfo) throws JDMException {
        this.m_creatorInfo = creatorInfo;
    }

    protected void setCreationDate(Date creationDate) throws JDMException {
        this.m_creationDate = creationDate;
    }

    protected void setObjectIdentifier(String identifier) throws JDMException {
        this.m_identifier = identifier;
    }

    public void doBeforeStore(String name) throws JDMException {
        this.setName(name);
        try {
            this.setCreationDate(new Date());
            this.setCreatorInfo(this.getDatabaseConnection().getMetaData().getUserName());
        }
        catch (Exception anyExp) {
            this.logTrace("Failed Operation: doBeforeStore: " + this.getObjectType() + ": " + name, anyExp);
        }
    }

    public void saveObjectInDatabase(Connection dmeConn, String name, boolean replace) throws JDMException {
        if (dmeConn.doesObjectExist(name, this.getObjectType())) {
            if (replace) {
                try {
                    dmeConn.removeObject(name, this.getObjectType());
                }
                catch (JDMException anyJDMExp) {
                    this.logTrace("Failed Operation: saveObjectInDatabase: " + this.getObjectType() + ": " + name, anyJDMExp);
                }
            } else {
                this.createException(OraJDMBundleKeys.JDM_OBJECT_EXISTS, new String[]{this.getObjectType().name(), name}, null);
            }
        }
        this.saveObjectInDatabase(dmeConn, name);
    }

    protected abstract void saveObjectInDatabase(Connection var1, String var2) throws JDMException;

    public NamedObject getObjectType() {
        return this.m_objectType;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) throws JDMException {
        this.m_description = description;
    }

    public String getName() {
        return this.m_name;
    }

    public String getCreatorInfo() {
        return this.m_creatorInfo;
    }

    public Date getCreationDate() {
        return this.m_creationDate;
    }

    public String getObjectIdentifier() {
        return this.m_identifier;
    }

    public abstract boolean isInputObject();
}

