/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm;

public class OraDataURI {
    private String m_dataURI;
    private String m_tableName;
    private String m_schemaName;
    private boolean m_isUpdated = false;

    public OraDataURI(String uri) {
        this.m_dataURI = uri;
        if (uri != null) {
            this.parse();
        }
    }

    public OraDataURI(String tableName, String schemaName) {
        if (tableName != null) {
            this.m_tableName = tableName.startsWith("\"") ? tableName : tableName.toUpperCase();
        }
        if (schemaName == null) {
            this.m_dataURI = tableName;
        } else {
            this.m_schemaName = schemaName.startsWith("\"") ? schemaName : schemaName.toUpperCase();
            this.m_dataURI = this.m_schemaName + "." + this.m_tableName;
        }
    }

    public OraDataURI() {
    }

    public String getURI() {
        if (this.m_isUpdated) {
            this.updateURI(this.m_tableName, this.m_schemaName);
            this.m_isUpdated = false;
        }
        return this.m_dataURI;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public void setURI(String uri) {
        this.m_dataURI = uri;
        this.parse();
    }

    public void setTableName(String tableName) {
        this.m_isUpdated = true;
        this.m_tableName = tableName;
    }

    public void setSchemaName(String schemaName) {
        this.m_isUpdated = true;
        this.m_schemaName = schemaName;
    }

    private void parse() {
        int startsWithDblQuote = this.m_dataURI.indexOf("\"");
        int indexDot = this.m_dataURI.indexOf(".");
        int dblQuoteDotComb = this.m_dataURI.indexOf("\".");
        if (indexDot == -1) {
            this.m_tableName = startsWithDblQuote == -1 ? this.m_dataURI.toUpperCase() : this.m_dataURI;
            this.m_schemaName = null;
            return;
        }
        if (startsWithDblQuote != -1 && dblQuoteDotComb != -1) {
            this.m_tableName = this.m_dataURI.substring(dblQuoteDotComb + 2);
            this.m_schemaName = this.m_dataURI.substring(0, dblQuoteDotComb + 1);
            if (!this.m_tableName.startsWith("\"")) {
                this.m_tableName = this.m_tableName.toUpperCase();
            }
            return;
        }
        if (startsWithDblQuote != -1 && startsWithDblQuote == 0 && dblQuoteDotComb == -1) {
            this.m_tableName = this.m_dataURI;
            this.m_schemaName = null;
            return;
        }
        this.m_tableName = this.m_dataURI.substring(indexDot + 1);
        this.m_schemaName = this.m_dataURI.substring(0, indexDot).toUpperCase();
        if (!this.m_tableName.startsWith("\"")) {
            this.m_tableName = this.m_tableName.toUpperCase();
        }
    }

    private void updateURI(String tableName, String schemaName) {
        if (tableName == null && schemaName == null) {
            return;
        }
        this.m_dataURI = schemaName == null ? tableName : schemaName + "." + tableName;
    }
}

