/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm;

import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.datamining.JDMException;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraPLSQLConstants;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.resource.OraExceptionHandler;
import oracle.dmt.jdm.resource.OraValidationHandler;
import oracle.dmt.jdm.utils.OraStringUtils;

public abstract class OraDMObject
implements OraPLSQLConstants {
    private OraConnection m_dmeConn = null;
    private OraFactory m_parentFactory = null;
    protected String installedSchema = "SYS";

    public OraDMObject() {
    }

    protected OraDMObject(OraConnection dmeConn, OraFactory parentFactory) {
        this.m_dmeConn = dmeConn;
        if (dmeConn != null && dmeConn.is102()) {
            this.installedSchema = "DMSYS";
        }
        this.m_parentFactory = parentFactory;
    }

    protected OraConnection getConnection() {
        if (this.m_dmeConn == null && this.m_parentFactory != null) {
            this.m_dmeConn = this.m_parentFactory.getConnection();
        }
        return this.m_dmeConn;
    }

    protected Connection getDatabaseConnection() {
        return this.getConnection().getDatabaseConnection();
    }

    protected OraFactory getFactory() {
        return this.m_parentFactory;
    }

    protected OraValidationHandler getValidationHandler() {
        return this.getConnection().getValidationHandler();
    }

    protected OraExceptionHandler getExceptionHandler() {
        return this.getConnection().getExceptionHandler();
    }

    public String getLocalizedMessage(String errorCode, Object[] params) {
        return this.getConnection().getLocalizedMessage(errorCode, params);
    }

    protected Logger getLogger() {
        return this.getConnection().getLogger();
    }

    public void createException(String errorCode, Object[] params, Throwable cause) throws JDMException {
        this.getExceptionHandler().createException(errorCode, params, cause);
    }

    public void createRuntimeException(String errorCode, Object[] params, Throwable cause) {
        this.getExceptionHandler().createRuntimeException(errorCode, params, cause);
    }

    public void createException(String errorCode, Object[] jdmMsgparams, Throwable cause, String vendorCode, Object[] vendorMsgParams) throws JDMException {
        this.getExceptionHandler().createException(errorCode, jdmMsgparams, cause, vendorCode, vendorMsgParams);
    }

    public void createRuntimeException(String errorCode, Object[] jdmMsgparams, Throwable cause, String vendorCode, Object[] vendorMsgParams) {
        this.getExceptionHandler().createRuntimeException(errorCode, jdmMsgparams, cause, vendorCode, vendorMsgParams);
    }

    public void unsupported(String featureName) {
        this.unsupported(featureName, "-1", null);
    }

    public void unsupported(String featureName, String featureDescriptionErrorCode, Object[] featureDescriptionParameters) {
        String featureDescription = "";
        if (featureDescriptionErrorCode == "-1") {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{featureName, featureDescription}, null);
        } else {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{featureName, featureDescription}, null, featureDescriptionErrorCode, featureDescriptionParameters);
        }
    }

    protected String[] splitAttribute(String attrName, boolean trimDoubleQuotes) {
        String[] attrs = new String[]{null, null, null};
        int startsWithDblQuote = attrName.indexOf("\"");
        int indexDot = attrName.indexOf(".");
        int dblQuoteDotComb = attrName.indexOf("\".");
        if (indexDot == -1) {
            attrs[0] = this.getValidationHandler().validateTableColumnName(attrName, "attrName");
            attrs[1] = null;
            attrs[2] = new String(attrs[0]);
        } else if (startsWithDblQuote != -1 && dblQuoteDotComb != -1) {
            attrs[1] = attrName.substring(dblQuoteDotComb + 2);
            attrs[0] = attrName.substring(0, dblQuoteDotComb + 1);
            attrs[0] = this.getValidationHandler().validateTableColumnName(attrs[0], "attrName");
            attrs[2] = attrs[0] + "." + attrs[1];
        }
        if (trimDoubleQuotes) {
            attrs[0] = OraStringUtils.trimDoubleQuotes(attrs[0]);
        }
        return attrs;
    }

    public boolean isConnectionOpen() {
        return this.getConnection().isOpen();
    }

    protected boolean is102() {
        return this.getConnection().is102();
    }

    public void logInfo(String msg, Object[] params) {
        this.getConnection().getLogger().log(Level.INFO, msg, params);
    }

    public void logSevere(String msg, Object[] params) {
        this.getConnection().getLogger().log(Level.SEVERE, msg, params);
    }

    public void logTrace(String msg, Object[] params) {
        this.getConnection().getLogger().log(Level.FINEST, msg, params);
    }

    public void logTrace(String msg, Throwable exception) {
        this.getConnection().getLogger().log(Level.FINEST, msg, exception);
    }
}

