/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.odm.binning;

import java.util.Vector;
import oracle.dmt.dm4j.datasources.CategoricDiscretizeDataSource;
import oracle.dmt.odm.binning.BinningType;

public class CategoricalBackupData {
    private int m_selectedRow;
    private Integer m_numberofBins;
    private BinningType m_binningType;
    private Vector m_binBounds;
    private StringBuffer m_viewDefinition;
    private boolean n_numeric;
    private Integer m_totalCount;
    private Integer m_distinctCount;
    private String m_mode;
    private Double m_missingPercent;

    public CategoricalBackupData() {
    }

    public CategoricalBackupData(CategoricDiscretizeDataSource categoricDiscretizeDataSource, int n) {
        this.collectBackupData(categoricDiscretizeDataSource, n);
    }

    public void collectBackupData(CategoricDiscretizeDataSource categoricDiscretizeDataSource, int n) {
        this.m_selectedRow = n;
        this.m_numberofBins = categoricDiscretizeDataSource.getNumberOfBins(n);
        this.m_binningType = categoricDiscretizeDataSource.getBinningType(n);
        this.getStats(categoricDiscretizeDataSource, n);
        this.m_binBounds = categoricDiscretizeDataSource.getBinBounds(n);
        this.m_viewDefinition = categoricDiscretizeDataSource.getViewDefinition(n);
        this.n_numeric = categoricDiscretizeDataSource.isNumeric(n);
    }

    public int restoreBackupData(CategoricDiscretizeDataSource categoricDiscretizeDataSource) {
        categoricDiscretizeDataSource.setData(CategoricDiscretizeDataSource.COLUMN_NAMES.BINNUMBER, this.m_selectedRow, this.m_numberofBins);
        if (this.m_numberofBins != null) {
            categoricDiscretizeDataSource.markAttributeBinned(this.m_selectedRow, this.m_binningType, this.m_numberofBins);
        } else {
            categoricDiscretizeDataSource.markAttributeUnBinned(this.m_selectedRow);
        }
        this.setStats(categoricDiscretizeDataSource, this.m_selectedRow);
        categoricDiscretizeDataSource.setBinBounds(this.m_selectedRow, this.m_binBounds);
        categoricDiscretizeDataSource.setViewDefinition(this.m_selectedRow, this.m_viewDefinition);
        return this.m_selectedRow;
    }

    public int partialRestoreBackupData(CategoricDiscretizeDataSource categoricDiscretizeDataSource) {
        categoricDiscretizeDataSource.setData(CategoricDiscretizeDataSource.COLUMN_NAMES.BINNUMBER, this.m_selectedRow, this.m_numberofBins);
        if (this.m_numberofBins != null) {
            categoricDiscretizeDataSource.markAttributeBinned(this.m_selectedRow, this.m_binningType, this.m_numberofBins);
        } else {
            categoricDiscretizeDataSource.markAttributeUnBinned(this.m_selectedRow);
        }
        categoricDiscretizeDataSource.setBinBounds(this.m_selectedRow, this.m_binBounds);
        categoricDiscretizeDataSource.setViewDefinition(this.m_selectedRow, this.m_viewDefinition);
        return this.m_selectedRow;
    }

    private void setStats(CategoricDiscretizeDataSource categoricDiscretizeDataSource, int n) {
        categoricDiscretizeDataSource.setData(CategoricDiscretizeDataSource.COLUMN_NAMES.TOTAL, n, this.m_totalCount);
        categoricDiscretizeDataSource.setData(CategoricDiscretizeDataSource.COLUMN_NAMES.DISTINCT, n, this.m_distinctCount);
        categoricDiscretizeDataSource.setData(CategoricDiscretizeDataSource.COLUMN_NAMES.MODE, n, this.m_mode);
        categoricDiscretizeDataSource.setData(CategoricDiscretizeDataSource.COLUMN_NAMES.MISSING_PERCENT, n, this.m_missingPercent);
    }

    private void getStats(CategoricDiscretizeDataSource categoricDiscretizeDataSource, int n) {
        this.m_totalCount = (Integer)categoricDiscretizeDataSource.getData(CategoricDiscretizeDataSource.COLUMN_NAMES.TOTAL, n);
        this.m_distinctCount = (Integer)categoricDiscretizeDataSource.getData(CategoricDiscretizeDataSource.COLUMN_NAMES.DISTINCT, n);
        this.m_mode = (String)categoricDiscretizeDataSource.getData(CategoricDiscretizeDataSource.COLUMN_NAMES.MODE, n);
        this.m_missingPercent = (Double)categoricDiscretizeDataSource.getData(CategoricDiscretizeDataSource.COLUMN_NAMES.MISSING_PERCENT, n);
    }
}

