/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.odm.binning;

import java.util.Vector;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.odm.binning.BinningType;

public class BackupData {
    private int m_selectedRow;
    private Integer m_numberofBins;
    private BinningType m_binningType;
    private Double m_tailPercent;
    private Vector m_binBounds;
    private StringBuffer m_viewDefinition;
    private boolean n_numeric;
    private Integer m_totalCount;
    private Double m_average;
    private Double m_max;
    private Double m_min;
    private Double m_var;
    private Double m_stdev;
    private Double m_skew;
    private Double m_kurt;

    public BackupData() {
    }

    public BackupData(DiscretizeDataSource discretizeDataSource, int n) {
        this.collectBackupData(discretizeDataSource, n);
    }

    public void collectBackupData(DiscretizeDataSource discretizeDataSource, int n) {
        this.m_selectedRow = n;
        this.m_numberofBins = discretizeDataSource.getNumberOfBins(n);
        this.m_binningType = discretizeDataSource.getBinningType(n);
        this.m_tailPercent = discretizeDataSource.getTailPercent(n);
        this.getStats(discretizeDataSource, n);
        this.m_binBounds = discretizeDataSource.getBinBounds(n);
        this.m_viewDefinition = discretizeDataSource.getViewDefinition(n);
        this.n_numeric = discretizeDataSource.isNumeric(n);
    }

    public int restoreBackupData(DiscretizeDataSource discretizeDataSource) {
        discretizeDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.BINNUMBER, this.m_selectedRow, this.m_numberofBins);
        discretizeDataSource.markAttributeBinned(this.m_selectedRow, this.m_binningType, this.m_numberofBins);
        discretizeDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.TAILPERCENT, this.m_selectedRow, this.m_tailPercent);
        this.setStats(discretizeDataSource, this.m_selectedRow);
        discretizeDataSource.setBinBounds(this.m_selectedRow, this.m_binBounds);
        discretizeDataSource.setViewDefinition(this.m_selectedRow, this.m_viewDefinition);
        return this.m_selectedRow;
    }

    public int partialRestoreBackupData(DiscretizeDataSource discretizeDataSource) {
        discretizeDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.BINNUMBER, this.m_selectedRow, this.m_numberofBins);
        if (this.m_numberofBins != null) {
            discretizeDataSource.markAttributeBinned(this.m_selectedRow, this.m_binningType, this.m_numberofBins);
        } else {
            discretizeDataSource.setBinTypeNONE(this.m_selectedRow);
        }
        discretizeDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.TAILPERCENT, this.m_selectedRow, this.m_tailPercent);
        discretizeDataSource.setBinBounds(this.m_selectedRow, this.m_binBounds);
        discretizeDataSource.setViewDefinition(this.m_selectedRow, this.m_viewDefinition);
        return this.m_selectedRow;
    }

    private void setStats(DiscretizeDataSource discretizeDataSource, int n) {
        discretizeDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.TOTAL, n, this.m_totalCount);
        discretizeDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.AVG, n, this.m_average);
        discretizeDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.MAX, n, this.m_max);
        discretizeDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.MIN, n, this.m_min);
        discretizeDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.VAR, n, this.m_var);
        discretizeDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.STDDEV, n, this.m_stdev);
        discretizeDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.SKEW, n, this.m_skew);
        discretizeDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.KURT, n, this.m_kurt);
    }

    private void getStats(DiscretizeDataSource discretizeDataSource, int n) {
        this.m_totalCount = (Integer)discretizeDataSource.getData(DiscretizeDataSource.COLUMN_NAMES.TOTAL, n);
        this.m_average = (Double)discretizeDataSource.getData(DiscretizeDataSource.COLUMN_NAMES.AVG, n);
        this.m_max = (Double)discretizeDataSource.getData(DiscretizeDataSource.COLUMN_NAMES.MAX, n);
        this.m_min = (Double)discretizeDataSource.getData(DiscretizeDataSource.COLUMN_NAMES.MIN, n);
        this.m_var = (Double)discretizeDataSource.getData(DiscretizeDataSource.COLUMN_NAMES.VAR, n);
        this.m_stdev = (Double)discretizeDataSource.getData(DiscretizeDataSource.COLUMN_NAMES.STDDEV, n);
        this.m_skew = (Double)discretizeDataSource.getData(DiscretizeDataSource.COLUMN_NAMES.SKEW, n);
        this.m_kurt = (Double)discretizeDataSource.getData(DiscretizeDataSource.COLUMN_NAMES.KURT, n);
    }
}

