/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.validation;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JException;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.ValidationType;

public class StateValidation
implements Serializable {
    protected transient ValidationType m_type = null;
    protected String m_description;
    protected String m_validationType = null;
    protected String m_causeStackTrace = null;
    protected String m_causeMessage = null;
    protected String m_causeClass = null;
    protected transient Exception m_cause = null;

    public StateValidation() {
    }

    public StateValidation(ValidationType validationType, DM4JException dM4JException) throws Exception {
        this(validationType);
        this.m_cause = dM4JException;
        this.loadCause();
    }

    public StateValidation(ValidationType validationType, Exception exception) throws Exception {
        this(validationType);
        this.m_cause = exception;
        this.loadCause();
    }

    public StateValidation(ValidationType validationType) throws Exception {
        this.m_type = validationType;
        this.determineValidationType(validationType);
        this.m_description = ResourceUtilities.getDM4JValidationMessage(validationType);
    }

    public StateValidation(ValidationType validationType, String string, String[] stringArray) throws Exception {
        this.m_type = validationType;
        this.determineValidationType(validationType);
        this.loadCause();
        this.m_description = MessageFormat.format(string, stringArray);
    }

    public StateValidation(ValidationType validationType, String[] stringArray) throws Exception {
        this.m_type = validationType;
        this.determineValidationType(validationType);
        String string = ResourceUtilities.getDM4JValidationMessage(validationType);
        this.m_description = MessageFormat.format(string, stringArray);
    }

    public static Vector getWarningValidations(Vector vector) {
        Iterator iterator = vector.iterator();
        Vector<StateValidation> vector2 = new Vector<StateValidation>();
        StateValidation stateValidation = null;
        while (iterator.hasNext()) {
            stateValidation = (StateValidation)iterator.next();
            if ("ERROR".compareTo(stateValidation.getValidationType()) == 0) continue;
            vector2.add(stateValidation);
        }
        return vector2;
    }

    public static StateValidation getFirstErrorValidation(Vector vector) {
        Iterator iterator = vector.iterator();
        StateValidation stateValidation = null;
        while (iterator.hasNext()) {
            stateValidation = (StateValidation)iterator.next();
            if ("ERROR".compareTo(stateValidation.getValidationType()) != 0) continue;
            return stateValidation;
        }
        return null;
    }

    public String getValidationType() {
        return this.m_validationType;
    }

    public void setValidationType(String string) {
        this.m_validationType = string;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String string) {
        this.m_description = string;
    }

    public String getCauseMessage() {
        String string = this.m_causeMessage == null ? "" : this.m_causeMessage;
        return string;
    }

    public void setCauseMessage(String string) {
        this.m_causeMessage = string;
    }

    public String getCauseClass() {
        String string = this.m_causeClass == null ? "" : this.m_causeClass;
        return string;
    }

    public void setCauseClass(String string) {
        this.m_causeClass = string;
    }

    public String getCauseStackTrace() {
        String string = this.m_causeStackTrace == null ? "" : this.m_causeStackTrace;
        return string;
    }

    public void setCauseStackTrace(String string) {
        this.m_causeStackTrace = string;
    }

    private void determineValidationType(ValidationType validationType) {
        this.m_validationType = validationType.getTypeString();
    }

    private void loadCause() {
        if (this.m_cause != null) {
            this.m_causeMessage = this.m_cause.getMessage();
            this.m_causeClass = this.m_cause.getClass().toString();
            if (this.m_cause.getStackTrace() != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                this.m_cause.printStackTrace(printStream);
                this.m_causeStackTrace = byteArrayOutputStream.toString();
            }
        }
    }
}

