/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.uicontrols;

import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.uicontrols.RowEditorModel;
import oracle.dmt.dm4j.wizard.uicontrols.SelectionChangeListener;

public class CustomTable
extends JTable {
    protected RowEditorModel rm = null;
    protected SelectionChangeListener m_selChangeListener = null;

    public CustomTable(TableModel tableModel, RowEditorModel rowEditorModel) {
        super(tableModel, null, null);
        this.rm = rowEditorModel;
    }

    public CustomTable() {
    }

    public CustomTable(TableModel tableModel) {
        super(tableModel);
    }

    public void setRowEditorModel(RowEditorModel rowEditorModel) {
        this.rm = rowEditorModel;
    }

    public void addSelectionChangeListener(SelectionChangeListener selectionChangeListener) {
        this.m_selChangeListener = selectionChangeListener;
    }

    public RowEditorModel getRowEditorModel() {
        return this.rm;
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        TableCellEditor tableCellEditor = null;
        if (this.rm != null) {
            tableCellEditor = this.rm.getEditor(n);
        }
        if (tableCellEditor != null) {
            return tableCellEditor;
        }
        return super.getCellEditor(n, n2);
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        super.changeSelection(n, n2, bl, bl2);
        if (this.m_selChangeListener != null) {
            this.m_selChangeListener.selectionChanged(this);
        }
    }

    public Object getValueAt(int n, int n2) {
        Object object = super.getValueAt(n, n2);
        if (n == 0 && n2 == 1) {
            return ResourceUtilities.getUILabel("BINNING_STRATEGY_NO_UPPER_BOUND");
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            if (d.floatValue() == Float.MIN_VALUE) {
                return "No lower bound";
            }
            if (d.floatValue() == Float.MAX_VALUE) {
                return "No upper bound";
            }
            return DM4JNumericFormat.format(d);
        }
        return object;
    }
}

