/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.uicontrols;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Locale;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dm4j.wizard.uicontrols.UpdatableTextField;

public class CustomNumberTextField
extends NumberTextField {
    UpdatableTextField m_textFileld;
    int m_id;

    public CustomNumberTextField(UpdatableTextField updatableTextField, int n) {
        this.setLocale(Locale.getDefault());
        this.m_id = n;
        this.m_textFileld = updatableTextField;
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                super.keyReleased(keyEvent);
                if (127 == keyEvent.getKeyCode() || 8 == keyEvent.getKeyCode()) {
                    Number number = CustomNumberTextField.this.getNumber();
                    Number number2 = null;
                    if (number != null) {
                        try {
                            int n = number.intValue();
                            number2 = new Integer(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            try {
                                double d = number.doubleValue();
                                number2 = new Double(d);
                            }
                            catch (NumberFormatException numberFormatException2) {
                                // empty catch block
                            }
                        }
                    }
                    CustomNumberTextField.this.validateNumber(number2);
                }
            }
        });
    }

    protected boolean validateNumber(Number number) {
        boolean bl = super.validateNumber(number);
        if (bl && number != null) {
            this.m_textFileld.updateNumber(number, this.m_id);
        }
        return bl;
    }
}

