/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.GridLayout;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeWinsorizeArray;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.steps.transformsteps.EqualBinningSettingsPanel;
import oracle.dmt.odm.binning.BackupData;
import oracle.dmt.odm.binning.BinningType;

public class WinsorizeBinningSettingsPanel
extends EqualBinningSettingsPanel {
    protected JPanel pnlTailPercent;
    protected JLabel lblTailPercent;
    protected TailPercentTextField txtTailPercent;

    public WinsorizeBinningSettingsPanel(DM4JDialog dM4JDialog, WizardState wizardState, SpreadTable spreadTable) throws Exception {
        super(dM4JDialog, wizardState, spreadTable);
    }

    protected void jbInit() throws Exception {
        this.pnlTailPercent = new JPanel(new GridLayout(1, 2, 5, 0));
        this.lblTailPercent = new JLabel();
        this.txtTailPercent = new TailPercentTextField();
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("WINSORIZE_BINNING_STRATEGY_DIALOG_DESCRIPTION"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 5, 1, 1);
        this.addFilledComponent(this.pnlNumberOfBins, COL1_INDENTED1_LABEL, n++, 0, 1, 1, 1);
        this.lblNumberOfBins.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_NUMBER_OF_BINS_SPECIFY"));
        this.lblNumberOfBins.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("BINNING_STRATEGY_NUMBER_OF_BINS_SPECIFY"));
        this.txtNumberOfBins.setDecimal(true);
        this.txtNumberOfBins.setColumns(10);
        this.lblNumberOfBins.setLabelFor(this.txtNumberOfBins);
        this.pnlNumberOfBins.add(this.lblNumberOfBins);
        this.pnlNumberOfBins.add(this.txtNumberOfBins);
        this.addFilledComponent(this.pnlTailPercent, COL1_INDENTED1_LABEL, n, 0, 1, 1, 1);
        this.lblTailPercent.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_TAIL_PERCENT"));
        this.txtTailPercent.setDecimal(true);
        this.txtTailPercent.setColumns(10);
        this.lblTailPercent.setLabelFor(this.txtTailPercent);
        this.pnlTailPercent.add(this.lblTailPercent);
        this.pnlTailPercent.add(this.txtTailPercent);
        this.addOKHelpCancelListeners();
        this.loadState();
    }

    protected void loadState() throws Exception {
        super.loadState();
        double d = this.getGroupTailPercentage();
        this.m_settingsState.setCurrentTailPercent(d);
        this.txtTailPercent.setNumber(new Double(d));
    }

    protected double getGroupTailPercentage() {
        if (this.m_range == null || this.m_range.length == 0) {
            return DiscretizeDataSource.DEFAULT_TAIL_PERCENT;
        }
        Double d = null;
        for (int i = 0; i < this.m_range.length; ++i) {
            int n = this.m_range[i].getLowerLimit();
            int n2 = this.m_range[i].getUpperLimit();
            for (int j = n; j <= n2; ++j) {
                if (!this.m_dataSourcemodel.isAttributeBinned(j)) {
                    return DiscretizeDataSource.DEFAULT_TAIL_PERCENT;
                }
                Double d2 = this.m_dataSourcemodel.getTailPercent(j);
                if (d == null) {
                    d = d2;
                    continue;
                }
                if (0 == d.compareTo(d2)) continue;
                return DiscretizeDataSource.DEFAULT_TAIL_PERCENT;
            }
        }
        return d != null ? d : 0.0;
    }

    protected void validate(Vector vector) throws Exception {
        this.m_settingsState.validateBinNumberValue(vector);
        this.m_settingsState.validateTailPercentValue(vector);
    }

    protected boolean isSameTypeBinning(int n) {
        return this.m_dataSourcemodel.isWinsorizeBinning(n);
    }

    protected void processUserInput() {
        int n = this.m_settingsState.getCurrentNumberOfBins();
        int n2 = this.getGroupNumberOfBins();
        double d = this.m_settingsState.getCurrentTailPercent();
        double d2 = this.getGroupTailPercentage();
        if (!this.isBinningRequired() && n2 == n && d == d2) {
            return;
        }
        this.m_backupData.clear();
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (int i = 0; i < this.m_range.length; ++i) {
            int n3 = this.m_range[i].getLowerLimit();
            int n4 = this.m_range[i].getUpperLimit();
            for (int j = n3; j <= n4; ++j) {
                BackupData backupData = new BackupData(this.m_dataSourcemodel, j);
                this.m_dataSourcemodel.setNumberOfBins(j, n);
                String string = this.m_dataSourcemodel.getAttributeName(j);
                hashtable.put(string, new Integer(j));
                this.m_dataSourcemodel.markAttributeBinned(j, BinningType.WINSORIZE, n);
                this.m_dataSourcemodel.setTailPercent(j, d);
                this.m_backupData.put(new Integer(j), backupData);
            }
        }
        Hashtable hashtable2 = this.getWinsorizeBounds(hashtable, n, d);
        if (!hashtable2.isEmpty()) {
            String string = null;
            if (hashtable2.size() > 1) {
                string = ResourceUtilities.getUILabel("WINSORIZE_ERROR_DESCRIPTION_MANY");
            } else {
                Enumeration enumeration = hashtable2.keys();
                String string2 = (String)enumeration.nextElement();
                string = string2 + ResourceUtilities.getUILabel("WINSORIZE_ERROR_DESCRIPTION_SINGLE");
            }
            JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), string, ResourceUtilities.getUILabel("BINNING_STRATEGY_WINSORIZE_OPTION"), 0);
            this.restoreAttrubuteValues(hashtable2);
        }
        this.m_settingsState.invalidate();
    }

    protected void updateTailPercent(Number number) {
        this.m_settingsState.setCurrentTailPercent(number != null ? number.doubleValue() : 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getWinsorizeBounds(Hashtable hashtable, int n, double d) {
        DiscretizeWinsorizeArray discretizeWinsorizeArray = null;
        try {
            discretizeWinsorizeArray = new DiscretizeWinsorizeArray(this.m_dataSourcemodel, hashtable, n, d);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), discretizeWinsorizeArray, true);
            discretizeWinsorizeArray.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_DESC"));
            if (discretizeWinsorizeArray.getException() != null) {
                this.restoreAttrubuteValues(hashtable);
            } else if (progressBar.hasUserCancelled()) {
                this.restoreAttrubuteValues(hashtable);
            }
        }
        catch (Exception exception) {}
        return discretizeWinsorizeArray.getFailed();
    }

    class TailPercentTextField
    extends NumberTextField {
        TailPercentTextField() {
            this.setLocale(Locale.getDefault());
        }

        protected boolean validateNumber(Number number) {
            boolean bl = super.validateNumber(number);
            if (bl && number != null) {
                WinsorizeBinningSettingsPanel.this.updateTailPercent(number);
            }
            return bl;
        }
    }
}

