/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.FinishState;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.NameStateError;

public abstract class TransformsTableNamesPanel
extends JPanel {
    protected static final int TABLE_NAME_LENGTH_MAX = 30;
    protected FinishState m_state;
    protected DM4JDialog m_parentDialog;
    protected GridBagLayout gridBagLayout = new GridBagLayout();
    protected MultiLineLabel mlblStepDescription = new MultiLineLabel();
    protected JLabel lblFiller = new JLabel();

    public TransformsTableNamesPanel(DM4JDialog dM4JDialog, FinishState finishState) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = finishState;
        this.initModel();
        this.jbInit();
    }

    protected abstract void initModel();

    protected abstract void jbInit() throws Exception;

    protected abstract void m_parentDialog_actionPerformed(ActionEvent var1);

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransformsTableNamesPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void validateTableName(String string, Vector vector) throws Exception {
        String[] stringArray;
        Object object;
        boolean bl = DM4JStringUtils.isDoubleQuotedString(string);
        String string2 = string;
        if (bl) {
            string2 = DM4JStringUtils.trimDoubleQuotes(string2);
        }
        if (string2.length() == 0) {
            object = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("TRANSFORM_TABLE_NAME")};
            vector.add(new StateValidation(NameStateError.DATA_USAGE_VIEW_NAME_EMPTY, (String)object, stringArray));
        }
        if (!ValidationUtil.checkStringLength(string2, 30)) {
            object = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getUILabel("TRANSFORM_TABLE_NAME"), Integer.toString(30)};
            vector.add(new StateValidation(NameStateError.DATA_USAGE_VIEW_NAME_EXCEEDS_MAXIMUM_LENGTH, (String)object, stringArray));
        }
        if (!ValidationUtil.isTableNameUnique(string2, (Connection)(object = this.m_state.getparentWizardState().getConnection()))) {
            vector.add(new StateValidation(NameStateError.DATA_USAGE_VIEW_NAME_DUPLICATE));
        }
        if (!bl && !ValidationUtil.isValidNonQuotedDBObjectName(string2)) {
            vector.add(new StateValidation(NameStateError.DATAMINING_NAME_INVALID_DB_OBJECT_NAME));
        }
    }

    class UpperCaseField
    extends JTextField {
        public UpperCaseField(int n) {
            super(n);
        }

        protected Document createDefaultModel() {
            return new UpperCaseDocument();
        }

        class UpperCaseDocument
        extends PlainDocument {
            UpperCaseDocument() {
            }

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string == null) {
                    return;
                }
                char[] cArray = string.toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = Character.toUpperCase(cArray[i]);
                }
                super.insertString(n, new String(cArray), attributeSet);
            }
        }
    }
}

