/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.collection.Range;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.CategoricDiscretizeDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeTopNArray;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CategoricalDiscretizationSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.DiscretizationDataUsageState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.odm.binning.BinningType;
import oracle.dmt.odm.binning.CategoricalBackupData;

public class TopNBinningSetiingsPanel
extends GriddedPanel {
    private boolean m_binningRequired = false;
    protected DM4JDialog m_parentDialog;
    protected WizardState m_state = null;
    protected MultiLineLabel mlblStepDescription = new MultiLineLabel();
    protected JPanel pnlNumberOfBins = new JPanel(new GridLayout(1, 2, 5, 0));
    protected JLabel lblNumberOfBins = new JLabel();
    protected CustomNumberTextField txtNumberOfBins = new CustomNumberTextField();
    protected SpreadTable m_spreadTable;
    protected Range[] m_range = null;
    protected CategoricDiscretizeDataSource m_dataSourcemodel = null;
    protected CategoricalDiscretizationSettingsState m_settingsState;
    protected Hashtable m_backupData = new Hashtable();

    public TopNBinningSetiingsPanel(DM4JDialog dM4JDialog, WizardState wizardState, SpreadTable spreadTable) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = wizardState;
        this.m_spreadTable = spreadTable;
        this.jbInit();
    }

    protected void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("TOPN_BINNING_STRATEGY_DIALOG_DESCRIPTION"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 5, 1, 1);
        this.addFilledComponent(this.pnlNumberOfBins, COL1_INDENTED1_LABEL, n, 0, 1, 1, 1);
        this.lblNumberOfBins.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_NUMBER_OF_BINS_SPECIFY"));
        this.lblNumberOfBins.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("BINNING_STRATEGY_NUMBER_OF_BINS_SPECIFY"));
        this.txtNumberOfBins.setColumns(10);
        this.txtNumberOfBins.setDataType(Integer.TYPE);
        this.txtNumberOfBins.setSigned(false);
        this.lblNumberOfBins.setLabelFor(this.txtNumberOfBins);
        this.pnlNumberOfBins.add(this.lblNumberOfBins);
        this.pnlNumberOfBins.add(this.txtNumberOfBins);
        this.m_parentDialog.setInitialFocus(this.txtNumberOfBins);
        this.addOKHelpCancelListeners();
        this.loadState();
    }

    protected void loadState() throws Exception {
        if (this.m_state == null) {
            throw new Exception();
        }
        this.m_settingsState = (CategoricalDiscretizationSettingsState)this.m_state.getStep(StepType.SETTING_STEP_2);
        DiscretizationDataUsageState discretizationDataUsageState = (DiscretizationDataUsageState)this.m_state.getStep(StepType.DATA_USAGE_STEP);
        this.m_dataSourcemodel = discretizationDataUsageState.getCategoricModel();
        if (this.m_dataSourcemodel == null) {
            throw new Exception();
        }
        TwoDSelection twoDSelection = this.m_spreadTable.getSelection();
        if (twoDSelection == null) {
            return;
        }
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        if (oneDSelection == null) {
            return;
        }
        this.m_range = oneDSelection.getRanges();
        int n = this.getGroupNumberOfBins();
        this.m_settingsState.setCurrentNumberOfBins(n);
        this.txtNumberOfBins.setNumber(new Integer(n));
    }

    protected int getGroupNumberOfBins() {
        if (this.m_range == null || this.m_range.length == 0) {
            return CategoricDiscretizeDataSource.DEFAULT_BIN_NUMBER;
        }
        Integer n = null;
        for (int i = 0; i < this.m_range.length; ++i) {
            int n2 = this.m_range[i].getLowerLimit();
            int n3 = this.m_range[i].getUpperLimit();
            for (int j = n2; j <= n3; ++j) {
                if (!this.m_dataSourcemodel.isAttributeBinned(j)) {
                    this.m_binningRequired = true;
                    return CategoricDiscretizeDataSource.DEFAULT_BIN_NUMBER;
                }
                Integer n4 = this.m_dataSourcemodel.getNumberOfBins(j);
                if (n == null) {
                    n = n4;
                    continue;
                }
                if (0 == n.compareTo(n4)) continue;
                this.m_binningRequired = true;
                return CategoricDiscretizeDataSource.DEFAULT_BIN_NUMBER;
            }
        }
        return n;
    }

    protected boolean isBinningRequired() {
        for (int i = 0; i < this.m_range.length; ++i) {
            int n = this.m_range[i].getLowerLimit();
            int n2 = this.m_range[i].getUpperLimit();
            for (int j = n; j <= n2; ++j) {
                if (!this.m_dataSourcemodel.isAttributeBinned(j)) {
                    return true;
                }
                if (this.isSameTypeBinning(j)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isSameTypeBinning(int n) {
        return this.m_dataSourcemodel.isTopNBinning(n);
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopNBinningSetiingsPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void validate(Vector vector) throws Exception {
        this.m_settingsState.validateBinNumberValue(vector);
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.validate(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
                if (vector.isEmpty()) {
                    this.processUserInput();
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else if ("cancel" == string) {
            // empty if block
        }
    }

    protected void processUserInput() {
        Object object;
        int n;
        int n2;
        int n3 = this.m_settingsState.getCurrentNumberOfBins();
        int n4 = this.getGroupNumberOfBins();
        if (!this.m_binningRequired && !this.isBinningRequired() && n4 == n3) {
            return;
        }
        this.m_backupData.clear();
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
        for (int i = 0; i < this.m_range.length; ++i) {
            int n5 = this.m_range[i].getLowerLimit();
            n2 = this.m_range[i].getUpperLimit();
            for (n = n5; n <= n2; ++n) {
                object = new CategoricalBackupData(this.m_dataSourcemodel, n);
                String string = this.m_dataSourcemodel.getAttributeName(n);
                hashtable2.put(string, new Integer(n));
                Integer n6 = this.m_dataSourcemodel.getDistinctValue(n);
                if (n6 < n3) {
                    hashtable.put(string, n6);
                }
                this.m_backupData.put(new Integer(n), object);
            }
        }
        if (!hashtable.isEmpty()) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            if (hashtable.size() < 10) {
                Enumeration enumeration = hashtable.keys();
                n = 0;
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    stringBuffer.append("\"" + (String)object + "\"");
                    n += ((String)object).length();
                    if (enumeration.hasMoreElements()) {
                        stringBuffer.append(",");
                        ++n;
                    }
                    if (n < 40) continue;
                    stringBuffer.append("\n");
                    n = 0;
                }
                string = MessageFormat.format(ResourceUtilities.getUILabel("TOPN_BINNING_STRATEGY_DIALOG_WARNING"), stringBuffer.toString());
            } else {
                string = ResourceUtilities.getUILabel("TOPN_BINNING_STRATEGY_DIALOG_WARNING_MUTIPLE");
            }
            n2 = JOptionPane.showOptionDialog(this, string, ResourceUtilities.getUILabel("WARNING_DIALOG_TITLE"), 0, 2, null, null, null);
            if (n2 == 1 || n2 == -1) {
                this.m_backupData.clear();
                return;
            }
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n7 = (Integer)hashtable.get(string);
            n = 0;
            n = n7 == null ? n3 : Math.min(n3, n7);
            object = (Integer)hashtable2.get(string);
            this.m_dataSourcemodel.markAttributeBinned((Integer)object, BinningType.TOPN, n);
            this.m_dataSourcemodel.setNumberOfBins((Integer)object, n);
        }
        this.getTopNBounds(hashtable2);
        this.m_settingsState.invalidate();
    }

    protected void updateNumberOfBins(Number number) {
        this.m_settingsState.setCurrentNumberOfBins(number.intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getTopNBounds(Hashtable hashtable) {
        try {
            block5: {
                try {
                    DiscretizeTopNArray discretizeTopNArray = new DiscretizeTopNArray(this.m_dataSourcemodel, hashtable);
                    ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), discretizeTopNArray, true);
                    discretizeTopNArray.setProgressBar(progressBar);
                    progressBar.start(ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_DESC"));
                    if (discretizeTopNArray.getException() != null) {
                        this.restoreAttrubuteValues(hashtable);
                        break block5;
                    }
                    if (!progressBar.hasUserCancelled()) break block5;
                    this.restoreAttrubuteValues(hashtable);
                }
                catch (Exception exception) {
                    Object var5_6 = null;
                }
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            throw throwable;
        }
    }

    protected void restoreAttrubuteValues(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n = (Integer)hashtable.get(string);
            if (n == null) continue;
            CategoricalBackupData categoricalBackupData = (CategoricalBackupData)this.m_backupData.get(n);
            int n2 = n;
            categoricalBackupData.restoreBackupData(this.m_dataSourcemodel);
        }
    }

    protected class CustomNumberTextField
    extends NumberTextField {
        CustomNumberTextField() {
            this.setLocale(Locale.getDefault());
            this.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    super.keyReleased(keyEvent);
                    if (127 == keyEvent.getKeyCode() || 8 == keyEvent.getKeyCode()) {
                        Number number = CustomNumberTextField.this.getNumber();
                        int n = 0;
                        if (number != null) {
                            n = number.intValue();
                        }
                        Integer n2 = new Integer(n);
                        CustomNumberTextField.this.validateNumber(n2);
                    }
                }
            });
        }

        protected boolean validateNumber(Number number) {
            boolean bl = super.validateNumber(number);
            if (bl && number != null) {
                TopNBinningSetiingsPanel.this.updateNumberOfBins(number);
            }
            return bl;
        }
    }
}

