/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transforms.StratifiedSplitState;
import oracle.dmt.dm4j.wizard.state.transformsteps.StratifiedSplitTargetState;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;
import oracle.dmt.dm4j.wizard.steps.commonsteps.HistogramDialog;

public class StratifiedSplitTargetPanel
extends DM4JStep {
    StratifiedSplitTargetState m_state;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblTargetColumn = new JLabel();
    JComboBox cmbColumns = new JComboBox();
    JLabel lblFiller = new JLabel();
    JButton btnHistogram = new JButton(ResourceUtilities.getUILabel("STRATIFIED_TARGET_HISTOGRAM"));

    public StratifiedSplitTargetPanel(StratifiedSplitTargetState stratifiedSplitTargetState) throws Exception {
        super(stratifiedSplitTargetState);
        this.m_state = stratifiedSplitTargetState;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("STRATIFIED_TARGET_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(1);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        this.lblTargetColumn.setText(ResourceUtilities.getUILabel("STRATIFIED_TARGET_COLUMN"));
        this.lblTargetColumn.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("STRATIFIED_TARGET_COLUMN"));
        this.lblTargetColumn.setLabelFor(this.cmbColumns);
        this.addComponent(this.lblTargetColumn, COL1_LABEL, n, 0);
        this.addFilledComponent(this.cmbColumns, COL_VALUE, n++, 1, 2, 1, 1);
        this.btnHistogram.setMnemonic(ResourceUtilities.getUILabel("STRATIFIED_TARGET_HISTOGRAM").charAt(0));
        this.btnHistogram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StratifiedSplitTargetPanel.this.butHistogram_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.btnHistogram, COL1_CONTROL, n++, 2);
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n, 0, 2, 2, 1);
    }

    protected void processUserInput() {
        if (this.m_state != null) {
            this.m_state.setTargetColumnName((String)this.cmbColumns.getSelectedItem());
        }
    }

    public void init() throws Exception {
        this.loadValues();
    }

    public void reinit() throws Exception {
        this.init();
    }

    protected void loadValues() throws Exception {
        if (this.m_state != null) {
            this.cmbColumns.setModel(new DefaultComboBoxModel(this.m_state.getColumnNames()));
            this.cmbColumns.setEditable(false);
            String string = this.m_state.getTargetColumnName();
            if (string != null && string.length() > 0) {
                this.cmbColumns.setSelectedItem(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void butHistogram_actionPerformed(ActionEvent actionEvent) {
        try {
            try {
                StratifiedSplitState stratifiedSplitState = (StratifiedSplitState)this.m_state.getparentWizardState();
                HistogramDialog histogramDialog = new HistogramDialog(this.getparentWizardState().getDialog(), this.m_state.getparentWizardState(), this.m_state.getLDSDataSource(), stratifiedSplitState.getGraph(), (String)this.cmbColumns.getSelectedItem());
            }
            catch (Exception exception) {
                this.m_state.getparentWizardState().doAbortCancel(exception);
                try {
                    this.m_state.getLDSDataSource().abortCleanUp();
                }
                catch (Exception exception2) {
                }
                Object var5_7 = null;
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            throw throwable;
        }
    }
}

