/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JNumericEditor;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JNumericRenderer;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.AttrValCountsTableModel;
import oracle.dmt.dm4j.wizard.state.transformsteps.CaseCountDataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.StratifiedSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.StratifiedTargetState;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.transformsteps.AdvancedStratifiedSettingsDialog;

public class StratifiedSettingsPanel
extends DM4JStep {
    StratifiedSettingsState m_state;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JScrollPane mscrollPane = new JScrollPane();
    JPanel pnlButtons = new JPanel();
    JPanel advpnlButtons = new JPanel();
    JButton btnRestore = new JButton(ResourceUtilities.getUILabel("STRATIFIED_SETTINGS_RESTORE"));
    JButton btnEqDistribution = new JButton(ResourceUtilities.getUILabel("STRATIFIED_EQUAL_DSTRIBUTION"));
    JTable mtblAttrValCount;
    GriddedPanel pnlTotalNumCases = new GriddedPanel();
    JLabel lblTotalNumCases = new JLabel();
    JLabel lblTotalNumCasesVal = new JLabel();
    GriddedPanel pnlBottomPnl = new GriddedPanel();
    JLabel lblTotalSample = new JLabel();
    JLabel lblTotalSampleVal = new JLabel();
    JLabel lblPercentageOriginal = new JLabel();
    JLabel lblPercentageOriginalVal = new JLabel();
    JButton butAdvStratifSettings = new JButton();
    NumberFormat nf = DM4JNumericFormat.getInstance(true, 2);

    public StratifiedSettingsPanel(StratifiedSettingsState stratifiedSettingsState) throws Exception {
        super(stratifiedSettingsState);
        this.m_state = stratifiedSettingsState;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("STRATIFIED_SETTINGS_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(3);
        this.mlblStepDescription.setMinimumRows(3);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        this.lblTotalNumCases.setText(ResourceUtilities.getUILabel("STRATIFIED_SETTINGS_ATTRVAL_TOTAL_NUMBER_OF_CASES"));
        this.pnlTotalNumCases.addFilledComponent(this.lblTotalNumCases, new Insets(5, 0, 0, 0), 0, 0, 1, 1, 1);
        this.pnlTotalNumCases.addFilledComponent(this.lblTotalNumCasesVal, COL1_CONTROL, 0, 1, 1, 1, 1);
        this.addFilledComponent(this.pnlTotalNumCases, COL2_CONTROL, n++, 0, 1, 1, 1);
        this.btnRestore.setMnemonic(ResourceUtilities.getUILabel("STRATIFIED_SETTINGS_RESTORE").charAt(0));
        this.btnEqDistribution.setMnemonic(ResourceUtilities.getUILabel("STRATIFIED_EQUAL_DSTRIBUTION").charAt(0));
        this.btnRestore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StratifiedSettingsPanel.this.restore_actionPerformed(actionEvent);
            }
        });
        this.btnEqDistribution.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StratifiedSettingsPanel.this.eqdistribution_actionPerformed(actionEvent);
            }
        });
        this.pnlButtons.setLayout(new FlowLayout(2));
        this.pnlButtons.add(this.btnEqDistribution);
        this.pnlButtons.add(this.btnRestore);
        this.addFilledComponent(this.pnlButtons, COL1_CONTROL, n++, 1, 1, 1, 1);
        this.mtblAttrValCount = new JTable(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                super.tableChanged(tableModelEvent);
                AbstractTableModel abstractTableModel = (AbstractTableModel)tableModelEvent.getSource();
                int n = abstractTableModel.getColumnCount();
                if (n > 0) {
                    StratifiedSettingsPanel.this.updateSampleTotalCount();
                }
            }
        };
        this.mtblAttrValCount.setSelectionMode(0);
        this.mscrollPane.getViewport().add((Component)this.mtblAttrValCount, null);
        this.addFilledComponent(this.mscrollPane, COL2_CONTROL, n++, 0, 2, 4, 1);
        n += 4;
        this.lblTotalSample.setText(ResourceUtilities.getUILabel("STRATIFIED_SETTINGS_ATTRVAL_TOTAL_SAMPLE"));
        this.pnlBottomPnl.addFilledComponent(this.lblTotalSample, new Insets(5, 0, 0, 0), 0, 0, 1, 1, 1);
        this.pnlBottomPnl.addFilledComponent(this.lblTotalSampleVal, COL1_CONTROL, 0, 1, 1, 1, 1);
        this.lblPercentageOriginal.setText(ResourceUtilities.getUILabel("STRATIFIED_SETTINGS_ATTRVAL_PERCENTAGE_OTIGINAL"));
        this.pnlBottomPnl.addFilledComponent(this.lblPercentageOriginal, new Insets(5, 0, 0, 0), 1, 0, 1, 1, 1);
        this.pnlBottomPnl.addFilledComponent(this.lblPercentageOriginalVal, COL1_CONTROL, 1, 1, 1, 1, 1);
        this.addFilledComponent(this.pnlBottomPnl, COL2_CONTROL, n++, 0, 1, 1, 1);
        this.butAdvStratifSettings.setText(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_ADVANCED"));
        this.butAdvStratifSettings.setMnemonic(ResourceUtilities.getUIMnemonic("SAMPLE_SETTINGS_ADVANCED"));
        this.butAdvStratifSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StratifiedSettingsPanel.this.butAdvStratifSettings_actionPerformed(actionEvent);
            }
        });
        this.advpnlButtons.setLayout(new FlowLayout(2));
        this.advpnlButtons.add(this.butAdvStratifSettings);
        this.addFilledComponent(this.advpnlButtons, COL1_CONTROL, n, 1, 1, 1, 1);
    }

    public void focusOnErrorField(Vector vector) {
    }

    public void init() throws Exception {
        this.loadValues();
        this.stopCellEditing();
    }

    public void reinit() throws Exception {
        this.init();
    }

    protected void loadValues() throws Exception {
        if (this.m_state != null) {
            AttrValCountsTableModel attrValCountsTableModel = this.m_state.getTableModel();
            if (attrValCountsTableModel != null) {
                this.mtblAttrValCount.setModel(attrValCountsTableModel);
                this.mtblAttrValCount.setDefaultEditor(Long.class, new DM4JNumericEditor(4, true));
                this.mtblAttrValCount.setDefaultRenderer(Long.class, new DM4JNumericRenderer(4));
                this.mtblAttrValCount.setPreferredScrollableViewportSize(new Dimension(500, 70));
                this.updateSampleTotalCount();
            }
            this.mtblAttrValCount.updateUI();
            this.mscrollPane.repaint();
        }
    }

    private void updateSampleTotalCount() {
        StratifiedTargetState stratifiedTargetState = (StratifiedTargetState)this.getparentWizardState().getStep(StepType.SETTING_STEP);
        if (stratifiedTargetState != null && this.lblTotalSampleVal != null) {
            CaseCountDataState caseCountDataState = stratifiedTargetState.getDataState();
            this.lblTotalNumCasesVal.setText(caseCountDataState.getCaseCountString());
            this.lblTotalSampleVal.setText(String.valueOf(stratifiedTargetState.getSampleNumberOfCases()));
            this.lblPercentageOriginalVal.setText(this.nf.format(100.0 * stratifiedTargetState.getSampleNumberOfCases().doubleValue() / (double)caseCountDataState.getCaseCount()) + "%");
        }
    }

    public void clear() throws Exception {
        this.loadValues();
    }

    protected void processUserInput() {
        try {
            if (this.m_state != null) {
                this.stopCellEditing();
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    void stopCellEditing() {
        DefaultCellEditor defaultCellEditor = (DefaultCellEditor)this.mtblAttrValCount.getCellEditor();
        if (defaultCellEditor != null) {
            defaultCellEditor.stopCellEditing();
        }
    }

    void cancelCellEditing() {
        DefaultCellEditor defaultCellEditor = (DefaultCellEditor)this.mtblAttrValCount.getCellEditor();
        if (defaultCellEditor != null) {
            defaultCellEditor.cancelCellEditing();
        }
    }

    private void restore_actionPerformed(ActionEvent actionEvent) {
        String string;
        String string2 = ResourceUtilities.getUILabel("STRATIFIED_SETTINGS_RESTORE_CONFIRMATION");
        int n = JOptionPane.showConfirmDialog(null, string2, string = ResourceUtilities.getUILabel("CONFIRMATION_DIALOG_TITLE"), 0);
        if (n != 0) {
            return;
        }
        this.m_state.restore();
        try {
            this.cancelCellEditing();
            this.m_state.refresh();
            this.mscrollPane.repaint();
            this.updateSampleTotalCount();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void refresh() throws Exception {
        super.refresh();
        this.stopCellEditing();
    }

    private void eqdistribution_actionPerformed(ActionEvent actionEvent) {
        try {
            this.stopCellEditing();
            this.updateSampleTotalCount();
            String string = ResourceUtilities.getUILabel("STRATIFIED_SETTINGS_RESTORE_CONFIRMATION");
            String string2 = ResourceUtilities.getUILabel("CONFIRMATION_DIALOG_TITLE");
            int n = JOptionPane.showConfirmDialog(null, string, string2, 0);
            if (n != 0) {
                return;
            }
            this.m_state.setEqualDistribution();
            this.m_state.refresh();
            this.mscrollPane.repaint();
            this.updateSampleTotalCount();
        }
        catch (Exception exception) {
            this.m_state.getparentWizardState().doAbortCancel(exception);
        }
    }

    protected void butAdvStratifSettings_actionPerformed(ActionEvent actionEvent) {
        try {
            this.stopCellEditing();
            this.updateSampleTotalCount();
            Integer n = this.m_state.getRandomSeed();
            AdvancedStratifiedSettingsDialog advancedStratifiedSettingsDialog = new AdvancedStratifiedSettingsDialog(this.getparentWizardState().getDialog(), this.m_state);
            if (advancedStratifiedSettingsDialog.isCancelled()) {
                this.m_state.setRandomSeed(n);
            }
        }
        catch (Exception exception) {
            this.m_state.getparentWizardState().doAbortCancel(exception);
        }
    }
}

