/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.SplitSettingsState;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;

public class SplitSettingsPanel
extends DM4JStep {
    SplitSettingsState m_state;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JSlider sliderPartition;
    JLabel lblPercentage = new JLabel();
    JLabel lblTotalCaseCountValue = new JLabel();
    JLabel lblTotalCaseCount = new JLabel();
    JLabel lblBuildTable = new JLabel();
    JLabel lblBuildPercentage = new JLabel();
    JLabel lblBuildCount = new JLabel();
    JLabel lblBuildPercentageValue = new JLabel();
    JLabel lblBuildCountValue = new JLabel();
    JLabel lblTestTable = new JLabel();
    JLabel lblTestPercentage = new JLabel();
    JLabel lblTestCount = new JLabel();
    JLabel lblTestPercentageValue = new JLabel();
    JLabel lblTestCountValue = new JLabel();
    JCheckBox ckbxRandomize = new JCheckBox();
    String m_panelDescriptionResourceKey;
    JLabel lblFiller = new JLabel();
    boolean m_enableRandomize;

    public SplitSettingsPanel(SplitSettingsState splitSettingsState) throws Exception {
        this(splitSettingsState, true);
    }

    public SplitSettingsPanel(SplitSettingsState splitSettingsState, boolean bl) throws Exception {
        super(splitSettingsState);
        this.m_state = splitSettingsState;
        this.m_enableRandomize = bl;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("SPLIT_SETTINGS_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 4, 1, 1);
        this.lblTotalCaseCount.setText(ResourceUtilities.getUILabel("SPLIT_SETTINGS_TOTAL_CASE_COUNT"));
        this.addComponent(this.lblTotalCaseCount, COL1_LABEL, n, 0);
        this.addComponent(this.lblTotalCaseCountValue, COL_VALUE, n++, 1);
        this.lblBuildTable.setText(ResourceUtilities.getUILabel("SPLIT_SETTINGS_BUILD_TABLE"));
        this.addComponent(this.lblBuildTable, COL1_LABEL, n, 0);
        this.sliderPartition = new JSlider(0, 100);
        this.sliderPartition.setMajorTickSpacing(10);
        this.sliderPartition.setPaintTicks(true);
        this.sliderPartition.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SplitSettingsPanel.this.slider_actionPerformed(changeEvent);
            }
        });
        this.addFilledComponent(this.sliderPartition, COL_VALUE, n, 1);
        this.lblTestTable.setText(ResourceUtilities.getUILabel("SPLIT_SETTINGS_TEST_TABLE"));
        this.addComponent(this.lblTestTable, COL1_LABEL, n++, 2);
        this.lblBuildCount.setText(ResourceUtilities.getUILabel("COUNT"));
        this.lblBuildCount.setLabelFor(this.lblBuildCountValue);
        this.addComponent(this.lblBuildCount, COL1_INDENTED1_LABEL, n, 0);
        this.addComponent(this.lblBuildCountValue, COL_VALUE, n, 1);
        this.lblTestCount.setText(ResourceUtilities.getUILabel("COUNT"));
        this.lblTestCount.setLabelFor(this.lblTestCountValue);
        this.addComponent(this.lblTestCount, COL2_LABEL, n, 2);
        this.addComponent(this.lblTestCountValue, COL_VALUE, n++, 3);
        this.lblBuildPercentage.setText(ResourceUtilities.getUILabel("PERCENTAGE"));
        this.lblBuildPercentage.setLabelFor(this.lblBuildPercentageValue);
        this.addComponent(this.lblBuildPercentage, COL1_INDENTED1_LABEL, n, 0);
        this.addComponent(this.lblBuildPercentageValue, COL_VALUE, n, 1);
        this.lblTestPercentage.setText(ResourceUtilities.getUILabel("PERCENTAGE"));
        this.lblTestPercentage.setLabelFor(this.lblTestPercentageValue);
        this.addComponent(this.lblTestPercentage, COL2_LABEL, n, 2);
        this.addComponent(this.lblTestPercentageValue, COL_VALUE, n++, 3);
        if (this.m_enableRandomize) {
            this.ckbxRandomize.setText(ResourceUtilities.getUILabel("SPLIT_SETTINGS_RANDOMIZE"));
            this.ckbxRandomize.setMnemonic(ResourceUtilities.getUIMnemonic("SPLIT_SETTINGS_RANDOMIZE"));
            this.addComponent(this.ckbxRandomize, COL1_LABEL, n++, 0, 2, 1);
        }
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n, 0, 4, 2, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void slider_actionPerformed(ChangeEvent changeEvent) {
        try {
            try {
                this.processSliderValue();
                int n = this.m_state.getDataState().getCaseCount();
                int n2 = Integer.parseInt(this.m_state.getBuildTablePercentage());
                int n3 = Integer.parseInt(this.m_state.getTestTablePercentage());
                this.lblBuildPercentageValue.setText(n2 + "");
                this.lblBuildCountValue.setText(n * n2 / 100 + "");
                this.lblTestPercentageValue.setText(n3 + "");
                this.lblTestCountValue.setText(n * n3 / 100 + "");
            }
            catch (Exception exception) {
                this.getparentWizardState().doAbortCancel(exception);
                Object var6_7 = null;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            throw throwable;
        }
    }

    public void focusOnErrorField(Vector vector) {
    }

    public void init() {
        this.loadDefaultValues();
    }

    public void reinit() {
        this.init();
    }

    protected void loadDefaultValues() {
        if (this.m_state != null) {
            int n = this.m_state.getDataState().getCaseCount();
            int n2 = Integer.parseInt(this.m_state.getBuildTablePercentage());
            int n3 = Integer.parseInt(this.m_state.getTestTablePercentage());
            this.lblTotalCaseCountValue.setText(this.m_state.getDataState().getCaseCountString());
            this.lblBuildPercentageValue.setText(n2 + "");
            this.lblBuildCountValue.setText(n * n2 / 100 + "");
            this.lblTestPercentageValue.setText(n3 + "");
            this.lblTestCountValue.setText(n * n3 / 100 + "");
            this.sliderPartition.setValue(n2);
            this.ckbxRandomize.setSelected(this.m_state.getRandomizeBeforeSplit());
        }
    }

    public void clear() {
        this.loadDefaultValues();
    }

    protected void processUserInput() {
        try {
            this.processSliderValue();
            if (this.m_state != null) {
                this.m_state.setRandomizeBeforeSplit(this.ckbxRandomize.isSelected());
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    protected void processSliderValue() {
        try {
            if (this.m_state != null) {
                int n = this.sliderPartition.getValue();
                this.m_state.setBuildTablePercentage(n + "");
                this.m_state.setTestTablePercentage(100 - n + "");
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }
}

