/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.collection.Range;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.OutlierDiscretizeDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.OutlierDataUsageState;
import oracle.dmt.dm4j.wizard.state.transformsteps.OutlierSettingsState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.uicontrols.CustomNumberTextField;
import oracle.dmt.dm4j.wizard.uicontrols.UpdatableTextField;

public class OutlierSigmaSettingsPanel
extends GriddedPanel
implements UpdatableTextField {
    protected static int LOWER_TAIL_PERCENT = 0;
    protected static int UPPER_TAIL_PERCENT = 1;
    protected static int LOWER_TAIL_VALUE = 2;
    protected static int UPPER_TAIL_VALUE = 3;
    protected static int LOWER_TAIL_VALUE_CUSTOM = 4;
    protected static int UPPER_TAIL_VALUE_CUSTOM = 5;
    protected static int SIGMA_CUSTOM = 6;
    protected static int TEXT_FIELD_WIDTH = 15;
    protected MultiLineLabel m_mlblStepDescription = new MultiLineLabel();
    protected DM4JDialog m_parentDialog;
    protected OutlierSettingsState m_state = null;
    protected SpreadTable m_spreadTable;
    protected JRadioButton m_nulls = new JRadioButton();
    protected JRadioButton m_edges = new JRadioButton();
    protected ButtonGroup m_choices = new ButtonGroup();
    public static char PLUS_MINUS = (char)177;
    public static char SIGMA_SIGN = (char)963;
    protected static Insets TEXT_OFFSET = new Insets(5, 0, 0, 0);
    protected static double DEFAULT_PERCENT = 5.0;
    protected static Double ZERO = new Double(0.0);
    protected static double SIGMA_MULTIPLE = 3.0;
    protected EmptyBorder border5 = new EmptyBorder(5, 5, 5, 5);
    protected GriddedPanel m_BottomPanel;
    protected GriddedPanel m_TopPanel;
    protected JLabel lblSigmaValue;
    protected CustomNumberTextField txtSigmaValue;

    public OutlierSigmaSettingsPanel(DM4JDialog dM4JDialog, OutlierSettingsState outlierSettingsState, SpreadTable spreadTable) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = outlierSettingsState;
        this.m_spreadTable = spreadTable;
        this.jbInit();
    }

    protected int createRadioButtons(int n, GriddedPanel griddedPanel, Insets insets) {
        int n2 = n;
        this.m_nulls.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_STDEV_NULLS"));
        this.m_nulls.setSelected(true);
        this.m_choices.add(this.m_nulls);
        this.m_nulls.setMnemonic(ResourceUtilities.getUIMnemonic("OUTLIER_STRATEGY_BY_STDEV_NULLS"));
        griddedPanel.addComponent(this.m_nulls, insets, n2++, 0, 1, 1);
        this.m_edges.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_STDEV_EDGES"));
        this.m_edges.setSelected(false);
        this.m_choices.add(this.m_edges);
        this.m_edges.setMnemonic(ResourceUtilities.getUIMnemonic("OUTLIER_STRATEGY_BY_STDEV_EDGES"));
        griddedPanel.addComponent(this.m_edges, insets, n2++, 0, 1, 1);
        return n2;
    }

    protected void jbInit() throws Exception {
        int n = 0;
        this.m_mlblStepDescription.setText(this.getStepDescription());
        this.m_mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.m_mlblStepDescription.setPreferredRows(3);
        this.m_mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent(this.m_mlblStepDescription, TOP_DESC, n++, 0, 5, 1, 1);
        this.createTopPanel();
        this.addFilledComponent(this.m_TopPanel, COL1_LABEL, 1, 0, 2, 3, 1);
        this.createBottomPanel();
        this.addFilledComponent(this.m_BottomPanel, COL1_LABEL, 5, 0, 2, 2, 1);
        this.addFilledComponent(new JLabel(), TOPLABELITEMINSETS, 8, 0, 5, 1, 1);
        this.addOKHelpCancelListeners();
        this.loadState();
    }

    private void createTopPanel() {
        this.m_TopPanel = new GriddedPanel();
        this.m_TopPanel.setBorder(new CompoundBorder(new TitledBorder(null, ResourceUtilities.getUILabel("OUTLIER_STRATEGY_CUSTOM_CUTOFF_POINTS"), 1, 2), this.border5));
        int n = 0;
        this.lblSigmaValue = new JLabel();
        this.txtSigmaValue = new CustomNumberTextField(this, SIGMA_CUSTOM);
        this.lblSigmaValue.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_SIGMA"));
        this.lblSigmaValue.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("OUTLIER_STRATEGY_BY_SIGMA"));
        this.txtSigmaValue.setColumns(TEXT_FIELD_WIDTH);
        this.txtSigmaValue.setDataType(Double.TYPE);
        this.txtSigmaValue.setSigned(false);
        this.lblSigmaValue.setLabelFor(this.txtSigmaValue);
        this.m_TopPanel.addComponent(this.lblSigmaValue, COL1_INDENTED2_CONTROL, n, 0, 2, 1, 12, 1);
        this.m_TopPanel.addFilledComponent(this.txtSigmaValue, TEXT_OFFSET, n++, 2, 2, 1, 1);
        this.m_TopPanel.addComponent(this.lblSigmaValue, COL1_INDENTED2_CONTROL, n, 0, 2, 1, 12, 1);
        this.m_TopPanel.addFilledComponent(this.txtSigmaValue, TEXT_OFFSET, n++, 2, 2, 1, 1);
    }

    protected void createBottomPanel() {
        this.m_BottomPanel = new GriddedPanel();
        this.m_BottomPanel.setBorder(new CompoundBorder(new TitledBorder(null, ResourceUtilities.getUILabel("OUTLIER_STRATEGY_CUSTOM_REPLACE_WITH"), 1, 2), this.border5));
        int n = 0;
        n = this.createRadioButtons(n, this.m_BottomPanel, COL1_LABEL);
        this.m_BottomPanel.addFilledComponent(new JLabel(), TEXT_OFFSET, n++, 2, 2, 1, 1);
    }

    protected void loadState() throws Exception {
        OutlierDataUsageState outlierDataUsageState = (OutlierDataUsageState)this.m_state.getparentWizardState().getStep(StepType.DATA_USAGE_STEP);
        OutlierDiscretizeDataSource outlierDiscretizeDataSource = outlierDataUsageState.getNumericModel();
        TwoDSelection twoDSelection = this.m_spreadTable.getSelection();
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        Range[] rangeArray = oneDSelection.getRanges();
        Double d = null;
        Boolean bl = null;
        boolean bl2 = true;
        block0: for (int i = 0; i < rangeArray.length; ++i) {
            int n = rangeArray[i].getLowerLimit();
            int n2 = rangeArray[i].getUpperLimit();
            for (int j = n; j <= n2; ++j) {
                OutlierDiscretizeDataSource.OutlierCutoffRange outlierCutoffRange = outlierDiscretizeDataSource.getCutoffRange(j);
                if (outlierCutoffRange == null || !outlierCutoffRange.isStdevTreatment()) {
                    bl2 = false;
                    continue block0;
                }
                if (d == null || bl == null) {
                    d = outlierCutoffRange.getSigmaMultiple();
                    bl = new Boolean(outlierCutoffRange.isEdges());
                    continue;
                }
                if (d != outlierCutoffRange.getSigmaMultiple()) {
                    bl2 = false;
                    continue block0;
                }
                if (bl.booleanValue() == outlierCutoffRange.isEdges()) continue;
                bl2 = false;
                continue block0;
            }
        }
        if (bl2 && d != null) {
            this.txtSigmaValue.setNumber(d);
            this.m_state.setSigmaMultiple(d);
        } else {
            this.txtSigmaValue.setNumber(new Double(SIGMA_MULTIPLE));
            this.m_state.setSigmaMultiple(SIGMA_MULTIPLE);
        }
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        this.m_edges.setSelected(bl == true);
        this.m_nulls.setSelected(bl == false);
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutlierSigmaSettingsPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.validate(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
                if (vector.isEmpty() && this.warningAccepted()) {
                    this.processUserInput();
                    this.m_state.invalidate();
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else if ("cancel" == string) {
            // empty if block
        }
    }

    protected void validate(Vector vector) throws Exception {
        this.m_state.setSigmaValidation();
        this.m_state.validateValues(vector);
    }

    protected void processUserInput() {
        Double d = (Double)this.txtSigmaValue.getNumber();
        this.doSigmaTreatment(d);
    }

    protected void doSigmaTreatment(Double d) {
        if (d == null) {
            return;
        }
        double d2 = d;
        OutlierDataUsageState outlierDataUsageState = (OutlierDataUsageState)this.m_state.getparentWizardState().getStep(StepType.DATA_USAGE_STEP);
        OutlierDiscretizeDataSource outlierDiscretizeDataSource = outlierDataUsageState.getNumericModel();
        TwoDSelection twoDSelection = this.m_spreadTable.getSelection();
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        Range[] rangeArray = oneDSelection.getRanges();
        for (int i = 0; i < rangeArray.length; ++i) {
            int n = rangeArray[i].getLowerLimit();
            int n2 = rangeArray[i].getUpperLimit();
            for (int j = n; j <= n2; ++j) {
                Double d3 = outlierDiscretizeDataSource.getAverage(j);
                Double d4 = outlierDiscretizeDataSource.getSigma(j);
                if (d3 == null || d4 == null) continue;
                StringBuffer stringBuffer = new StringBuffer(this.getOpenBracket() + "AVG ");
                stringBuffer.append(PLUS_MINUS);
                stringBuffer.append(" " + d);
                stringBuffer.append(SIGMA_SIGN + this.getCloseBracket());
                double d5 = d3 - d2 * d4;
                double d6 = d3 + d2 * d4;
                outlierDiscretizeDataSource.setMin(j, d5);
                outlierDiscretizeDataSource.setMax(j, d6);
                outlierDiscretizeDataSource.setCutoffRange(j, stringBuffer.toString(), d5, d6, d2, this.m_edges.isSelected());
            }
        }
    }

    protected String getOpenBracket() {
        return OutlierDiscretizeDataSource.getOpenBracket(this.m_edges.isSelected());
    }

    protected String getCloseBracket() {
        return OutlierDiscretizeDataSource.getCloseBracket(this.m_edges.isSelected());
    }

    protected String getStepDescription() {
        return ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_STDEV_DIALOG_DESCRIPTION");
    }

    public void updateNumber(Number number, int n) {
        if (n == LOWER_TAIL_PERCENT) {
            this.m_state.setLowerTailPercent(number.doubleValue());
        } else if (n == UPPER_TAIL_PERCENT) {
            this.m_state.setUpperTailPercent(number.doubleValue());
        } else if (n == LOWER_TAIL_VALUE) {
            this.m_state.setLowerTailValue(number.doubleValue());
        } else if (n == UPPER_TAIL_VALUE) {
            this.m_state.setUpperTailValue(number.doubleValue());
        } else if (n == UPPER_TAIL_VALUE_CUSTOM) {
            this.m_state.setCustomUpperTailValue(number.doubleValue());
        } else if (n == LOWER_TAIL_VALUE_CUSTOM) {
            this.m_state.setCustomUpperTailValue(number.doubleValue());
        } else if (n == SIGMA_CUSTOM) {
            this.m_state.setSigmaMultiple(number.doubleValue());
        }
    }

    protected void doPercentTreatment(Double d, Double d2) {
        block9: {
            if (d == null) {
                return;
            }
            if (d2 == null) {
                return;
            }
            OutlierDataUsageState outlierDataUsageState = (OutlierDataUsageState)this.m_state.getparentWizardState().getStep(StepType.DATA_USAGE_STEP);
            OutlierDiscretizeDataSource outlierDiscretizeDataSource = outlierDataUsageState.getNumericModel();
            Vector<String> vector = new Vector<String>();
            TwoDSelection twoDSelection = this.m_spreadTable.getSelection();
            OneDSelection oneDSelection = twoDSelection.getRowSelection();
            Range[] rangeArray = oneDSelection.getRanges();
            for (int i = 0; i < rangeArray.length; ++i) {
                int n = rangeArray[i].getLowerLimit();
                int n2 = rangeArray[i].getUpperLimit();
                for (int j = n; j <= n2; ++j) {
                    vector.add(outlierDiscretizeDataSource.getAttributeName(j));
                    outlierDiscretizeDataSource.clearCutoffRange(j);
                }
            }
            if (vector.isEmpty()) {
                return;
            }
            double d3 = d;
            double d4 = d2;
            if (d3 == 0.0 && d4 == 0.0) {
                return;
            }
            OutlierWinsorize outlierWinsorize = null;
            try {
                outlierWinsorize = new OutlierWinsorize(vector.toArray(new String[vector.size()]), d3, d4, this.m_edges.isSelected(), true);
                ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_TITLE"), outlierWinsorize, true);
                outlierWinsorize.setProgressBar(progressBar);
                progressBar.start(ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_TITLE"), ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_DESC"));
                if (outlierWinsorize.getException() != null) {
                    throw outlierWinsorize.getException();
                }
            }
            catch (Exception exception) {
                if (!OutlierDiscretizeDataSource.isDebug()) break block9;
                exception.printStackTrace();
            }
        }
    }

    protected void doValueTreatment(Double d, Double d2) {
        if (d == null) {
            return;
        }
        if (d2 == null) {
            return;
        }
        OutlierDataUsageState outlierDataUsageState = (OutlierDataUsageState)this.m_state.getparentWizardState().getStep(StepType.DATA_USAGE_STEP);
        OutlierDiscretizeDataSource outlierDiscretizeDataSource = outlierDataUsageState.getNumericModel();
        double d3 = d;
        double d4 = d2;
        TwoDSelection twoDSelection = this.m_spreadTable.getSelection();
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        Range[] rangeArray = oneDSelection.getRanges();
        for (int i = 0; i < rangeArray.length; ++i) {
            int n = rangeArray[i].getLowerLimit();
            int n2 = rangeArray[i].getUpperLimit();
            for (int j = n; j <= n2; ++j) {
                outlierDiscretizeDataSource.setMin(j, d3);
                outlierDiscretizeDataSource.setMax(j, d4);
                StringBuffer stringBuffer = new StringBuffer(this.getOpenBracket() + d);
                stringBuffer.append(",");
                stringBuffer.append(" " + d2 + this.getCloseBracket());
                outlierDiscretizeDataSource.setCutoffRange(j, stringBuffer.toString(), d3, d4, this.m_edges.isSelected(), 2);
            }
        }
    }

    protected boolean warningAccepted() {
        int n;
        OutlierDataUsageState outlierDataUsageState = (OutlierDataUsageState)this.m_state.getparentWizardState().getStep(StepType.DATA_USAGE_STEP);
        OutlierDiscretizeDataSource outlierDiscretizeDataSource = outlierDataUsageState.getNumericModel();
        TwoDSelection twoDSelection = this.m_spreadTable.getSelection();
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        Range[] rangeArray = oneDSelection.getRanges();
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < rangeArray.length; ++n) {
            int n2 = rangeArray[n].getLowerLimit();
            int n3 = rangeArray[n].getUpperLimit();
            for (int i = n2; i <= n3; ++i) {
                if (null == outlierDiscretizeDataSource.getCutoffRange(i)) continue;
                vector.add(new Integer(i));
            }
        }
        if (vector.isEmpty()) {
            this.m_state.getparentWizardState().getDM4JWizardDialog().setDialogBusy(false);
            return true;
        }
        n = JOptionPane.showOptionDialog(this, ResourceUtilities.getUILabel("OUTLIER_SETTINGS_RESTORE"), ResourceUtilities.getUILabel("WARNING_DIALOG_TITLE"), 0, 2, null, null, null);
        return n != 1 && n != -1;
    }

    protected class OutlierWinsorize
    extends LongRunningProcess
    implements Cancelable {
        private boolean m_bPercent;
        private boolean m_canceled = false;
        private String[] m_columnNames;
        private double m_lowerTail;
        private double m_upperTail;
        private boolean m_bEdges;

        public OutlierWinsorize(String[] stringArray, double d, double d2, boolean bl, boolean bl2) {
            this.m_columnNames = stringArray;
            this.m_lowerTail = d;
            this.m_upperTail = d2;
            this.m_bEdges = bl;
            this.m_bPercent = bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    OutlierDataUsageState outlierDataUsageState = (OutlierDataUsageState)OutlierSigmaSettingsPanel.this.m_state.getparentWizardState().getStep(StepType.DATA_USAGE_STEP);
                    OutlierDiscretizeDataSource outlierDiscretizeDataSource = outlierDataUsageState.getNumericModel();
                    if (this.m_bPercent) {
                        outlierDiscretizeDataSource.setOutlierPercent(this.m_columnNames, this.m_lowerTail, this.m_upperTail, this.m_bEdges);
                    }
                    this.getProgressBar().setDoneStatus();
                }
                catch (Exception exception) {
                    this.setException(exception);
                    this.getProgressBar().setDoneStatus();
                    Object var4_5 = null;
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                throw throwable;
            }
        }

        public boolean isCancelled() {
            return this.m_canceled;
        }

        public void cancel() {
            this.m_canceled = true;
        }
    }
}

