/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.collection.Range;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.datasources.OutlierDiscretizeDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.OutlierDataUsageState;
import oracle.dmt.dm4j.wizard.state.transformsteps.OutlierSettingsState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.transformsteps.OutlierSigmaSettingsPanel;
import oracle.dmt.dm4j.wizard.uicontrols.CustomNumberTextField;

public class OutlierPercentSettingsPanel
extends OutlierSigmaSettingsPanel {
    protected JLabel lblLowerPercent;
    protected CustomNumberTextField txtLowerPercent;
    protected JLabel lblUpperPercent;
    protected CustomNumberTextField txtUpperPercent;

    public OutlierPercentSettingsPanel(DM4JDialog dM4JDialog, OutlierSettingsState outlierSettingsState, SpreadTable spreadTable) throws Exception {
        super(dM4JDialog, outlierSettingsState, spreadTable);
    }

    protected String getStepDescription() {
        return ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_PERCENT_DIALOG_DESCRIPTION");
    }

    protected void jbInit() throws Exception {
        boolean bl = false;
        this.m_mlblStepDescription.setText(this.getStepDescription());
        this.m_mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.m_mlblStepDescription.setPreferredRows(3);
        this.m_mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent(this.m_mlblStepDescription, TOP_DESC, 0, 0, 4, 1, 1);
        this.createTopPanel();
        this.addFilledComponent(this.m_TopPanel, COL1_LABEL, 1, 0, 2, 3, 1);
        this.createBottomPanel();
        this.addFilledComponent(this.m_BottomPanel, COL1_LABEL, 5, 0, 2, 2, 1);
        this.addFilledComponent(new JLabel(), TOPLABELITEMINSETS, 8, 0, 5, 1, 1);
        this.addOKHelpCancelListeners();
        this.loadState();
    }

    private void createTopPanel() {
        this.m_TopPanel = new GriddedPanel();
        this.m_TopPanel.setBorder(new CompoundBorder(new TitledBorder(null, ResourceUtilities.getUILabel("OUTLIER_STRATEGY_CUSTOM_CUTOFF_POINTS"), 1, 2), this.border5));
        int n = 0;
        this.lblLowerPercent = new JLabel();
        this.txtLowerPercent = new CustomNumberTextField(this, LOWER_TAIL_PERCENT);
        this.lblLowerPercent.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_PERCENT_LOWER_TAIL"));
        this.lblLowerPercent.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("OUTLIER_STRATEGY_BY_PERCENT_LOWER_TAIL"));
        this.txtLowerPercent.setColumns(TEXT_FIELD_WIDTH);
        this.txtLowerPercent.setDataType(Double.TYPE);
        this.txtLowerPercent.setSigned(false);
        this.lblLowerPercent.setLabelFor(this.txtLowerPercent);
        this.m_TopPanel.addComponent(this.lblLowerPercent, COL1_INDENTED2_CONTROL, n, 0, 2, 1, 12, 1);
        this.m_TopPanel.addFilledComponent(this.txtLowerPercent, TEXT_OFFSET, n++, 2, 2, 1, 1);
        this.lblUpperPercent = new JLabel();
        this.txtUpperPercent = new CustomNumberTextField(this, UPPER_TAIL_PERCENT);
        this.lblUpperPercent.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_PERCENT_UPPER_TAIL"));
        this.lblUpperPercent.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("OUTLIER_STRATEGY_BY_PERCENT_UPPER_TAIL"));
        this.txtUpperPercent.setColumns(TEXT_FIELD_WIDTH);
        this.txtUpperPercent.setDataType(Double.TYPE);
        this.txtUpperPercent.setSigned(false);
        this.lblUpperPercent.setLabelFor(this.txtUpperPercent);
        this.m_TopPanel.addComponent(this.lblUpperPercent, COL1_INDENTED2_CONTROL, n, 0, 2, 1, 12, 1);
        this.m_TopPanel.addFilledComponent(this.txtUpperPercent, TEXT_OFFSET, n++, 2, 2, 1, 1);
    }

    protected void validate(Vector vector) throws Exception {
        this.m_state.setPercentValidation();
        this.m_state.validate(vector);
    }

    protected void processUserInput() {
        this.doPercentTreatment((Double)this.txtLowerPercent.getNumber(), (Double)this.txtUpperPercent.getNumber());
    }

    protected void loadState() throws Exception {
        OutlierDataUsageState outlierDataUsageState = (OutlierDataUsageState)this.m_state.getparentWizardState().getStep(StepType.DATA_USAGE_STEP);
        OutlierDiscretizeDataSource outlierDiscretizeDataSource = outlierDataUsageState.getNumericModel();
        TwoDSelection twoDSelection = this.m_spreadTable.getSelection();
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        Range[] rangeArray = oneDSelection.getRanges();
        Boolean bl = null;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        Double d = null;
        Double d2 = null;
        block0: for (int i = 0; i < rangeArray.length; ++i) {
            int n = rangeArray[i].getLowerLimit();
            int n2 = rangeArray[i].getUpperLimit();
            for (int j = n; j <= n2; ++j) {
                OutlierDiscretizeDataSource.OutlierCutoffRange outlierCutoffRange = outlierDiscretizeDataSource.getCutoffRange(j);
                if (outlierCutoffRange == null || !outlierCutoffRange.isPercentTreatment()) {
                    bl4 = false;
                    bl2 = false;
                    bl3 = false;
                    continue block0;
                }
                if (d == null && d2 == null && bl == null) {
                    d = outlierCutoffRange.getLowerTailPercent();
                    d2 = outlierCutoffRange.getUpperTailPercent();
                    bl = new Boolean(outlierCutoffRange.isEdges());
                } else {
                    if (d.doubleValue() != outlierCutoffRange.getLowerTailPercent().doubleValue()) {
                        bl3 = false;
                    }
                    if (d2.doubleValue() != outlierCutoffRange.getUpperTailPercent().doubleValue()) {
                        bl3 = false;
                    }
                    if (bl.booleanValue() != outlierCutoffRange.isEdges()) {
                        bl4 = false;
                    }
                }
                if (bl3 && bl4) continue;
                bl4 = false;
                bl2 = false;
                bl3 = false;
                continue block0;
            }
        }
        if (bl2 && bl3 && bl4) {
            this.txtLowerPercent.setNumber(d);
            this.txtUpperPercent.setNumber(d2);
            this.m_state.setLowerTailPercent(d);
            this.m_state.setUpperTailPercent(d2);
            this.m_edges.setSelected(bl == true);
            this.m_nulls.setSelected(bl == false);
        } else {
            this.m_state.setLowerTailPercent(DEFAULT_PERCENT);
            this.m_state.setUpperTailPercent(DEFAULT_PERCENT);
            this.txtLowerPercent.setNumber(new Double(DEFAULT_PERCENT));
            this.txtUpperPercent.setNumber(new Double(DEFAULT_PERCENT));
            this.m_edges.setSelected(false);
            this.m_nulls.setSelected(true);
        }
    }
}

