/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.collection.Range;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.datasources.OutlierDiscretizeDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.OutlierDataUsageState;
import oracle.dmt.dm4j.wizard.state.transformsteps.OutlierSettingsState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.transformsteps.OutlierSigmaSettingsPanel;
import oracle.dmt.dm4j.wizard.uicontrols.CustomNumberTextField;

public class OutlierCustomSettingsPanel
extends OutlierSigmaSettingsPanel {
    protected GriddedPanel m_TopPanel;
    protected JLabel lblLowerValue;
    protected JLabel lblUpperValue;
    protected CustomNumberTextField txtLowerValue;
    protected CustomNumberTextField txtUpperValue;
    protected JLabel lblLowerPercent;
    protected JLabel lblUpperPercent;
    protected CustomNumberTextField txtLowerPercent;
    protected CustomNumberTextField txtUpperPercent;
    protected JRadioButton m_chkBoxStdev;
    protected JRadioButton m_chkBoxPercent;
    protected JRadioButton m_chkBoxValue;
    protected ButtonGroup m_TopPanelGroup;

    public OutlierCustomSettingsPanel(DM4JDialog dM4JDialog, OutlierSettingsState outlierSettingsState, SpreadTable spreadTable) throws Exception {
        super(dM4JDialog, outlierSettingsState, spreadTable);
    }

    protected String getStepDescription() {
        return ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_VALUE_DIALOG_DESCRIPTION");
    }

    protected void jbInit() throws Exception {
        boolean bl = false;
        this.m_mlblStepDescription.setText(this.getStepDescription());
        this.m_mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.m_mlblStepDescription.setPreferredRows(3);
        this.m_mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent(this.m_mlblStepDescription, TOP_DESC, 0, 0, 4, 1, 1);
        this.createTopPanel();
        this.addFilledComponent(this.m_TopPanel, COL1_LABEL, 1, 0, 2, 3, 1);
        this.createBottomPanel();
        this.addFilledComponent(this.m_BottomPanel, COL1_LABEL, 5, 0, 2, 2, 1);
        this.addFilledComponent(new JLabel(), TOPLABELITEMINSETS, 8, 0, 5, 1, 1);
        this.addOKHelpCancelListeners();
        this.m_chkBoxStdev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutlierCustomSettingsPanel.this.enableStdev();
                OutlierCustomSettingsPanel.this.m_state.setSigmaValidation();
            }
        });
        this.m_chkBoxValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutlierCustomSettingsPanel.this.selectValue();
                OutlierCustomSettingsPanel.this.m_state.setValueValidation();
            }
        });
        this.m_chkBoxPercent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutlierCustomSettingsPanel.this.enablePercent();
                OutlierCustomSettingsPanel.this.m_state.setPercentValidation();
            }
        });
        this.loadState();
    }

    private void createTopPanel() {
        this.m_TopPanel = new GriddedPanel();
        this.m_TopPanel.setBorder(new CompoundBorder(new TitledBorder(null, ResourceUtilities.getUILabel("OUTLIER_STRATEGY_CUSTOM_CUTOFF_POINTS"), 1, 2), this.border5));
        int n = 0;
        this.m_chkBoxStdev = new JRadioButton();
        this.m_chkBoxPercent = new JRadioButton();
        this.m_chkBoxValue = new JRadioButton();
        this.m_TopPanelGroup = new ButtonGroup();
        this.m_chkBoxStdev.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_STDEV"));
        this.m_chkBoxStdev.setSelected(true);
        this.m_state.setSigmaValidation();
        this.m_TopPanelGroup.add(this.m_chkBoxStdev);
        this.m_chkBoxStdev.setMnemonic(ResourceUtilities.getUIMnemonic("OUTLIER_STRATEGY_BY_STDEV"));
        this.m_TopPanel.addComponent(this.m_chkBoxStdev, COL1_LABEL, n++, 0, 1, 1);
        this.lblSigmaValue = new JLabel();
        this.txtSigmaValue = new CustomNumberTextField(this, SIGMA_CUSTOM);
        this.lblSigmaValue.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_SIGMA"));
        this.txtSigmaValue.setColumns(TEXT_FIELD_WIDTH);
        this.txtSigmaValue.setDataType(Double.TYPE);
        this.txtSigmaValue.setSigned(false);
        this.lblSigmaValue.setLabelFor(this.txtSigmaValue);
        this.m_TopPanel.addComponent(this.lblSigmaValue, COL1_INDENTED2_CONTROL, n, 0, 2, 1, 12, 1);
        this.m_TopPanel.addFilledComponent(this.txtSigmaValue, TEXT_OFFSET, n++, 2, 2, 1, 1);
        this.m_chkBoxPercent.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_PERCENT"));
        this.m_chkBoxPercent.setSelected(false);
        this.m_TopPanelGroup.add(this.m_chkBoxPercent);
        this.m_chkBoxPercent.setMnemonic(ResourceUtilities.getUIMnemonic("OUTLIER_STRATEGY_BY_PERCENT"));
        this.m_TopPanel.addComponent(this.m_chkBoxPercent, COL1_LABEL, n++, 0, 1, 1);
        this.lblLowerPercent = new JLabel();
        this.txtLowerPercent = new CustomNumberTextField(this, LOWER_TAIL_PERCENT);
        this.lblLowerPercent.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_PERCENT_LOWER_TAIL"));
        this.txtLowerPercent.setColumns(TEXT_FIELD_WIDTH);
        this.txtLowerPercent.setDataType(Double.TYPE);
        this.txtLowerPercent.setSigned(false);
        this.lblLowerPercent.setLabelFor(this.txtLowerPercent);
        this.m_TopPanel.addComponent(this.lblLowerPercent, COL1_INDENTED2_CONTROL, n, 0, 2, 1, 12, 1);
        this.m_TopPanel.addFilledComponent(this.txtLowerPercent, TEXT_OFFSET, n++, 2, 2, 1, 1);
        this.lblUpperPercent = new JLabel();
        this.txtUpperPercent = new CustomNumberTextField(this, UPPER_TAIL_PERCENT);
        this.lblUpperPercent.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_PERCENT_UPPER_TAIL"));
        this.txtUpperPercent.setColumns(TEXT_FIELD_WIDTH);
        this.txtUpperPercent.setDataType(Double.TYPE);
        this.txtUpperPercent.setSigned(false);
        this.lblUpperPercent.setLabelFor(this.txtUpperPercent);
        this.m_TopPanel.addComponent(this.lblUpperPercent, COL1_INDENTED2_CONTROL, n, 0, 2, 1, 12, 1);
        this.m_TopPanel.addFilledComponent(this.txtUpperPercent, TEXT_OFFSET, n++, 2, 2, 1, 1);
        this.m_chkBoxValue.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_VALUE"));
        this.m_chkBoxValue.setSelected(false);
        this.m_TopPanelGroup.add(this.m_chkBoxValue);
        this.m_chkBoxValue.setMnemonic(ResourceUtilities.getUIMnemonic("OUTLIER_STRATEGY_BY_VALUE"));
        this.m_TopPanel.addComponent(this.m_chkBoxValue, COL1_LABEL, n++, 0, 1, 1);
        this.lblLowerValue = new JLabel();
        this.txtLowerValue = new CustomNumberTextField(this, LOWER_TAIL_VALUE);
        this.lblLowerValue.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_VALUE_LOWER_TAIL"));
        this.txtLowerValue.setColumns(TEXT_FIELD_WIDTH);
        this.txtLowerValue.setDataType(Double.TYPE);
        this.lblLowerValue.setLabelFor(this.txtLowerValue);
        this.m_TopPanel.addComponent(this.lblLowerValue, COL1_INDENTED2_CONTROL, n, 0, 2, 1, 12, 1);
        this.m_TopPanel.addFilledComponent(this.txtLowerValue, TEXT_OFFSET, n++, 2, 2, 1, 1);
        this.lblUpperValue = new JLabel();
        this.txtUpperValue = new CustomNumberTextField(this, UPPER_TAIL_VALUE);
        this.lblUpperValue.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_VALUE_UPPER_TAIL"));
        this.txtUpperValue.setColumns(TEXT_FIELD_WIDTH);
        this.txtUpperValue.setDataType(Double.TYPE);
        this.lblUpperValue.setLabelFor(this.txtUpperValue);
        this.m_TopPanel.addComponent(this.lblUpperValue, COL1_INDENTED2_CONTROL, n, 0, 2, 1, 12, 1);
        this.m_TopPanel.addFilledComponent(this.txtUpperValue, TEXT_OFFSET, n++, 2, 2, 1, 1);
    }

    protected void loadState() throws Exception {
        OutlierDataUsageState outlierDataUsageState = (OutlierDataUsageState)this.m_state.getparentWizardState().getStep(StepType.DATA_USAGE_STEP);
        OutlierDiscretizeDataSource outlierDiscretizeDataSource = outlierDataUsageState.getNumericModel();
        TwoDSelection twoDSelection = this.m_spreadTable.getSelection();
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        Range[] rangeArray = oneDSelection.getRanges();
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < rangeArray.length; ++i) {
            int n = rangeArray[i].getLowerLimit();
            int n2 = rangeArray[i].getUpperLimit();
            for (int j = n; j <= n2; ++j) {
                vector.add(new Integer(j));
            }
        }
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = false;
        if (vector.size() == 1) {
            double d3 = SIGMA_MULTIPLE * this.getPrimitiveFromDouble(outlierDiscretizeDataSource.getSigma((Integer)vector.elementAt(0)));
            double d4 = this.getPrimitiveFromDouble(outlierDiscretizeDataSource.getAverage((Integer)vector.elementAt(0)));
            d = d4 + d3;
            d2 = d4 - d3;
            bl = true;
        }
        if (outlierDiscretizeDataSource.isSameStrategy(vector.toArray(new Integer[vector.size()]))) {
            OutlierDiscretizeDataSource.OutlierCutoffRange outlierCutoffRange = outlierDiscretizeDataSource.getCutoffRange((Integer)vector.elementAt(0));
            if (outlierCutoffRange.isStdevTreatment()) {
                this.selectStdev(outlierCutoffRange, d, d2, bl);
            } else if (outlierCutoffRange.isPercentTreatment()) {
                this.selectPercent(outlierCutoffRange, d, d2, bl);
            } else if (outlierCutoffRange.isValueTreatment()) {
                this.selectValue(outlierCutoffRange, d, d2, bl);
            }
        } else {
            this.selectStdev(null, d, d2, bl);
        }
    }

    private double getPrimitiveFromDouble(Double d) {
        return d != null ? d : 0.0;
    }

    private void selectStdev(OutlierDiscretizeDataSource.OutlierCutoffRange outlierCutoffRange, double d, double d2, boolean bl) {
        Double d3;
        Double d4;
        Double d5;
        Double d6;
        Double d7 = !bl ? ZERO : (d6 = outlierCutoffRange == null ? new Double(d2) : outlierCutoffRange.getLowerValue());
        Double d8 = !bl ? ZERO : (d5 = outlierCutoffRange == null ? new Double(d) : outlierCutoffRange.getUpperValue());
        Double d9 = !bl ? ZERO : (d4 = outlierCutoffRange == null ? new Double(DEFAULT_PERCENT) : outlierCutoffRange.getLowerTailPercent());
        Double d10 = !bl ? ZERO : (d3 = outlierCutoffRange == null ? new Double(DEFAULT_PERCENT) : outlierCutoffRange.getUpperTailPercent());
        Double d11 = !bl ? ZERO : (outlierCutoffRange == null ? new Double(SIGMA_MULTIPLE) : outlierCutoffRange.getSigmaMultiple());
        this.txtSigmaValue.setNumber(d11 != null ? d11 : ZERO);
        this.txtLowerValue.setNumber(d6);
        this.txtUpperValue.setNumber(d5);
        this.txtLowerPercent.setNumber(d4 != null ? d4 : ZERO);
        this.txtUpperPercent.setNumber(d3 != null ? d3 : ZERO);
        boolean bl2 = outlierCutoffRange != null ? outlierCutoffRange.isEdges() : false;
        this.m_nulls.setSelected(!bl2);
        this.m_edges.setSelected(bl2);
        this.enableStdev();
    }

    private void selectPercent(OutlierDiscretizeDataSource.OutlierCutoffRange outlierCutoffRange, double d, double d2, boolean bl) {
        Double d3;
        Double d4;
        Double d5 = !bl ? ZERO : (d4 = outlierCutoffRange == null ? new Double(d2) : outlierCutoffRange.getLowerValue());
        Double d6 = !bl ? ZERO : (outlierCutoffRange == null ? new Double(d) : outlierCutoffRange.getUpperValue());
        Double d7 = outlierCutoffRange == null ? new Double(DEFAULT_PERCENT) : outlierCutoffRange.getLowerTailPercent();
        Double d8 = d3 = outlierCutoffRange == null ? new Double(DEFAULT_PERCENT) : outlierCutoffRange.getUpperTailPercent();
        Double d9 = !bl ? ZERO : (outlierCutoffRange == null ? new Double(SIGMA_MULTIPLE) : outlierCutoffRange.getSigmaMultiple());
        this.txtSigmaValue.setNumber(d9 != null ? d9 : ZERO);
        this.txtLowerValue.setNumber(d4);
        this.txtUpperValue.setNumber(d6);
        this.txtLowerPercent.setNumber(d7 != null ? d7 : ZERO);
        this.txtUpperPercent.setNumber(d3 != null ? d3 : ZERO);
        boolean bl2 = outlierCutoffRange != null ? outlierCutoffRange.isEdges() : false;
        this.m_nulls.setSelected(!bl2);
        this.m_edges.setSelected(bl2);
        this.enablePercent();
    }

    private void selectValue(OutlierDiscretizeDataSource.OutlierCutoffRange outlierCutoffRange, double d, double d2, boolean bl) {
        Double d3;
        Double d4;
        Double d5;
        Double d6 = outlierCutoffRange == null ? new Double(d2) : outlierCutoffRange.getLowerValue();
        Double d7 = d5 = outlierCutoffRange == null ? new Double(d) : outlierCutoffRange.getUpperValue();
        Double d8 = !bl ? ZERO : (d4 = outlierCutoffRange == null ? new Double(DEFAULT_PERCENT) : outlierCutoffRange.getLowerTailPercent());
        Double d9 = !bl ? ZERO : (d3 = outlierCutoffRange == null ? new Double(DEFAULT_PERCENT) : outlierCutoffRange.getUpperTailPercent());
        Double d10 = !bl ? ZERO : (outlierCutoffRange == null ? new Double(SIGMA_MULTIPLE) : outlierCutoffRange.getSigmaMultiple());
        this.txtSigmaValue.setNumber(d10 != null ? d10 : ZERO);
        this.txtLowerValue.setNumber(d6);
        this.txtUpperValue.setNumber(d5);
        this.txtLowerPercent.setNumber(d4 != null ? d4 : ZERO);
        this.txtUpperPercent.setNumber(d3 != null ? d3 : ZERO);
        boolean bl2 = outlierCutoffRange != null ? outlierCutoffRange.isEdges() : false;
        this.m_nulls.setSelected(!bl2);
        this.m_edges.setSelected(bl2);
        this.selectValue();
    }

    private void enableStdev() {
        this.m_chkBoxStdev.setSelected(true);
        this.m_chkBoxPercent.setSelected(false);
        this.m_chkBoxValue.setSelected(false);
        this.txtSigmaValue.setEnabled(true);
        this.txtLowerValue.setEnabled(false);
        this.txtUpperValue.setEnabled(false);
        this.txtLowerPercent.setEnabled(false);
        this.txtUpperPercent.setEnabled(false);
    }

    private void enablePercent() {
        this.m_chkBoxStdev.setSelected(false);
        this.m_chkBoxPercent.setSelected(true);
        this.m_chkBoxValue.setSelected(false);
        this.txtSigmaValue.setEnabled(false);
        this.txtLowerValue.setEnabled(false);
        this.txtUpperValue.setEnabled(false);
        this.txtLowerPercent.setEnabled(true);
        this.txtUpperPercent.setEnabled(true);
    }

    private void selectValue() {
        this.m_chkBoxStdev.setSelected(false);
        this.m_chkBoxPercent.setSelected(false);
        this.m_chkBoxValue.setSelected(true);
        this.txtSigmaValue.setEnabled(false);
        this.txtLowerValue.setEnabled(true);
        this.txtUpperValue.setEnabled(true);
        this.txtLowerPercent.setEnabled(false);
        this.txtUpperPercent.setEnabled(false);
    }

    protected void validate(Vector vector) throws Exception {
        this.m_state.validate(vector);
    }

    protected void processUserInput() {
        if (this.m_chkBoxPercent.isSelected()) {
            this.doPercentTreatment((Double)this.txtLowerPercent.getNumber(), (Double)this.txtUpperPercent.getNumber());
            return;
        }
        if (this.m_chkBoxValue.isSelected()) {
            this.doValueTreatment((Double)this.txtLowerValue.getNumber(), (Double)this.txtUpperValue.getNumber());
            return;
        }
        if (this.m_chkBoxStdev.isSelected()) {
            this.doSigmaTreatment((Double)this.txtSigmaValue.getNumber());
            return;
        }
    }
}

