/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.steps.transformsteps.WinsorizeBinningSettingsPanel;

public class GenerateBinsPanel
extends WinsorizeBinningSettingsPanel {
    JRadioButton optEqualWidth;
    JRadioButton optWinsorize;
    ButtonGroup groupBinning;
    JPanel pnlBinningStrategy;
    int m_nSelectedRow;

    public GenerateBinsPanel(DM4JDialog dM4JDialog, WizardState wizardState, SpreadTable spreadTable) throws Exception {
        super(dM4JDialog, wizardState, spreadTable);
    }

    protected void jbInit() throws Exception {
        this.pnlTailPercent = new JPanel(new GridLayout(1, 2, 5, 0));
        this.lblTailPercent = new JLabel();
        this.txtTailPercent = new WinsorizeBinningSettingsPanel.TailPercentTextField(this);
        this.optEqualWidth = new JRadioButton();
        this.optWinsorize = new JRadioButton();
        this.groupBinning = new ButtonGroup();
        this.pnlBinningStrategy = new JPanel(new GridLayout(1, 3));
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_DIALOG_DESCRIPTION"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 5, 1, 1);
        this.optEqualWidth.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_EQUAL_WIDTH_OPTION"));
        this.groupBinning.add(this.optEqualWidth);
        this.optEqualWidth.setMnemonic(ResourceUtilities.getUIMnemonic("BINNING_STRATEGY_EQUAL_WIDTH_OPTION"));
        this.optEqualWidth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenerateBinsPanel.this.optBin_actionPerformed(actionEvent);
            }
        });
        this.optWinsorize.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_WINSORIZE_OPTION"));
        this.groupBinning.add(this.optWinsorize);
        this.optWinsorize.setMnemonic(ResourceUtilities.getUIMnemonic("BINNING_STRATEGY_WINSORIZE_OPTION"));
        this.optWinsorize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenerateBinsPanel.this.optBin_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.pnlBinningStrategy, COL1_INDENTED1_LABEL, n++, 0, 5, 1, 1);
        this.pnlBinningStrategy.add(this.optEqualWidth);
        this.pnlBinningStrategy.add(this.optWinsorize);
        this.addFilledComponent(this.pnlNumberOfBins, COL1_INDENTED1_LABEL, n++, 0, 1, 1, 1);
        this.lblNumberOfBins.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_NUMBER_OF_BINS_SPECIFY"));
        this.lblNumberOfBins.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("BINNING_STRATEGY_NUMBER_OF_BINS_SPECIFY"));
        this.txtNumberOfBins.setDecimal(true);
        this.txtNumberOfBins.setColumns(10);
        this.lblNumberOfBins.setLabelFor(this.txtNumberOfBins);
        this.pnlNumberOfBins.add(this.lblNumberOfBins);
        this.pnlNumberOfBins.add(this.txtNumberOfBins);
        this.addFilledComponent(this.pnlTailPercent, COL1_INDENTED1_LABEL, n, 0, 1, 1, 1);
        this.lblTailPercent.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_TAIL_PERCENT"));
        this.txtTailPercent.setDecimal(true);
        this.txtTailPercent.setColumns(10);
        this.lblTailPercent.setLabelFor(this.txtTailPercent);
        this.pnlTailPercent.add(this.lblTailPercent);
        this.pnlTailPercent.add(this.txtTailPercent);
        this.addOKHelpCancelListeners();
        this.loadState();
    }

    protected void loadState() throws Exception {
        super.loadState();
        this.m_nSelectedRow = this.m_range[0].getLowerLimit();
        Double d = this.m_dataSourcemodel.getTailPercent(this.m_nSelectedRow);
        if (d != null && d > 0.0) {
            this.optWinsorize.setSelected(true);
        } else {
            this.optEqualWidth.setSelected(true);
            this.txtTailPercent.setEnabled(false);
        }
    }

    private void optBin_actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        if (this.optEqualWidth.isSelected()) {
            this.txtTailPercent.setEnabled(false);
            this.txtTailPercent.setText("0.0");
        } else if (this.optWinsorize.isSelected()) {
            this.txtTailPercent.setEnabled(true);
        }
    }

    private void setUIComponentsForEqualWidth() {
        this.txtTailPercent.setEnabled(false);
        this.txtTailPercent.setText("0.0");
    }

    private void setUIComponentsForWinsorize() {
        this.txtTailPercent.setEnabled(true);
    }

    protected void processUserInput() {
        int n = this.m_settingsState.getCurrentNumberOfBins();
        Integer n2 = this.m_dataSourcemodel.getNumberOfBins(this.m_nSelectedRow);
        double d = this.m_settingsState.getCurrentTailPercent();
        Double d2 = this.m_dataSourcemodel.getTailPercent(this.m_nSelectedRow);
        if (n2 != null && n2 == n && d2 != null && d2 == d) {
            this.m_settingsState.setRecalculate(false);
            return;
        }
        this.m_dataSourcemodel.setNumberOfBins(this.m_nSelectedRow, n);
        this.m_dataSourcemodel.setTailPercent(this.m_nSelectedRow, d);
        this.m_settingsState.setRecalculate(true);
        if (this.optEqualWidth.isSelected()) {
            this.m_dataSourcemodel.setEqualWidthBinning(this.m_nSelectedRow, n);
        } else if (this.optWinsorize.isSelected()) {
            this.m_dataSourcemodel.setWinsorizeBinning(this.m_nSelectedRow, n);
        }
    }
}

