/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.steps.transformsteps.EqualBinningSettingsPanel;

public class GenerateBinBoundsPanel
extends EqualBinningSettingsPanel {
    private JRadioButton optEqualWidth;
    private JRadioButton optQuantile;
    private ButtonGroup groupBinning;
    private JPanel pnlBinningStrategy;
    private int m_nSelectedRow;

    public GenerateBinBoundsPanel(DM4JDialog dM4JDialog, WizardState wizardState, SpreadTable spreadTable) throws Exception {
        super(dM4JDialog, wizardState, spreadTable);
    }

    protected void jbInit() throws Exception {
        this.optEqualWidth = new JRadioButton();
        this.optQuantile = new JRadioButton();
        this.groupBinning = new ButtonGroup();
        this.pnlBinningStrategy = new JPanel(new GridLayout(1, 3));
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_DIALOG_DESCRIPTION"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 5, 1, 1);
        this.optEqualWidth.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_EQUAL_WIDTH_OPTION"));
        this.groupBinning.add(this.optEqualWidth);
        this.optEqualWidth.setMnemonic(ResourceUtilities.getUIMnemonic("BINNING_STRATEGY_EQUAL_WIDTH_OPTION"));
        this.optQuantile.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_QTILE_BINNING_OPTION"));
        this.groupBinning.add(this.optQuantile);
        this.optQuantile.setMnemonic(ResourceUtilities.getUIMnemonic("BINNING_STRATEGY_QTILE_BINNING_OPTION"));
        this.addFilledComponent(this.pnlBinningStrategy, COL1_INDENTED1_LABEL, n++, 0, 5, 1, 1);
        this.pnlBinningStrategy.add(this.optEqualWidth);
        this.pnlBinningStrategy.add(this.optQuantile);
        this.addFilledComponent(this.pnlNumberOfBins, COL1_INDENTED1_LABEL, n++, 0, 1, 1, 1);
        this.lblNumberOfBins.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_NUMBER_OF_BINS_SPECIFY"));
        this.lblNumberOfBins.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("BINNING_STRATEGY_NUMBER_OF_BINS_SPECIFY"));
        this.txtNumberOfBins.setDecimal(true);
        this.txtNumberOfBins.setColumns(10);
        this.lblNumberOfBins.setLabelFor(this.txtNumberOfBins);
        this.pnlNumberOfBins.add(this.lblNumberOfBins);
        this.pnlNumberOfBins.add(this.txtNumberOfBins);
        this.addOKHelpCancelListeners();
        this.loadState();
    }

    protected void loadState() throws Exception {
        super.loadState();
        this.m_nSelectedRow = this.m_range[0].getLowerLimit();
        this.optEqualWidth.setSelected(!this.m_settingsState.isQtileBinning());
        this.optQuantile.setSelected(this.m_settingsState.isQtileBinning());
    }

    protected void processUserInput() {
        int n = this.m_settingsState.getCurrentNumberOfBins();
        Integer n2 = this.m_dataSourcemodel.getNumberOfBins(this.m_nSelectedRow);
        if (n2 != null && n2 == n && this.m_settingsState.isQtileBinning() && this.optQuantile.isSelected()) {
            this.m_settingsState.setRecalculate(false);
            return;
        }
        this.m_settingsState.setRecalculate(true);
        if (this.optEqualWidth.isSelected()) {
            this.m_settingsState.setEqualWidthBinning();
            this.m_dataSourcemodel.setEqualWidthBinning(this.m_nSelectedRow, n);
        } else if (this.optQuantile.isSelected()) {
            this.m_settingsState.setQtileBinning();
            this.m_dataSourcemodel.setQtileBinning(this.m_nSelectedRow, n);
        }
    }
}

