/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.plaf.FileChooserUI;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.transforms.ODMrTextState;
import oracle.dmt.dm4j.wizard.state.transforms.TransformWizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FinishState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.transformsteps.CreationSQLDialog;
import oracle.dmt.dm4j.wizard.steps.transformsteps.PreviewPanel;

public class FinishPreviewPanel
extends GriddedPanel {
    TransformWizardState m_state;
    boolean m_showProcedure = false;
    DM4JDialog m_parentDialog;
    JPanel m_previewPanel;
    JTabbedPane m_tabbedPane = new JTabbedPane();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JTextArea txtSQLGenerated = new JTextArea();
    JScrollPane scrollSQLGenerated = new JScrollPane();
    GriddedPanel m_sqlPanel = new GriddedPanel();
    GriddedPanel m_packagePanel = new GriddedPanel();
    JTextArea txtPackageGenerated = new JTextArea();
    JScrollPane scrollPackageGenerated = new JScrollPane();
    GriddedPanel m_procedurePanel = new GriddedPanel();
    JTextArea txtProcedureGenerated = new JTextArea();
    JScrollPane scrollProcedureGenerated = new JScrollPane();
    JButton butAdvancedSQL = new JButton();
    static final int PREVIEW_TAB = 0;
    static final int SQL_TAB = 1;
    static final int PACKAGE_TAB = 2;
    static final int PROCEDURE_TAB = 3;

    public FinishPreviewPanel(DM4JDialog dM4JDialog, WizardState wizardState) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = (TransformWizardState)wizardState;
        FinishState finishState = (FinishState)this.m_state.getStep(StepType.FINISH_STEP);
        this.m_showProcedure = finishState.isGenerateStoredProcedure();
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("FINISH_PREVIEW_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(3);
        this.mlblStepDescription.setMinimumRows(3);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        if (!(this.m_state instanceof ODMrTextState)) {
            this.addPreviewPanel();
        }
        this.addSQLPanel();
        if (this.m_showProcedure) {
            this.addPackagePanel();
            this.addProcedurePanel();
        }
        this.addFilledComponent(this.m_tabbedPane, COL1_CONTROL, n++, 0, 2, 2, 1);
        this.butAdvancedSQL.setText(ResourceUtilities.getUILabel("FINISH_STEP_ADVANCED_SQL"));
        this.butAdvancedSQL.setMnemonic(ResourceUtilities.getUIMnemonic("FINISH_STEP_ADVANCED_SQL"));
        this.butAdvancedSQL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FinishPreviewPanel.this.butAdvancedSQL_actionPerformed(actionEvent);
            }
        });
        this.addAnchoredComponent(this.butAdvancedSQL, COL_VALUE, ++n, 1, 13);
        this.setState();
    }

    private void setState() throws Exception {
        this.txtSQLGenerated.setText(this.m_state.getConstructResultsQueryOnly());
        JScrollBar jScrollBar = this.scrollSQLGenerated.getVerticalScrollBar();
        jScrollBar.setValue(jScrollBar.getMinimum());
        if (this.m_showProcedure) {
            this.txtPackageGenerated.setText(this.m_state.getConstructPackage());
            jScrollBar = this.scrollPackageGenerated.getVerticalScrollBar();
            jScrollBar.setValue(jScrollBar.getMinimum());
            this.txtProcedureGenerated.setText(this.m_state.getConstructPackageBody());
            jScrollBar = this.scrollProcedureGenerated.getVerticalScrollBar();
            jScrollBar.setValue(jScrollBar.getMinimum());
        }
    }

    private void addPreviewPanel() throws Exception {
        this.m_previewPanel = new PreviewPanel(this.m_parentDialog, this.m_state, true, this.m_state.getConstructResultsQueryOnly());
        this.m_tabbedPane.addTab(ResourceUtilities.getUILabel("FINISH_PREVIEW_PREVIEW_TAB"), this.m_previewPanel);
    }

    private void addSQLPanel() {
        int n = 0;
        this.txtSQLGenerated.setLineWrap(true);
        this.txtSQLGenerated.setWrapStyleWord(true);
        this.txtSQLGenerated.setEditable(false);
        this.scrollSQLGenerated.getViewport().add((Component)this.txtSQLGenerated, null);
        this.scrollSQLGenerated.setPreferredSize(new Dimension(250, 60));
        this.m_sqlPanel.addFilledComponent(this.scrollSQLGenerated, COL_VALUE, n++, 0, 4, 2, 1);
        this.addSQLButtons(n, this.m_sqlPanel);
        this.m_tabbedPane.addTab(ResourceUtilities.getUILabel("FINISH_PREVIEW_SQL_TAB"), this.m_sqlPanel);
    }

    private void addPackagePanel() {
        int n = 0;
        this.txtPackageGenerated.setLineWrap(true);
        this.txtPackageGenerated.setWrapStyleWord(true);
        this.txtPackageGenerated.setEditable(false);
        this.scrollPackageGenerated.getViewport().add((Component)this.txtPackageGenerated, null);
        this.scrollPackageGenerated.setPreferredSize(new Dimension(250, 60));
        this.m_packagePanel.addFilledComponent(this.scrollPackageGenerated, COL_VALUE, n++, 0, 4, 2, 1);
        this.addSQLButtons(n, this.m_packagePanel);
        this.m_tabbedPane.addTab(ResourceUtilities.getUILabel("FINISH_PREVIEW_PACKAGE_TAB"), this.m_packagePanel);
    }

    private void addProcedurePanel() {
        int n = 0;
        this.txtProcedureGenerated.setLineWrap(true);
        this.txtProcedureGenerated.setWrapStyleWord(true);
        this.txtProcedureGenerated.setEditable(false);
        this.scrollProcedureGenerated.getViewport().add((Component)this.txtProcedureGenerated, null);
        this.scrollProcedureGenerated.setPreferredSize(new Dimension(250, 60));
        this.m_procedurePanel.addFilledComponent(this.scrollProcedureGenerated, COL_VALUE, n++, 0, 4, 2, 1);
        this.addSQLButtons(n, this.m_procedurePanel);
        this.m_tabbedPane.addTab(ResourceUtilities.getUILabel("FINISH_PREVIEW_PROCEDURE_TAB"), this.m_procedurePanel);
    }

    private void addSQLButtons(int n, GriddedPanel griddedPanel) {
        JButton jButton = new JButton();
        jButton.setText(ResourceUtilities.getUILabel("SAVE_TO_FILE"));
        jButton.setMnemonic(ResourceUtilities.getUIMnemonic("SAVE_TO_FILE"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FinishPreviewPanel.this.butSaveToFile_actionPerformed(actionEvent);
            }
        });
        griddedPanel.addAnchoredComponent(jButton, COL_VALUE, ++n, 1, 17);
        JButton jButton2 = new JButton();
        jButton2.setText(ResourceUtilities.getUILabel("COPY_CLIPBOARD"));
        jButton2.setMnemonic(ResourceUtilities.getUIMnemonic("COPY_CLIPBOARD"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FinishPreviewPanel.this.butCopyClipboard_actionPerformed(actionEvent);
            }
        });
        griddedPanel.addAnchoredComponent(jButton2, COL_VALUE, n, 2, 13);
        JButton[] jButtonArray = new JButton[]{jButton2, jButton};
        FinishPreviewPanel.setPreferredSize(jButtonArray, 150, 25);
    }

    private void butAdvancedSQL_actionPerformed(ActionEvent actionEvent) {
        try {
            CreationSQLDialog creationSQLDialog = new CreationSQLDialog(this.m_state.getDialog(), this.m_state);
        }
        catch (Exception exception) {
            this.m_state.doAbortCancel(exception);
        }
    }

    private void butCopyClipboard_actionPerformed(ActionEvent actionEvent) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(this.getDisplayedTextArea().getText());
        clipboard.setContents(stringSelection, null);
    }

    private void butSaveToFile_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(2);
        FileChooserUI fileChooserUI = jFileChooser.getUI();
        jFileChooser.setDialogTitle(ResourceUtilities.getUILabel("SAVE_TRANSFORM_DIALOG_TITLE"));
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(this.getDisplayedTextArea().getText());
                fileWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private JTextArea getDisplayedTextArea() {
        JTextArea jTextArea = null;
        switch (this.m_tabbedPane.getSelectedIndex()) {
            case 0: {
                jTextArea = this.txtSQLGenerated;
                break;
            }
            case 1: {
                jTextArea = this.txtSQLGenerated;
                break;
            }
            case 2: {
                jTextArea = this.txtPackageGenerated;
                break;
            }
            case 3: {
                jTextArea = this.txtProcedureGenerated;
                break;
            }
            default: {
                jTextArea = new JTextArea();
            }
        }
        return jTextArea;
    }
}

