/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JDefaultNameGenerator;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.commonsteps.OpenFileState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FileImportTableSettingsState;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.transformsteps.FileImportTableSettingsNumberDialog;
import oracle.dmt.dm4j.wizard.steps.transformsteps.FileImportTableSettingsVarcharDialog;
import oracle.dmt.dm4j.wizard.steps.transformsteps.PreviewDialog;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class FileImportTableSettingsPanel
extends DM4JStep {
    private boolean DEBUG = false;
    FileImportTableSettingsState m_state;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JScrollPane scrollPane = new JScrollPane();
    JTable table = new JTable();
    FileImportTableModel tableModel = new FileImportTableModel();
    JButton butVarchar = new JButton();
    JButton butNumber = new JButton();
    JButton butPreview = new JButton();
    JButton butGenerateNames = new JButton();
    JLabel lblFiller = new JLabel();

    public FileImportTableSettingsPanel(FileImportTableSettingsState fileImportTableSettingsState) throws Exception {
        super(fileImportTableSettingsState);
        this.m_state = fileImportTableSettingsState;
        this.jbInit();
    }

    private void butVarchar_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.table.getSelectedRows();
        try {
            FileImportTableSettingsVarcharDialog fileImportTableSettingsVarcharDialog = new FileImportTableSettingsVarcharDialog(this.getparentWizardState().getDialog(), this.m_state, this.table);
            if (!fileImportTableSettingsVarcharDialog.isCancelled()) {
                this.m_state.getClass();
                this.tableModel.setDataType(nArray, "VARCHAR2(SIZE)");
                this.m_state.VARCHAR2_SIZE = fileImportTableSettingsVarcharDialog.getSizeValue().toString();
                this.m_state.DEFAULT_SIZE = fileImportTableSettingsVarcharDialog.getSizeValue().toString();
                this.tableModel.setDataSize(nArray, this.m_state.VARCHAR2_SIZE);
                this.setUpDataTypeColumn(this.table.getColumnModel().getColumn(1));
                this.processUserInput();
            }
        }
        catch (Exception exception) {
            this.m_state.getparentWizardState().doAbortCancel(exception);
        }
    }

    private void butNumber_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.table.getSelectedRows();
        try {
            FileImportTableSettingsNumberDialog fileImportTableSettingsNumberDialog = new FileImportTableSettingsNumberDialog(this.getparentWizardState().getDialog(), this.m_state, this.table);
            if (!fileImportTableSettingsNumberDialog.isCancelled()) {
                if (fileImportTableSettingsNumberDialog.getIsNumberWithPrecisionScale()) {
                    this.tableModel.setDataType(nArray, this.m_state.NUMBER);
                    this.m_state.NUMBER_PRECISION = fileImportTableSettingsNumberDialog.getPrecisionValue().toString();
                    this.m_state.NUMBER_SCALE = fileImportTableSettingsNumberDialog.getScaleValue().toString();
                    this.m_state.NUMBER_SIZE = this.m_state.NUMBER_PRECISION + "," + this.m_state.NUMBER_SCALE;
                    this.tableModel.setDataSize(nArray, this.m_state.NUMBER_SIZE);
                } else {
                    this.tableModel.setDataType(nArray, this.m_state.NUMBER_NO_SIZE);
                    this.tableModel.setDataSize(nArray, this.m_state.NO_SIZE);
                }
                this.setUpDataTypeColumn(this.table.getColumnModel().getColumn(1));
                this.processUserInput();
            }
        }
        catch (Exception exception) {
            this.m_state.getparentWizardState().doAbortCancel(exception);
        }
    }

    private void butGenerateNames_actionPerformed(ActionEvent actionEvent) {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.table.getRowCount());
        try {
            String string = null;
            String string2 = null;
            String string3 = null;
            boolean bl = false;
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                string = DM4JStringUtils.trimDoubleQuotes((String)this.table.getModel().getValueAt(i, 0));
                string2 = ValidationUtil.createNonQuotedCompliantName(string);
                string3 = DM4JStringUtils.addDoubleQuotes(string2);
                bl = hashMap.containsKey(string3);
                if (!bl) {
                    string2 = DM4JStringUtils.addDoubleQuotes(string2);
                    hashMap.put(string2, string2);
                } else {
                    string2 = this.generateUniqueName(string2, hashMap);
                    string2 = DM4JStringUtils.addDoubleQuotes(string2);
                    hashMap.put(string2, string2);
                }
                this.table.getModel().setValueAt(string2, i, 0);
            }
        }
        catch (Exception exception) {
            this.m_state.getparentWizardState().doAbortCancel(exception);
        }
    }

    private String generateUniqueName(String string, HashMap hashMap) {
        String string2 = string;
        if (string2.length() > 26) {
            string2 = string2.substring(0, 26);
        }
        String string3 = string2;
        DM4JDefaultNameGenerator dM4JDefaultNameGenerator = new DM4JDefaultNameGenerator(string3, "", false);
        string2 = dM4JDefaultNameGenerator.nextName();
        boolean bl = true;
        do {
            boolean bl2;
            if (bl2 = hashMap.containsKey(string2)) {
                String string4;
                string2 = string4 = dM4JDefaultNameGenerator.nextName();
                continue;
            }
            bl = false;
        } while (bl);
        return string2;
    }

    private void butAdd_actionPerformed(ActionEvent actionEvent) {
        String string = this.m_state.DEFAULT_NAME + (this.tableModel.getRowCount() + 1);
        this.m_state.getClass();
        String string2 = "VARCHAR2(SIZE)";
        String string3 = this.m_state.DEFAULT_SIZE;
        this.tableModel.addRow(new Object[]{string, string2, string3});
        this.setUpDataTypeColumn(this.table.getColumnModel().getColumn(1));
        this.processUserInput();
    }

    private void butPreview_actionPerformed(ActionEvent actionEvent) {
        try {
            OpenFileState openFileState = (OpenFileState)this.getparentWizardState().getStep(StepType.DATA_STEP);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(openFileState.getFile()));
            String string = bufferedReader.readLine();
            String string2 = "";
            if (string != null) {
                string2 = string;
            }
            for (int i = 0; i < 20; ++i) {
                string = bufferedReader.readLine();
                if (string == null) continue;
                string2 = string2 + "\n" + string;
            }
            PreviewDialog previewDialog = new PreviewDialog(this.getparentWizardState().getDialog(), this.m_state.getparentWizardState(), string2);
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    private void setUpStringEditor(JTable jTable) {
        final JTextField jTextField = new JTextField();
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField){

            public Object getCellEditorValue() {
                String string = jTextField.getText();
                FileImportTableSettingsPanel.this.processUserInput();
                return string;
            }
        };
        jTable.setDefaultEditor(String.class, defaultCellEditor);
    }

    private void sizeColumns(JTable jTable) {
        jTable.getColumnModel().getColumn(0).setMinWidth(180);
        jTable.getColumnModel().getColumn(1).setMinWidth(100);
        jTable.getColumnModel().getColumn(2).setMinWidth(30);
        jTable.getColumnModel().getColumn(3).setMinWidth(15);
    }

    private void jbInit() throws Exception {
        String string = ResourceUtilities.getUILabel("FILEIMPORT_TABLE_SETTINGS_STEP_DESCRIPTION");
        String string2 = ResourceUtilities.getUILabel("FILEIMPORT_TABLE_SETTINGS_VARCHAR");
        int n = ResourceUtilities.getUIMnemonic("FILEIMPORT_TABLE_SETTINGS_VARCHAR");
        String string3 = ResourceUtilities.getUILabel("FILEIMPORT_TABLE_SETTINGS_NUMBER");
        int n2 = ResourceUtilities.getUIMnemonic("FILEIMPORT_TABLE_SETTINGS_NUMBER");
        String string4 = ResourceUtilities.getUILabel("FILEIMPORT_TABLE_SETTINGS_PREVIEW");
        int n3 = ResourceUtilities.getUIMnemonic("FILEIMPORT_TABLE_SETTINGS_PREVIEW");
        int n4 = 0;
        this.mlblStepDescription.setText(string);
        this.mlblStepDescription.setPreferredAspectRatio(0.0f);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n4, 0, 4, 2, 1);
        n4 += n4 + 2;
        this.table = new JTable(this.tableModel);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.setUpDataTypeColumn(this.table.getColumnModel().getColumn(1));
        this.setUpStringEditor(this.table);
        this.sizeColumns(this.table);
        this.scrollPane.getViewport().add((Component)this.table, null);
        this.addFilledComponent(this.scrollPane, MIDLABELITEMINSETS, n4, 1, 2, 7, 1);
        this.butVarchar.setText(string2);
        this.butVarchar.setMnemonic(n);
        this.butVarchar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileImportTableSettingsPanel.this.butVarchar_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.butVarchar, TOPLABELITEMINSETS, n4++, 4, 1, 1, 2);
        this.butNumber.setText(string3);
        this.butNumber.setMnemonic(n2);
        this.butNumber.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileImportTableSettingsPanel.this.butNumber_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.butNumber, TOPLABELITEMINSETS, n4++, 4, 1, 1, 2);
        this.butPreview.setText(string4);
        this.butPreview.setMnemonic(n3);
        this.butPreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileImportTableSettingsPanel.this.butPreview_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.butPreview, TOPLABELITEMINSETS, n4++, 4, 1, 1, 2);
        this.butGenerateNames.setText("Clean Up Names");
        this.butGenerateNames.setMnemonic('U');
        this.butGenerateNames.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileImportTableSettingsPanel.this.butGenerateNames_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.butGenerateNames, TOPLABELITEMINSETS, n4++, 4, 1, 1, 2);
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n4, 0, 4, 2, 1);
    }

    public void focusOnErrorField(Vector vector) {
    }

    public void init() {
        this.loadDefaultValues();
    }

    public void reinit() {
        try {
            if (this.m_state != null) {
                this.m_state.refresh();
            }
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void loadDefaultValues() {
        if (this.m_state != null) {
            this.tableModel = new FileImportTableModel();
            String[] stringArray = new String[]{this.tableModel.COLUMN_NAME, this.tableModel.DATA_TYPE, this.tableModel.DATA_SIZE, this.tableModel.IF_NULL};
            String[] stringArray2 = this.m_state.getFieldNames();
            String[] stringArray3 = this.m_state.getFieldDataTypes();
            String[] stringArray4 = this.m_state.getFieldSizes();
            String[] stringArray5 = this.m_state.getFieldNullIfs();
            int n = stringArray2.length;
            Object[][] objectArray = new Object[n][4];
            for (int i = 0; i < n; ++i) {
                objectArray[i][0] = stringArray2[i];
                objectArray[i][1] = stringArray3[i];
                objectArray[i][2] = stringArray4[i];
                objectArray[i][3] = stringArray5[i];
            }
            this.tableModel.setTable(stringArray, objectArray);
            this.table.setModel(this.tableModel);
            this.setUpDataTypeColumn(this.table.getColumnModel().getColumn(1));
            this.sizeColumns(this.table);
            this.m_state.setPanel(this);
        }
    }

    public void clear() {
        this.loadDefaultValues();
    }

    protected void processUserInput() {
        try {
            if (this.m_state != null) {
                FileImportTableModel fileImportTableModel = (FileImportTableModel)this.table.getModel();
                Object[][] objectArray = fileImportTableModel.getData();
                int n = objectArray.length;
                String[] stringArray = new String[n];
                String[] stringArray2 = new String[n];
                String[] stringArray3 = new String[n];
                String[] stringArray4 = new String[n];
                for (int i = 0; i < n; ++i) {
                    Object object;
                    try {
                        stringArray[i] = (String)objectArray[i][0];
                        stringArray2[i] = (String)objectArray[i][1];
                        stringArray3[i] = (String)objectArray[i][2];
                        stringArray4[i] = (String)objectArray[i][3];
                        Vector vector = new Vector();
                        String string = stringArray2[i];
                        this.m_state.getClass();
                        if (string.equalsIgnoreCase("VARCHAR2(SIZE)")) {
                            if (Integer.parseInt(stringArray3[i]) >= 1 && Integer.parseInt(stringArray3[i]) <= 4000) continue;
                            Integer n2 = Integer.valueOf(stringArray3[i]);
                            this.m_state.getClass();
                            this.m_state.validateSizeValues(vector, n2, "VARCHAR2(SIZE)");
                            DialogUtilities.displayValidations(vector, null, this.getparentWizardState().getDM4JWizardDialog());
                            stringArray3[i] = "4000";
                            fileImportTableModel.setValueAt("4000", i, 2);
                            continue;
                        }
                        if (stringArray2[i].equalsIgnoreCase(this.m_state.NVARCHAR2)) {
                            if (Integer.parseInt(stringArray3[i]) >= 1 && Integer.parseInt(stringArray3[i]) <= 2000) continue;
                            this.m_state.validateSizeValues(vector, Integer.valueOf(stringArray3[i]), this.m_state.NVARCHAR2);
                            DialogUtilities.displayValidations(vector, null, this.getparentWizardState().getDM4JWizardDialog());
                            stringArray3[i] = "2000";
                            fileImportTableModel.setValueAt("2000", i, 2);
                            continue;
                        }
                        if (stringArray2[i].equalsIgnoreCase(this.m_state.CHAR)) {
                            if (Integer.parseInt(stringArray3[i]) >= 1 && Integer.parseInt(stringArray3[i]) <= 2000) continue;
                            this.m_state.validateSizeValues(vector, Integer.valueOf(stringArray3[i]), this.m_state.CHAR);
                            DialogUtilities.displayValidations(vector, null, this.getparentWizardState().getDM4JWizardDialog());
                            stringArray3[i] = "2000";
                            fileImportTableModel.setValueAt("2000", i, 2);
                            continue;
                        }
                        if (stringArray2[i].equalsIgnoreCase(this.m_state.NCHAR)) {
                            if (Integer.parseInt(stringArray3[i]) >= 1 && Integer.parseInt(stringArray3[i]) <= 1000) continue;
                            this.m_state.validateSizeValues(vector, Integer.valueOf(stringArray3[i]), this.m_state.NCHAR);
                            DialogUtilities.displayValidations(vector, null, this.getparentWizardState().getDM4JWizardDialog());
                            stringArray3[i] = "1000";
                            fileImportTableModel.setValueAt("1000", i, 2);
                            continue;
                        }
                        if (stringArray2[i].equalsIgnoreCase(this.m_state.RAW)) {
                            if (Integer.parseInt(stringArray3[i]) >= 1 && Integer.parseInt(stringArray3[i]) <= 2000) continue;
                            this.m_state.validateSizeValues(vector, Integer.valueOf(stringArray3[i]), this.m_state.RAW);
                            DialogUtilities.displayValidations(vector, null, this.getparentWizardState().getDM4JWizardDialog());
                            stringArray3[i] = "2000";
                            fileImportTableModel.setValueAt("2000", i, 2);
                            continue;
                        }
                        if (stringArray2[i].equalsIgnoreCase(this.m_state.DATE)) {
                            if (!stringArray3[i].equalsIgnoreCase("")) continue;
                            this.m_state.validateSizeValues(vector, null, this.m_state.DATE);
                            DialogUtilities.displayValidations(vector, null, this.getparentWizardState().getDM4JWizardDialog());
                            stringArray3[i] = this.m_state.DATE_FORMAT;
                            fileImportTableModel.setValueAt(this.m_state.DATE_FORMAT, i, 2);
                            continue;
                        }
                        if (!stringArray2[i].equalsIgnoreCase(this.m_state.NUMBER)) continue;
                        object = new StringTokenizer(stringArray3[i], ",");
                        String string2 = ((StringTokenizer)object).nextToken();
                        String string3 = ((StringTokenizer)object).nextToken();
                        if (Integer.parseInt(string2) <= 38 && Integer.parseInt(string3) <= 127 && Integer.parseInt(string3) >= -84) continue;
                        this.m_state.validatePrecisionScaleValues(vector, Integer.valueOf(string2), Integer.valueOf(string3));
                        DialogUtilities.displayValidations(vector, null, this.getparentWizardState().getDM4JWizardDialog());
                        if (Integer.parseInt(string2) > 38) {
                            string2 = "38";
                        }
                        if (Integer.parseInt(string3) > 127) {
                            string3 = "127";
                        } else if (Integer.parseInt(string3) < -84) {
                            string3 = "-84";
                        }
                        stringArray3[i] = string2 + "," + string3;
                        fileImportTableModel.setValueAt(string2 + "," + string3, i, 2);
                        continue;
                    }
                    catch (Exception exception) {
                        object = new Vector();
                        this.m_state.getClass();
                        this.m_state.validateSizeValues((Vector)object, null, "VARCHAR2(SIZE)");
                        DialogUtilities.displayValidations(object, null, this.getparentWizardState().getDM4JWizardDialog());
                        String string = stringArray2[i];
                        this.m_state.getClass();
                        if (string.equalsIgnoreCase("VARCHAR2(SIZE)")) {
                            stringArray3[i] = this.m_state.VARCHAR2_SIZE;
                        } else if (stringArray2[i].equalsIgnoreCase(this.m_state.NVARCHAR2)) {
                            stringArray3[i] = this.m_state.NVARCHAR2_SIZE;
                        } else if (stringArray2[i].equalsIgnoreCase(this.m_state.CHAR)) {
                            this.m_state.getClass();
                            stringArray3[i] = "1";
                        } else if (stringArray2[i].equalsIgnoreCase(this.m_state.RAW)) {
                            stringArray3[i] = this.m_state.RAW_SIZE;
                        } else if (stringArray2[i].equalsIgnoreCase(this.m_state.NUMBER)) {
                            stringArray3[i] = this.m_state.NUMBER_SIZE;
                        }
                        fileImportTableModel.setValueAt(stringArray3[i], i, 2);
                        break;
                    }
                }
                fileImportTableModel.fireTableDataChanged();
                this.m_state.setFieldNames(stringArray);
                this.m_state.setFieldDataTypes(stringArray2);
                this.m_state.setFieldSizes(stringArray3);
                this.m_state.setFieldNullIfs(stringArray4);
                this.m_state.setState(StepStateType.DIRTY);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUpDataTypeColumn(TableColumn tableColumn) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        this.m_state.getClass();
        jComboBox.addItem("VARCHAR2(SIZE)");
        jComboBox.addItem(this.m_state.NVARCHAR2);
        jComboBox.addItem(this.m_state.CHAR);
        jComboBox.addItem(this.m_state.NCHAR);
        jComboBox.addItem(this.m_state.RAW);
        jComboBox.addItem(this.m_state.NUMBER);
        jComboBox.addItem(this.m_state.NUMBER_NO_SIZE);
        jComboBox.addItem(this.m_state.DATE);
        jComboBox.addItem(this.m_state.LONG);
        jComboBox.addItem(this.m_state.LONG_RAW);
        jComboBox.addItem(this.m_state.ROWID);
        jComboBox.addItem(this.m_state.CLOB);
        jComboBox.addItem(this.m_state.NCLOB);
        jComboBox.addItem(this.m_state.BLOB);
        jComboBox.addItem(this.m_state.BFILE);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                int[] nArray = FileImportTableSettingsPanel.this.table.getSelectedRows();
                FileImportTableSettingsPanel.this.m_state.getClass();
                if (string.equalsIgnoreCase("VARCHAR2(SIZE)")) {
                    FileImportTableModel fileImportTableModel = FileImportTableSettingsPanel.this.tableModel;
                    FileImportTableSettingsPanel.this.m_state.getClass();
                    fileImportTableModel.setDataType(nArray, "VARCHAR2(SIZE)");
                    FileImportTableSettingsPanel.this.tableModel.setDataSize(nArray, FileImportTableSettingsPanel.this.m_state.VARCHAR2_SIZE);
                } else if (string.equalsIgnoreCase(FileImportTableSettingsPanel.this.m_state.NVARCHAR2)) {
                    FileImportTableSettingsPanel.this.tableModel.setDataType(nArray, FileImportTableSettingsPanel.this.m_state.NVARCHAR2);
                    FileImportTableSettingsPanel.this.tableModel.setDataSize(nArray, FileImportTableSettingsPanel.this.m_state.NVARCHAR2_SIZE);
                } else if (string.equalsIgnoreCase(FileImportTableSettingsPanel.this.m_state.CHAR)) {
                    FileImportTableSettingsPanel.this.tableModel.setDataType(nArray, FileImportTableSettingsPanel.this.m_state.CHAR);
                    FileImportTableModel fileImportTableModel = FileImportTableSettingsPanel.this.tableModel;
                    FileImportTableSettingsPanel.this.m_state.getClass();
                    fileImportTableModel.setDataSize(nArray, "1");
                } else if (string.equalsIgnoreCase(FileImportTableSettingsPanel.this.m_state.NCHAR)) {
                    FileImportTableSettingsPanel.this.tableModel.setDataType(nArray, FileImportTableSettingsPanel.this.m_state.NCHAR);
                    FileImportTableModel fileImportTableModel = FileImportTableSettingsPanel.this.tableModel;
                    FileImportTableSettingsPanel.this.m_state.getClass();
                    fileImportTableModel.setDataSize(nArray, "1");
                } else if (string.equalsIgnoreCase(FileImportTableSettingsPanel.this.m_state.RAW)) {
                    FileImportTableSettingsPanel.this.tableModel.setDataType(nArray, FileImportTableSettingsPanel.this.m_state.RAW);
                    FileImportTableSettingsPanel.this.tableModel.setDataSize(nArray, FileImportTableSettingsPanel.this.m_state.RAW_SIZE);
                } else if (string.equalsIgnoreCase(FileImportTableSettingsPanel.this.m_state.NUMBER)) {
                    FileImportTableSettingsPanel.this.tableModel.setDataType(nArray, FileImportTableSettingsPanel.this.m_state.NUMBER);
                    FileImportTableSettingsPanel.this.tableModel.setDataSize(nArray, FileImportTableSettingsPanel.this.m_state.NUMBER_SIZE);
                } else if (string.equalsIgnoreCase(FileImportTableSettingsPanel.this.m_state.DATE)) {
                    FileImportTableSettingsPanel.this.tableModel.setDataType(nArray, FileImportTableSettingsPanel.this.m_state.DATE);
                    FileImportTableSettingsPanel.this.tableModel.setDataSize(nArray, FileImportTableSettingsPanel.this.m_state.DATE_FORMAT);
                } else {
                    FileImportTableSettingsPanel.this.tableModel.setDataSize(nArray, FileImportTableSettingsPanel.this.m_state.NO_SIZE);
                }
                FileImportTableSettingsPanel.this.setUpDataTypeColumn(FileImportTableSettingsPanel.this.table.getColumnModel().getColumn(1));
                FileImportTableSettingsPanel.this.processUserInput();
            }
        });
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        tableColumn.setCellRenderer(defaultTableCellRenderer);
    }

    class FileImportTableModel
    extends AbstractTableModel {
        public String COLUMN_NAME = ResourceUtilities.getUILabel("FILEIMPORT_SETTINGS_COLUMN_NAME");
        public String DATA_TYPE = ResourceUtilities.getUILabel("FILEIMPORT_SETTINGS_DATA_TYPE");
        public String DATA_SIZE = ResourceUtilities.getUILabel("FILEIMPORT_SETTINGS_DATA_SIZE");
        public String IF_NULL = ResourceUtilities.getUILabel("FILEIMPORT_SETTINGS_NULL_IF");
        String[] columnNames = new String[]{this.COLUMN_NAME, this.DATA_TYPE, this.DATA_SIZE, this.IF_NULL};
        Object[][] data = new Object[][]{{"Dummy", "Dummy", "Dummy", "Dummy"}, {"Dummy", "Dummy", "Dummy", "Dummy"}};

        FileImportTableModel() {
        }

        public Object[][] getData() {
            return this.data;
        }

        public void setTable(String[] stringArray, Object[][] objectArray) {
            this.columnNames = stringArray;
            this.data = objectArray;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 < 0) {
                return false;
            }
            return n2 != 2 || !this.getValueAt(n, n2).toString().equalsIgnoreCase(FileImportTableSettingsPanel.this.m_state.NO_SIZE);
        }

        public void setDataType(int[] nArray, String string) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                this.data[n][1] = string;
            }
            this.fireTableDataChanged();
        }

        public void setDataSize(int[] nArray, String string) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                this.data[n][2] = string;
            }
            this.fireTableDataChanged();
        }

        public void addRow(Object[] objectArray) {
            int n = this.getRowCount() + 1;
            Object[][] objectArray2 = new Object[n][4];
            String[] stringArray = FileImportTableSettingsPanel.this.m_state.getFieldNames();
            String[] stringArray2 = FileImportTableSettingsPanel.this.m_state.getFieldDataTypes();
            String[] stringArray3 = FileImportTableSettingsPanel.this.m_state.getFieldSizes();
            String[] stringArray4 = FileImportTableSettingsPanel.this.m_state.getFieldNullIfs();
            for (int i = 0; i < n; ++i) {
                if (i < n - 1) {
                    objectArray2[i][0] = stringArray[i];
                    objectArray2[i][1] = stringArray2[i];
                    objectArray2[i][2] = stringArray3[i];
                    objectArray2[i][3] = stringArray4[i];
                    continue;
                }
                objectArray2[i][0] = objectArray[0];
                objectArray2[i][1] = objectArray[1];
                objectArray2[i][2] = objectArray[2];
                objectArray2[i][3] = objectArray[3];
            }
            this.data = objectArray2;
            this.fireTableDataChanged();
        }

        public void setValueAt(Object object, int n, int n2) {
            if (FileImportTableSettingsPanel.this.DEBUG) {
                System.out.println("Setting value at " + n + "," + n2 + " to " + object + " (an instance of " + object.getClass() + ")");
            }
            if (this.data[0][n2] instanceof Integer && !(object instanceof Integer)) {
                try {
                    this.data[n][n2] = new Integer(object.toString());
                    this.fireTableCellUpdated(n, n2);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.data[n][n2] = object;
                this.fireTableCellUpdated(n, n2);
            }
            if (n2 == 2) {
                FileImportTableSettingsPanel.this.processUserInput();
            }
            if (FileImportTableSettingsPanel.this.DEBUG) {
                System.out.println("New value of data:");
                this.printDebugData();
            }
        }

        private void printDebugData() {
            int n = this.getRowCount();
            int n2 = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < n2; ++j) {
                    System.out.print("  " + this.data[i][j]);
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }
}

