/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.FileImportTableSettingsState;

public class FileImportTableSettingsNumberPanel
extends GriddedPanel {
    MultiLineLabel m_mlblStepDescription = new MultiLineLabel();
    DM4JDialog m_parentDialog;
    FileImportTableSettingsState m_state = null;
    JTable m_table;
    JRadioButton radioNumber = new JRadioButton();
    JRadioButton radioNumberWithPrecisionScale = new JRadioButton();
    JLabel lblPrecision = new JLabel();
    JLabel lblScale = new JLabel();
    NumberTextField txtPrecision = new NumberTextField();
    NumberTextField txtScale = new NumberTextField();
    boolean m_isNumberWithPrecisionScale = false;
    Integer m_precisionValue = new Integer(10);
    Integer m_scaleValue = new Integer(2);

    public FileImportTableSettingsNumberPanel(DM4JDialog dM4JDialog, FileImportTableSettingsState fileImportTableSettingsState, JTable jTable) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = fileImportTableSettingsState;
        this.m_table = jTable;
        this.jbInit();
    }

    protected void jbInit() throws Exception {
        int n = 0;
        this.m_mlblStepDescription.setText(ResourceUtilities.getUILabel("FILEIMPORT_VARCHAR_SETTINGS_DIALOG_DESCRIPTION"));
        this.m_mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.m_mlblStepDescription.setPreferredRows(1);
        this.m_mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent(this.m_mlblStepDescription, TOP_DESC, n++, 0, 5, 1, 1);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioNumber);
        buttonGroup.add(this.radioNumberWithPrecisionScale);
        this.radioNumber.setSelected(true);
        this.radioNumber.setText(ResourceUtilities.getUILabel("FILEIMPORT_NUMBER_SETTINGS_DIALOG_NUMBER"));
        this.radioNumber.setMnemonic(ResourceUtilities.getUIMnemonic("FILEIMPORT_NUMBER_SETTINGS_DIALOG_NUMBER"));
        this.addComponent(this.radioNumber, COL1_INDENTED1_LABEL, n++, 0);
        this.radioNumberWithPrecisionScale.setText(ResourceUtilities.getUILabel("FILEIMPORT_NUMBER_SETTINGS_DIALOG_NUMBER_WITH_PRECISION"));
        this.radioNumberWithPrecisionScale.setMnemonic(ResourceUtilities.getUIMnemonic("FILEIMPORT_NUMBER_SETTINGS_DIALOG_NUMBER_WITH_PRECISION"));
        this.addComponent(this.radioNumberWithPrecisionScale, COL1_INDENTED1_LABEL, n++, 0);
        if (this.m_state != null) {
            this.m_precisionValue = new Integer(this.m_state.NUMBER_PRECISION);
            this.m_scaleValue = new Integer(this.m_state.NUMBER_SCALE);
        }
        this.lblPrecision.setText(ResourceUtilities.getUILabel("FILEIMPORT_NUMBER_SETTINGS_DIALOG_PRECISION"));
        this.lblPrecision.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("FILEIMPORT_NUMBER_SETTINGS_DIALOG_PRECISION"));
        this.lblPrecision.setLabelFor(this.txtPrecision);
        this.txtPrecision.setLocale(Locale.getDefault());
        this.txtPrecision.setDataType(Integer.TYPE);
        this.txtPrecision.setNumber(this.m_precisionValue);
        this.txtPrecision.setColumns(5);
        this.addComponent(this.lblPrecision, COL1_INDENTED2_CONTROL, n, 0);
        this.addComponent(this.txtPrecision, COL_VALUE, n++, 1);
        this.lblScale.setText(ResourceUtilities.getUILabel("FILEIMPORT_NUMBER_SETTINGS_DIALOG_SCALE"));
        this.lblScale.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("FILEIMPORT_NUMBER_SETTINGS_DIALOG_SCALE"));
        this.lblScale.setLabelFor(this.txtScale);
        this.txtScale.setLocale(Locale.getDefault());
        this.txtScale.setDataType(Integer.TYPE);
        this.txtScale.setNumber(this.m_scaleValue);
        this.txtScale.setColumns(5);
        this.addComponent(this.lblScale, COL1_INDENTED2_CONTROL, n, 0);
        this.addComponent(this.txtScale, COL_VALUE, n++, 1);
        this.addFilledComponent(new JLabel(), TOPLABELITEMINSETS, 8, 0, 5, 1, 1);
        this.addOKHelpCancelListeners();
        this.loadState();
    }

    protected void loadState() throws Exception {
        if (this.m_state != null) {
            // empty if block
        }
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileImportTableSettingsNumberPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                if (this.radioNumberWithPrecisionScale.isSelected()) {
                    this.m_state.validatePrecisionScaleValues(vector, (Integer)this.txtPrecision.getNumber(), (Integer)this.txtScale.getNumber());
                }
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
                if (vector.isEmpty()) {
                    this.processUserInput();
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else if ("cancel" == string) {
            // empty if block
        }
    }

    protected void processUserInput() {
        this.m_isNumberWithPrecisionScale = this.radioNumberWithPrecisionScale.isSelected();
        this.m_precisionValue = (Integer)this.txtPrecision.getNumber();
        this.m_scaleValue = (Integer)this.txtScale.getNumber();
    }

    public Integer getPrecisionValue() {
        return this.m_precisionValue;
    }

    public Integer getScaleValue() {
        return this.m_scaleValue;
    }

    public boolean getIsNumberWithPrecisionScale() {
        return this.m_isNumberWithPrecisionScale;
    }
}

