/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.commonsteps.OpenFileState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FileImportAdvanceState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FileImportSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FileImportTableSettingsState;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.transformsteps.FileImportAdvanceDialog;
import oracle.dmt.dm4j.wizard.steps.transformsteps.FileImportTableSettingsPanel;
import oracle.dmt.dm4j.wizard.steps.transformsteps.PreviewDialog;

public class FileImportSettingsPanel
extends DM4JStep {
    FileImportSettingsState m_state;
    String COMMA = "Comma (,)";
    String COMMA_VALUE = ",";
    String VERTICAL_BAR = "Vertical Bar (|)";
    String VERTICAL_BAR_VALUE = "|";
    String HYPHEN = "Hyphen (-)";
    String HYPHEN_VALUE = "-";
    String PERIOD = "Period (.)";
    String PERIOD_VALUE = ".";
    String SPACE = "Space";
    String SPACE_VALUE = " ";
    String TAB = "Tab";
    String TAB_VALUE = "\t";
    String WHITESPACE = "White Space";
    String WHITESPACE_VALUE = "WHITESPACE";
    String UNKNOWN = "Enter your delimiter here";
    String NONE = "None";
    String NONE_VALUE = "";
    String SINGLE_QUOTE = "Single Quote (')";
    String SINGLE_QUOTE_VALUE = "'";
    String DOUBLE_QUOTE = "Double Quote ('')";
    String DOUBLE_QUOTE_VALUE = "\"";
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblFieldDelimiter = new JLabel();
    JComboBox comboFieldDelimiter = new JComboBox();
    JLabel lblEnclosure = new JLabel();
    JComboBox comboEnclosure = new JComboBox();
    JLabel lblHasColumnHeader = new JLabel();
    JCheckBox ckbxHasColumnHeader = new JCheckBox();
    JButton butAdvance = new JButton();
    JButton butPreview = new JButton();
    JLabel lblFiller = new JLabel();

    public FileImportSettingsPanel(FileImportSettingsState fileImportSettingsState) throws Exception {
        super(fileImportSettingsState);
        this.m_state = fileImportSettingsState;
        this.jbInit();
    }

    private void comboFieldDelimiter_actionPerformed(ActionEvent actionEvent) {
        try {
            this.processUserInput();
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    private void comboEnclosure_actionPerformed(ActionEvent actionEvent) {
        try {
            this.m_state.setState(StepStateType.DIRTY);
            this.processUserInput();
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    private void ckbxColumnHeader_actionPerformed(ActionEvent actionEvent) {
        this.m_state.setHasColumnHeader(this.ckbxHasColumnHeader.isSelected());
    }

    private void butAdvance_actionPerformed(ActionEvent actionEvent) {
        try {
            this.m_state.getparentWizardState().getDM4JWizardDialog().setDialogBusy(false);
            FileImportAdvanceState fileImportAdvanceState = this.m_state.getFileImportAdvanceState();
            this.processUserInput();
            FileImportAdvanceDialog fileImportAdvanceDialog = new FileImportAdvanceDialog(this.getparentWizardState().getDialog(), fileImportAdvanceState);
            if (fileImportAdvanceState.getSave()) {
                if (this.m_state != null) {
                    this.m_state.setFileImportAdvanceState(fileImportAdvanceState);
                }
                this.processUserInput();
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    private void butPreview_actionPerformed(ActionEvent actionEvent) {
        try {
            OpenFileState openFileState = (OpenFileState)this.getparentWizardState().getStep(StepType.DATA_STEP);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(openFileState.getFile()));
            String string = bufferedReader.readLine();
            String string2 = "";
            if (string != null) {
                string2 = string;
            }
            for (int i = 0; i < 20; ++i) {
                string = bufferedReader.readLine();
                if (string == null) continue;
                string2 = string2 + "\n" + string;
            }
            JDialog jDialog = this.getparentWizardState().getDialog();
            PreviewDialog previewDialog = new PreviewDialog(jDialog, this.m_state.getparentWizardState(), string2);
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    private void jbInit() throws Exception {
        String string = ResourceUtilities.getUILabel("FILEIMPORT_SETTINGS_STEP_DESCRIPTION");
        String string2 = ResourceUtilities.getUILabel("FILEIMPORT_SETTINGS_FIELD_DELIMITER");
        int n = ResourceUtilities.getUIMnemonic("FILEIMPORT_SETTINGS_FIELD_DELIMITER");
        String string3 = ResourceUtilities.getUILabel("FILEIMPORT_SETTINGS_ENCLOSURE");
        int n2 = ResourceUtilities.getUIMnemonic("FILEIMPORT_SETTINGS_ENCLOSURE");
        String string4 = ResourceUtilities.getUILabel("FILEIMPORT_SETTINGS_FIELD_NAMES");
        int n3 = ResourceUtilities.getUIMnemonic("FILEIMPORT_SETTINGS_FIELD_NAMES");
        String string5 = ResourceUtilities.getUILabel("FILEIMPORT_SETTINGS_ADVANCE");
        int n4 = ResourceUtilities.getUIMnemonic("FILEIMPORT_SETTINGS_ADVANCE");
        String string6 = ResourceUtilities.getUILabel("FILEIMPORT_SETTINGS_PREVIEW");
        int n5 = ResourceUtilities.getUIMnemonic("FILEIMPORT_SETTINGS_PREVIEW");
        int n6 = 0;
        this.mlblStepDescription.setText(string);
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n6++, 0, 2, 1, 1);
        String[] stringArray = new String[]{this.COMMA, this.HYPHEN, this.PERIOD, this.SPACE, this.TAB, this.VERTICAL_BAR, this.WHITESPACE, this.UNKNOWN};
        this.comboFieldDelimiter = new JComboBox<String>(stringArray);
        this.comboFieldDelimiter.setEditable(true);
        this.comboFieldDelimiter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileImportSettingsPanel.this.comboFieldDelimiter_actionPerformed(actionEvent);
            }
        });
        this.lblFieldDelimiter.setText(string2);
        this.lblFieldDelimiter.setDisplayedMnemonic(n);
        this.lblFieldDelimiter.setLabelFor(this.comboFieldDelimiter);
        this.addComponent(this.lblFieldDelimiter, COL1_INDENTED1_LABEL, n6, 0);
        this.addFilledComponent(this.comboFieldDelimiter, COL_VALUE, n6++, 1);
        String[] stringArray2 = new String[]{this.NONE, this.SINGLE_QUOTE, this.DOUBLE_QUOTE};
        this.comboEnclosure = new JComboBox<String>(stringArray2);
        this.comboEnclosure.setEditable(true);
        this.comboEnclosure.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileImportSettingsPanel.this.comboEnclosure_actionPerformed(actionEvent);
            }
        });
        this.lblEnclosure.setText(string3);
        this.lblEnclosure.setDisplayedMnemonic(n2);
        this.lblEnclosure.setLabelFor(this.comboEnclosure);
        this.addComponent(this.lblEnclosure, COL1_INDENTED1_LABEL, n6, 0);
        this.addFilledComponent(this.comboEnclosure, COL_VALUE, n6++, 1);
        this.lblHasColumnHeader.setText(string4);
        this.lblHasColumnHeader.setDisplayedMnemonic(n3);
        this.lblFieldDelimiter.setLabelFor(this.lblHasColumnHeader);
        this.ckbxHasColumnHeader.setText(this.lblHasColumnHeader.getText());
        this.addComponent(this.ckbxHasColumnHeader, COL1_INDENTED1_LABEL, n6++, 0, 2, 1);
        this.ckbxHasColumnHeader.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileImportSettingsPanel.this.ckbxColumnHeader_actionPerformed(actionEvent);
            }
        });
        this.butPreview.setText(string6);
        this.butPreview.setMnemonic(n5);
        this.butPreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileImportSettingsPanel.this.butPreview_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.butPreview, COL1_CONTROL, n6, 0);
        this.butAdvance.setText(string5);
        this.butAdvance.setMnemonic(n4);
        this.butAdvance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileImportSettingsPanel.this.butAdvance_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.butAdvance, COL2_CONTROL, n6++, 1);
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n6++, 0, 4, 2, 1);
    }

    public void focusOnErrorField(Vector vector) {
    }

    public void init() {
        this.loadDefaultValues();
    }

    public void reinit() {
        this.init();
    }

    protected void loadDefaultValues() {
        if (this.m_state != null) {
            String string = this.m_state.getFieldDelimiter();
            String string2 = this.m_state.getEnclosure();
            boolean bl = this.m_state.getHasColumnHeader();
            if (string.equalsIgnoreCase(this.COMMA_VALUE)) {
                this.comboFieldDelimiter.setSelectedItem(this.COMMA);
            } else if (string.equalsIgnoreCase(this.VERTICAL_BAR_VALUE)) {
                this.comboFieldDelimiter.setSelectedItem(this.VERTICAL_BAR);
            } else if (string.equalsIgnoreCase(this.HYPHEN_VALUE)) {
                this.comboFieldDelimiter.setSelectedItem(this.HYPHEN);
            } else if (string.equalsIgnoreCase(this.PERIOD_VALUE)) {
                this.comboFieldDelimiter.setSelectedItem(this.PERIOD);
            } else if (string.equalsIgnoreCase(this.SPACE_VALUE)) {
                this.comboFieldDelimiter.setSelectedItem(this.SPACE);
            } else if (string.equalsIgnoreCase(this.TAB_VALUE)) {
                this.comboFieldDelimiter.setSelectedItem(this.TAB);
            } else if (string.equalsIgnoreCase(this.WHITESPACE_VALUE)) {
                this.comboFieldDelimiter.setSelectedItem(this.WHITESPACE);
            }
            if (string2.equalsIgnoreCase(this.NONE_VALUE)) {
                this.comboEnclosure.setSelectedItem(this.NONE);
            } else if (string2.equalsIgnoreCase(this.SINGLE_QUOTE_VALUE)) {
                this.comboEnclosure.setSelectedItem(this.SINGLE_QUOTE);
            } else if (string2.equalsIgnoreCase(this.DOUBLE_QUOTE_VALUE)) {
                this.comboEnclosure.setSelectedItem(this.DOUBLE_QUOTE);
            }
            this.ckbxHasColumnHeader.setSelected(bl);
        }
    }

    public void clear() {
        this.loadDefaultValues();
    }

    protected void processUserInput() {
        try {
            if (this.m_state != null) {
                String string;
                if (this.comboFieldDelimiter.getSelectedItem() != "") {
                    string = (String)this.comboFieldDelimiter.getSelectedItem();
                    if (string.equalsIgnoreCase(this.COMMA)) {
                        this.m_state.setFieldDelimiter(this.COMMA_VALUE);
                    } else if (string.equalsIgnoreCase(this.VERTICAL_BAR)) {
                        this.m_state.setFieldDelimiter(this.VERTICAL_BAR_VALUE);
                    } else if (string.equalsIgnoreCase(this.HYPHEN)) {
                        this.m_state.setFieldDelimiter(this.HYPHEN_VALUE);
                    } else if (string.equalsIgnoreCase(this.PERIOD)) {
                        this.m_state.setFieldDelimiter(this.PERIOD_VALUE);
                    } else if (string.equalsIgnoreCase(this.SPACE)) {
                        this.m_state.setFieldDelimiter(this.SPACE_VALUE);
                    } else if (string.equalsIgnoreCase(this.TAB)) {
                        this.m_state.setFieldDelimiter(this.TAB_VALUE);
                    } else if (string.equalsIgnoreCase(this.WHITESPACE)) {
                        this.m_state.setFieldDelimiter(this.WHITESPACE_VALUE);
                    } else {
                        this.m_state.setFieldDelimiter(string);
                    }
                }
                if (this.comboEnclosure.getSelectedItem() != "") {
                    string = (String)this.comboEnclosure.getSelectedItem();
                    if (string.equalsIgnoreCase(this.NONE)) {
                        this.m_state.setEnclosure(this.NONE_VALUE);
                    } else if (string.equalsIgnoreCase(this.SINGLE_QUOTE)) {
                        this.m_state.setEnclosure(this.SINGLE_QUOTE_VALUE);
                    } else if (string.equalsIgnoreCase(this.DOUBLE_QUOTE)) {
                        this.m_state.setEnclosure(this.DOUBLE_QUOTE_VALUE);
                    } else {
                        this.m_state.setFieldDelimiter(string);
                    }
                }
                this.m_state.setHasColumnHeader(this.ckbxHasColumnHeader.isSelected());
                if (this.ckbxHasColumnHeader.isSelected()) {
                    this.m_state.getFileImportAdvanceState().setSkipCount(new Integer(1));
                } else if (this.m_state.getFileImportAdvanceState().getSkipCount() == 1) {
                    this.m_state.getFileImportAdvanceState().setSkipCount(new Integer(0));
                }
                FileImportTableSettingsState fileImportTableSettingsState = (FileImportTableSettingsState)this.getparentWizardState().getStep(StepType.SETTING_STEP_1);
                FileImportTableSettingsPanel fileImportTableSettingsPanel = fileImportTableSettingsState.getPanel();
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }
}

