/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.collection.Range;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeEqualWidthArray;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.DiscretizationDataUsageState;
import oracle.dmt.dm4j.wizard.state.transformsteps.DiscretizationSettingsState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.odm.binning.BackupData;
import oracle.dmt.odm.binning.BinningType;

public class EqualBinningSettingsPanel
extends GriddedPanel {
    protected DM4JDialog m_parentDialog;
    protected WizardState m_state = null;
    protected MultiLineLabel mlblStepDescription = new MultiLineLabel();
    protected JPanel pnlNumberOfBins = new JPanel(new GridLayout(1, 2, 5, 0));
    protected JRadioButton radioNumberOfBins = new JRadioButton();
    protected JLabel lblNumberOfBins = new JLabel();
    protected CustomNumberTextField txtNumberOfBins = new CustomNumberTextField();
    protected JPanel pnlAutoNumberOfBins = new JPanel(new GridLayout(1, 2, 5, 0));
    protected JRadioButton radioAutoNumberOfBins = new JRadioButton();
    protected CustomNumberTextField txtAutoNumberOfBins = new CustomNumberTextField();
    ButtonGroup groupBinning = new ButtonGroup();
    protected SpreadTable m_spreadTable;
    protected Range[] m_range = null;
    protected DiscretizeDataSource m_dataSourcemodel = null;
    protected DiscretizationSettingsState m_settingsState;
    protected Hashtable m_backupData = new Hashtable();
    protected boolean m_bAutoCalculate = false;
    protected Integer m_autobinNumber;
    protected Integer m_Selection;

    public EqualBinningSettingsPanel(DM4JDialog dM4JDialog, WizardState wizardState, SpreadTable spreadTable) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = wizardState;
        this.m_spreadTable = spreadTable;
        this.jbInit();
    }

    protected void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("EQUAL_WIDTH_BINNING_STRATEGY_DIALOG_DESCRIPTION"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 5, 1, 1);
        this.addFilledComponent(this.pnlNumberOfBins, COL1_INDENTED1_LABEL, n++, 0, 1, 1, 1);
        this.radioNumberOfBins.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_NUMBER_OF_BINS_SPECIFY"));
        this.txtNumberOfBins.setColumns(8);
        this.txtNumberOfBins.setDataType(Integer.TYPE);
        this.txtNumberOfBins.setSigned(false);
        this.pnlNumberOfBins.add(this.radioNumberOfBins);
        this.pnlNumberOfBins.add(this.txtNumberOfBins);
        this.radioNumberOfBins.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EqualBinningSettingsPanel.this.optCalculate_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.pnlAutoNumberOfBins, COL1_INDENTED1_LABEL, n, 0, 1, 1, 1);
        this.radioAutoNumberOfBins.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_NUMBER_OF_BINS_AUTO"));
        this.txtAutoNumberOfBins.setColumns(8);
        this.txtAutoNumberOfBins.setDataType(Integer.TYPE);
        this.txtAutoNumberOfBins.setSigned(false);
        this.radioAutoNumberOfBins.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EqualBinningSettingsPanel.this.optAutoCalculate_actionPerformed(actionEvent);
            }
        });
        this.pnlAutoNumberOfBins.add(this.radioAutoNumberOfBins);
        this.pnlAutoNumberOfBins.add(this.txtAutoNumberOfBins);
        this.groupBinning.add(this.radioNumberOfBins);
        this.groupBinning.add(this.radioAutoNumberOfBins);
        this.m_parentDialog.setInitialFocus(this.txtNumberOfBins);
        this.addOKHelpCancelListeners();
        this.loadState();
    }

    protected int getSingleRowSelection() {
        if (this.m_Selection == null) {
            Range range;
            int n = -1;
            TwoDSelection twoDSelection = this.m_spreadTable.getSelection();
            OneDSelection oneDSelection = twoDSelection.getRowSelection();
            Range[] rangeArray = oneDSelection.getRanges();
            if (null == rangeArray) {
                this.m_Selection = new Integer(-1);
                return this.m_Selection;
            }
            if (rangeArray.length == 1 && (range = rangeArray[0]).getLowerLimit() == range.getUpperLimit()) {
                this.m_Selection = new Integer(range.getLowerLimit());
            }
        }
        return this.m_Selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void optAutoCalculate_actionPerformed(ActionEvent actionEvent) {
        if (this.m_autobinNumber == null) {
            int n = this.getSingleRowSelection();
            if (n != -1) {
                Cursor cursor = this.getCursor();
                try {
                    this.setCursor(new Cursor(3));
                    int n2 = this.m_dataSourcemodel.calculateBinNumber(null, this.m_dataSourcemodel.getAttributeName(n));
                    this.m_autobinNumber = new Integer(n2);
                    this.txtAutoNumberOfBins.setNumber(new Integer(n2));
                    this.m_bAutoCalculate = true;
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    this.setCursor(cursor);
                    throw throwable;
                }
                this.setCursor(cursor);
                {
                }
            }
        } else {
            int n = this.getSingleRowSelection();
            if (n != -1) {
                this.m_bAutoCalculate = true;
            }
        }
        this.updateFields();
    }

    private void optCalculate_actionPerformed(ActionEvent actionEvent) {
        this.m_bAutoCalculate = false;
        this.updateFields();
    }

    private void updateButtons() {
        this.radioAutoNumberOfBins.setSelected(this.m_bAutoCalculate);
        this.txtAutoNumberOfBins.setEnabled(this.m_bAutoCalculate);
        this.radioNumberOfBins.setSelected(!this.m_bAutoCalculate);
        this.txtNumberOfBins.setEnabled(!this.m_bAutoCalculate);
    }

    private void updateFields() {
        this.txtAutoNumberOfBins.setEnabled(this.m_bAutoCalculate);
        this.txtNumberOfBins.setEnabled(!this.m_bAutoCalculate);
    }

    protected void loadState() throws Exception {
        if (this.m_state == null) {
            throw new Exception();
        }
        this.m_settingsState = (DiscretizationSettingsState)this.m_state.getStep(StepType.SETTING_STEP_1);
        DiscretizationDataUsageState discretizationDataUsageState = (DiscretizationDataUsageState)this.m_state.getStep(StepType.DATA_USAGE_STEP);
        this.m_dataSourcemodel = discretizationDataUsageState.getNumericModel();
        if (this.m_dataSourcemodel == null) {
            throw new Exception();
        }
        TwoDSelection twoDSelection = this.m_spreadTable.getSelection();
        if (twoDSelection == null) {
            return;
        }
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        if (oneDSelection == null) {
            return;
        }
        this.m_range = oneDSelection.getRanges();
        if (this.m_range == null || this.m_range.length != 1 || this.m_range[0].getLowerLimit() != this.m_range[0].getUpperLimit()) {
            this.radioAutoNumberOfBins.setEnabled(false);
            this.txtAutoNumberOfBins.setEnabled(false);
            this.m_bAutoCalculate = false;
        }
        this.updateButtons();
        int n = this.getGroupNumberOfBins();
        this.m_settingsState.setCurrentNumberOfBins(n);
        this.txtNumberOfBins.setNumber(new Integer(n));
    }

    protected int getGroupNumberOfBins() {
        if (this.m_range == null || this.m_range.length == 0) {
            return DiscretizeDataSource.DEFAULT_BIN_NUMBER;
        }
        Integer n = null;
        for (int i = 0; i < this.m_range.length; ++i) {
            int n2 = this.m_range[i].getLowerLimit();
            int n3 = this.m_range[i].getUpperLimit();
            for (int j = n2; j <= n3; ++j) {
                if (!this.m_dataSourcemodel.isAttributeBinned(j)) {
                    return DiscretizeDataSource.DEFAULT_BIN_NUMBER;
                }
                Integer n4 = this.m_dataSourcemodel.getNumberOfBins(j);
                if (n == null) {
                    n = n4;
                    continue;
                }
                if (0 == n.compareTo(n4)) continue;
                return DiscretizeDataSource.DEFAULT_BIN_NUMBER;
            }
        }
        return n != null ? n : DiscretizeDataSource.DEFAULT_BIN_NUMBER;
    }

    protected boolean isBinningRequired() {
        for (int i = 0; i < this.m_range.length; ++i) {
            int n = this.m_range[i].getLowerLimit();
            int n2 = this.m_range[i].getUpperLimit();
            for (int j = n; j <= n2; ++j) {
                if (!this.m_dataSourcemodel.isAttributeBinned(j)) {
                    return true;
                }
                if (this.isSameTypeBinning(j)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isSameTypeBinning(int n) {
        return this.m_dataSourcemodel.isEqualWidthBinning(n);
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EqualBinningSettingsPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void validate(Vector vector) throws Exception {
        this.m_settingsState.validateBinNumberValue(vector);
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.validate(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
                if (vector.isEmpty()) {
                    this.processUserInput();
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else if ("cancel" == string) {
            // empty if block
        }
    }

    protected void processUserInput() {
        Object object;
        int n;
        int n2;
        int n3 = this.m_settingsState.getCurrentNumberOfBins();
        int n4 = this.getGroupNumberOfBins();
        if (!this.isBinningRequired() && n4 == n3) {
            return;
        }
        this.m_backupData.clear();
        Vector<Integer> vector = new Vector<Integer>();
        Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>();
        for (int i = 0; i < this.m_range.length; ++i) {
            n2 = this.m_range[i].getLowerLimit();
            n = this.m_range[i].getUpperLimit();
            for (int j = n2; j <= n; ++j) {
                BackupData backupData = new BackupData(this.m_dataSourcemodel, j);
                this.m_dataSourcemodel.setNumberOfBins(j, n3);
                object = this.m_dataSourcemodel.getAttributeName(j);
                hashtable.put(object, new Integer(j));
                this.m_dataSourcemodel.markAttributeBinned(j, BinningType.EQ_WIDTH, n3);
                this.m_dataSourcemodel.setTailPercent(j, 0.0);
                this.m_backupData.put(new Integer(j), backupData);
                vector.add(new Integer(j));
            }
        }
        this.getEqualWidthBounds(hashtable, n3);
        StringBuffer stringBuffer = new StringBuffer();
        n2 = 0;
        for (n = 0; n < vector.size(); ++n) {
            Integer n5 = (Integer)vector.elementAt(n);
            int n6 = n5;
            object = this.m_dataSourcemodel.getBinBounds(n6);
            if (object != null) continue;
            ++n2;
            this.m_dataSourcemodel.setViewDefinition(n6, null);
            this.m_dataSourcemodel.setBinTypeNONE(n6);
            this.m_dataSourcemodel.setNumberOfBins(n6, 0);
            this.m_dataSourcemodel.setBinBounds(n6, null);
            stringBuffer.append(this.m_dataSourcemodel.getAttributeName(n6));
            stringBuffer.append("\n");
        }
        if (n2 > 0) {
            String string = null;
            string = n2 <= 5 ? MessageFormat.format(ResourceUtilities.getUILabel("EQW_BINNING_STRATEGY_DIALOG_WARNING_LIST"), stringBuffer.toString()) : ResourceUtilities.getUILabel("EQW_BINNING_STRATEGY_DIALOG_WARNING_SOME");
            JOptionPane.showMessageDialog(null, string, ResourceUtilities.getUILabel("WARNING_DIALOG_TITLE"), 1);
        }
        this.m_settingsState.invalidate();
    }

    protected void updateNumberOfBins(Number number) {
        this.m_settingsState.setCurrentNumberOfBins(number.intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getEqualWidthBounds(Hashtable hashtable, int n) {
        try {
            block5: {
                try {
                    DiscretizeEqualWidthArray discretizeEqualWidthArray = new DiscretizeEqualWidthArray(this.m_dataSourcemodel, hashtable, n);
                    ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), discretizeEqualWidthArray, true);
                    discretizeEqualWidthArray.setProgressBar(progressBar);
                    progressBar.start(ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_DESC"));
                    if (discretizeEqualWidthArray.getException() != null) {
                        this.restoreAttrubuteValues(hashtable);
                        break block5;
                    }
                    if (!progressBar.hasUserCancelled()) break block5;
                    this.restoreAttrubuteValues(hashtable);
                }
                catch (Exception exception) {
                    Object var6_7 = null;
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            throw throwable;
        }
    }

    protected void restoreAttrubuteValues(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n = (Integer)hashtable.get(string);
            if (n == null) continue;
            BackupData backupData = (BackupData)this.m_backupData.get(n);
            int n2 = n;
            backupData.restoreBackupData(this.m_dataSourcemodel);
        }
    }

    protected class CustomNumberTextField
    extends NumberTextField {
        CustomNumberTextField() {
            this.setLocale(Locale.getDefault());
            this.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    super.keyReleased(keyEvent);
                    if (127 == keyEvent.getKeyCode() || 8 == keyEvent.getKeyCode()) {
                        Number number = CustomNumberTextField.this.getNumber();
                        int n = 0;
                        if (number != null) {
                            n = number.intValue();
                        }
                        Integer n2 = new Integer(n);
                        CustomNumberTextField.this.validateNumber(n2);
                    }
                }
            });
        }

        protected boolean validateNumber(Number number) {
            boolean bl = super.validateNumber(number);
            if (bl && number != null) {
                EqualBinningSettingsPanel.this.updateNumberOfBins(number);
            }
            return bl;
        }
    }
}

