/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.datasources.CategoricDiscretizeDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CategoricBinBoundary;
import oracle.dmt.dm4j.wizard.state.transformsteps.CategoricBinBoundaryTableModel;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.transformsteps.DiscretizeSettingsStateError;

public class CustomCategoricalEditBinsPanel
extends GriddedPanel {
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private MultiLineLabel mlblStepDescription = new MultiLineLabel();
    private JLabel m_lblBinCategory = new JLabel();
    private JTextField m_txtBinCategory = null;
    private JLabel m_lblShowUnassigned = new JLabel();
    private JCheckBox m_chkShowUnassigned = new JCheckBox();
    private Shuttle m_shuttle;
    private DM4JDialog m_parentDialog;
    private WizardState m_state = null;
    protected Vector m_vAllDistinctValues;
    protected CategoricBinBoundaryTableModel m_tableModel;
    protected JTable m_table;
    protected int m_tableSelection;

    public CustomCategoricalEditBinsPanel(DM4JDialog dM4JDialog, WizardState wizardState, JTable jTable, int n, Vector vector, boolean bl) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = wizardState;
        this.m_table = jTable;
        this.m_tableModel = (CategoricBinBoundaryTableModel)this.m_table.getModel();
        this.m_vAllDistinctValues = vector;
        this.m_tableSelection = n;
        this.m_txtBinCategory = bl ? new CustomNumberTextField() : new CustomTextField();
        this.jbInit();
    }

    private Vector buildTheFromList(Vector vector) {
        Vector vector2 = new Vector();
        for (int i = 0; i < this.m_vAllDistinctValues.size(); ++i) {
            String string = (String)this.m_vAllDistinctValues.elementAt(i);
            boolean bl = false;
            for (int j = 0; j < vector.size(); ++j) {
                String string2 = (String)vector.elementAt(j);
                if (0 != string.compareTo(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            vector2.add(string);
        }
        return this.m_chkShowUnassigned.isSelected() ? this.m_tableModel.getUnAssignedDistictValues(vector2) : vector2;
    }

    public void init() {
        this.loadDefaultValues();
    }

    protected void loadDefaultValues() {
        if (this.m_state != null) {
            // empty if block
        }
    }

    public void reinit() {
        this.init();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("CUSTOM_EDIT_BINNING_STRATEGY"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 6, 1, 1);
        String string = this.m_tableSelection != -1 ? this.m_tableModel.getFieldEntry(this.m_tableSelection).getBinCategory() : "";
        this.m_lblBinCategory.setText(ResourceUtilities.getUILabel("CUSTOM_BINNING_BIN_NUMBER"));
        this.m_lblBinCategory.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("CUSTOM_BINNING_BIN_NUMBER"));
        this.m_lblBinCategory.setLabelFor(this.m_txtBinCategory);
        this.m_txtBinCategory.setText(string);
        this.m_parentDialog.setInitialFocus(this.m_txtBinCategory);
        this.addComponent(this.m_lblBinCategory, COL1_INDENTED1_LABEL, n, 0, 1, 1, 18, 1);
        this.addComponent(this.m_txtBinCategory, COL1_CONTROL, n, 1, 2, 1, 18, 1);
        this.addComponent(new JLabel(), COL1_CONTROL, n++, 3, 2, 1, 18, 1);
        this.m_lblShowUnassigned.setText(ResourceUtilities.getUILabel("CUSTOM_SHOW_UNASSIGNED"));
        this.m_lblShowUnassigned.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("CUSTOM_SHOW_UNASSIGNED"));
        this.m_lblShowUnassigned.setLabelFor(this.m_chkShowUnassigned);
        this.addComponent(this.m_lblShowUnassigned, COL1_INDENTED1_LABEL, n, 0, 1, 1, 18, 1);
        this.addComponent(this.m_chkShowUnassigned, COL1_CONTROL, n++, 1, 1, 1, 18, 1);
        this.m_chkShowUnassigned.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListPicker listPicker = (ListPicker)CustomCategoricalEditBinsPanel.this.m_shuttle.getFromPicker();
                if (listPicker != null) {
                    JList jList = listPicker.getList();
                    boolean bl = CustomCategoricalEditBinsPanel.this.m_chkShowUnassigned.isSelected();
                    String string = CustomCategoricalEditBinsPanel.this.m_txtBinCategory.getText();
                    Vector vector = CustomCategoricalEditBinsPanel.this.getBinVectorValues(string);
                    Vector vector2 = CustomCategoricalEditBinsPanel.this.buildTheFromList(vector);
                    DefaultListModel defaultListModel = new DefaultListModel();
                    for (int i = 0; i < vector2.size(); ++i) {
                        defaultListModel.addElement(vector2.elementAt(i));
                    }
                    jList.setModel(defaultListModel);
                    JButton jButton = (JButton)CustomCategoricalEditBinsPanel.this.m_shuttle.getComponent("FromHeader");
                    if (jButton != null) {
                        jButton.setText(CustomCategoricalEditBinsPanel.this.m_chkShowUnassigned.isSelected() ? ResourceUtilities.getUILabel("CUSTOM_UNASSIGNED_ONLY_DISTINCT_VALUES") : ResourceUtilities.getUILabel("CUSTOM_ALL_DISTINCT_VALUES"));
                    }
                }
            }
        });
        this.m_shuttle = new Shuttle();
        this.m_shuttle.setBorder(new EmptyBorder(0, 5, 0, 5));
        int[] nArray = new int[]{65, 82, 76, 86, 67, 89, 38, 40, 80, 66};
        this.m_shuttle.setButtonMnemonics(nArray);
        this.m_shuttle.setHorizontalLayout(false);
        this.buildShuttleFromList(this.m_shuttle);
        this.buildShuttleToList(this.m_shuttle);
        this.addComponent(this.m_shuttle, COL1_INDENTED1_LABEL, n, 0, 6, 6, 18, 1);
        this.addOKHelpCancelListeners();
    }

    private void buildShuttleFromList(Shuttle shuttle) {
        Vector vector = this.m_tableSelection != -1 ? this.m_tableModel.getFieldEntry(this.m_table.getSelectedRow()).getBinVectorValues() : new Vector();
        Vector vector2 = this.buildTheFromList(vector);
        String[] stringArray = vector2.toArray(new String[vector2.size()]);
        JList<String> jList = new JList<String>(stringArray);
        jList.setSelectionMode(2);
        ListPicker listPicker = new ListPicker(jList);
        listPicker.setItemsSorted(true);
        shuttle.setFromPicker(listPicker);
        shuttle.add((Component)new JButton(ResourceUtilities.getUILabel("CUSTOM_ALL_DISTINCT_VALUES")), "FromHeader");
    }

    private void updateShuttleFromList(Vector vector) {
        Vector vector2 = this.buildTheFromList(vector);
        DefaultListModel defaultListModel = new DefaultListModel();
        for (int i = 0; i < vector2.size(); ++i) {
            defaultListModel.addElement(vector2.elementAt(i));
        }
        ListPicker listPicker = (ListPicker)this.m_shuttle.getFromPicker();
        JList jList = listPicker.getList();
        jList.setModel(defaultListModel);
    }

    private void buildShuttleToList(Shuttle shuttle) {
        Vector vector = this.m_tableSelection != -1 ? this.m_tableModel.getFieldEntry(this.m_tableSelection).getBinVectorValues() : new Vector();
        DefaultListModel defaultListModel = new DefaultListModel();
        for (int i = 0; i < vector.size(); ++i) {
            defaultListModel.addElement(vector.elementAt(i));
        }
        JList jList = new JList(defaultListModel);
        jList.setSelectionMode(2);
        ListPicker listPicker = new ListPicker(jList);
        listPicker.setItemsSorted(true);
        shuttle.setToPicker(listPicker);
        shuttle.add((Component)new JButton(ResourceUtilities.getUILabel("CUSTOM_SELECTED_BIN_VALUES")), "ToHeader");
    }

    private void updateShuttleToList(Vector vector) {
        DefaultListModel defaultListModel = new DefaultListModel();
        for (int i = 0; i < vector.size(); ++i) {
            defaultListModel.addElement(vector.elementAt(i));
        }
        ListPicker listPicker = (ListPicker)this.m_shuttle.getToPicker();
        JList jList = listPicker.getList();
        jList.setModel(defaultListModel);
    }

    private Vector getBinVectorValues(String string) {
        Vector vector = new Vector();
        for (int i = 0; i < this.m_tableModel.getRowCount(); ++i) {
            CategoricBinBoundary categoricBinBoundary = this.m_tableModel.getFieldEntry(i);
            String string2 = categoricBinBoundary.getBinCategory();
            if (0 != string2.compareTo(string)) continue;
            vector = categoricBinBoundary.getBinVectorValues();
            break;
        }
        return vector;
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomCategoricalEditBinsPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        block9: {
            String string = actionEvent.getActionCommand();
            if ("ok" == string) {
                Vector<StateValidation> vector = new Vector<StateValidation>();
                try {
                    Object object;
                    String string2 = this.m_txtBinCategory.getText();
                    if (string2 == null || string2.length() == 0) {
                        vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_BIN_CATEGORY));
                    } else if (this.m_tableSelection == -1 && -1 != this.m_tableModel.getBinCategoryPosition(string2)) {
                        vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZATION_CATEGORICAL_EXISTING_CATEGORY));
                    } else {
                        object = (ListPicker)this.m_shuttle.getToPicker();
                        JList jList = ((ListPicker)object).getList();
                        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
                        Object[] objectArray = defaultListModel.toArray();
                        if (objectArray == null || objectArray.length == 0) {
                            vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_EMPTY_BIN_VALUE));
                        }
                    }
                    object = (DM4JEvent)actionEvent;
                    DialogUtilities.displayValidations(vector, (DM4JEvent)object, this.m_parentDialog);
                    if (vector.isEmpty()) {
                        this.processUserInput();
                    }
                }
                catch (Exception exception) {
                    if (!CategoricDiscretizeDataSource.isDebug()) break block9;
                    exception.printStackTrace();
                }
            }
        }
    }

    protected void processUserInput() {
        ListPicker listPicker = (ListPicker)this.m_shuttle.getToPicker();
        JList jList = listPicker.getList();
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        Object[] objectArray = defaultListModel.toArray();
        String string = this.m_txtBinCategory.getText();
        for (int i = 0; i < objectArray.length; ++i) {
            this.m_tableModel.removeValueFromEntry(objectArray[i].toString());
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < objectArray.length; ++i) {
            vector.add(objectArray[i].toString());
        }
        this.m_tableModel.addEntry(new CategoricBinBoundary(string, vector));
    }

    protected class CustomNumberTextField
    extends NumberTextField {
        CustomNumberTextField() {
            this.setLocale(Locale.getDefault());
        }
    }

    protected class CustomTextField
    extends JTextField {
        CustomTextField() {
        }
    }
}

