/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.plaf.FileChooserUI;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transforms.TransformWizardState;

public class CreationSQLPanel
extends GriddedPanel {
    DM4JDialog m_parentDialog;
    String m_previewSQL = null;
    String m_createSQL = null;
    String m_packageSQL = null;
    String m_packageBodySQL = null;
    TransformWizardState m_state = null;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    MultiLineLabel mlblFormatHint = new MultiLineLabel();
    JLabel lblSQLGenerated = new JLabel();
    JTextArea txtSQLGenerated = new JTextArea();
    JScrollPane scrollSQLGenerated = new JScrollPane();
    JButton butCopyClipboard = new JButton();
    JButton butSaveToFile = new JButton();
    JLabel lblFiller = new JLabel();

    public CreationSQLPanel(DM4JDialog dM4JDialog, TransformWizardState transformWizardState) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = transformWizardState;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("CREATION_SQL_DESCRIPTION"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(3);
        this.mlblStepDescription.setMinimumRows(3);
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 3, 1, 1);
        this.txtSQLGenerated.setLineWrap(true);
        this.txtSQLGenerated.setWrapStyleWord(true);
        this.txtSQLGenerated.setEditable(false);
        this.scrollSQLGenerated.getViewport().add((Component)this.txtSQLGenerated, null);
        this.scrollSQLGenerated.setPreferredSize(new Dimension(250, 60));
        this.addFilledComponent(this.scrollSQLGenerated, COL_VALUE, n++, 0, 4, 2, 1);
        this.butSaveToFile.setText(ResourceUtilities.getUILabel("SAVE_TO_FILE"));
        this.butSaveToFile.setMnemonic(ResourceUtilities.getUIMnemonic("SAVE_TO_FILE"));
        this.butSaveToFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreationSQLPanel.this.butSaveToFile_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.butSaveToFile, COL1_CONTROL, ++n, 0);
        this.butCopyClipboard.setText(ResourceUtilities.getUILabel("COPY_CLIPBOARD"));
        this.butCopyClipboard.setMnemonic(ResourceUtilities.getUIMnemonic("COPY_CLIPBOARD"));
        this.butCopyClipboard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreationSQLPanel.this.butCopyClipboard_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.butCopyClipboard, COL2_CONTROL, n, 1);
        JButton[] jButtonArray = new JButton[]{this.butCopyClipboard, this.butSaveToFile};
        CreationSQLPanel.setPreferredSize(jButtonArray, 190, 25);
        this.loadState();
    }

    protected void loadState() throws Exception {
        StringBuffer[] stringBufferArray = this.m_state.getVisibleSQLStatements();
        if (stringBufferArray != null) {
            StringBuffer stringBuffer = new StringBuffer(1000);
            for (int i = 0; i < stringBufferArray.length; ++i) {
                stringBuffer.append(stringBufferArray[i].toString());
                stringBuffer.append("\n\n\n\n");
            }
            this.txtSQLGenerated.setText(stringBuffer.toString());
            JScrollBar jScrollBar = this.scrollSQLGenerated.getVerticalScrollBar();
            jScrollBar.setValue(jScrollBar.getMinimum());
        }
    }

    private void butCopyClipboard_actionPerformed(ActionEvent actionEvent) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        String string = this.txtSQLGenerated.getText();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, null);
    }

    private void butSaveToFile_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(2);
        FileChooserUI fileChooserUI = jFileChooser.getUI();
        jFileChooser.setDialogTitle(ResourceUtilities.getUILabel("SAVE_TRANSFORM_DIALOG_TITLE"));
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(this.txtSQLGenerated.getText());
                fileWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

